/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.components;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.KnnPredicateHint;
import org.vitrivr.cottontail.math.knn.metrics.DistanceKernel;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003BS\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0018\u00010\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u00c6\u0003J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003J\u0015\u0010'\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0018\u00010\tH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003Je\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\u0014\b\u0002\u0010\f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0018\u00010\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0096\u0002J\b\u0010.\u001a\u00020\u0007H\u0016J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001d\u0010\f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!\u00a8\u00061"}, d2={"Lorg/vitrivr/cottontail/database/queries/components/KnnPredicate;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "column", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "k", "", "query", "", "distance", "Lorg/vitrivr/cottontail/math/knn/metrics/DistanceKernel;", "weights", "hint", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "(Lorg/vitrivr/cottontail/model/basics/ColumnDef;ILjava/util/List;Lorg/vitrivr/cottontail/math/knn/metrics/DistanceKernel;Ljava/util/List;Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;)V", "getColumn", "()Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "columns", "", "getColumns", "()Ljava/util/Set;", "cost", "", "getCost", "()F", "getDistance", "()Lorg/vitrivr/cottontail/math/knn/metrics/DistanceKernel;", "getHint", "()Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "getK", "()I", "getQuery", "()Ljava/util/List;", "getWeights", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "", "hashCode", "toString", "", "cottontaildb"})
public final class KnnPredicate<T extends VectorValue<?>>
extends Predicate {
    @NotNull
    private final Set<ColumnDef<?>> columns;
    private final float cost;
    @NotNull
    private final ColumnDef<T> column;
    private final int k;
    @NotNull
    private final List<T> query;
    @NotNull
    private final DistanceKernel distance;
    @Nullable
    private final List<VectorValue<?>> weights;
    @Nullable
    private final KnnPredicateHint hint;

    @Override
    @NotNull
    public Set<ColumnDef<?>> getColumns() {
        return this.columns;
    }

    @Override
    public float getCost() {
        return this.cost;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.components.KnnPredicate<*>");
        }
        KnnPredicate cfr_ignored_0 = (KnnPredicate)object2;
        if (Intrinsics.areEqual(this.column, ((KnnPredicate)other).column) ^ true) {
            return false;
        }
        if (this.k != ((KnnPredicate)other).k) {
            return false;
        }
        if (Intrinsics.areEqual(this.query, ((KnnPredicate)other).query) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.distance, (Object)((KnnPredicate)other).distance) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.weights, ((KnnPredicate)other).weights) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.hint, (Object)((KnnPredicate)other).hint) ^ true);
    }

    public int hashCode() {
        int result = this.column.hashCode();
        result = 31 * result + this.k;
        result = 31 * result + ((Object)this.query).hashCode();
        result = 31 * result + this.distance.hashCode();
        List<VectorValue<?>> list = this.weights;
        result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
        KnnPredicateHint knnPredicateHint = this.hint;
        result = 31 * result + (knnPredicateHint != null ? knnPredicateHint.hashCode() : 0);
        return result;
    }

    @NotNull
    public final ColumnDef<T> getColumn() {
        return this.column;
    }

    public final int getK() {
        return this.k;
    }

    @NotNull
    public final List<T> getQuery() {
        return this.query;
    }

    @NotNull
    public final DistanceKernel getDistance() {
        return this.distance;
    }

    @Nullable
    public final List<VectorValue<?>> getWeights() {
        return this.weights;
    }

    @Nullable
    public final KnnPredicateHint getHint() {
        return this.hint;
    }

    public KnnPredicate(@NotNull ColumnDef<T> column, int k, @NotNull List<? extends T> query, @NotNull DistanceKernel distance, @Nullable List<? extends VectorValue<?>> weights, @Nullable KnnPredicateHint hint) {
        VectorValue it;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        super(null);
        this.column = column;
        this.k = k;
        this.query = query;
        this.distance = distance;
        this.weights = weights;
        this.hint = hint;
        if (this.k <= 0) {
            throw (Throwable)new QueryException.QuerySyntaxException("The value of k for a kNN query cannot be smaller than one (is " + this.k + ")s!");
        }
        Iterable $this$forEach$iv = this.query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VectorValue)element$iv;
            boolean bl = false;
            if (this.column.getLogicalSize() == it.getLogicalSize()) continue;
            throw (Throwable)new QueryException.QueryBindException("The size of the provided column " + this.column.getName() + " (s_c=" + this.column.getLogicalSize() + ") does not match the size of the query vector (s_q=" + it.getLogicalSize() + ").");
        }
        List<VectorValue<?>> list = this.weights;
        if (list != null) {
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (VectorValue)element$iv;
                boolean bl = false;
                if (this.column.getLogicalSize() == it.getLogicalSize()) continue;
                throw (Throwable)new QueryException.QueryBindException("The size of the provided column " + this.column.getName() + " (s_c=" + this.column.getLogicalSize() + ") does not match the size of the weight vector (s_w=" + it.getLogicalSize() + ").");
            }
        }
        this.columns = SetsKt.setOf(this.column);
        List<VectorValue<?>> list2 = this.weights;
        this.cost = this.distance.costForDimension(((VectorValue)CollectionsKt.first(this.query)).getLogicalSize()) * (float)(this.query.size() + (list2 != null ? list2.size() : 0));
    }

    public /* synthetic */ KnnPredicate(ColumnDef columnDef, int n, List list, DistanceKernel distanceKernel, List list2, KnnPredicateHint knnPredicateHint, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            list2 = null;
        }
        if ((n2 & 0x20) != 0) {
            knnPredicateHint = null;
        }
        this(columnDef, n, list, distanceKernel, list2, knnPredicateHint);
    }

    @NotNull
    public final ColumnDef<T> component1() {
        return this.column;
    }

    public final int component2() {
        return this.k;
    }

    @NotNull
    public final List<T> component3() {
        return this.query;
    }

    @NotNull
    public final DistanceKernel component4() {
        return this.distance;
    }

    @Nullable
    public final List<VectorValue<?>> component5() {
        return this.weights;
    }

    @Nullable
    public final KnnPredicateHint component6() {
        return this.hint;
    }

    @NotNull
    public final KnnPredicate<T> copy(@NotNull ColumnDef<T> column, int k, @NotNull List<? extends T> query, @NotNull DistanceKernel distance, @Nullable List<? extends VectorValue<?>> weights, @Nullable KnnPredicateHint hint) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        return new KnnPredicate<T>(column, k, query, distance, weights, hint);
    }

    public static /* synthetic */ KnnPredicate copy$default(KnnPredicate knnPredicate, ColumnDef columnDef, int n, List list, DistanceKernel distanceKernel, List list2, KnnPredicateHint knnPredicateHint, int n2, Object object) {
        if ((n2 & 1) != 0) {
            columnDef = knnPredicate.column;
        }
        if ((n2 & 2) != 0) {
            n = knnPredicate.k;
        }
        if ((n2 & 4) != 0) {
            list = knnPredicate.query;
        }
        if ((n2 & 8) != 0) {
            distanceKernel = knnPredicate.distance;
        }
        if ((n2 & 0x10) != 0) {
            list2 = knnPredicate.weights;
        }
        if ((n2 & 0x20) != 0) {
            knnPredicateHint = knnPredicate.hint;
        }
        return knnPredicate.copy(columnDef, n, list, distanceKernel, list2, knnPredicateHint);
    }

    @NotNull
    public String toString() {
        return "KnnPredicate(column=" + this.column + ", k=" + this.k + ", query=" + this.query + ", distance=" + this.distance + ", weights=" + this.weights + ", hint=" + this.hint + ")";
    }
}

