/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.queries.planning.RuleGroup;
import org.vitrivr.cottontail.database.queries.planning.nodes.interfaces.NodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.interfaces.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.LogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.PhysicalNodeExpression;
import org.vitrivr.cottontail.model.exceptions.QueryException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\f\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "", "logicalRewriteRules", "", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/interfaces/RewriteRule;", "physicalRewriteRules", "(Ljava/util/Collection;Ljava/util/Collection;)V", "logicalShuttle", "Lorg/vitrivr/cottontail/database/queries/planning/RuleGroup;", "physicalShuttle", "optimize", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/interfaces/NodeExpression;", "expression", "group", "plan", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/PhysicalNodeExpression;", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/logical/LogicalNodeExpression;", "cottontaildb"})
public final class CottontailQueryPlanner {
    private final RuleGroup logicalShuttle;
    private final RuleGroup physicalShuttle;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<PhysicalNodeExpression> plan(@NotNull LogicalNodeExpression expression) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        NodeExpression it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List stage1 = CollectionsKt.plus(this.optimize(expression, this.logicalShuttle), (Object)expression);
        Iterable $this$flatMap$iv = stage1;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (NodeExpression)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.optimize(it, this.physicalShuttle);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NodeExpression)element$iv$iv;
            boolean bl = false;
            if (!it.getRoot().getExecutable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PhysicalNodeExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List stage2 = (List)destination$iv$iv;
        if (stage2.isEmpty()) {
            throw (Throwable)new QueryException.QueryPlannerException("Failed to generate a physical execution plan for expression: " + expression + '.');
        }
        return stage2;
    }

    @NotNull
    public final Collection<NodeExpression> optimize(@NotNull NodeExpression expression, @NotNull RuleGroup group) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        boolean bl = false;
        List candidates = new ArrayList();
        boolean bl2 = false;
        List explore = new ArrayList();
        NodeExpression pointer = expression;
        while (pointer != null) {
            List<NodeExpression> results = group.apply(pointer);
            if (results.isEmpty()) {
                if (pointer.getInputs().size() > 0) {
                    explore.addAll((Collection)pointer.getInputs());
                } else {
                    candidates.add(pointer.getRoot());
                }
            }
            for (NodeExpression r : results) {
                if (r.getInputs().size() > 0) {
                    explore.addAll((Collection)r.getInputs());
                    continue;
                }
                candidates.add(r.getRoot());
            }
            pointer = (NodeExpression)CollectionsKt.removeLastOrNull((List)explore);
        }
        return candidates;
    }

    public CottontailQueryPlanner(@NotNull Collection<? extends RewriteRule> logicalRewriteRules, @NotNull Collection<? extends RewriteRule> physicalRewriteRules) {
        Intrinsics.checkNotNullParameter(logicalRewriteRules, (String)"logicalRewriteRules");
        Intrinsics.checkNotNullParameter(physicalRewriteRules, (String)"physicalRewriteRules");
        this.logicalShuttle = new RuleGroup(logicalRewriteRules);
        this.physicalShuttle = new RuleGroup(physicalRewriteRules);
    }
}

