/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning.nodes.physical.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.NullaryPhysicalNodeExpression;
import org.vitrivr.cottontail.execution.ExecutionEngine;
import org.vitrivr.cottontail.execution.operators.sources.EntitySampleOperator;
import org.vitrivr.cottontail.model.basics.ColumnDef;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u0018\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\b\u0010!\u001a\u00020\u0000H\u0016J@\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010)2\u0006\u0010*\u001a\u00020'H\u0016J\u0014\u0010+\u001a\u00020,2\n\u0010-\u001a\u00060.R\u00020/H\u0016J\t\u00100\u001a\u000201H\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001a\u00a8\u00062"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/EntitySamplePhysicalNodeExpression;", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/NullaryPhysicalNodeExpression;", "entity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "size", "", "seed", "(Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;JJ)V", "canBePartitioned", "", "getCanBePartitioned", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getCost", "()Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getEntity", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "outputSize", "getOutputSize", "()J", "getSeed", "getSize", "component1", "component2", "component3", "component4", "copy", "(Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;JJ)Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/EntitySamplePhysicalNodeExpression;", "equals", "other", "", "hashCode", "", "partition", "", "p", "toOperator", "Lorg/vitrivr/cottontail/execution/operators/sources/EntitySampleOperator;", "context", "Lorg/vitrivr/cottontail/execution/ExecutionEngine$ExecutionContext;", "Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "toString", "", "cottontaildb"})
public final class EntitySamplePhysicalNodeExpression
extends NullaryPhysicalNodeExpression {
    private final long outputSize;
    private final boolean canBePartitioned;
    @NotNull
    private final Cost cost;
    @NotNull
    private final Entity entity;
    @NotNull
    private final ColumnDef<?>[] columns;
    private final long size;
    private final long seed;

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    public boolean getCanBePartitioned() {
        return this.canBePartitioned;
    }

    @Override
    @NotNull
    public Cost getCost() {
        return this.cost;
    }

    @Override
    @NotNull
    public EntitySamplePhysicalNodeExpression copy() {
        return new EntitySamplePhysicalNodeExpression(this.entity, this.columns, this.size, this.seed);
    }

    @Override
    @NotNull
    public EntitySampleOperator toOperator(@NotNull ExecutionEngine.ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new EntitySampleOperator(context, this.entity, this.columns, this.size, this.seed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<NullaryPhysicalNodeExpression> partition(int p) {
        void $this$mapTo$iv$iv;
        long partitionSize = Math.floorDiv(this.size, (long)p) + 1L;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)p);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long start = (long)it * partitionSize;
            long l = ((long)it + 1L) * partitionSize;
            long l2 = this.size;
            boolean bl2 = false;
            long end = Math.min(l, l2);
            EntitySamplePhysicalNodeExpression entitySamplePhysicalNodeExpression = new EntitySamplePhysicalNodeExpression(this.entity, this.columns, end - start + 1L, 0L, 8, null);
            collection.add(entitySamplePhysicalNodeExpression);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public final long getSize() {
        return this.size;
    }

    public final long getSeed() {
        return this.seed;
    }

    public EntitySamplePhysicalNodeExpression(@NotNull Entity entity, @NotNull ColumnDef<?>[] columns, long size, long seed) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.entity = entity;
        this.columns = columns;
        this.size = size;
        this.seed = seed;
        boolean bl = this.size > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Sample size must be greater than zero for sampling an entity.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.outputSize = this.size;
        this.canBePartitioned = true;
        this.cost = new Cost((float)(this.getOutputSize() * (long)this.columns.length) * 1.0E-4f, (float)this.size * Cost.Companion.getCOST_MEMORY_ACCESS(), 0.0f, 4, null);
    }

    public /* synthetic */ EntitySamplePhysicalNodeExpression(Entity entity, ColumnDef[] columnDefArray, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Collection<ColumnDef<?>> $this$toTypedArray$iv = entity.allColumns();
            boolean $i$f$toTypedArray = false;
            Collection<ColumnDef<?>> thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray2 = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            columnDefArray = columnDefArray2;
        }
        if ((n & 8) != 0) {
            l2 = System.currentTimeMillis();
        }
        this(entity, columnDefArray, l, l2);
    }

    @NotNull
    public final Entity component1() {
        return this.entity;
    }

    @NotNull
    public final ColumnDef<?>[] component2() {
        return this.columns;
    }

    public final long component3() {
        return this.size;
    }

    public final long component4() {
        return this.seed;
    }

    @NotNull
    public final EntitySamplePhysicalNodeExpression copy(@NotNull Entity entity, @NotNull ColumnDef<?>[] columns, long size, long seed) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return new EntitySamplePhysicalNodeExpression(entity, columns, size, seed);
    }

    public static /* synthetic */ EntitySamplePhysicalNodeExpression copy$default(EntitySamplePhysicalNodeExpression entitySamplePhysicalNodeExpression, Entity entity, ColumnDef[] columnDefArray, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            entity = entitySamplePhysicalNodeExpression.entity;
        }
        if ((n & 2) != 0) {
            columnDefArray = entitySamplePhysicalNodeExpression.columns;
        }
        if ((n & 4) != 0) {
            l = entitySamplePhysicalNodeExpression.size;
        }
        if ((n & 8) != 0) {
            l2 = entitySamplePhysicalNodeExpression.seed;
        }
        return entitySamplePhysicalNodeExpression.copy(entity, columnDefArray, l, l2);
    }

    @NotNull
    public String toString() {
        return "EntitySamplePhysicalNodeExpression(entity=" + this.entity + ", columns=" + Arrays.toString(this.columns) + ", size=" + this.size + ", seed=" + this.seed + ")";
    }

    public int hashCode() {
        Entity entity = this.entity;
        return (((entity != null ? entity.hashCode() : 0) * 31 + (this.columns != null ? Arrays.hashCode(this.columns) : 0)) * 31 + Long.hashCode(this.size)) * 31 + Long.hashCode(this.seed);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EntitySamplePhysicalNodeExpression)) break block3;
                EntitySamplePhysicalNodeExpression entitySamplePhysicalNodeExpression = (EntitySamplePhysicalNodeExpression)object;
                if (!Intrinsics.areEqual((Object)this.entity, (Object)entitySamplePhysicalNodeExpression.entity) || !Intrinsics.areEqual(this.columns, entitySamplePhysicalNodeExpression.columns) || this.size != entitySamplePhysicalNodeExpression.size || this.seed != entitySamplePhysicalNodeExpression.seed) break block3;
            }
            return true;
        }
        return false;
    }
}

