/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.math.knn.metrics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.math.knn.metrics.DistanceKernel;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\rJ:\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\u000f\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/math/knn/metrics/CosineDistance;", "Lorg/vitrivr/cottontail/math/knn/metrics/DistanceKernel;", "()V", "costForDimension", "", "d", "", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "a", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "b", "invoke-Z2rTJmk", "(Lorg/vitrivr/cottontail/model/values/types/VectorValue;Lorg/vitrivr/cottontail/model/values/types/VectorValue;)D", "weights", "(Lorg/vitrivr/cottontail/model/values/types/VectorValue;Lorg/vitrivr/cottontail/model/values/types/VectorValue;Lorg/vitrivr/cottontail/model/values/types/VectorValue;)D", "cottontaildb"})
public final class CosineDistance
implements DistanceKernel {
    public static final CosineDistance INSTANCE;

    @Override
    public float costForDimension(int d) {
        return 6.0f * Cost.Companion.getCOST_FLOP() + 3.0f / (float)d * Cost.Companion.getCOST_FLOP();
    }

    @Override
    public double invoke-Z2rTJmk(@NotNull VectorValue<?> a, @NotNull VectorValue<?> b) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        return DoubleValue.minus-Z2rTJmk(DoubleValue.Companion.getONE-Z2rTJmk(), DoubleValue.box-impl(a.dot(b).div(a.norm2().times((NumericValue)b.norm2())).asDouble-Z2rTJmk()));
    }

    @Override
    public double invoke-Z2rTJmk(@NotNull VectorValue<?> a, @NotNull VectorValue<?> b, @NotNull VectorValue<?> weights) {
        Intrinsics.checkNotNullParameter(a, (String)"a");
        Intrinsics.checkNotNullParameter(b, (String)"b");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        VectorValue<?> wa = a.times(weights);
        VectorValue<?> wb = b.times(weights);
        return DoubleValue.minus-Z2rTJmk(DoubleValue.Companion.getONE-Z2rTJmk(), DoubleValue.box-impl(wa.dot(wb).div(wa.norm2().times((NumericValue)wb.norm2())).asDouble-Z2rTJmk()));
    }

    private CosineDistance() {
    }

    static {
        CosineDistance cosineDistance;
        INSTANCE = cosineDistance = new CosineDistance();
    }
}

