/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.basics;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.BooleanColumnType;
import org.vitrivr.cottontail.database.column.BooleanVectorColumnType;
import org.vitrivr.cottontail.database.column.ByteColumnType;
import org.vitrivr.cottontail.database.column.ColumnType;
import org.vitrivr.cottontail.database.column.Complex32ColumnType;
import org.vitrivr.cottontail.database.column.Complex32VectorColumnType;
import org.vitrivr.cottontail.database.column.Complex64ColumnType;
import org.vitrivr.cottontail.database.column.Complex64VectorColumnType;
import org.vitrivr.cottontail.database.column.DoubleColumnType;
import org.vitrivr.cottontail.database.column.DoubleVectorColumnType;
import org.vitrivr.cottontail.database.column.FloatColumnType;
import org.vitrivr.cottontail.database.column.FloatVectorColumnType;
import org.vitrivr.cottontail.database.column.IntColumnType;
import org.vitrivr.cottontail.database.column.IntVectorColumnType;
import org.vitrivr.cottontail.database.column.LongColumnType;
import org.vitrivr.cottontail.database.column.LongVectorColumnType;
import org.vitrivr.cottontail.database.column.ShortColumnType;
import org.vitrivr.cottontail.database.column.StringColumnType;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.ValidationException;
import org.vitrivr.cottontail.model.values.BooleanValue;
import org.vitrivr.cottontail.model.values.BooleanVectorValue;
import org.vitrivr.cottontail.model.values.ByteValue;
import org.vitrivr.cottontail.model.values.Complex32Value;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.IntValue;
import org.vitrivr.cottontail.model.values.IntVectorValue;
import org.vitrivr.cottontail.model.values.LongValue;
import org.vitrivr.cottontail.model.values.LongVectorValue;
import org.vitrivr.cottontail.model.values.ShortValue;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001!B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002J\u0013\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\u001a\u001a\u00020\tH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002J\u0010\u0010\u001f\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "type", "Lorg/vitrivr/cottontail/database/column/ColumnType;", "logicalSize", "", "nullable", "", "(Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;Lorg/vitrivr/cottontail/database/column/ColumnType;IZ)V", "getLogicalSize", "()I", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getNullable", "()Z", "physicalSize", "getPhysicalSize", "getType", "()Lorg/vitrivr/cottontail/database/column/ColumnType;", "defaultValue", "equals", "other", "hashCode", "toString", "", "validate", "value", "validateOrThrow", "", "Companion", "cottontaildb"})
public final class ColumnDef<T extends Value> {
    @NotNull
    private final Name.ColumnName name;
    @NotNull
    private final ColumnType<T> type;
    private final int logicalSize;
    private final boolean nullable;
    public static final Companion Companion = new Companion(null);

    public final int getPhysicalSize() {
        return this.logicalSize * this.type.getSize();
    }

    public final void validateOrThrow(@Nullable Value value) {
        if (value != null) {
            if (!this.type.compatible(value)) {
                throw (Throwable)new ValidationException("The type " + this.type + " of column '" + this.name + "' is not compatible with value " + value + '.');
            }
            T cast = this.type.cast(value);
            if (cast instanceof DoubleVectorValue && cast.getLogicalSize() != this.logicalSize) {
                throw (Throwable)new ValidationException("The size of column '" + this.name + "' (sc=" + this.logicalSize + ") is not compatible with size of value (sv=" + cast.getLogicalSize() + ").");
            }
            if (cast instanceof FloatVectorValue && cast.getLogicalSize() != this.logicalSize) {
                throw (Throwable)new ValidationException("The size of column '" + this.name + "' (sc=" + this.logicalSize + ") is not compatible with size of value (sv=" + cast.getLogicalSize() + ").");
            }
            if (cast instanceof LongVectorValue && cast.getLogicalSize() != this.logicalSize) {
                throw (Throwable)new ValidationException("The size of column '" + this.name + "' (sc=" + this.logicalSize + ") is not compatible with size of value (sv=" + cast.getLogicalSize() + ").");
            }
            if (cast instanceof IntVectorValue && cast.getLogicalSize() != this.logicalSize) {
                throw (Throwable)new ValidationException("The size of column '" + this.name + "' (sc=" + this.logicalSize + ") is not compatible with size of value (sv=" + cast.getLogicalSize() + ").");
            }
            if (cast instanceof Complex32VectorValue && cast.getLogicalSize() != this.logicalSize) {
                throw (Throwable)new ValidationException("The size of column '" + this.name + "' (sc=" + this.logicalSize + ") is not compatible with size of value (sv=" + cast.getLogicalSize() + ").");
            }
            if (cast instanceof Complex64VectorValue && cast.getLogicalSize() != this.logicalSize) {
                throw (Throwable)new ValidationException("The size of column '" + this.name + "' (sc=" + this.logicalSize + ") is not compatible with size of value (sv=" + cast.getLogicalSize() + ").");
            }
        } else if (!this.nullable) {
            throw (Throwable)new ValidationException("The column '" + this.name + "' cannot be null!");
        }
    }

    public final boolean validate(@Nullable Value value) {
        if (value != null) {
            if (!this.type.compatible(value)) {
                return false;
            }
            T cast = this.type.cast(value);
            return cast instanceof DoubleVectorValue && cast.getLogicalSize() != this.logicalSize ? false : (cast instanceof FloatVectorValue && cast.getLogicalSize() != this.logicalSize ? false : (cast instanceof LongVectorValue && cast.getLogicalSize() != this.logicalSize ? false : (cast instanceof IntVectorValue && cast.getLogicalSize() != this.logicalSize ? false : (cast instanceof Complex32VectorValue && cast.getLogicalSize() != this.logicalSize ? false : !(cast instanceof Complex64VectorValue) || cast.getLogicalSize() == this.logicalSize))));
        }
        return this.nullable;
    }

    @Nullable
    public final Value defaultValue() {
        Value value;
        if (this.nullable) {
            value = null;
        } else if (this.type instanceof StringColumnType) {
            value = StringValue.box-impl(StringValue.constructor-impl(""));
        } else if (this.type instanceof FloatColumnType) {
            value = FloatValue.box-impl(FloatValue.constructor-impl(0.0f));
        } else if (this.type instanceof DoubleColumnType) {
            value = DoubleValue.box-impl(DoubleValue.constructor-impl(0.0));
        } else if (this.type instanceof IntColumnType) {
            value = IntValue.box-impl(IntValue.constructor-impl(0));
        } else if (this.type instanceof LongColumnType) {
            value = LongValue.box-impl(LongValue.constructor-impl(0L));
        } else if (this.type instanceof ShortColumnType) {
            value = ShortValue.box-impl(ShortValue.constructor-impl((short)0));
        } else if (this.type instanceof ByteColumnType) {
            value = ByteValue.box-impl(ByteValue.constructor-impl((byte)0));
        } else if (this.type instanceof BooleanColumnType) {
            value = BooleanValue.box-impl(BooleanValue.constructor-impl(false));
        } else if (this.type instanceof Complex32ColumnType) {
            value = Complex32Value.box-impl(Complex32Value.Companion.getZERO-WO0UQc4());
        } else if (this.type instanceof Complex64ColumnType) {
            value = Complex64Value.box-impl(Complex64Value.Companion.getZERO-IY5coek());
        } else if (this.type instanceof DoubleVectorColumnType) {
            value = DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl(new double[this.logicalSize]));
        } else if (this.type instanceof FloatVectorColumnType) {
            value = FloatVectorValue.box-impl(FloatVectorValue.constructor-impl(new float[this.logicalSize]));
        } else if (this.type instanceof LongVectorColumnType) {
            value = LongVectorValue.box-impl(LongVectorValue.constructor-impl(new long[this.logicalSize]));
        } else if (this.type instanceof IntVectorColumnType) {
            value = IntVectorValue.box-impl(IntVectorValue.constructor-impl(new int[this.logicalSize]));
        } else if (this.type instanceof BooleanVectorColumnType) {
            value = BooleanVectorValue.box-impl(BooleanVectorValue.constructor-impl(new boolean[this.logicalSize]));
        } else if (this.type instanceof Complex32VectorColumnType) {
            int n = 2 * this.logicalSize;
            float[] fArray = new float[n];
            int n2 = 0;
            while (n2 < n) {
                float f;
                int n3 = n2;
                int n4 = n2++;
                float[] fArray2 = fArray;
                boolean bl = false;
                fArray2[n4] = f = 0.0f;
            }
            value = Complex32VectorValue.box-impl(Complex32VectorValue.constructor-impl(fArray));
        } else if (this.type instanceof Complex64VectorColumnType) {
            int n = 2 * this.logicalSize;
            double[] dArray = new double[n];
            int n5 = 0;
            while (n5 < n) {
                double d;
                int it = n5;
                int n6 = n5++;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n6] = d = 0.0;
            }
            value = Complex64VectorValue.box-impl(Complex64VectorValue.constructor-impl(dArray));
        } else {
            throw (Throwable)new RuntimeException("Default value for the specified type " + this.type + " has not been specified yet!");
        }
        return value;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<*>");
        }
        ColumnDef cfr_ignored_0 = (ColumnDef)object2;
        if (Intrinsics.areEqual((Object)this.name, (Object)((ColumnDef)other).name) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.type, ((ColumnDef)other).type) ^ true) {
            return false;
        }
        return this.logicalSize == ((ColumnDef)other).logicalSize;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Integer.hashCode(this.logicalSize);
        return result;
    }

    @NotNull
    public String toString() {
        return this.name + "(type=" + this.type + ", size=" + this.logicalSize + ", nullable=" + this.nullable + ')';
    }

    @NotNull
    public final Name.ColumnName getName() {
        return this.name;
    }

    @NotNull
    public final ColumnType<T> getType() {
        return this.type;
    }

    public final int getLogicalSize() {
        return this.logicalSize;
    }

    public final boolean getNullable() {
        return this.nullable;
    }

    public ColumnDef(@NotNull Name.ColumnName name, @NotNull ColumnType<T> type, int logicalSize, boolean nullable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.name = name;
        this.type = type;
        this.logicalSize = logicalSize;
        this.nullable = nullable;
    }

    public /* synthetic */ ColumnDef(Name.ColumnName columnName, ColumnType columnType, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(columnName, columnType, n, bl);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/model/basics/ColumnDef$Companion;", "", "()V", "withAttributes", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "type", "", "size", "", "nullable", "", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final ColumnDef<?> withAttributes(@NotNull Name.ColumnName name, @NotNull String type, int size, boolean nullable) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new ColumnDef(name, ColumnType.Companion.forName(type), size, nullable);
        }

        public static /* synthetic */ ColumnDef withAttributes$default(Companion companion, Name.ColumnName columnName, String string, int n, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = -1;
            }
            if ((n2 & 8) != 0) {
                bl = true;
            }
            return companion.withAttributes(columnName, string, n, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

