/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.exceptions;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DBException;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001:\t\u0005\u0006\u0007\b\t\n\u000b\f\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "message", "", "(Ljava/lang/String;)V", "ColumnUnknownException", "InvalidTupleId", "TransactionClosedException", "TransactionDBOClosedException", "TransactionInErrorException", "TransactionReadOnlyException", "TransactionStorageException", "TransactionValidationException", "TransactionWriteLockException", "cottontaildb"})
public class TransactionException
extends DatabaseException {
    public TransactionException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionDBOClosedException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "cottontaildb"})
    public static final class TransactionDBOClosedException
    extends TransactionException {
        public TransactionDBOClosedException(@NotNull UUID tid) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            super("The enclosing DBO has been closed. Transaction " + tid + " could not be created!");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionClosedException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "cottontaildb"})
    public static final class TransactionClosedException
    extends TransactionException {
        public TransactionClosedException(@NotNull UUID tid) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            super("Transaction " + tid + " has been closed and cannot be used anymore.");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionInErrorException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "cottontaildb"})
    public static final class TransactionInErrorException
    extends TransactionException {
        public TransactionInErrorException(@NotNull UUID tid) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            super("Transaction " + tid + " is in error and cannot be used, until it is rolled back.");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionReadOnlyException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "cottontaildb"})
    public static final class TransactionReadOnlyException
    extends TransactionException {
        public TransactionReadOnlyException(@NotNull UUID tid) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            super("Transaction " + tid + " is read-only and cannot be used to alter data.");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionWriteLockException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "(Ljava/util/UUID;)V", "cottontaildb"})
    public static final class TransactionWriteLockException
    extends TransactionException {
        public TransactionWriteLockException(@NotNull UUID tid) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            super("Transaction " + tid + " was unable to obtain the necessary locks.");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionValidationException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "message", "", "(Ljava/util/UUID;Ljava/lang/String;)V", "cottontaildb"})
    public static final class TransactionValidationException
    extends TransactionException {
        public TransactionValidationException(@NotNull UUID tid, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Transaction " + tid + " reported validation error: " + message);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$TransactionStorageException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "message", "", "(Ljava/util/UUID;Ljava/lang/String;)V", "cottontaildb"})
    public static final class TransactionStorageException
    extends TransactionException {
        public TransactionStorageException(@NotNull UUID tid, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super("Transaction " + tid + " reported storage error: " + message);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$InvalidTupleId;", "Lorg/mapdb/DBException;", "tid", "Ljava/util/UUID;", "tupleId", "", "(Ljava/util/UUID;J)V", "cottontaildb"})
    public static final class InvalidTupleId
    extends DBException {
        public InvalidTupleId(@NotNull UUID tid, long tupleId) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            super("Transaction " + tid + " reported an error: The provided tuple ID " + tupleId + " is out of bounds and therefore invalid.");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/TransactionException$ColumnUnknownException;", "Lorg/vitrivr/cottontail/model/exceptions/TransactionException;", "tid", "Ljava/util/UUID;", "column", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "(Ljava/util/UUID;Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "cottontaildb"})
    public static final class ColumnUnknownException
    extends TransactionException {
        public ColumnUnknownException(@NotNull UUID tid, @NotNull ColumnDef<?> column) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            super("Transaction " + tid + " could not be executed, because column '" + column.getName() + "' (type=" + column.getType().getName() + ", size=" + column.getLogicalSize() + ") does not either not exist or has a different type.");
        }
    }
}

