/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.recordset;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.queries.components.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Filterable;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Scanable;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00019B!\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0004\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0012J'\u0010\u0018\u001a\u00020\u00192\n\u0010\u001e\u001a\u00060\u0007j\u0002`\u001f2\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u0004\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010$\u001a\u00020\nJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010'\u001a\u0004\u0018\u00010\u0012J \u0010(\u001a\u00020)2\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020)0+J\u0015\u0010,\u001a\u00020\u00122\n\u0010\u001e\u001a\u00060\u0007j\u0002`\u001fH\u0086\u0002J\u0012\u0010-\u001a\u00020\n2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0005J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00120&J%\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u0016\u00a2\u0006\u0002\u00102J-\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120&2\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u00103\u001a\u000204H\u0016\u00a2\u0006\u0002\u00105J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001207J\u000e\u00108\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006:"}, d2={"Lorg/vitrivr/cottontail/model/recordset/Recordset;", "Lorg/vitrivr/cottontail/model/basics/Scanable;", "Lorg/vitrivr/cottontail/model/basics/Filterable;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "capacity", "", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;J)V", "columnCount", "", "getColumnCount", "()I", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "list", "Lit/unimi/dsi/fastutil/objects/ObjectBigArrayBigList;", "Lorg/vitrivr/cottontail/model/basics/Record;", "lock", "Ljava/util/concurrent/locks/StampedLock;", "rowCount", "getRowCount", "()J", "addRow", "", "values", "Lorg/vitrivr/cottontail/model/values/types/Value;", "([Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "record", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "(J[Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "column", "filter", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "first", "forEachIndexed", "", "action", "Lkotlin/Function2;", "get", "indexOf", "intersect", "other", "iterator", "scan", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;)Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "range", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;Lkotlin/ranges/LongRange;)Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "toList", "", "union", "RecordsetRecord", "cottontaildb"})
public final class Recordset
implements Scanable,
Filterable {
    private final ObjectBigArrayBigList<Record> list;
    private final StampedLock lock;
    @NotNull
    private final ColumnDef<?>[] columns;

    public final int getColumnCount() {
        return this.columns.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRowCount() {
        long l;
        long stamp = this.lock.tryOptimisticRead();
        long size = this.list.size64();
        if (this.lock.validate(stamp)) {
            l = size;
        } else {
            long l2;
            try {
                stamp = this.lock.readLock();
                l2 = size;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
            l = l2;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addRow(long tupleId, @NotNull Value[] values) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        StampedLock $this$write$iv = this.lock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean bl2 = false;
            bl = this.list.add((Object)new RecordsetRecord(tupleId, values));
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
        return bl;
    }

    public final boolean addRow(@NotNull Value[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.addRow(this.list.size64(), values);
    }

    public final boolean addRow(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        return this.addRow(record.getTupleId(), record.getValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Record get(long tupleId) {
        Record record;
        long stamp = this.lock.tryOptimisticRead();
        Record value = (Record)this.list.get(tupleId);
        if (this.lock.validate(stamp)) {
            Record record2 = value;
            record = record2;
            Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"value");
        } else {
            Record record3;
            try {
                stamp = this.lock.readLock();
                record3 = (Record)this.list.get(tupleId);
            }
            finally {
                this.lock.unlockRead(stamp);
            }
            Record record4 = record3;
            record = record4;
            Intrinsics.checkNotNullExpressionValue((Object)record4, (String)"try {\n                st\u2026Read(stamp)\n            }");
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Recordset union(@NotNull Recordset other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            long it;
            long element$iv;
            boolean bl = false;
            Object object = other.columns;
            Object[] objectArray = this.columns;
            boolean bl2 = false;
            if (!ArraysKt.contentDeepEquals((Object[])object, (Object[])objectArray)) {
                throw (Throwable)new IllegalArgumentException("UNION of record sets not possible; columns of the two record sets are not the same!");
            }
            object = new Recordset(this.columns, 0L, 2, null);
            boolean bl3 = false;
            bl2 = false;
            Object object2 = object;
            boolean bl4 = false;
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)this.list.size64());
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl5 = false;
                Object object3 = this.list.get(it);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"this.list[it]");
                ((Recordset)object2).addRow((Record)object3);
            }
            $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)this.list.size64());
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl6 = false;
                Object object4 = this.list.get(it);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"this.list[it]");
                ((Recordset)object2).addRow((Record)object4);
            }
            Object object5 = object;
            return object5;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Recordset intersect(@NotNull Recordset other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            long it;
            long element$iv;
            boolean bl = false;
            Object object = other.columns;
            Object[] objectArray = this.columns;
            boolean bl2 = false;
            if (!ArraysKt.contentDeepEquals((Object[])object, (Object[])objectArray)) {
                throw (Throwable)new IllegalArgumentException("INTERSECT of record sets not possible; columns of the two record sets are not the same!");
            }
            object = new Recordset(this.columns, 0L, 2, null);
            boolean bl3 = false;
            bl2 = false;
            Object object2 = object;
            boolean bl4 = false;
            Long2LongOpenHashMap map2 = new Long2LongOpenHashMap();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)this.list.size64());
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl5 = false;
                ((Map)map2).put(((Record)this.list.get(it)).getTupleId(), it);
            }
            $this$forEach$iv = (Iterable)RangesKt.until((long)0L, (long)other.list.size64());
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = ((LongIterator)iterator2).nextLong();
                boolean bl6 = false;
                Record record = (Record)this.list.get(it);
                Map map3 = (Map)map2;
                Long l = record.getTupleId();
                boolean bl7 = false;
                Map map4 = map3;
                boolean bl8 = false;
                if (!map4.containsKey(l)) continue;
                Record record2 = record;
                Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"record");
                ((Recordset)object2).addRow(record2);
            }
            Object object3 = object;
            return object3;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    @Nullable
    public final Record first() {
        return (Record)CollectionsKt.first((Iterable)((Iterable)this.list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void forEachIndexed(@NotNull Function2<? super Integer, ? super Record, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            void $this$forEachIndexed$iv;
            boolean $i$a$-read-Recordset$forEachIndexed$22 = false;
            Iterable iterable = (Iterable)this.list;
            Function2<? super Integer, ? super Record, Unit> action$iv = action2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                action$iv.invoke((Object)n, item$iv);
            }
            Unit $i$a$-read-Recordset$forEachIndexed$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        ColumnDef it;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate)) return false;
        Iterable $this$all$iv = predicate.getColumns();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            it = (ColumnDef)element$iv;
            boolean bl = false;
        } while (ArraysKt.contains((Object[])this.columns, (Object)it));
        return false;
    }

    @Override
    @NotNull
    public CloseableIterator<Record> filter(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final ColumnDef<?> column(int column) {
        return this.columns[column];
    }

    public final int indexOf(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.indexOf((Object[])this.columns, column);
    }

    @NotNull
    public final List<Record> toList() {
        return CollectionsKt.toList((Iterable)((Iterable)this.list));
    }

    @NotNull
    public final CloseableIterator<Record> iterator() {
        return new CloseableIterator<Record>(this){
            private final long stamp;
            private volatile boolean closed;
            private volatile long pointer;
            final /* synthetic */ Recordset this$0;

            public boolean hasNext() {
                if (this.closed) {
                    throw (Throwable)new IllegalStateException("Illegal invocation of hasNext(): This CloseableIterator has been closed.");
                }
                return this.pointer < Recordset.access$getList$p(this.this$0).size64();
            }

            @NotNull
            public Record next() {
                if (this.closed) {
                    throw (Throwable)new IllegalStateException("Illegal invocation of next(): This CloseableIterator has been closed.");
                }
                Record record = (Record)Recordset.access$getList$p(this.this$0).get(this.pointer);
                ++this.pointer;
                Record record2 = record;
                Intrinsics.checkNotNullExpressionValue((Object)record2, (String)"record");
                return record2;
            }

            public void close() {
                if (!this.closed) {
                    this.closed = true;
                    Recordset.access$getLock$p(this.this$0).unlockRead(this.stamp);
                }
            }

            protected final void finalize() {
                this.close();
            }
            {
                this.this$0 = this$0;
                this.stamp = Recordset.access$getLock$p(this$0).readLock();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Override
    @NotNull
    public CloseableIterator<Record> scan(@NotNull ColumnDef<?>[] columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public CloseableIterator<Record> scan(@NotNull ColumnDef<?>[] columns, @NotNull LongRange range) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public Recordset(@NotNull ColumnDef<?>[] columns, long capacity) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
        this.list = new ObjectBigArrayBigList(capacity);
        this.lock = new StampedLock();
    }

    public /* synthetic */ Recordset(ColumnDef[] columnDefArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 250L;
        }
        this(columnDefArray, l);
    }

    public static final /* synthetic */ ObjectBigArrayBigList access$getList$p(Recordset $this) {
        return $this.list;
    }

    public static final /* synthetic */ StampedLock access$getLock$p(Recordset $this) {
        return $this.lock;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0001H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001e\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/model/recordset/Recordset$RecordsetRecord;", "Lorg/vitrivr/cottontail/model/basics/Record;", "tupleId", "", "values", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(Lorg/vitrivr/cottontail/model/recordset/Recordset;J[Lorg/vitrivr/cottontail/model/values/types/Value;)V", "columns", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getTupleId", "()J", "getValues", "()[Lorg/vitrivr/cottontail/model/values/types/Value;", "[Lorg/vitrivr/cottontail/model/values/types/Value;", "copy", "equals", "", "other", "", "hashCode", "", "cottontaildb"})
    public final class RecordsetRecord
    implements Record {
        private final long tupleId;
        @NotNull
        private final Value[] values;

        @Override
        @NotNull
        public ColumnDef<?>[] getColumns() {
            return Recordset.this.getColumns();
        }

        @Override
        @NotNull
        public Record copy() {
            long l = this.getTupleId();
            ColumnDef<?>[] columnDefArray = this.getColumns();
            Value[] valueArray = this.getValues();
            boolean bl = false;
            Value[] valueArray2 = Arrays.copyOf(valueArray, valueArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)valueArray2, (String)"java.util.Arrays.copyOf(this, size)");
            return new StandaloneRecord(l, columnDefArray, valueArray2);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
                return false;
            }
            Object object2 = other;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.Record");
            }
            Record cfr_ignored_0 = (Record)object2;
            if (this.getTupleId() != ((Record)other).getTupleId()) {
                return false;
            }
            Object[] objectArray = this.getColumns();
            Object[] objectArray2 = ((Record)other).getColumns();
            boolean bl = false;
            if (!Arrays.equals(objectArray, objectArray2)) {
                return false;
            }
            objectArray = this.getValues();
            objectArray2 = ((Record)other).getValues();
            bl = false;
            return Arrays.equals(objectArray, objectArray2);
        }

        public int hashCode() {
            int result = Long.hashCode(this.getTupleId());
            result = 31 * result + this.getColumns().hashCode();
            Object[] objectArray = this.getValues();
            boolean bl = false;
            result = 31 * result + Arrays.hashCode(objectArray);
            return result;
        }

        @Override
        public long getTupleId() {
            return this.tupleId;
        }

        @Override
        @NotNull
        public Value[] getValues() {
            return this.values;
        }

        /*
         * WARNING - void declaration
         */
        public RecordsetRecord(@NotNull long tupleId, Value[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.tupleId = tupleId;
            this.values = values;
            boolean bl = this.getValues().length == this.getColumns().length;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The number of values must be equal to the number of columns held by the StandaloneRecord (v = " + this.getValues().length + ", c = " + this.getColumns().length + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ColumnDef<?>[] $this$forEachIndexed$iv = this.getColumns();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ColumnDef<?> item$iv : $this$forEachIndexed$iv) {
                void columnDef;
                int n = index$iv++;
                ColumnDef<?> columnDef2 = item$iv;
                int index = n;
                boolean bl5 = false;
                columnDef.validateOrThrow(this.getValues()[index]);
            }
        }

        @Override
        public int getSize() {
            return Record.DefaultImpls.getSize(this);
        }

        @Override
        @Nullable
        public Value first() {
            return Record.DefaultImpls.first(this);
        }

        @Override
        @Nullable
        public Value last() {
            return Record.DefaultImpls.last(this);
        }

        @Override
        @NotNull
        public Record assign(@NotNull Value[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return Record.DefaultImpls.assign(this, values);
        }

        @Override
        public boolean has(@NotNull ColumnDef<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return Record.DefaultImpls.has(this, column);
        }

        @Override
        @NotNull
        public Map<Name, Value> toMap() {
            return Record.DefaultImpls.toMap(this);
        }

        @Override
        @Nullable
        public <T extends Value> T get(@NotNull ColumnDef<T> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return Record.DefaultImpls.get(this, column);
        }

        @Override
        public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Record.DefaultImpls.set(this, column, value);
        }
    }
}

