/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.recordset;

import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B1\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R \u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/model/recordset/StandaloneRecord;", "Lorg/vitrivr/cottontail/model/basics/Record;", "tupleId", "", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "values", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(J[Lorg/vitrivr/cottontail/model/basics/ColumnDef;[Lorg/vitrivr/cottontail/model/values/types/Value;)V", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getTupleId", "()J", "getValues", "()[Lorg/vitrivr/cottontail/model/values/types/Value;", "[Lorg/vitrivr/cottontail/model/values/types/Value;", "copy", "equals", "", "other", "", "hashCode", "", "cottontaildb"})
public final class StandaloneRecord
implements Record {
    private final long tupleId;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Value[] values;

    @Override
    @NotNull
    public Record copy() {
        long l = this.getTupleId();
        ColumnDef<?>[] columnDefArray = this.getColumns();
        Value[] valueArray = this.getValues();
        boolean bl = false;
        Value[] valueArray2 = Arrays.copyOf(valueArray, valueArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)valueArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return new StandaloneRecord(l, columnDefArray, valueArray2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.Record");
        }
        Record cfr_ignored_0 = (Record)object2;
        if (this.getTupleId() != ((Record)other).getTupleId()) {
            return false;
        }
        Object[] objectArray = this.getColumns();
        Object[] objectArray2 = ((Record)other).getColumns();
        boolean bl = false;
        if (!Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        objectArray = this.getValues();
        objectArray2 = ((Record)other).getValues();
        bl = false;
        return Arrays.equals(objectArray, objectArray2);
    }

    public int hashCode() {
        int result = Long.hashCode(this.getTupleId());
        result = 31 * result + this.getColumns().hashCode();
        Object[] objectArray = this.getValues();
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(objectArray);
        return result;
    }

    @Override
    public long getTupleId() {
        return this.tupleId;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Value[] getValues() {
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    public StandaloneRecord(long tupleId, @NotNull ColumnDef<?>[] columns, @NotNull Value[] values) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tupleId = tupleId;
        this.columns = columns;
        this.values = values;
        boolean bl = this.getValues().length == this.getColumns().length;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The number of values must be equal to the number of columns held by the StandaloneRecord (v = " + this.getValues().length + ", c = " + this.getColumns().length + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ColumnDef<?>[] $this$forEachIndexed$iv = this.getColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ColumnDef<?> item$iv : $this$forEachIndexed$iv) {
            void columnDef;
            int n = index$iv++;
            ColumnDef<?> columnDef2 = item$iv;
            int index = n;
            boolean bl5 = false;
            columnDef.validateOrThrow(this.getValues()[index]);
        }
    }

    public /* synthetic */ StandaloneRecord(long l, ColumnDef[] columnDefArray, Value[] valueArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = Long.MIN_VALUE;
        }
        this(l, columnDefArray, valueArray);
    }

    @Override
    public int getSize() {
        return Record.DefaultImpls.getSize(this);
    }

    @Override
    @Nullable
    public Value first() {
        return Record.DefaultImpls.first(this);
    }

    @Override
    @Nullable
    public Value last() {
        return Record.DefaultImpls.last(this);
    }

    @Override
    @NotNull
    public Record assign(@NotNull Value[] values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return Record.DefaultImpls.assign(this, values);
    }

    @Override
    public boolean has(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return Record.DefaultImpls.has(this, column);
    }

    @Override
    @NotNull
    public Map<Name, Value> toMap() {
        return Record.DefaultImpls.toMap(this);
    }

    @Override
    @Nullable
    public <T extends Value> T get(@NotNull ColumnDef<T> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return Record.DefaultImpls.get(this, column);
    }

    @Override
    public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Record.DefaultImpls.set(this, column, value);
    }
}

