/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.column.BooleanVectorColumnType;
import org.vitrivr.cottontail.database.column.ColumnType;
import org.vitrivr.cottontail.database.column.Complex32VectorColumnType;
import org.vitrivr.cottontail.database.column.Complex64VectorColumnType;
import org.vitrivr.cottontail.database.column.DoubleVectorColumnType;
import org.vitrivr.cottontail.database.column.FloatVectorColumnType;
import org.vitrivr.cottontail.database.column.IntVectorColumnType;
import org.vitrivr.cottontail.database.column.LongVectorColumnType;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.components.AtomicBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.components.CompoundBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ConnectionOperator;
import org.vitrivr.cottontail.database.queries.components.KnnPredicate;
import org.vitrivr.cottontail.database.queries.components.Projection;
import org.vitrivr.cottontail.database.queries.planning.nodes.interfaces.NodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.LogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.NullaryLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.management.DeleteLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.management.UpdateLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.predicates.FilterLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.predicates.KnnLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.projection.LimitLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.projection.ProjectionLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.sources.EntitySampleLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.sources.EntityScanLogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.predicates.KnnPredicateHint;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.math.knn.metrics.DistanceKernel;
import org.vitrivr.cottontail.math.knn.metrics.Distances;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.BooleanVectorValue;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.IntVectorValue;
import org.vitrivr.cottontail.model.values.LongVectorValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.server.grpc.helper.DataExtensionsKt;
import org.vitrivr.cottontail.server.grpc.helper.ExtensionsKt;
import org.vitrivr.cottontail.server.grpc.helper.GrpcQueryBinder$WhenMappings;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/server/grpc/helper/GrpcQueryBinder;", "", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "parseAndBind", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/logical/LogicalNodeExpression;", "query", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Query;", "parseAndBindAtomicBooleanPredicate", "Lorg/vitrivr/cottontail/database/queries/components/AtomicBooleanPredicate;", "entity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "atomic", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$AtomicLiteralBooleanPredicate;", "parseAndBindBooleanPredicate", "Lorg/vitrivr/cottontail/database/queries/components/BooleanPredicate;", "where", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Where;", "parseAndBindCompoundBooleanPredicate", "Lorg/vitrivr/cottontail/database/queries/components/CompoundBooleanPredicate;", "compound", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CompoundBooleanPredicate;", "parseAndBindDelete", "delete", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DeleteMessage;", "parseAndBindKnnPredicate", "Lorg/vitrivr/cottontail/database/queries/components/KnnPredicate;", "knn", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Knn;", "parseAndBindProjection", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/logical/projection/ProjectionLogicalNodeExpression;", "projection", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Projection;", "parseAndBindSimpleFrom", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/logical/NullaryLogicalNodeExpression;", "from", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$From;", "parseAndBindSimpleQuery", "parseAndBindUpdate", "update", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$UpdateMessage;", "cottontaildb"})
public final class GrpcQueryBinder {
    @NotNull
    private final Catalogue catalogue;

    @NotNull
    public final LogicalNodeExpression parseAndBind(@NotNull CottontailGrpc.Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (!query.hasFrom()) {
            throw (Throwable)new QueryException.QuerySyntaxException("Missing FROM-clause in query.");
        }
        if (query.getFrom().hasQuery()) {
            throw (Throwable)new QueryException.QuerySyntaxException("Cottontail DB currently doesn't support sub-selects.");
        }
        return this.parseAndBindSimpleQuery(query);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LogicalNodeExpression parseAndBindUpdate(@NotNull CottontailGrpc.UpdateMessage update) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        CottontailGrpc.From from = update.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)from, (String)"update.from");
        Pair<Entity, NullaryLogicalNodeExpression> scanClause = this.parseAndBindSimpleFrom(from);
        Entity entity = (Entity)scanClause.getFirst();
        LogicalNodeExpression root = (LogicalNodeExpression)scanClause.getSecond();
        if (update.hasWhere()) {
            CottontailGrpc.Where where = update.getWhere();
            Intrinsics.checkNotNullExpressionValue((Object)where, (String)"update.where");
            FilterLogicalNodeExpression where2 = new FilterLogicalNodeExpression(this.parseAndBindBooleanPredicate(entity, where));
            where2.addInput((NodeExpression)root);
            root = where2;
        }
        CottontailGrpc.Tuple tuple = update.getTuple();
        Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"update.tuple");
        Map<String, CottontailGrpc.Data> map2 = tuple.getDataMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"update.tuple.dataMap");
        Map<String, CottontailGrpc.Data> $this$map$iv = map2;
        boolean $i$f$map = false;
        Map<String, CottontailGrpc.Data> map3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var11_11 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var11_11.entrySet().iterator();
        while (iterator2.hasNext()) {
            ColumnDef<?> column;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Name.EntityName entityName = entity.getName();
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            Name.ColumnName columnName = entityName.column((String)k);
            if (entity.columnForName(columnName) == null) {
                throw (Throwable)new QueryException.QueryBindException("Failed to bind column '" + columnName + "'. Column does not exist on entity'.");
            }
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            Pair pair = TuplesKt.to(column, DataExtensionsKt.toValue((CottontailGrpc.Data)v, column));
            collection.add(pair);
        }
        List values = (List)destination$iv$iv;
        UpdateLogicalNodeExpression upd = new UpdateLogicalNodeExpression(entity, values);
        upd.addInput((NodeExpression)root);
        return upd;
    }

    @NotNull
    public final LogicalNodeExpression parseAndBindDelete(@NotNull CottontailGrpc.DeleteMessage delete) {
        Intrinsics.checkNotNullParameter((Object)delete, (String)"delete");
        CottontailGrpc.From from = delete.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)from, (String)"delete.from");
        Pair<Entity, NullaryLogicalNodeExpression> scanClause = this.parseAndBindSimpleFrom(from);
        Entity entity = (Entity)scanClause.getFirst();
        LogicalNodeExpression root = (LogicalNodeExpression)scanClause.getSecond();
        if (delete.hasWhere()) {
            CottontailGrpc.Where where = delete.getWhere();
            Intrinsics.checkNotNullExpressionValue((Object)where, (String)"delete.where");
            FilterLogicalNodeExpression where2 = new FilterLogicalNodeExpression(this.parseAndBindBooleanPredicate(entity, where));
            where2.addInput((NodeExpression)root);
            root = where2;
        }
        DeleteLogicalNodeExpression del = new DeleteLogicalNodeExpression(entity);
        del.addInput((NodeExpression)root);
        return del;
    }

    private final LogicalNodeExpression parseAndBindSimpleQuery(CottontailGrpc.Query query) {
        LogicalNodeExpression logicalNodeExpression;
        ProjectionLogicalNodeExpression projection;
        CottontailGrpc.From from = query.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)from, (String)"query.from");
        Pair<Entity, NullaryLogicalNodeExpression> scanClause = this.parseAndBindSimpleFrom(from);
        Entity entity = (Entity)scanClause.getFirst();
        LogicalNodeExpression root = (LogicalNodeExpression)scanClause.getSecond();
        if (query.hasWhere()) {
            CottontailGrpc.Where where = query.getWhere();
            Intrinsics.checkNotNullExpressionValue((Object)where, (String)"query.where");
            FilterLogicalNodeExpression where2 = new FilterLogicalNodeExpression(this.parseAndBindBooleanPredicate(entity, where));
            where2.addInput((NodeExpression)root);
            root = where2;
        }
        if (query.hasKnn()) {
            CottontailGrpc.Knn knn = query.getKnn();
            Intrinsics.checkNotNullExpressionValue((Object)knn, (String)"query.knn");
            KnnLogicalNodeExpression knn2 = new KnnLogicalNodeExpression(this.parseAndBindKnnPredicate(entity, knn));
            knn2.addInput((NodeExpression)root);
            root = knn2;
        }
        if (query.hasProjection()) {
            CottontailGrpc.Projection projection2 = query.getProjection();
            Intrinsics.checkNotNullExpressionValue((Object)projection2, (String)"query.projection");
            projection = this.parseAndBindProjection(entity, projection2);
            projection.addInput((NodeExpression)root);
            logicalNodeExpression = projection;
        } else {
            CottontailGrpc.Projection projection3 = CottontailGrpc.Projection.newBuilder().setOp(CottontailGrpc.Projection.Operation.SELECT).putAttributes("*", "").build();
            Intrinsics.checkNotNullExpressionValue((Object)projection3, (String)"CottontailGrpc.Projectio\u2026tributes(\"*\", \"\").build()");
            projection = this.parseAndBindProjection(entity, projection3);
            projection.addInput((NodeExpression)root);
            logicalNodeExpression = root = (LogicalNodeExpression)projection;
        }
        if (query.getLimit() > 0L || query.getSkip() > 0L) {
            LimitLogicalNodeExpression limit2 = new LimitLogicalNodeExpression(query.getLimit(), query.getSkip());
            limit2.addInput((NodeExpression)root);
            root = limit2;
        }
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<Entity, NullaryLogicalNodeExpression> parseAndBindSimpleFrom(CottontailGrpc.From from) {
        try {
            CottontailGrpc.From.FromCase fromCase = from.getFromCase();
            if (fromCase == null) throw (Throwable)new QueryException.QuerySyntaxException("Invalid FROM-clause in query.");
            switch (GrpcQueryBinder$WhenMappings.$EnumSwitchMapping$0[fromCase.ordinal()]) {
                case 1: {
                    CottontailGrpc.Entity entity = from.getEntity();
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"from.entity");
                    Name.EntityName entityName = ExtensionsKt.fqn(entity);
                    Entity entity2 = this.catalogue.schemaForName(entityName.schema()).entityForName(entityName);
                    Pair pair = new Pair((Object)entity2, (Object)new EntityScanLogicalNodeExpression(entity2, null, 2, null));
                    return pair;
                }
                case 2: {
                    CottontailGrpc.Sample sample = from.getSample();
                    Intrinsics.checkNotNullExpressionValue((Object)sample, (String)"from.sample");
                    CottontailGrpc.Entity entity = sample.getEntity();
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"from.sample.entity");
                    Name.EntityName entityName = ExtensionsKt.fqn(entity);
                    Entity entity2 = this.catalogue.schemaForName(entityName.schema()).entityForName(entityName);
                    CottontailGrpc.Sample sample2 = from.getSample();
                    Intrinsics.checkNotNullExpressionValue((Object)sample2, (String)"from.sample");
                    long l = sample2.getSize();
                    CottontailGrpc.Sample sample3 = from.getSample();
                    Intrinsics.checkNotNullExpressionValue((Object)sample3, (String)"from.sample");
                    Pair pair = new Pair((Object)entity2, (Object)new EntitySampleLogicalNodeExpression(entity2, null, l, sample3.getSeed(), 2, null));
                    return pair;
                }
                default: {
                    throw (Throwable)new QueryException.QuerySyntaxException("Invalid FROM-clause in query.");
                }
            }
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to bind '");
            CottontailGrpc.Entity entity = from.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"from.entity");
            throw (Throwable)new QueryException.QueryBindException(stringBuilder.append(ExtensionsKt.fqn(entity)).append("'. Schema does not exist!").toString());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to bind '");
            CottontailGrpc.Entity entity = from.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"from.entity");
            throw (Throwable)new QueryException.QueryBindException(stringBuilder.append(ExtensionsKt.fqn(entity)).append("'. Entity does not exist!").toString());
        }
        catch (DatabaseException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to bind ");
            CottontailGrpc.Entity entity = from.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"from.entity");
            throw (Throwable)new QueryException.QueryBindException(stringBuilder.append(ExtensionsKt.fqn(entity)).append(". Database error!").toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BooleanPredicate parseAndBindBooleanPredicate(Entity entity, CottontailGrpc.Where where) {
        CottontailGrpc.Where.PredicateCase predicateCase = where.getPredicateCase();
        if (predicateCase == null) throw (Throwable)new QueryException.QuerySyntaxException("WHERE clause without a predicate is invalid!");
        switch (GrpcQueryBinder$WhenMappings.$EnumSwitchMapping$1[predicateCase.ordinal()]) {
            case 1: {
                CottontailGrpc.AtomicLiteralBooleanPredicate atomicLiteralBooleanPredicate = where.getAtomic();
                Intrinsics.checkNotNullExpressionValue((Object)atomicLiteralBooleanPredicate, (String)"where.atomic");
                BooleanPredicate booleanPredicate = this.parseAndBindAtomicBooleanPredicate(entity, atomicLiteralBooleanPredicate);
                return booleanPredicate;
            }
            case 2: {
                CottontailGrpc.CompoundBooleanPredicate compoundBooleanPredicate = where.getCompound();
                Intrinsics.checkNotNullExpressionValue((Object)compoundBooleanPredicate, (String)"where.compound");
                BooleanPredicate booleanPredicate = this.parseAndBindCompoundBooleanPredicate(entity, compoundBooleanPredicate);
                return booleanPredicate;
            }
            case 3: {
                throw (Throwable)new QueryException.QuerySyntaxException("WHERE clause without a predicate is invalid!");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CompoundBooleanPredicate parseAndBindCompoundBooleanPredicate(Entity entity, CottontailGrpc.CompoundBooleanPredicate compound) {
        BooleanPredicate booleanPredicate;
        BooleanPredicate booleanPredicate2;
        CottontailGrpc.CompoundBooleanPredicate.LeftCase leftCase = compound.getLeftCase();
        if (leftCase == null) throw (Throwable)new QueryException.QuerySyntaxException("Unbalanced predicate! A compound boolean predicate must have a left and a right side.");
        switch (GrpcQueryBinder$WhenMappings.$EnumSwitchMapping$2[leftCase.ordinal()]) {
            case 1: {
                CottontailGrpc.AtomicLiteralBooleanPredicate atomicLiteralBooleanPredicate = compound.getAleft();
                Intrinsics.checkNotNullExpressionValue((Object)atomicLiteralBooleanPredicate, (String)"compound.aleft");
                booleanPredicate2 = this.parseAndBindAtomicBooleanPredicate(entity, atomicLiteralBooleanPredicate);
                break;
            }
            case 2: {
                CottontailGrpc.CompoundBooleanPredicate compoundBooleanPredicate = compound.getCleft();
                Intrinsics.checkNotNullExpressionValue((Object)compoundBooleanPredicate, (String)"compound.cleft");
                booleanPredicate2 = this.parseAndBindCompoundBooleanPredicate(entity, compoundBooleanPredicate);
                break;
            }
            case 3: {
                throw (Throwable)new QueryException.QuerySyntaxException("Unbalanced predicate! A compound boolean predicate must have a left and a right side.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BooleanPredicate left = booleanPredicate2;
        CottontailGrpc.CompoundBooleanPredicate.RightCase rightCase = compound.getRightCase();
        if (rightCase == null) throw (Throwable)new QueryException.QuerySyntaxException("Unbalanced predicate! A compound boolean predicate must have a left and a right side.");
        switch (GrpcQueryBinder$WhenMappings.$EnumSwitchMapping$3[rightCase.ordinal()]) {
            case 1: {
                CottontailGrpc.AtomicLiteralBooleanPredicate atomicLiteralBooleanPredicate = compound.getAright();
                Intrinsics.checkNotNullExpressionValue((Object)atomicLiteralBooleanPredicate, (String)"compound.aright");
                booleanPredicate = this.parseAndBindAtomicBooleanPredicate(entity, atomicLiteralBooleanPredicate);
                break;
            }
            case 2: {
                CottontailGrpc.CompoundBooleanPredicate compoundBooleanPredicate = compound.getCright();
                Intrinsics.checkNotNullExpressionValue((Object)compoundBooleanPredicate, (String)"compound.cright");
                booleanPredicate = this.parseAndBindCompoundBooleanPredicate(entity, compoundBooleanPredicate);
                break;
            }
            case 3: {
                throw (Throwable)new QueryException.QuerySyntaxException("Unbalanced predicate! A compound boolean predicate must have a left and a right side.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BooleanPredicate right = booleanPredicate;
        try {
            return new CompoundBooleanPredicate(ConnectionOperator.valueOf(compound.getOp().name()), left, right);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new QueryException.QuerySyntaxException('\'' + compound.getOp().name() + "' is not a valid connection operator for a boolean predicate!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final AtomicBooleanPredicate<?> parseAndBindAtomicBooleanPredicate(Entity entity, CottontailGrpc.AtomicLiteralBooleanPredicate atomic) {
        Collection<?> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Name.EntityName entityName = entity.getName();
        String string = atomic.getAttribute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"atomic.attribute");
        Name.ColumnName columnName = entityName.column(string);
        ColumnDef<?> columnDef = entity.columnForName(columnName);
        if (columnDef == null) {
            throw (Throwable)new QueryException.QueryBindException("Failed to bind column '" + columnName + "'. Column does not exist on entity'.");
        }
        ColumnDef<?> column = columnDef;
        try {
            object = ComparisonOperator.valueOf(atomic.getOp().name());
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new QueryException.QuerySyntaxException('\'' + atomic.getOp().name() + "' is not a valid comparison operator for a boolean predicate!");
        }
        ComparisonOperator operator = object;
        if (operator == ComparisonOperator.LIKE && !entity.hasIndexForColumn(column, IndexType.LUCENE)) {
            throw (Throwable)new QueryException.QueryBindException("Failed to bind clause '" + atomic.getAttribute() + " LIKE :1' on entity '" + entity.getName() + "'. The entity does not have a text-index on the specified column '" + column.getName() + "', which is required for LIKE comparisons.");
        }
        boolean bl = atomic.getNot();
        List<CottontailGrpc.Data> list = atomic.getDataList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"atomic.dataList");
        object = list;
        boolean bl2 = bl;
        ComparisonOperator comparisonOperator = operator;
        ColumnDef<?> columnDef2 = column;
        boolean $i$f$map = false;
        void var8_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object obj;
            void it;
            CottontailGrpc.Data data = (CottontailGrpc.Data)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            if (DataExtensionsKt.toValue((CottontailGrpc.Data)v5, column) == null) {
                throw (Throwable)new QueryException.QuerySyntaxException("Cannot compare " + column.getName() + " to NULL value with operator " + (Object)((Object)operator) + '.');
            }
            collection.add(obj);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        boolean bl4 = bl2;
        ComparisonOperator comparisonOperator2 = comparisonOperator;
        ColumnDef<?> columnDef3 = columnDef2;
        return new AtomicBooleanPredicate(columnDef3, comparisonOperator2, bl4, collection2);
    }

    /*
     * WARNING - void declaration
     */
    private final KnnPredicate<?> parseAndBindKnnPredicate(Entity entity, CottontailGrpc.Knn knn) {
        KnnPredicate knnPredicate;
        Name.EntityName entityName = entity.getName();
        String string = knn.getAttribute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"knn.attribute");
        Name.ColumnName columnName = entityName.column(string);
        ColumnDef<?> columnDef = entity.columnForName(columnName);
        if (columnDef == null) {
            throw (Throwable)new QueryException.QueryBindException("Failed to bind column '" + columnName + "'. Column does not exist on entity!");
        }
        ColumnDef<?> column = columnDef;
        DistanceKernel distance = Distances.valueOf(knn.getDistance().name()).getKernel();
        CottontailGrpc.KnnHint knnHint = knn.getHint();
        Intrinsics.checkNotNullExpressionValue((Object)knnHint, (String)"knn.hint");
        KnnPredicateHint hint = ExtensionsKt.toHint(knnHint, entity);
        ColumnType<?> columnType = column.getType();
        if (columnType instanceof DoubleVectorColumnType) {
            DoubleVectorValue doubleVectorValue;
            Collection collection;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void q;
                CottontailGrpc.Vector vector = (CottontailGrpc.Vector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                void v5 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"q");
                doubleVectorValue = DoubleVectorValue.box-impl(DataExtensionsKt.toDoubleVectorValue((CottontailGrpc.Vector)v5));
                collection.add(doubleVectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                Object $this$all$iv;
                List weights;
                Object $this$mapTo$iv$iv2;
                block99: {
                    Object item$iv$iv;
                    List<CottontailGrpc.Vector> list2 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"knn.weightsList");
                    Iterable $this$map$iv2 = list2;
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    item$iv$iv = $this$mapTo$iv$iv2.iterator();
                    while (item$iv$iv.hasNext()) {
                        void w;
                        Object item$iv$iv2 = item$iv$iv.next();
                        CottontailGrpc.Vector bl2 = (CottontailGrpc.Vector)item$iv$iv2;
                        collection = destination$iv$iv2;
                        boolean bl3 = false;
                        void v7 = w;
                        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"w");
                        doubleVectorValue = DoubleVectorValue.box-impl(DataExtensionsKt.toDoubleVectorValue((CottontailGrpc.Vector)v7));
                        collection.add(doubleVectorValue);
                    }
                    weights = (List)destination$iv$iv2;
                    $this$all$iv = weights;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        $this$mapTo$iv$iv2 = $this$all$iv.iterator();
                        while ($this$mapTo$iv$iv2.hasNext()) {
                            Object element$iv = $this$mapTo$iv$iv2.next();
                            double[] it = ((DoubleVectorValue)element$iv).unbox-impl();
                            boolean bl4 = false;
                            if (DoubleVectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block99;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef2 = column;
                    if (columnDef2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.DoubleVectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef2, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef3 = column;
                    if (columnDef3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.DoubleVectorValue>");
                    }
                    $this$all$iv = hint;
                    DistanceKernel $i$f$all = distance;
                    $this$mapTo$iv$iv2 = weights;
                    KnnPredicate knnPredicate2 = new KnnPredicate(columnDef3, knn.getK(), query, $i$f$all, (List<VectorValue<?>>)$this$mapTo$iv$iv2, (KnnPredicateHint)$this$all$iv);
                    knnPredicate = knnPredicate2;
                }
            } else {
                ColumnDef<?> columnDef4 = column;
                if (columnDef4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.DoubleVectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef4, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else if (columnType instanceof FloatVectorColumnType) {
            FloatVectorValue floatVectorValue;
            Collection collection;
            CottontailGrpc.Vector item$iv$iv2;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$all = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void q;
                item$iv$iv2 = (CottontailGrpc.Vector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                void v15 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"q");
                floatVectorValue = FloatVectorValue.box-impl(DataExtensionsKt.toFloatVectorValue((CottontailGrpc.Vector)v15));
                collection.add(floatVectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                Object $this$all$iv;
                List weights;
                Object $this$mapTo$iv$iv3;
                block100: {
                    Object item$iv$iv;
                    List<CottontailGrpc.Vector> list3 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"knn.weightsList");
                    Iterable $this$map$iv3 = list3;
                    boolean $i$f$map3 = false;
                    destination$iv$iv = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    item$iv$iv = $this$mapTo$iv$iv3.iterator();
                    while (item$iv$iv.hasNext()) {
                        void it;
                        CottontailGrpc.Vector bl5 = item$iv$iv2 = item$iv$iv.next();
                        collection = destination$iv$iv3;
                        boolean bl6 = false;
                        void v17 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"it");
                        floatVectorValue = FloatVectorValue.box-impl(DataExtensionsKt.toFloatVectorValue((CottontailGrpc.Vector)v17));
                        collection.add(floatVectorValue);
                    }
                    weights = (List)destination$iv$iv3;
                    $this$all$iv = weights;
                    boolean $i$f$all2 = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        $this$mapTo$iv$iv3 = $this$all$iv.iterator();
                        while ($this$mapTo$iv$iv3.hasNext()) {
                            Object element$iv = $this$mapTo$iv$iv3.next();
                            float[] it = ((FloatVectorValue)element$iv).unbox-impl();
                            boolean bl7 = false;
                            if (FloatVectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block100;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef5 = column;
                    if (columnDef5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.FloatVectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef5, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef6 = column;
                    if (columnDef6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.FloatVectorValue>");
                    }
                    $this$all$iv = hint;
                    DistanceKernel $i$f$all2 = distance;
                    $this$mapTo$iv$iv3 = weights;
                    KnnPredicate knnPredicate3 = new KnnPredicate(columnDef6, knn.getK(), query, $i$f$all2, (List<VectorValue<?>>)$this$mapTo$iv$iv3, (KnnPredicateHint)$this$all$iv);
                    knnPredicate = knnPredicate3;
                }
            } else {
                ColumnDef<?> columnDef7 = column;
                if (columnDef7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.FloatVectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef7, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else if (columnType instanceof LongVectorColumnType) {
            LongVectorValue longVectorValue;
            Collection collection;
            CottontailGrpc.Vector item$iv$iv;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$all2 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void q;
                item$iv$iv = (CottontailGrpc.Vector)item$iv$iv3;
                collection = destination$iv$iv;
                boolean bl8 = false;
                void v24 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"q");
                longVectorValue = LongVectorValue.box-impl(DataExtensionsKt.toLongVectorValue((CottontailGrpc.Vector)v24));
                collection.add(longVectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                Object $this$all$iv;
                List weights;
                Object $this$mapTo$iv$iv4;
                block101: {
                    Object item$iv$iv3;
                    List<CottontailGrpc.Vector> list4 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"knn.weightsList");
                    Iterable $this$map$iv4 = list4;
                    boolean $i$f$map4 = false;
                    destination$iv$iv = $this$map$iv4;
                    Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                    boolean $i$f$mapTo4 = false;
                    item$iv$iv3 = $this$mapTo$iv$iv4.iterator();
                    while (item$iv$iv3.hasNext()) {
                        void it;
                        CottontailGrpc.Vector bl8 = item$iv$iv = item$iv$iv3.next();
                        collection = destination$iv$iv4;
                        boolean bl9 = false;
                        void v26 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"it");
                        longVectorValue = LongVectorValue.box-impl(DataExtensionsKt.toLongVectorValue((CottontailGrpc.Vector)v26));
                        collection.add(longVectorValue);
                    }
                    weights = (List)destination$iv$iv4;
                    $this$all$iv = weights;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        $this$mapTo$iv$iv4 = $this$all$iv.iterator();
                        while ($this$mapTo$iv$iv4.hasNext()) {
                            Object element$iv = $this$mapTo$iv$iv4.next();
                            long[] it = ((LongVectorValue)element$iv).unbox-impl();
                            boolean bl10 = false;
                            if (LongVectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block101;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef8 = column;
                    if (columnDef8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.LongVectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef8, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef9 = column;
                    if (columnDef9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.LongVectorValue>");
                    }
                    $this$all$iv = hint;
                    DistanceKernel $i$f$all = distance;
                    $this$mapTo$iv$iv4 = weights;
                    KnnPredicate knnPredicate4 = new KnnPredicate(columnDef9, knn.getK(), query, $i$f$all, (List<VectorValue<?>>)$this$mapTo$iv$iv4, (KnnPredicateHint)$this$all$iv);
                    knnPredicate = knnPredicate4;
                }
            } else {
                ColumnDef<?> columnDef10 = column;
                if (columnDef10 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.LongVectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef10, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else if (columnType instanceof IntVectorColumnType) {
            IntVectorValue intVectorValue;
            Collection collection;
            CottontailGrpc.Vector item$iv$iv;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$all = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
                void q;
                item$iv$iv = (CottontailGrpc.Vector)item$iv$iv4;
                collection = destination$iv$iv;
                boolean bl11 = false;
                void v33 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v33, (String)"q");
                intVectorValue = IntVectorValue.box-impl(DataExtensionsKt.toIntVectorValue((CottontailGrpc.Vector)v33));
                collection.add(intVectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                Object $this$all$iv;
                List weights;
                Object $this$mapTo$iv$iv5;
                block102: {
                    Object item$iv$iv4;
                    List<CottontailGrpc.Vector> list5 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list5, (String)"knn.weightsList");
                    Iterable $this$map$iv5 = list5;
                    boolean $i$f$map5 = false;
                    destination$iv$iv = $this$map$iv5;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
                    boolean $i$f$mapTo5 = false;
                    item$iv$iv4 = $this$mapTo$iv$iv5.iterator();
                    while (item$iv$iv4.hasNext()) {
                        void it;
                        CottontailGrpc.Vector bl11 = item$iv$iv = item$iv$iv4.next();
                        collection = destination$iv$iv5;
                        boolean bl12 = false;
                        void v35 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v35, (String)"it");
                        intVectorValue = IntVectorValue.box-impl(DataExtensionsKt.toIntVectorValue((CottontailGrpc.Vector)v35));
                        collection.add(intVectorValue);
                    }
                    weights = (List)destination$iv$iv5;
                    $this$all$iv = weights;
                    boolean $i$f$all3 = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        $this$mapTo$iv$iv5 = $this$all$iv.iterator();
                        while ($this$mapTo$iv$iv5.hasNext()) {
                            Object element$iv = $this$mapTo$iv$iv5.next();
                            int[] it = ((IntVectorValue)element$iv).unbox-impl();
                            boolean bl13 = false;
                            if (IntVectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block102;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef11 = column;
                    if (columnDef11 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.IntVectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef11, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef12 = column;
                    if (columnDef12 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.IntVectorValue>");
                    }
                    $this$all$iv = hint;
                    DistanceKernel $i$f$all3 = distance;
                    $this$mapTo$iv$iv5 = weights;
                    KnnPredicate knnPredicate5 = new KnnPredicate(columnDef12, knn.getK(), query, $i$f$all3, (List<VectorValue<?>>)$this$mapTo$iv$iv5, (KnnPredicateHint)$this$all$iv);
                    knnPredicate = knnPredicate5;
                }
            } else {
                ColumnDef<?> columnDef13 = column;
                if (columnDef13 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.IntVectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef13, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else if (columnType instanceof BooleanVectorColumnType) {
            BooleanVectorValue booleanVectorValue;
            Collection collection;
            CottontailGrpc.Vector item$iv$iv;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$all3 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv) {
                void q;
                item$iv$iv = (CottontailGrpc.Vector)item$iv$iv5;
                collection = destination$iv$iv;
                boolean bl14 = false;
                void v42 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"q");
                booleanVectorValue = BooleanVectorValue.box-impl(DataExtensionsKt.toBooleanVectorValue((CottontailGrpc.Vector)v42));
                collection.add(booleanVectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                Object $this$all$iv;
                List weights;
                Object $this$mapTo$iv$iv6;
                block103: {
                    Object item$iv$iv5;
                    List<CottontailGrpc.Vector> list6 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list6, (String)"knn.weightsList");
                    Iterable $this$map$iv6 = list6;
                    boolean $i$f$map6 = false;
                    destination$iv$iv = $this$map$iv6;
                    Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                    boolean $i$f$mapTo6 = false;
                    item$iv$iv5 = $this$mapTo$iv$iv6.iterator();
                    while (item$iv$iv5.hasNext()) {
                        void it;
                        CottontailGrpc.Vector bl14 = item$iv$iv = item$iv$iv5.next();
                        collection = destination$iv$iv6;
                        boolean bl15 = false;
                        void v44 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v44, (String)"it");
                        booleanVectorValue = BooleanVectorValue.box-impl(DataExtensionsKt.toBooleanVectorValue((CottontailGrpc.Vector)v44));
                        collection.add(booleanVectorValue);
                    }
                    weights = (List)destination$iv$iv6;
                    $this$all$iv = weights;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        $this$mapTo$iv$iv6 = $this$all$iv.iterator();
                        while ($this$mapTo$iv$iv6.hasNext()) {
                            Object element$iv = $this$mapTo$iv$iv6.next();
                            boolean[] it = ((BooleanVectorValue)element$iv).unbox-impl();
                            boolean bl16 = false;
                            if (BooleanVectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block103;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef14 = column;
                    if (columnDef14 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.BooleanVectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef14, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef15 = column;
                    if (columnDef15 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.BooleanVectorValue>");
                    }
                    $this$all$iv = hint;
                    DistanceKernel $i$f$all = distance;
                    $this$mapTo$iv$iv6 = weights;
                    KnnPredicate knnPredicate6 = new KnnPredicate(columnDef15, knn.getK(), query, $i$f$all, (List<VectorValue<?>>)$this$mapTo$iv$iv6, (KnnPredicateHint)$this$all$iv);
                    knnPredicate = knnPredicate6;
                }
            } else {
                ColumnDef<?> columnDef16 = column;
                if (columnDef16 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.BooleanVectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef16, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else if (columnType instanceof Complex32VectorColumnType) {
            Complex32VectorValue complex32VectorValue;
            Collection collection;
            CottontailGrpc.Vector item$iv$iv;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$all = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv6 : $this$mapTo$iv$iv) {
                void q;
                item$iv$iv = (CottontailGrpc.Vector)item$iv$iv6;
                collection = destination$iv$iv;
                boolean bl17 = false;
                void v51 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v51, (String)"q");
                complex32VectorValue = Complex32VectorValue.box-impl(DataExtensionsKt.toComplex32VectorValue((CottontailGrpc.Vector)v51));
                collection.add(complex32VectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                Object $this$all$iv;
                List weights;
                Object $this$mapTo$iv$iv7;
                block104: {
                    Object item$iv$iv6;
                    List<CottontailGrpc.Vector> list7 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list7, (String)"knn.weightsList");
                    Iterable $this$map$iv7 = list7;
                    boolean $i$f$map7 = false;
                    destination$iv$iv = $this$map$iv7;
                    Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
                    boolean $i$f$mapTo7 = false;
                    item$iv$iv6 = $this$mapTo$iv$iv7.iterator();
                    while (item$iv$iv6.hasNext()) {
                        void it;
                        CottontailGrpc.Vector bl17 = item$iv$iv = item$iv$iv6.next();
                        collection = destination$iv$iv7;
                        boolean bl18 = false;
                        void v53 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v53, (String)"it");
                        complex32VectorValue = Complex32VectorValue.box-impl(DataExtensionsKt.toComplex32VectorValue((CottontailGrpc.Vector)v53));
                        collection.add(complex32VectorValue);
                    }
                    weights = (List)destination$iv$iv7;
                    $this$all$iv = weights;
                    boolean $i$f$all4 = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        $this$mapTo$iv$iv7 = $this$all$iv.iterator();
                        while ($this$mapTo$iv$iv7.hasNext()) {
                            Object element$iv = $this$mapTo$iv$iv7.next();
                            float[] it = ((Complex32VectorValue)element$iv).unbox-impl();
                            boolean bl19 = false;
                            if (Complex32VectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block104;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef17 = column;
                    if (columnDef17 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.Complex32VectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef17, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef18 = column;
                    if (columnDef18 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.Complex32VectorValue>");
                    }
                    $this$all$iv = hint;
                    DistanceKernel $i$f$all4 = distance;
                    $this$mapTo$iv$iv7 = weights;
                    KnnPredicate knnPredicate7 = new KnnPredicate(columnDef18, knn.getK(), query, $i$f$all4, (List<VectorValue<?>>)$this$mapTo$iv$iv7, (KnnPredicateHint)$this$all$iv);
                    knnPredicate = knnPredicate7;
                }
            } else {
                ColumnDef<?> columnDef19 = column;
                if (columnDef19 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.Complex32VectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef19, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else if (columnType instanceof Complex64VectorColumnType) {
            Complex64VectorValue complex64VectorValue;
            Collection collection;
            CottontailGrpc.Vector item$iv$iv;
            void $this$mapTo$iv$iv;
            List<CottontailGrpc.Vector> list = knn.getQueryList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"knn.queryList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$all4 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv7 : $this$mapTo$iv$iv) {
                void q;
                item$iv$iv = (CottontailGrpc.Vector)item$iv$iv7;
                collection = destination$iv$iv;
                boolean bl20 = false;
                void v60 = q;
                Intrinsics.checkNotNullExpressionValue((Object)v60, (String)"q");
                complex64VectorValue = Complex64VectorValue.box-impl(DataExtensionsKt.toComplex64VectorValue((CottontailGrpc.Vector)v60));
                collection.add(complex64VectorValue);
            }
            List query = (List)destination$iv$iv;
            if (knn.getWeightsCount() > 0) {
                boolean bl;
                List weights;
                block105: {
                    void $this$mapTo$iv$iv8;
                    Object item$iv$iv7;
                    List<CottontailGrpc.Vector> list8 = knn.getWeightsList();
                    Intrinsics.checkNotNullExpressionValue(list8, (String)"knn.weightsList");
                    Iterable $this$map$iv8 = list8;
                    boolean $i$f$map8 = false;
                    destination$iv$iv = $this$map$iv8;
                    Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv8, (int)10));
                    boolean $i$f$mapTo8 = false;
                    item$iv$iv7 = $this$mapTo$iv$iv8.iterator();
                    while (item$iv$iv7.hasNext()) {
                        void it;
                        CottontailGrpc.Vector bl20 = item$iv$iv = item$iv$iv7.next();
                        collection = destination$iv$iv8;
                        boolean bl21 = false;
                        void v62 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v62, (String)"it");
                        complex64VectorValue = Complex64VectorValue.box-impl(DataExtensionsKt.toComplex64VectorValue((CottontailGrpc.Vector)v62));
                        collection.add(complex64VectorValue);
                    }
                    weights = (List)destination$iv$iv8;
                    Iterable $this$all$iv = weights;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            double[] it = ((Complex64VectorValue)element$iv).unbox-impl();
                            boolean bl22 = false;
                            if (Complex64VectorValue.allOnes-impl(it)) continue;
                            bl = false;
                            break block105;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    ColumnDef<?> columnDef20 = column;
                    if (columnDef20 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.Complex64VectorValue>");
                    }
                    knnPredicate = new KnnPredicate(columnDef20, knn.getK(), query, distance, null, hint, 16, null);
                } else {
                    ColumnDef<?> columnDef21 = column;
                    if (columnDef21 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.Complex64VectorValue>");
                    }
                    KnnPredicateHint knnPredicateHint = hint;
                    DistanceKernel distanceKernel = distance;
                    List list9 = weights;
                    KnnPredicate knnPredicate8 = new KnnPredicate(columnDef21, knn.getK(), query, distanceKernel, list9, knnPredicateHint);
                    knnPredicate = knnPredicate8;
                }
            } else {
                ColumnDef<?> columnDef22 = column;
                if (columnDef22 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.ColumnDef<org.vitrivr.cottontail.model.values.Complex64VectorValue>");
                }
                knnPredicate = new KnnPredicate(columnDef22, knn.getK(), query, distance, null, hint, 16, null);
            }
        } else {
            throw (Throwable)new QueryException.QuerySyntaxException("A kNN predicate does not contain a valid query vector!");
        }
        return knnPredicate;
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectionLogicalNodeExpression parseAndBindProjection(Entity entity, CottontailGrpc.Projection projection) {
        ProjectionLogicalNodeExpression projectionLogicalNodeExpression;
        try {
            boolean bl = false;
            List fields = new ArrayList();
            Map<String, String> map2 = projection.getAttributesMap();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"projection.attributesMap");
            Map<String, String> $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Map<String, String> map3 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator<Map.Entry<String, String>> iterator2 = map3.entrySet().iterator();
            block7: while (iterator2.hasNext()) {
                void expr;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$expr$alias = element$iv = iterator2.next();
                boolean bl3 = false;
                Map.Entry<String, String> entry = $dstr$expr$alias;
                boolean bl4 = false;
                String string = entry.getKey();
                entry = $dstr$expr$alias;
                bl4 = false;
                String alias = entry.getValue();
                void v1 = expr;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"expr");
                List split = StringsKt.split$default((CharSequence)((CharSequence)v1), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                switch (split.size()) {
                    case 1: {
                        Name.ColumnName columnName = entity.getName().column((String)split.get(0));
                        if (columnName.getWildcard()) {
                            fields.add(new Pair((Object)columnName, (Object)null));
                            break;
                        }
                        String string2 = alias;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"alias");
                        fields.add(new Pair((Object)columnName, (Object)(StringsKt.isBlank((CharSequence)string2) ? null : new Name.ColumnName(alias))));
                        break;
                    }
                    case 2: {
                        if (!Intrinsics.areEqual((Object)((String)split.get(0)), (Object)entity.getName().getSimple())) continue block7;
                        Name.ColumnName columnName = entity.getName().column((String)split.get(1));
                        if (columnName.getWildcard()) {
                            fields.add(new Pair((Object)columnName, (Object)null));
                            break;
                        }
                        String string3 = alias;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"alias");
                        fields.add(new Pair((Object)columnName, (Object)(StringsKt.isBlank((CharSequence)string3) ? null : new Name.ColumnName(alias))));
                        break;
                    }
                    case 3: {
                        if (!Intrinsics.areEqual((Object)((String)split.get(0)), (Object)entity.getParent().getName().getSimple()) || !Intrinsics.areEqual((Object)((String)split.get(1)), (Object)entity.getName().getSimple())) continue block7;
                        Name.ColumnName columnName = entity.getName().column((String)split.get(2));
                        if (columnName.getWildcard()) {
                            fields.add(new Pair((Object)columnName, (Object)null));
                            break;
                        }
                        String string4 = alias;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"alias");
                        fields.add(new Pair((Object)columnName, (Object)(StringsKt.isBlank((CharSequence)string4) ? null : new Name.ColumnName(alias))));
                        break;
                    }
                    default: {
                        throw (Throwable)new QueryException.QuerySyntaxException("The provided column '" + (String)expr + "' is invalid.");
                    }
                }
            }
            projectionLogicalNodeExpression = new ProjectionLogicalNodeExpression(Projection.valueOf(projection.getOp().name()), fields);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new QueryException.QuerySyntaxException("The query lacks a valid SELECT-clause (projection): " + (Object)((Object)projection.getOp()) + " is not supported.");
        }
        return projectionLogicalNodeExpression;
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    public GrpcQueryBinder(@NotNull Catalogue catalogue) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        this.catalogue = catalogue;
    }
}

