/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.database.queries.planning.nodes.interfaces.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.LogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.PhysicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.DeleteImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.EntityScanImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.FilterImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.UpdateImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.execution.ExecutionEngine;
import org.vitrivr.cottontail.execution.exceptions.ExecutionException;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.grpc.CottonDMLGrpc;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.ValidationException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.server.grpc.helper.DataExtensionsKt;
import org.vitrivr.cottontail.server.grpc.helper.ExtensionsKt;
import org.vitrivr.cottontail.server.grpc.helper.GrpcQueryBinder;
import org.vitrivr.cottontail.server.grpc.helper.ResultsSpoolerOperator;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0016J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDMLService;", "Lorg/vitrivr/cottontail/grpc/CottonDMLGrpc$CottonDMLImplBase;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "engine", "Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/ExecutionEngine;)V", "binder", "Lorg/vitrivr/cottontail/server/grpc/helper/GrpcQueryBinder;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getEngine", "()Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "planner", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "delete", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DeleteMessage;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "insert", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Status;", "update", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$UpdateMessage;", "Companion", "InsertSink", "cottontaildb"})
@ExperimentalTime
public final class CottonDMLService
extends CottonDMLGrpc.CottonDMLImplBase {
    private final GrpcQueryBinder binder;
    private final CottontailQueryPlanner planner;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final ExecutionEngine engine;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @Override
    public void update(@NotNull CottontailGrpc.UpdateMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Object v1;
            CharSequence charSequence;
            ExecutionEngine.ExecutionContext context = this.engine.new ExecutionEngine.ExecutionContext();
            CharSequence charSequence2 = request.getQueryId();
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl2 = false;
                charSequence = context.getUuid().toString();
            } else {
                charSequence = charSequence2;
            }
            String queryId = (String)charSequence;
            boolean $i$f$measureTime = false;
            boolean bl3 = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl4 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl5 = false;
            boolean $i$f$measureTimedValue = false;
            boolean bl6 = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl7 = false;
            TimeMark mark$iv$iv22 = $this$measureTimedValue$iv$iv.markNow();
            boolean bl8 = false;
            LogicalNodeExpression result$iv$iv = this.binder.parseAndBindUpdate(request);
            TimedValue bindTimedValue = new TimedValue((Object)result$iv$iv, mark$iv$iv22.elapsedNow-UwyO8pc(), null);
            LOGGER.trace("Parsing & binding UPDATE " + queryId + " took " + Duration.toString-impl((double)bindTimedValue.getDuration-UwyO8pc()) + '.');
            boolean $i$f$measureTime3 = false;
            boolean mark$iv$iv22 = false;
            TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime4 = false;
            boolean bl9 = false;
            TimeMark mark$iv$iv3 = $this$measureTime$iv$iv2.markNow();
            boolean bl10 = false;
            Collection<PhysicalNodeExpression> candidates = this.planner.plan((LogicalNodeExpression)bindTimedValue.getValue());
            if (candidates.isEmpty()) {
                responseObserver.onError((Throwable)Status.INTERNAL.withDescription("UPDATE query execution failed because no valid execution plan could be produced").asException());
                return;
            }
            Iterable $this$minByOrNull$iv = candidates;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    PhysicalNodeExpression it = (PhysicalNodeExpression)minElem$iv;
                    boolean bl11 = false;
                    Comparable minValue$iv = it.getTotalCost();
                    do {
                        Object e$iv = iterator$iv.next();
                        PhysicalNodeExpression it2 = (PhysicalNodeExpression)e$iv;
                        $i$a$-minByOrNull-CottonDMLService$update$totalDuration$1$planningTime$1$operator$1 = false;
                        Comparable v$iv = it2.getTotalCost();
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            Operator operator = ((PhysicalNodeExpression)v1).toOperator(context);
            String string = queryId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queryId");
            context.addOperator(new ResultsSpoolerOperator(operator, context, string, 0, responseObserver));
            double planningTime = mark$iv$iv3.elapsedNow-UwyO8pc();
            LOGGER.trace("Planning UPDATE " + queryId + " took " + Duration.toString-impl((double)planningTime) + '.');
            context.execute();
            double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
            responseObserver.onCompleted();
            LOGGER.trace("Executing UPDATE " + context.getUuid() + " took " + Duration.toString-impl((double)totalDuration) + " to complete.");
        }
        catch (QueryException.QuerySyntaxException e) {
            LOGGER.error("Error while executing UPDATE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("UPDATE syntax is invalid: " + e.getMessage()).asException());
        }
        catch (QueryException.QueryBindException e) {
            LOGGER.error("Error while executing UPDATE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("UPDATE query binding failed: " + e.getMessage()).asException());
        }
        catch (ExecutionException e) {
            LOGGER.error("Error while executing UPDATE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("UPDATE execution failed: " + e.getMessage()).asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while executing UPDATE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("UPDATE execution failed failed because of a database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while executing UPDATE " + request, e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("UPDATE execution failed failed because of an unknown error: " + e.getMessage()).asException());
        }
    }

    @Override
    public void delete(@NotNull CottontailGrpc.DeleteMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Object v1;
            CharSequence charSequence;
            ExecutionEngine.ExecutionContext context = this.engine.new ExecutionEngine.ExecutionContext();
            CharSequence charSequence2 = request.getQueryId();
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl2 = false;
                charSequence = context.getUuid().toString();
            } else {
                charSequence = charSequence2;
            }
            String queryId = (String)charSequence;
            boolean $i$f$measureTime = false;
            boolean bl3 = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl4 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl5 = false;
            boolean $i$f$measureTimedValue = false;
            boolean bl6 = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl7 = false;
            TimeMark mark$iv$iv22 = $this$measureTimedValue$iv$iv.markNow();
            boolean bl8 = false;
            LogicalNodeExpression result$iv$iv = this.binder.parseAndBindDelete(request);
            TimedValue bindTimedValue = new TimedValue((Object)result$iv$iv, mark$iv$iv22.elapsedNow-UwyO8pc(), null);
            LOGGER.trace("Parsing & binding DELETE " + queryId + " took " + Duration.toString-impl((double)bindTimedValue.getDuration-UwyO8pc()) + '.');
            boolean $i$f$measureTime3 = false;
            boolean mark$iv$iv22 = false;
            TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime4 = false;
            boolean bl9 = false;
            TimeMark mark$iv$iv3 = $this$measureTime$iv$iv2.markNow();
            boolean bl10 = false;
            Collection<PhysicalNodeExpression> candidates = this.planner.plan((LogicalNodeExpression)bindTimedValue.getValue());
            if (candidates.isEmpty()) {
                responseObserver.onError((Throwable)Status.INTERNAL.withDescription("DELETE query execution failed because no valid execution plan could be produced").asException());
                return;
            }
            Iterable $this$minByOrNull$iv = candidates;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    PhysicalNodeExpression it = (PhysicalNodeExpression)minElem$iv;
                    boolean bl11 = false;
                    Comparable minValue$iv = it.getTotalCost();
                    do {
                        Object e$iv = iterator$iv.next();
                        PhysicalNodeExpression it2 = (PhysicalNodeExpression)e$iv;
                        $i$a$-minByOrNull-CottonDMLService$delete$totalDuration$1$planningTime$1$operator$1 = false;
                        Comparable v$iv = it2.getTotalCost();
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            Operator operator = ((PhysicalNodeExpression)v1).toOperator(context);
            String string = queryId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queryId");
            context.addOperator(new ResultsSpoolerOperator(operator, context, string, 0, responseObserver));
            double planningTime = mark$iv$iv3.elapsedNow-UwyO8pc();
            LOGGER.trace("Planning DELETE " + queryId + " took " + Duration.toString-impl((double)planningTime) + '.');
            context.execute();
            double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
            responseObserver.onCompleted();
            LOGGER.trace("Executing DELETE " + context.getUuid() + " took " + Duration.toString-impl((double)totalDuration) + " to complete.");
        }
        catch (QueryException.QuerySyntaxException e) {
            LOGGER.error("Error while executing DELETE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("DELETE syntax is invalid: " + e.getMessage()).asException());
        }
        catch (QueryException.QueryBindException e) {
            LOGGER.error("Error while executing DELETE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("DELETE query binding failed: " + e.getMessage()).asException());
        }
        catch (ExecutionException e) {
            LOGGER.error("Error while executing DELETE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("DELETE execution failed: " + e.getMessage()).asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while executing DELETE " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("DELETE execution failed failed because of a database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while executing DELETE " + request, e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("DELETE execution failed failed because of an unknown error: " + e.getMessage()).asException());
        }
    }

    @Override
    @NotNull
    public StreamObserver<CottontailGrpc.InsertMessage> insert(@NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        return new InsertSink(responseObserver);
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    @NotNull
    public final ExecutionEngine getEngine() {
        return this.engine;
    }

    public CottonDMLService(@NotNull Catalogue catalogue, @NotNull ExecutionEngine engine) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.catalogue = catalogue;
        this.engine = engine;
        this.binder = new GrpcQueryBinder(this.catalogue);
        this.planner = new CottontailQueryPlanner(CollectionsKt.listOf((Object[])new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE}), CollectionsKt.listOf((Object[])new RewriteRule[]{BooleanIndexScanRule.INSTANCE, EntityScanImplementationRule.INSTANCE, FilterImplementationRule.INSTANCE, DeleteImplementationRule.INSTANCE, UpdateImplementationRule.INSTANCE}));
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(CottonDMLService.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\tH\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u00060\u000fR\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDMLService$InsertSink;", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage;", "responseObserver", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Status;", "(Lorg/vitrivr/cottontail/server/grpc/services/CottonDMLService;Lio/grpc/stub/StreamObserver;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "counter", "", "transactions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "txId", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "cleanup", "", "commit", "onCompleted", "onError", "t", "", "onNext", "request", "cottontaildb"})
    public final class InsertSink
    implements StreamObserver<CottontailGrpc.InsertMessage> {
        private final ConcurrentHashMap<Name.EntityName, Entity.Tx> transactions;
        private final UUID txId;
        private final StampedLock closeLock;
        private volatile long counter;
        private volatile boolean closed;
        private final StreamObserver<CottontailGrpc.Status> responseObserver;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(@NotNull CottontailGrpc.InsertMessage request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            try {
                StampedLock $this$read$iv = this.closeLock;
                boolean $i$f$read = false;
                long stamp$iv = $this$read$iv.readLock();
                try {
                    Name.EntityName entityName;
                    boolean bl = false;
                    if (this.closed) {
                        return;
                    }
                    try {
                        CottontailGrpc.From from = request.getFrom();
                        Intrinsics.checkNotNullExpressionValue((Object)from, (String)"request.from");
                        CottontailGrpc.Entity entity = from.getEntity();
                        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.from.entity");
                        entityName = ExtensionsKt.fqn(entity);
                    }
                    catch (IllegalArgumentException e) {
                        this.responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Failed to insert into entity: " + e.getMessage()).asException());
                        $this$read$iv.unlock(stamp$iv);
                        return;
                    }
                    Name.EntityName fqn = entityName;
                    Entity.Tx tx = this.transactions.get(fqn);
                    if (tx == null) {
                        Schema schema = CottonDMLService.this.getCatalogue().schemaForName(fqn.schema());
                        Entity entity = schema.entityForName(fqn);
                        UUID uUID = this.txId;
                        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"this.txId");
                        tx = new Entity.Tx(entity, false, uUID, false, 4, null);
                        ((Map)this.transactions).put(fqn, tx);
                    }
                    CottontailGrpc.Tuple tuple = request.getTuple();
                    Intrinsics.checkNotNullExpressionValue((Object)tuple, (String)"request.tuple");
                    ArrayList columns = new ArrayList(tuple.getDataMap().size());
                    CottontailGrpc.Tuple tuple2 = request.getTuple();
                    Intrinsics.checkNotNullExpressionValue((Object)tuple2, (String)"request.tuple");
                    ArrayList values = new ArrayList(tuple2.getDataMap().size());
                    CottontailGrpc.Tuple tuple3 = request.getTuple();
                    Intrinsics.checkNotNullExpressionValue((Object)tuple3, (String)"request.tuple");
                    Map<String, CottontailGrpc.Data> map2 = tuple3.getDataMap();
                    Intrinsics.checkNotNullExpressionValue(map2, (String)"request.tuple.dataMap");
                    Map<String, CottontailGrpc.Data> $this$forEach$iv = map2;
                    boolean $i$f$forEach = false;
                    Map<String, CottontailGrpc.Data> map3 = $this$forEach$iv;
                    boolean bl2 = false;
                    Iterator<Map.Entry<String, CottontailGrpc.Data>> iterator2 = map3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        ColumnDef<?> col;
                        Map.Entry<String, CottontailGrpc.Data> element$iv;
                        Map.Entry<String, CottontailGrpc.Data> it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        Entity entity = tx.getEntity();
                        String string = it.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.key");
                        if (entity.columnForName(fqn.column(string)) == null) {
                            throw (Throwable)new ValidationException("INSERT failed because column " + it.getKey() + " does not exist in entity '" + fqn + "'.");
                        }
                        columns.add(col);
                        CottontailGrpc.Data data = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"it.value");
                        values.add(DataExtensionsKt.toValue(data, col));
                    }
                    Collection $this$toTypedArray$iv = columns;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
                    if (columnDefArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    $this$toTypedArray$iv = values;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                    if (valueArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    tx.insert(new StandaloneRecord(0L, columnDefArray, valueArray, 1, null));
                    ++this.counter;
                    this.responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
                    Unit $i$a$-read-CottonDMLService$InsertSink$onNext$2 = Unit.INSTANCE;
                }
                catch (Throwable e$iv) {
                    throw e$iv;
                }
                finally {
                    $this$read$iv.unlock(stamp$iv);
                }
            }
            catch (DatabaseException.SchemaDoesNotExistException e) {
                LOGGER.error("Error while inserting data", (Throwable)e);
                this.cleanup(false);
                StringBuilder stringBuilder = new StringBuilder().append("INSERT failed because schema '");
                CottontailGrpc.From from = request.getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)from, (String)"request.from");
                CottontailGrpc.Entity entity = from.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.from.entity");
                CottontailGrpc.Schema schema = entity.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.from.entity.schema");
                this.responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(schema.getName()).append(" does not exist!").toString()).asException());
            }
            catch (DatabaseException.EntityDoesNotExistException e) {
                LOGGER.error("Error while inserting data", (Throwable)e);
                this.cleanup(false);
                StringBuilder stringBuilder = new StringBuilder().append("INSERT failed because entity '");
                CottontailGrpc.From from = request.getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)from, (String)"request.from");
                CottontailGrpc.Entity entity = from.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.from.entity");
                this.responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(entity)).append(" does not exist!").toString()).asException());
            }
            catch (DatabaseException.ColumnDoesNotExistException e) {
                LOGGER.error("Error while inserting data", (Throwable)e);
                this.cleanup(false);
                this.responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("INSERT failed because column '" + e.getColumn() + "' does not exist!").asException());
            }
            catch (ValidationException e) {
                LOGGER.error("Error while inserting data", (Throwable)e);
                this.cleanup(false);
                this.responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("INSERT failed because data validation failed: " + e.getMessage()).asException());
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while inserting data", (Throwable)e);
                this.cleanup(false);
                this.responseObserver.onError((Throwable)Status.INTERNAL.withDescription("INSERT failed because of a database error: " + e.getMessage()).asException());
            }
            catch (Throwable e) {
                LOGGER.error("Error while inserting data", e);
                this.cleanup(false);
                this.responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("INSERT failed because of a unknown error: " + e.getMessage()).asException());
            }
        }

        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this.cleanup(false);
            this.responseObserver.onError((Throwable)Status.ABORTED.withDescription("Transaction was aborted by client.").asException());
        }

        public void onCompleted() {
            this.cleanup(true);
            this.responseObserver.onCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void cleanup(boolean commit2) {
            StampedLock $this$write$iv = this.closeLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-CottonDMLService$InsertSink$cleanup$22 = false;
                this.closed = true;
                Map $this$forEach$iv = this.transactions;
                boolean $i$f$forEach = false;
                Map map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    try {
                        if (commit2) {
                            ((Entity.Tx)it.getValue()).commit();
                            LOGGER.trace("Insert transaction " + this.txId + " was committed by client (" + this.counter + " tuples inserted).");
                            continue;
                        }
                        LOGGER.trace("Insert transaction " + this.txId + " was rolled back by client.");
                        ((Entity.Tx)it.getValue()).rollback();
                    }
                    finally {
                        ((Entity.Tx)it.getValue()).close();
                    }
                }
                Unit $i$a$-write-CottonDMLService$InsertSink$cleanup$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        static /* synthetic */ void cleanup$default(InsertSink insertSink, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            insertSink.cleanup(bl);
        }

        public InsertSink(StreamObserver<CottontailGrpc.Status> responseObserver) {
            Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
            this.responseObserver = responseObserver;
            this.transactions = new ConcurrentHashMap();
            this.txId = UUID.randomUUID();
            this.closeLock = new StampedLock();
            LOGGER.trace("Insert transaction {} was initiated by client.", (Object)this.txId.toString());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDMLService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

