/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.database.queries.planning.nodes.interfaces.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.nodes.logical.LogicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.PhysicalNodeExpression;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferredFetchAfterFilterRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferredFetchAfterKnnRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.EntityScanImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.FetchImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.FilterImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.KnnImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.LimitImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.implementation.ProjectionImplementationRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.KnnIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.pushdown.CountPushdownRule;
import org.vitrivr.cottontail.execution.ExecutionEngine;
import org.vitrivr.cottontail.execution.exceptions.ExecutionException;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.grpc.CottonDQLGrpc;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.server.grpc.helper.GrpcQueryBinder;
import org.vitrivr.cottontail.server.grpc.helper.ResultsSpoolerOperator;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0016J\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDQLService;", "Lorg/vitrivr/cottontail/grpc/CottonDQLGrpc$CottonDQLImplBase;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "engine", "Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/ExecutionEngine;)V", "binder", "Lorg/vitrivr/cottontail/server/grpc/helper/GrpcQueryBinder;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getEngine", "()Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "planner", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "batchedQuery", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$BatchedQueryMessage;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "ping", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Empty;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Status;", "query", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "Companion", "cottontaildb"})
@ExperimentalTime
public final class CottonDQLService
extends CottonDQLGrpc.CottonDQLImplBase {
    private final GrpcQueryBinder binder;
    private final CottontailQueryPlanner planner;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final ExecutionEngine engine;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @Override
    public void query(@NotNull CottontailGrpc.QueryMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Object v2;
            CharSequence charSequence;
            ExecutionEngine.ExecutionContext context = this.engine.new ExecutionEngine.ExecutionContext();
            CharSequence charSequence2 = request.getQueryId();
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl2 = false;
                charSequence = context.getUuid().toString();
            } else {
                charSequence = charSequence2;
            }
            String queryId = (String)charSequence;
            boolean $i$f$measureTime = false;
            boolean bl3 = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl4 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl5 = false;
            boolean $i$f$measureTimedValue = false;
            boolean bl6 = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl7 = false;
            TimeMark mark$iv$iv22 = $this$measureTimedValue$iv$iv.markNow();
            boolean bl8 = false;
            CottontailGrpc.Query query = request.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"request.query");
            LogicalNodeExpression result$iv$iv = this.binder.parseAndBind(query);
            TimedValue bindTimedValue = new TimedValue((Object)result$iv$iv, mark$iv$iv22.elapsedNow-UwyO8pc(), null);
            LOGGER.trace("Parsing & binding query " + queryId + " took " + Duration.toString-impl((double)bindTimedValue.getDuration-UwyO8pc()) + '.');
            boolean $i$f$measureTime3 = false;
            boolean mark$iv$iv22 = false;
            TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime4 = false;
            boolean bl9 = false;
            TimeMark mark$iv$iv3 = $this$measureTime$iv$iv2.markNow();
            boolean bl10 = false;
            Collection<PhysicalNodeExpression> candidates = this.planner.plan((LogicalNodeExpression)bindTimedValue.getValue());
            if (candidates.isEmpty()) {
                responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Query execution failed because no valid execution plan could be produced").asException());
                return;
            }
            Iterable $this$minByOrNull$iv = candidates;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    PhysicalNodeExpression it = (PhysicalNodeExpression)minElem$iv;
                    boolean bl11 = false;
                    Comparable minValue$iv = it.getTotalCost();
                    do {
                        Object e$iv = iterator$iv.next();
                        PhysicalNodeExpression it2 = (PhysicalNodeExpression)e$iv;
                        $i$a$-minByOrNull-CottonDQLService$query$totalDuration$1$planningTime$1$operator$1 = false;
                        Comparable v$iv = it2.getTotalCost();
                        if (minValue$iv.compareTo(v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v2);
            Operator operator = ((PhysicalNodeExpression)v2).toOperator(context);
            String string = queryId;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queryId");
            context.addOperator(new ResultsSpoolerOperator(operator, context, string, 0, responseObserver));
            double planningTime = mark$iv$iv3.elapsedNow-UwyO8pc();
            LOGGER.trace("Planning query " + queryId + " took " + Duration.toString-impl((double)planningTime) + '.');
            context.execute();
            double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
            responseObserver.onCompleted();
            LOGGER.trace("Executing query " + context.getUuid() + " took " + Duration.toString-impl((double)totalDuration) + " to complete.");
        }
        catch (QueryException.QuerySyntaxException e) {
            LOGGER.error("Error while executing query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Query syntax is invalid: " + e.getMessage()).asException());
        }
        catch (QueryException.QueryBindException e) {
            LOGGER.error("Error while executing query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Query binding failed: " + e.getMessage()).asException());
        }
        catch (ExecutionException e) {
            LOGGER.error("Error while executing query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Query execution failed: " + e.getMessage()).asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while executing query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Query execution failed failed because of a database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while executing query " + request, e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Query execution failed failed because of an unknown error: " + e.getMessage()).asException());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void batchedQuery(@NotNull CottontailGrpc.BatchedQueryMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CharSequence charSequence;
            ExecutionEngine.ExecutionContext context = this.engine.new ExecutionEngine.ExecutionContext();
            CharSequence charSequence2 = request.getQueryId();
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl2 = false;
                charSequence = context.getUuid().toString();
            } else {
                charSequence = charSequence2;
            }
            String queryId = (String)charSequence;
            boolean $i$f$measureTime = false;
            boolean bl3 = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl4 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl5 = false;
            List<CottontailGrpc.Query> list = request.getQueriesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"request.queriesList");
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object v3;
                void query;
                int n = index$iv++;
                boolean bl6 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CottontailGrpc.Query query2 = (CottontailGrpc.Query)item$iv;
                int index = n;
                boolean bl7 = false;
                boolean $i$f$measureTimedValue = false;
                boolean bl8 = false;
                TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTimedValue2 = false;
                boolean bl9 = false;
                TimeMark mark$iv$iv2 = $this$measureTimedValue$iv$iv.markNow();
                boolean bl10 = false;
                void v2 = query;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"query");
                LogicalNodeExpression result$iv$iv = this.binder.parseAndBind((CottontailGrpc.Query)v2);
                TimedValue bindTimedValue = new TimedValue((Object)result$iv$iv, mark$iv$iv2.elapsedNow-UwyO8pc(), null);
                LOGGER.trace("Parsing & binding query: " + queryId + ", index: " + index + " took " + Duration.toString-impl((double)bindTimedValue.getDuration-UwyO8pc()) + '.');
                boolean $i$f$measureTimedValue3 = false;
                $i$f$measureTimedValue2 = false;
                TimeSource $this$measureTimedValue$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTimedValue4 = false;
                bl10 = false;
                TimeMark mark$iv$iv3 = $this$measureTimedValue$iv$iv2.markNow();
                boolean bl11 = false;
                Collection<PhysicalNodeExpression> candidates = this.planner.plan((LogicalNodeExpression)bindTimedValue.getValue());
                Iterable $this$minByOrNull$iv = candidates;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v3 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v3 = minElem$iv;
                    } else {
                        PhysicalNodeExpression it = (PhysicalNodeExpression)minElem$iv;
                        boolean bl12 = false;
                        Comparable minValue$iv = it.getTotalCost();
                        do {
                            Object e$iv = iterator$iv.next();
                            PhysicalNodeExpression it2 = (PhysicalNodeExpression)e$iv;
                            $i$a$-minByOrNull-CottonDQLService$batchedQuery$totalDuration$1$1$planTimedValue$1$operator$1 = false;
                            Comparable v$iv = it2.getTotalCost();
                            if (minValue$iv.compareTo(v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v3 = minElem$iv;
                    }
                }
                Intrinsics.checkNotNull(v3);
                Operator operator = ((PhysicalNodeExpression)v3).toOperator(context);
                String string = queryId;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queryId");
                context.addOperator(new ResultsSpoolerOperator(operator, context, string, index, responseObserver));
                Unit result$iv$iv2 = Unit.INSTANCE;
                TimedValue planTimedValue = new TimedValue((Object)result$iv$iv2, mark$iv$iv3.elapsedNow-UwyO8pc(), null);
                LOGGER.trace("Planning query: " + queryId + ", index: " + index + " took " + Duration.toString-impl((double)planTimedValue.getDuration-UwyO8pc()) + '.');
                context.execute();
            }
            double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
            responseObserver.onCompleted();
            LOGGER.info("Executing batched query " + queryId + " took " + Duration.toString-impl((double)totalDuration) + " to complete.");
        }
        catch (QueryException.QuerySyntaxException e) {
            LOGGER.error("Error while executing batched query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Query syntax is invalid: " + e.getMessage()).asException());
        }
        catch (QueryException.QueryBindException e) {
            LOGGER.error("Error while executing batched query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription("Query binding failed: " + e.getMessage()).asException());
        }
        catch (ExecutionException e) {
            LOGGER.error("Error while executing query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Query execution failed: " + e.getMessage()).asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while executing query " + request, (Throwable)e);
            responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Query execution failed failed because of a database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while executing batched query " + request, e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Query execution failed failed because of a unknown error: " + e.getMessage()).asException());
        }
    }

    @Override
    public void ping(@NotNull CottontailGrpc.Empty request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
        responseObserver.onCompleted();
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    @NotNull
    public final ExecutionEngine getEngine() {
        return this.engine;
    }

    public CottonDQLService(@NotNull Catalogue catalogue, @NotNull ExecutionEngine engine) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.catalogue = catalogue;
        this.engine = engine;
        this.binder = new GrpcQueryBinder(this.catalogue);
        this.planner = new CottontailQueryPlanner(CollectionsKt.listOf((Object[])new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE, DeferredFetchAfterFilterRewriteRule.INSTANCE, DeferredFetchAfterKnnRewriteRule.INSTANCE}), CollectionsKt.listOf((Object[])new RewriteRule[]{KnnIndexScanRule.INSTANCE, BooleanIndexScanRule.INSTANCE, CountPushdownRule.INSTANCE, EntityScanImplementationRule.INSTANCE, FilterImplementationRule.INSTANCE, KnnImplementationRule.INSTANCE, LimitImplementationRule.INSTANCE, ProjectionImplementationRule.INSTANCE, FetchImplementationRule.INSTANCE}));
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(CottonDQLService.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDQLService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

