/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.entity;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnTransaction;
import org.vitrivr.cottontail.database.column.mapdb.MapDBColumn;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityHeader;
import org.vitrivr.cottontail.database.entity.EntityHeaderSerializer;
import org.vitrivr.cottontail.database.entity.EntityStatistics;
import org.vitrivr.cottontail.database.entity.EntityTransaction;
import org.vitrivr.cottontail.database.entity.IndexEntry;
import org.vitrivr.cottontail.database.entity.IndexEntrySerializer;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.Transaction;
import org.vitrivr.cottontail.database.general.TransactionKt;
import org.vitrivr.cottontail.database.general.TransactionStatus;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.components.AtomicBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 A2\u00020\u0001:\u0002ABB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030+0*J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190*J\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010+2\u0006\u0010\u0002\u001a\u00020\u0010JC\u00103\u001a\u0002012\u0006\u0010\u0002\u001a\u0002042\u0006\u00105\u001a\u0002062\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030+072\u0014\b\u0002\u00108\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002090\u000f\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u0002012\u0006\u0010\u0002\u001a\u000204J\b\u0010<\u001a\u000201H\u0004J\u001e\u0010=\u001a\u00020\n2\n\u0010>\u001a\u0006\u0012\u0002\b\u00030+2\n\b\u0002\u00105\u001a\u0004\u0018\u000106J\u0006\u0010?\u001a\u000201J\u000e\u0010@\u001a\u0002012\u0006\u0010\u0002\u001a\u000204R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/vitrivr/cottontail/database/entity/Entity;", "Lorg/vitrivr/cottontail/database/general/DBO;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "parent", "Lorg/vitrivr/cottontail/database/schema/Schema;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;Lorg/vitrivr/cottontail/database/schema/Schema;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "Lorg/vitrivr/cottontail/database/column/Column;", "header", "Lorg/vitrivr/cottontail/database/entity/EntityHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/entity/EntityHeader;", "indexLock", "indexes", "", "Lorg/vitrivr/cottontail/database/index/Index;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "getParent", "()Lorg/vitrivr/cottontail/database/schema/Schema;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "statistics", "Lorg/vitrivr/cottontail/database/entity/EntityStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/database/entity/EntityStatistics;", "store", "Lorg/mapdb/CottontailStoreWAL;", "txLock", "allColumns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "allIndexes", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "close", "", "columnForName", "createIndex", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "", "params", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;Ljava/util/Map;)V", "dropIndex", "finalize", "hasIndexForColumn", "column", "updateAllIndexes", "updateIndex", "Companion", "Tx", "cottontaildb"})
public final class Entity
implements DBO {
    @NotNull
    private final Path path;
    private final CottontailStoreWAL store;
    private final StampedLock txLock;
    private final StampedLock closeLock;
    private final StampedLock indexLock;
    private final Map<Name.ColumnName, Column<?>> columns;
    private final Collection<Index> indexes;
    private volatile boolean closed;
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final Schema parent;
    @NotNull
    public static final String FILE_CATALOGUE = "index.db";
    public static final long HEADER_RECORD_ID = 1L;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    private final EntityHeader getHeader() {
        EntityHeader entityHeader = (EntityHeader)this.store.get(1L, EntityHeaderSerializer.INSTANCE);
        if (entityHeader == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of entity '" + this.getName() + "'!");
        }
        return entityHeader;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @NotNull
    public final EntityStatistics getStatistics() {
        EntityHeader entityHeader = this.getHeader();
        boolean bl = false;
        boolean bl2 = false;
        EntityHeader it = entityHeader;
        boolean bl3 = false;
        return new EntityStatistics(it.getColumns().length, it.getSize(), ((Column)CollectionsKt.first((Iterable)this.columns.values())).getMaxTupleId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canProcess(@NotNull Predicate predicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate)) return false;
        Iterable $this$all$iv = ((BooleanPredicate)predicate).getAtomics();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            AtomicBooleanPredicate it = (AtomicBooleanPredicate)element$iv;
            boolean bl2 = false;
            if (it.getOperator() == ComparisonOperator.LIKE) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ColumnDef<?>> allColumns() {
        List $i$a$-read-Entity$allColumns$22;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            void $this$mapTo$iv$iv;
            boolean $i$a$-read-Entity$allColumns$22 = false;
            boolean bl = !this.getClosed();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Entity " + this.getName() + " has been closed and cannot be used anymore.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable $this$map$iv = this.columns.values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Column column = (Column)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                ColumnDef columnDef = it.getColumnDef();
                collection.add(columnDef);
            }
            $i$a$-read-Entity$allColumns$22 = (List)destination$iv$iv;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return $i$a$-read-Entity$allColumns$22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ColumnDef<?> columnForName(@NotNull Name.ColumnName name) {
        ColumnDef<?> $i$a$-read-Entity$columnForName$22;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-Entity$columnForName$22 = false;
            boolean bl = !this.getClosed();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Entity " + this.getName() + " has been closed and cannot be used anymore.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Column<?> column = this.columns.get(name);
            $i$a$-read-Entity$columnForName$22 = column != null ? column.getColumnDef() : null;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return $i$a$-read-Entity$columnForName$22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<Index> allIndexes() {
        Collection<Index> $i$a$-read-Entity$allIndexes$22;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            Collection<Index> $i$a$-read-Entity$allIndexes$1$32;
            boolean $i$a$-read-Entity$allIndexes$22 = false;
            boolean bl = !this.getClosed();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Entity " + this.getName() + " has been closed and cannot be used anymore.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            StampedLock $this$read$iv2 = this.indexLock;
            boolean $i$f$read2 = false;
            long stamp$iv2 = $this$read$iv2.readLock();
            try {
                boolean $i$a$-read-Entity$allIndexes$1$32 = false;
                $i$a$-read-Entity$allIndexes$1$32 = this.indexes;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv2.unlock(stamp$iv2);
            }
            $i$a$-read-Entity$allIndexes$22 = $i$a$-read-Entity$allIndexes$1$32;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return $i$a$-read-Entity$allIndexes$22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasIndexForColumn(@NotNull ColumnDef<?> column, @Nullable IndexType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = !this.getClosed();
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Entity " + this.getName() + " has been closed and cannot be used anymore.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            StampedLock $this$read$iv2 = this.indexLock;
            boolean $i$f$read2 = false;
            long stamp$iv2 = $this$read$iv2.readLock();
            try {
                Object v0;
                block12: {
                    bl2 = false;
                    Iterable iterable = this.indexes;
                    boolean bl8 = false;
                    Iterable iterable2 = iterable;
                    boolean bl9 = false;
                    for (Object t : iterable2) {
                        Index it = (Index)t;
                        boolean bl10 = false;
                        if (!(ArraysKt.contains((Object[])it.getColumns(), column) && (type == null || it.getType() == type))) continue;
                        v0 = t;
                        break block12;
                    }
                    v0 = null;
                }
                bl2 = v0 != null;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv2.unlock(stamp$iv2);
            }
            bl = bl2;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return bl;
    }

    public static /* synthetic */ boolean hasIndexForColumn$default(Entity entity, ColumnDef columnDef, IndexType indexType, int n, Object object) {
        if ((n & 2) != 0) {
            indexType = null;
        }
        return entity.hasIndexForColumn(columnDef, indexType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, @NotNull Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean bl = false;
            boolean bl2 = !this.getClosed();
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Entity " + this.getName() + " has been closed and cannot be used anymore.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            StampedLock $this$write$iv = this.indexLock;
            boolean $i$f$write = false;
            long stamp$iv2 = $this$write$iv.writeLock();
            try {
                Object v1;
                Object object;
                Object object2;
                block20: {
                    Object $this$mapTo$iv$iv;
                    boolean bl6 = false;
                    Object $this$map$iv = this.getHeader().getIndexes();
                    boolean $i$f$map = false;
                    long[] lArray = $this$map$iv;
                    Collection destination$iv$iv22 = new ArrayList(((long[])$this$map$iv).length);
                    boolean $i$f$mapTo22 = false;
                    object2 = $this$mapTo$iv$iv;
                    int n = ((void)object2).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var27_44 = item$iv$iv = object2[i];
                        object = destination$iv$iv22;
                        boolean bl7 = false;
                        IndexEntry indexEntry = (IndexEntry)this.store.get((long)it, IndexEntrySerializer.INSTANCE);
                        if (indexEntry == null) {
                            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to create index '" + name + "': Could not read index definition at position " + (long)it + '!');
                        }
                        Pair pair = new Pair((Object)((long)it), (Object)indexEntry);
                        object.add(pair);
                    }
                    $this$map$iv = (List)destination$iv$iv22;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    boolean destination$iv$iv22 = false;
                    Iterator $i$f$mapTo22 = $this$mapTo$iv$iv.iterator();
                    while ($i$f$mapTo22.hasNext()) {
                        object2 = $i$f$mapTo22.next();
                        Pair it = (Pair)object2;
                        boolean bl8 = false;
                        if (!Intrinsics.areEqual((Object)this.getName().index(((IndexEntry)it.getSecond()).getName()), (Object)name)) continue;
                        v1 = object2;
                        break block20;
                    }
                    v1 = null;
                }
                Pair indexEntry = v1;
                if (indexEntry != null) {
                    throw (Throwable)new DatabaseException.IndexAlreadyExistsException(name);
                }
                Index newIndex = type.create(name, this, columns, params);
                this.indexes.add(newIndex);
                try {
                    Collection<String> collection;
                    int n;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ColumnDef<?>[] destination$iv$iv22 = columns;
                    boolean bl9 = false;
                    IndexType indexType = type;
                    String string = name.getSimple();
                    object = this.store;
                    boolean $i$f$map = false;
                    object2 = $this$map$iv;
                    Collection destination$iv$iv32 = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    void var37_53 = $this$mapTo$iv$iv;
                    int n2 = ((void)var37_53).length;
                    for (n = 0; n < n2; ++n) {
                        void it;
                        void item$iv$iv;
                        void bl7 = item$iv$iv = var37_53[n];
                        collection = destination$iv$iv32;
                        boolean bl10 = false;
                        String string2 = it.getName().getSimple();
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv32;
                    Collection $this$toTypedArray$iv = collection;
                    boolean $i$f$toTypedArray22 = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] stringArray2 = stringArray;
                    boolean bl11 = bl9;
                    IndexType indexType2 = indexType;
                    String string3 = string;
                    long sid = ((CottontailStoreWAL)object).put(new IndexEntry(string3, indexType2, bl11, stringArray2), IndexEntrySerializer.INSTANCE);
                    EntityHeader $i$f$toTypedArray22 = this.getHeader();
                    boolean bl12 = false;
                    boolean destination$iv$iv32 = false;
                    EntityHeader it = $i$f$toTypedArray22;
                    boolean bl13 = false;
                    long l = it.getSize();
                    long l2 = it.getCreated();
                    long l3 = System.currentTimeMillis();
                    long[] lArray = it.getColumns();
                    long[] lArray2 = it.getIndexes();
                    n = it.getIndexes().length + 1;
                    boolean bl14 = false;
                    long[] lArray3 = Arrays.copyOf(lArray2, n);
                    Intrinsics.checkNotNullExpressionValue((Object)lArray3, (String)"java.util.Arrays.copyOf(this, newSize)");
                    EntityHeader entityHeader = new EntityHeader(l, l2, l3, lArray, lArray3);
                    entityHeader.getIndexes()[entityHeader.getIndexes().length - 1] = sid;
                    this.store.update(1L, entityHeader, EntityHeaderSerializer.INSTANCE);
                    this.store.commit();
                }
                catch (DBException e) {
                    List pathsToDelete;
                    this.store.rollback();
                    List list = pathsToDelete = Files.walk(newIndex.getPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"pathsToDelete");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it = (Path)element$iv;
                        boolean bl15 = false;
                        Files.delete(it);
                    }
                    throw (Throwable)new DatabaseException("Failed to create index '" + name + "' due to a storage exception: " + e.getMessage());
                }
                Unit bl6 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    public static /* synthetic */ void createIndex$default(Entity entity, Name.IndexName indexName, IndexType indexType, ColumnDef[] columnDefArray, Map map2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        entity.createIndex(indexName, indexType, columnDefArray, map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void dropIndex(@NotNull Name.IndexName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-Entity$dropIndex$22 = false;
            boolean bl = !this.getClosed();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Entity " + this.getName() + " has been closed and cannot be used anymore.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            StampedLock $this$write$iv = this.indexLock;
            boolean $i$f$write = false;
            long stamp$iv2 = $this$write$iv.writeLock();
            try {
                Object var37_55;
                Object v3;
                Object object;
                Object it3;
                boolean $this$mapTo$iv$iv2;
                long l;
                block23: {
                    Object v1;
                    Object object2;
                    boolean $i$f$map;
                    Object $this$map$iv;
                    block22: {
                        Object $this$mapTo$iv$iv2;
                        boolean bl5 = false;
                        $this$map$iv = this.getHeader().getIndexes();
                        $i$f$map = false;
                        long[] lArray = $this$map$iv;
                        Collection destination$iv$iv22 = new ArrayList(((long[])$this$map$iv).length);
                        boolean $i$f$mapTo22 = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv2) {
                            void it2;
                            l = item$iv$iv;
                            Collection collection = destination$iv$iv22;
                            boolean bl6 = false;
                            IndexEntry indexEntry = (IndexEntry)this.store.get((long)it2, IndexEntrySerializer.INSTANCE);
                            if (indexEntry == null) {
                                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to drop index '" + name + "': Could not read index definition at position " + (long)it2 + '!');
                            }
                            Pair pair = new Pair((Object)((long)it2), (Object)indexEntry);
                            collection.add(pair);
                        }
                        $this$map$iv = (List)destination$iv$iv22;
                        $i$f$map = false;
                        $this$mapTo$iv$iv2 = $this$map$iv;
                        boolean destination$iv$iv22 = false;
                        Iterator $i$f$mapTo22 = $this$mapTo$iv$iv2.iterator();
                        while ($i$f$mapTo22.hasNext()) {
                            object2 = $i$f$mapTo22.next();
                            Pair it3 = (Pair)object2;
                            boolean bl7 = false;
                            if (!Intrinsics.areEqual((Object)this.getName().index(((IndexEntry)it3.getSecond()).getName()), (Object)name)) continue;
                            v1 = object2;
                            break block22;
                        }
                        v1 = null;
                    }
                    Pair pair = v1;
                    if (pair != null) {
                        $this$map$iv = pair;
                        $i$f$map = false;
                        $this$mapTo$iv$iv2 = false;
                        Object ie = $this$map$iv;
                        boolean bl8 = false;
                        object2 = this.indexes;
                        it3 = ie.getSecond();
                        object = ie.getFirst();
                        boolean bl9 = false;
                        Object object3 = object2;
                        boolean bl10 = false;
                        Iterator iterator2 = object3.iterator();
                        while (iterator2.hasNext()) {
                            Object t = iterator2.next();
                            Index it4 = (Index)t;
                            boolean bl11 = false;
                            if (!Intrinsics.areEqual((Object)it4.getName(), (Object)this.getName().index(((IndexEntry)ie.getSecond()).getName()))) continue;
                            v3 = t;
                            break block23;
                        }
                        v3 = null;
                    } else {
                        throw (Throwable)new DatabaseException.IndexDoesNotExistException(name);
                    }
                }
                Object var52_56 = var37_55 = v3;
                Object object4 = it3;
                Object object5 = object;
                Triple indexEntry = new Triple(object5, object4, var52_56);
                Object object6 = indexEntry.getThird();
                Intrinsics.checkNotNull((Object)object6);
                ((Index)object6).close();
                Object object7 = indexEntry.getThird();
                Intrinsics.checkNotNull((Object)object7);
                this.indexes.remove(object7);
                try {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    EntityHeader $i$f$map = this.getHeader();
                    $this$mapTo$iv$iv2 = false;
                    boolean bl12 = false;
                    EntityHeader it5 = $i$f$map;
                    boolean bl13 = false;
                    it3 = it5.getIndexes();
                    object = it5.getColumns();
                    long l2 = System.currentTimeMillis();
                    l = it5.getCreated();
                    long l3 = it5.getSize();
                    boolean $i$f$filter = false;
                    var37_55 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    void var43_63 = $this$filterTo$iv$iv;
                    int n = ((void)var43_63).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void it6 = element$iv$iv = var43_63[i];
                        boolean bl14 = false;
                        if (!(it6 != ((Number)indexEntry.getFirst()).longValue())) continue;
                        destination$iv$iv.add((long)element$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    long[] lArray = CollectionsKt.toLongArray((Collection)list);
                    Object object8 = object;
                    long l4 = l2;
                    long l5 = l;
                    long l6 = l3;
                    EntityHeader entityHeader = new EntityHeader(l6, l5, l4, (long[])object8, lArray);
                    this.store.update(1L, entityHeader, EntityHeaderSerializer.INSTANCE);
                    this.store.commit();
                }
                catch (DBException e) {
                    this.store.rollback();
                    throw (Throwable)new DatabaseException("Failed to drop index '" + name + "' due to a storage exception: " + e.getMessage());
                }
                if (indexEntry.getThird() != null) {
                    List pathsToDelete;
                    Object object9 = indexEntry.getThird();
                    Intrinsics.checkNotNull((Object)object9);
                    List list = pathsToDelete = Files.walk(((Index)object9).getPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"pathsToDelete");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it7 = (Path)element$iv;
                        boolean bl15 = false;
                        Files.delete(it7);
                    }
                }
                Unit bl5 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv2);
            }
            Unit $i$a$-read-Entity$dropIndex$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    public final void updateIndex(@NotNull Name.IndexName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TransactionKt.begin((Transaction)new Tx(this, false, null, false, 6, null), (Function1)new Function1<Tx, Boolean>(name){
            final /* synthetic */ Name.IndexName $name;

            public final boolean invoke(@NotNull Tx tx) {
                Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                IndexTransaction itx = tx.index(this.$name);
                if (itx == null) {
                    throw (Throwable)new DatabaseException.IndexDoesNotExistException(this.$name);
                }
                itx.rebuild();
                return true;
            }
            {
                this.$name = indexName;
                super(1);
            }
        });
    }

    public final void updateAllIndexes() {
        TransactionKt.begin((Transaction)new Tx(this, false, null, false, 6, null), updateAllIndexes.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-Entity$close$22 = false;
            if (!this.getClosed()) {
                Iterable $this$forEach$iv = this.columns.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl = false;
                    it.close();
                }
                this.store.close();
                this.closed = true;
            }
            Unit $i$a$-write-Entity$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    protected final synchronized void finalize() {
        this.close();
    }

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Schema getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public Entity(@NotNull Name.EntityName name, @NotNull Schema parent) {
        Object object;
        long it;
        Collection<Pair> collection;
        long[] $this$mapTo$iv$iv;
        long[] $this$map$iv;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        Path path = this.getParent().getPath().resolve("entity_" + this.getName().getSimple());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve(\"entity_${name.simple}\")");
        this.path = path;
        Entity entity = this;
        try {
            Entity entity2 = entity;
            MapDBConfig mapDBConfig = this.getParent().getParent().getConfig().getMapdb();
            Path path2 = this.getPath().resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(FILE_CATALOGUE)");
            object2 = mapDBConfig.store(path2);
        }
        catch (DBException dBException) {
            void e;
            Entity entity3 = entity;
            throw (Throwable)new DatabaseException("Failed to open entity '" + this.getName() + "': " + e.getMessage() + "'.");
        }
        entity2.store = object2;
        this.txLock = new StampedLock();
        this.closeLock = new StampedLock();
        this.indexLock = new StampedLock();
        object2 = this.getHeader().getColumns();
        entity = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (long item$iv$iv : $this$mapTo$iv$iv) {
            void var13_16 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Name.EntityName entityName = this.getName();
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.STRING");
            String string = (String)this.store.get(it, (Serializer)groupSerializer);
            if (string == null) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open entity '" + this.getName() + "': Could not read column definition at position " + it + '!');
            }
            Name.ColumnName n = entityName.column(string);
            object = TuplesKt.to((Object)n, new MapDBColumn(n, this));
            collection.add((Pair)object);
        }
        collection = (List)destination$iv$iv;
        entity.columns = MapsKt.toMap((Iterable)collection);
        $this$map$iv = this.getHeader().getIndexes();
        entity = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        long[] lArray = $this$mapTo$iv$iv;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Collection<ColumnDef<?>> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            IndexEntry index;
            void idx;
            long item$iv$iv;
            it = item$iv$iv = lArray[i];
            collection = destination$iv$iv;
            boolean bl = false;
            if ((IndexEntry)this.store.get((long)idx, IndexEntrySerializer.INSTANCE) == null) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open entity '" + this.getName() + "': Could not read index definition at position " + (long)idx + '!');
            }
            String[] stringArray = index.getColumns();
            Entity entity4 = this;
            Name.IndexName indexName = this.getName().index(index.getName());
            IndexType indexType = index.getType();
            boolean $i$f$map2 = false;
            void var22_24 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            void var25_27 = $this$mapTo$iv$iv2;
            int n2 = ((void)var25_27).length;
            for (int j = 0; j < n2; ++j) {
                ColumnDef<?> columnDef;
                void col;
                void item$iv$iv2;
                void var29_31 = item$iv$iv2 = var25_27[j];
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                if (StringsKt.contains$default((CharSequence)((CharSequence)col), (CharSequence)".", (boolean)false, (int)2, null)) {
                    columnDef = this.columnForName(this.getName().column((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)col), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null))));
                    if (columnDef == null) {
                        throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open entity '" + this.getName() + "': It hosts an index for column '" + (String)col + "' that does not exist on the entity!");
                    }
                } else {
                    columnDef = this.columnForName(this.getName().column((String)col));
                    if (columnDef == null) {
                        throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open entity '" + this.getName() + "': It hosts an index for column '" + (String)col + "' that does not exist on the entity!");
                    }
                }
                ColumnDef<?> columnDef2 = columnDef;
                collection2.add(columnDef2);
            }
            collection2 = (List)destination$iv$iv2;
            Collection $this$toTypedArray$iv = collection2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            object = indexType.open(indexName, entity4, columnDefArray);
            collection.add((Pair)object);
        }
        collection = (List)destination$iv$iv;
        entity.indexes = CollectionsKt.toMutableSet((Iterable)collection);
    }

    public static final /* synthetic */ boolean access$getClosed$p(Entity $this) {
        return $this.getClosed();
    }

    public static final /* synthetic */ void access$setClosed$p(Entity $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J)\u0010!\u001a\u00020\"2\u001a\u0010#\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0$\"\u0006\u0012\u0002\b\u00030\fH\u0002\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\"H\u0002J\b\u0010'\u001a\u00020\"H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020\tH\u0002J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010+\u001a\u00020\"H\u0016J\b\u0010,\u001a\u00020\tH\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010)\u001a\u00020\tH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u00142\u0006\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J1\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010#\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010$2\b\u00102\u001a\u0004\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104J\u001d\u00105\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`62\u0006\u00107\u001a\u000208H\u0016\u00a2\u0006\u0002\u00109J\n\u0010:\u001a\u00060\tj\u0002`6J\b\u0010;\u001a\u00020\"H\u0002J)\u0010<\u001a\u0002082\n\u0010)\u001a\u00060\tj\u0002`62\u0010\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0$\u00a2\u0006\u0002\u0010=J\b\u0010>\u001a\u00020\"H\u0016J%\u0010?\u001a\b\u0012\u0004\u0012\u0002080@2\u0010\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0$H\u0016\u00a2\u0006\u0002\u0010AJ-\u0010?\u001a\b\u0012\u0004\u0012\u0002080@2\u0010\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0$2\u0006\u0010B\u001a\u00020CH\u0016\u00a2\u0006\u0002\u0010DJ\u0010\u0010E\u001a\u00020\"2\u0006\u00107\u001a\u000208H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/EntityTransaction;", "readonly", "", "tid", "Ljava/util/UUID;", "omitIndex", "(Lorg/vitrivr/cottontail/database/entity/Entity;ZLjava/util/UUID;Z)V", "closeStamp", "", "colTxs", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "Lorg/vitrivr/cottontail/database/column/ColumnTransaction;", "entity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "getEntity", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "indexTxs", "", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "localLock", "Ljava/util/concurrent/locks/StampedLock;", "getReadonly", "()Z", "<set-?>", "Lorg/vitrivr/cottontail/database/general/TransactionStatus;", "status", "getStatus", "()Lorg/vitrivr/cottontail/database/general/TransactionStatus;", "getTid", "()Ljava/util/UUID;", "txStamp", "checkColumnsExist", "", "columns", "", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "checkValidForRead", "checkValidForWrite", "checkValidTupleId", "tupleId", "close", "commit", "count", "delete", "index", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "indexes", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;Lorg/vitrivr/cottontail/database/index/IndexType;)Ljava/util/Collection;", "insert", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "(Lorg/vitrivr/cottontail/model/basics/Record;)Ljava/lang/Long;", "maxTupleId", "performRollback", "read", "(J[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)Lorg/vitrivr/cottontail/model/basics/Record;", "rollback", "scan", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;)Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "range", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/model/basics/ColumnDef;Lkotlin/ranges/LongRange;)Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "update", "cottontaildb"})
    public final class Tx
    implements EntityTransaction {
        private final long closeStamp;
        private final long txStamp;
        private final Map<ColumnDef<?>, ColumnTransaction<?>> colTxs;
        private final Collection<IndexTransaction> indexTxs;
        @NotNull
        private volatile TransactionStatus status;
        private final StampedLock localLock;
        private final boolean readonly;
        @NotNull
        private final UUID tid;
        final /* synthetic */ Entity this$0;

        @Override
        @NotNull
        public TransactionStatus getStatus() {
            return this.status;
        }

        @Override
        @NotNull
        public Entity getEntity() {
            return this.this$0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                Iterator iterator2;
                boolean $i$f$forEach;
                Iterator $this$forEach$iv;
                boolean $i$a$-write-Entity$Tx$commit$22 = false;
                if (this.getStatus() == TransactionStatus.DIRTY) {
                    $this$forEach$iv = this.colTxs;
                    $i$f$forEach = false;
                    iterator2 = $this$forEach$iv;
                    boolean bl = false;
                    Iterator iterator3 = iterator2.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator3.next();
                        boolean bl2 = false;
                        ((ColumnTransaction)it.getValue()).commit();
                    }
                    this.this$0.store.commit();
                    this.status = TransactionStatus.CLEAN;
                }
                $this$forEach$iv = this.indexTxs;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    IndexTransaction it = (IndexTransaction)element$iv;
                    boolean bl = false;
                    it.commit();
                }
                Unit $i$a$-write-Entity$Tx$commit$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-Entity$Tx$rollback$22 = false;
                if (this.getStatus() == TransactionStatus.DIRTY) {
                    this.performRollback();
                    this.status = TransactionStatus.CLEAN;
                }
                Unit $i$a$-write-Entity$Tx$rollback$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        private final void performRollback() {
            Object $this$forEach$iv = this.indexTxs;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                IndexTransaction it = (IndexTransaction)element$iv;
                boolean bl = false;
                it.rollback();
            }
            $this$forEach$iv = this.colTxs;
            $i$f$forEach = false;
            object = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator2 = object.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl2 = false;
                ((ColumnTransaction)it.getValue()).rollback();
            }
            this.this$0.store.rollback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-Entity$Tx$close$22 = false;
                if (this.getStatus() != TransactionStatus.CLOSED) {
                    if (this.getStatus() == TransactionStatus.DIRTY) {
                        this.performRollback();
                    }
                    Object $this$forEach$iv = this.indexTxs;
                    boolean $i$f$forEach = false;
                    Object object = $this$forEach$iv.iterator();
                    while (object.hasNext()) {
                        Object element$iv = object.next();
                        IndexTransaction it = (IndexTransaction)element$iv;
                        boolean bl = false;
                        it.close();
                    }
                    $this$forEach$iv = this.colTxs;
                    $i$f$forEach = false;
                    object = $this$forEach$iv;
                    boolean bl = false;
                    Iterator iterator2 = object.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        ((ColumnTransaction)it.getValue()).close();
                    }
                    this.status = TransactionStatus.CLOSED;
                    this.this$0.txLock.unlock(this.txStamp);
                    this.this$0.closeLock.unlockRead(this.closeStamp);
                }
                Unit $i$a$-write-Entity$Tx$close$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                this.checkValidForRead();
                this.checkValidTupleId(tupleId);
                ColumnDef<?>[] $this$map$iv = columns;
                boolean $i$f$map = false;
                ColumnDef<?>[] columnDefArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var14_12 = $this$mapTo$iv$iv;
                int n = ((void)var14_12).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var18_16 = item$iv$iv = var14_12[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    this.checkColumnsExist(new ColumnDef[]{it});
                    Object t = ((ColumnTransaction)MapsKt.getValue(this.colTxs, (Object)it)).read(tupleId);
                    collection.add(t);
                }
                Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                if (valueArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Value[] values = valueArray;
                Record record = new StandaloneRecord(tupleId, columns, values);
                return record;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long count() {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForRead();
                long l = this.this$0.getHeader().getSize();
                return l;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long maxTupleId() {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForRead();
                long l = ((Column)CollectionsKt.first((Iterable)this.this$0.columns.values())).getMaxTupleId();
                return l;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Record> scan(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            long l = 1L;
            return this.scan(columns, new LongRange(l, this.maxTupleId()));
        }

        @Override
        @NotNull
        public CloseableIterator<Record> scan(@NotNull ColumnDef<?>[] columns, @NotNull LongRange range) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new CloseableIterator<Record>(this, (ColumnDef[])columns, range){
                private final long lock;
                private final CloseableIterator<Long> wrapped;
                private volatile boolean closed;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ ColumnDef[] $columns;
                final /* synthetic */ LongRange $range;

                @NotNull
                public Record next() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return this.this$0.read(((Number)this.wrapped.next()).longValue(), this.$columns);
                }

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of hasNext(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return this.wrapped.hasNext();
                }

                public void close() {
                    if (!this.closed) {
                        this.wrapped.close();
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.lock);
                        this.closed = true;
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$columns = $captured_local_variable$1;
                    this.$range = $captured_local_variable$2;
                    Tx.access$checkValidForRead(this$0);
                    this.lock = Tx.access$getLocalLock$p(this$0).readLock();
                    this.wrapped = ((ColumnTransaction)((Map.Entry)CollectionsKt.first((Iterable)Tx.access$getColTxs$p(this$0).entrySet())).getValue()).scan($captured_local_variable$2);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Collection<IndexTransaction> indexes() {
            Collection<IndexTransaction> $i$a$-read-Entity$Tx$indexes$22;
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-Entity$Tx$indexes$22 = false;
                $i$a$-read-Entity$Tx$indexes$22 = this.indexTxs;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            return $i$a$-read-Entity$Tx$indexes$22;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<IndexTransaction> indexes(@Nullable ColumnDef<?>[] columns, @Nullable IndexType type) {
            List list;
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                void $this$filterTo$iv$iv;
                boolean bl = false;
                Iterable $this$filter$iv = this.indexTxs;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl2;
                    IndexTransaction tx;
                    block9: {
                        tx = (IndexTransaction)element$iv$iv;
                        boolean bl3 = false;
                        if (columns != null) {
                            ColumnDef<?>[] $this$all$iv = columns;
                            boolean $i$f$all = false;
                            ColumnDef<?>[] columnDefArray = $this$all$iv;
                            int n = columnDefArray.length;
                            for (int i = 0; i < n; ++i) {
                                ColumnDef<?> element$iv;
                                ColumnDef<?> it = element$iv = columnDefArray[i];
                                boolean bl4 = false;
                                if (ArraysKt.contains((Object[])tx.getColumns(), it)) continue;
                                bl2 = false;
                                break block9;
                            }
                            bl2 = true;
                        } else {
                            bl2 = true;
                        }
                    }
                    if (!(bl2 && (type == null || tx.getType() == type))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public IndexTransaction index(@NotNull Name.IndexName name) {
            IndexTransaction indexTransaction2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                Object v0;
                block6: {
                    boolean indexTransaction2 = false;
                    Iterable iterable = this.indexTxs;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object t : iterable2) {
                        IndexTransaction it = (IndexTransaction)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                indexTransaction2 = v0;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            return indexTransaction2;
        }

        /*
         * Exception decompiling
         */
        @Override
        @Nullable
        public Long insert(@NotNull Record record) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-Entity$Tx$update$22 = false;
                this.checkValidForWrite();
                ColumnDef<?>[] columnDefArray = record.getColumns();
                this.checkColumnsExist(Arrays.copyOf(columnDefArray, columnDefArray.length));
                try {
                    void $this$zip$iv;
                    ColumnDef<?>[] columnDefArray2 = record.getColumns();
                    Value[] other$iv = record.getValues();
                    boolean $i$f$zip = false;
                    int n = ((void)$this$zip$iv).length;
                    int n2 = other$iv.length;
                    int n3 = 0;
                    int size$iv = Math.min(n, n2);
                    ArrayList<Unit> list$iv = new ArrayList<Unit>(size$iv);
                    n2 = 0;
                    n3 = size$iv;
                    while (n2 < n3) {
                        void value;
                        void columnDef;
                        void i$iv;
                        Value value2 = other$iv[i$iv];
                        void var15_20 = $this$zip$iv[i$iv];
                        ArrayList<Unit> arrayList = list$iv;
                        boolean bl = false;
                        columnDef.validateOrThrow((Value)value);
                        Object object = MapsKt.getValue(this.colTxs, (Object)columnDef);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTransaction<org.vitrivr.cottontail.model.values.types.Value>");
                        }
                        ((ColumnTransaction)object).update(record.getTupleId(), value);
                        Unit unit = Unit.INSTANCE;
                        arrayList.add(unit);
                        ++i$iv;
                    }
                }
                catch (DatabaseException e) {
                    this.status = TransactionStatus.ERROR;
                    throw (Throwable)e;
                }
                catch (DBException e) {
                    this.status = TransactionStatus.ERROR;
                    throw (Throwable)new DatabaseException("Updating record " + record.getTupleId() + " failed due to an error in the underlying storage: " + e.getMessage() + '.');
                }
                Unit $i$a$-read-Entity$Tx$update$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(long tupleId) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForWrite();
                try {
                    EntityHeader header;
                    Iterable $this$forEach$iv = this.colTxs.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ColumnTransaction it = (ColumnTransaction)element$iv;
                        boolean bl2 = false;
                        it.delete(tupleId);
                    }
                    EntityHeader entityHeader = header = this.this$0.getHeader();
                    entityHeader.setSize(entityHeader.getSize() - 1L);
                    header.setModified(System.currentTimeMillis());
                    this.this$0.store.update(1L, header, EntityHeaderSerializer.INSTANCE);
                }
                catch (DBException e) {
                    this.status = TransactionStatus.ERROR;
                    throw (Throwable)new DatabaseException("Deleting record " + tupleId + " failed due to an error in the underlying storage: " + e.getMessage() + '.');
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        private final void checkColumnsExist(ColumnDef<?> ... columns) {
            ColumnDef<?>[] $this$forEach$iv = columns;
            boolean $i$f$forEach = false;
            ColumnDef<?>[] columnDefArray = $this$forEach$iv;
            int n = columnDefArray.length;
            for (int i = 0; i < n; ++i) {
                ColumnDef<?> element$iv;
                ColumnDef<?> it1 = element$iv = columnDefArray[i];
                boolean bl = false;
                if (this.colTxs.containsKey(it1)) continue;
                throw (Throwable)new TransactionException.ColumnUnknownException(this.getTid(), it1);
            }
        }

        private final void checkValidTupleId(long tupleId) {
            if (tupleId <= 1L) {
                throw (Throwable)((Object)new TransactionException.InvalidTupleId(this.getTid(), tupleId));
            }
        }

        private final void checkValidForRead() {
            if (this.getStatus() == TransactionStatus.CLOSED) {
                throw (Throwable)new TransactionException.TransactionClosedException(this.getTid());
            }
            if (this.getStatus() == TransactionStatus.ERROR) {
                throw (Throwable)new TransactionException.TransactionInErrorException(this.getTid());
            }
        }

        private final void checkValidForWrite() {
            if (this.getReadonly()) {
                throw (Throwable)new TransactionException.TransactionReadOnlyException(this.getTid());
            }
            if (this.getStatus() == TransactionStatus.CLOSED) {
                throw (Throwable)new TransactionException.TransactionClosedException(this.getTid());
            }
            if (this.getStatus() == TransactionStatus.ERROR) {
                throw (Throwable)new TransactionException.TransactionInErrorException(this.getTid());
            }
            if (this.getStatus() != TransactionStatus.DIRTY) {
                this.status = TransactionStatus.DIRTY;
            }
        }

        @Override
        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @NotNull
        public UUID getTid() {
            return this.tid;
        }

        public Tx(Entity this$0, @NotNull boolean readonly, UUID tid, boolean omitIndex) {
            Collection<Pair> collection;
            Object object;
            Index it;
            Collection<Pair> collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            this.this$0 = this$0;
            this.readonly = readonly;
            this.tid = tid;
            this.closeStamp = this$0.closeLock.readLock();
            this.txStamp = this.getReadonly() ? this$0.txLock.readLock() : this$0.txLock.writeLock();
            Iterable iterable = this$0.columns.values();
            Tx tx = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Column column = (Column)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                object = TuplesKt.to(it.getColumnDef(), it.newTransaction(this.getReadonly(), this.getTid()));
                collection2.add((Pair)object);
            }
            collection2 = (List)destination$iv$iv;
            tx.colTxs = MapsKt.toMap((Iterable)collection2);
            Tx tx2 = this;
            if (!omitIndex) {
                $this$map$iv = this$0.indexes;
                tx = tx2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Index)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    object = it.begin(this);
                    collection2.add((Pair)object);
                }
                collection2 = (List)destination$iv$iv;
                tx2 = tx;
                collection = collection2;
            } else {
                collection = CollectionsKt.emptyList();
            }
            tx2.indexTxs = collection;
            this.status = TransactionStatus.CLEAN;
            if (this$0.getClosed()) {
                throw (Throwable)new TransactionException.TransactionDBOClosedException(this.getTid());
            }
            this.localLock = new StampedLock();
        }

        public /* synthetic */ Tx(Entity entity, boolean bl, UUID uUID, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                UUID uUID2 = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"UUID.randomUUID()");
                uUID = uUID2;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(entity, bl, uUID, bl2);
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.localLock;
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }

        public static final /* synthetic */ Map access$getColTxs$p(Tx $this) {
            return $this.colTxs;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/database/entity/Entity$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

