/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 1*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u00011B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010/\u001a\u000200R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b*\u0010\u0015R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00062"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/LSHIndex;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/database/index/Index;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "params", "", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;Ljava/util/Map;)V", "<set-?>", "", "closed", "getClosed", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "db", "Lorg/mapdb/DB;", "getDb", "()Lorg/mapdb/DB;", "map", "Lorg/mapdb/HTreeMap;", "", "", "getMap", "()Lorg/mapdb/HTreeMap;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "produces", "getProduces", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "close", "", "Companion", "cottontaildb"})
public abstract class LSHIndex<T extends VectorValue<?>>
extends Index {
    @NotNull
    private final Path path;
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final DB db;
    @NotNull
    private final HTreeMap<Integer, long[]> map;
    private volatile boolean closed;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final Entity parent;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    public static final String MAP_FIELD_NAME = "lsh_map";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public final ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @NotNull
    protected final DB getDb() {
        return this.db;
    }

    @NotNull
    protected final HTreeMap<Integer, long[]> getMap() {
        return this.map;
    }

    @Override
    public final boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        StampedLock $this$write$iv = this.getGlobalLock();
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-LSHIndex$close$22 = false;
            if (!this.closed) {
                this.db.close();
                this.closed = true;
            }
            Unit $i$a$-write-LSHIndex$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public final Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public final Entity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public LSHIndex(@NotNull Name.IndexName name, @NotNull Entity parent, @NotNull ColumnDef<?>[] columns, @Nullable Map<String, String> params) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.name = name;
        this.parent = parent;
        this.columns = columns;
        Path path = this.parent.getPath().resolve("idx_lsh_" + this.name.getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve\u2026x_lsh_${name.simple}.db\")");
        this.path = path;
        this.produces = new ColumnDef[0];
        this.type = IndexType.LSH;
        this.db = this.parent.getParent().getParent().getConfig().getMapdb().db(this.path);
        GroupSerializer groupSerializer = Serializer.INTEGER;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.INTEGER");
        Serializer serializer2 = (Serializer)groupSerializer;
        GroupSerializer groupSerializer2 = Serializer.LONG_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer2, (String)"Serializer.LONG_ARRAY");
        this.map = this.db.hashMap(MAP_FIELD_NAME, serializer2, (Serializer)groupSerializer2).counterEnable().createOrOpen();
    }

    public /* synthetic */ LSHIndex(Name.IndexName indexName, Entity entity, ColumnDef[] columnDefArray, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map2 = null;
        }
        this(indexName, entity, columnDefArray, map2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/LSHIndex$Companion;", "", "()V", "MAP_FIELD_NAME", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

