/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh.superbit;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBit;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tJ\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSH;", "Ljava/io/Serializable;", "s", "", "b", "d", "seed", "", "species", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "(IIIJLorg/vitrivr/cottontail/model/values/types/VectorValue;)V", "N", "k", "superBit", "Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBit;", "computeSuperBitDepth", "hash", "", "vector", "hashSignature", "signature", "", "Companion", "cottontaildb"})
public final class SuperBitLSH
implements Serializable {
    private final int k;
    private final int N;
    private final SuperBit superBit;
    private int s;
    private int b;
    public static final long LARGE_PRIME = 433494437L;
    public static final Companion Companion = new Companion(null);

    private final int computeSuperBitDepth(int d, int k) {
        int N;
        for (N = d; N >= 1 && k % N != 0; --N) {
        }
        boolean bl = N != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Super-Bit depth must not be 0";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return N;
    }

    @NotNull
    public final int[] hash(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        return this.hashSignature(this.superBit.signature(vector));
    }

    /*
     * WARNING - void declaration
     */
    private final int[] hashSignature(boolean[] signature) {
        long[] acc = new long[this.s];
        int n = 0;
        int n2 = this.s;
        while (n < n2) {
            void i;
            acc[i] = 0L;
            ++i;
        }
        int rows = signature.length / this.s;
        n2 = 0;
        int n3 = signature.length;
        while (n2 < n3) {
            void i;
            long j = 0L;
            if (signature[i]) {
                j = (long)(i + true) * 433494437L;
            }
            int k = RangesKt.coerceAtMost((int)(i / rows), (int)(this.s - 1));
            acc[k] = (acc[k] + j) % (long)Integer.MAX_VALUE;
            ++i;
        }
        int[] vector = new int[this.s];
        n3 = 0;
        int n4 = this.s;
        while (n3 < n4) {
            void i;
            vector[i] = (int)acc[i] % this.b;
            ++i;
        }
        return vector;
    }

    public SuperBitLSH(int s, int b, int d, long seed, @NotNull VectorValue<?> species) {
        Intrinsics.checkNotNullParameter(species, (String)"species");
        this.s = s;
        this.b = b;
        this.k = this.s * this.b / 2;
        this.N = this.computeSuperBitDepth(d, this.k);
        this.superBit = new SuperBit(d, this.N, this.k / this.N, seed, species);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSH$Companion;", "", "()V", "LARGE_PRIME", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

