/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh.superbit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.lsh.LSHIndex;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSH;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSHIndex;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSHIndexConfig;
import org.vitrivr.cottontail.database.queries.components.KnnPredicate;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.math.knn.metrics.AbsoluteInnerProductDistance;
import org.vitrivr.cottontail.math.knn.metrics.CosineDistance;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002$%B?\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0006\u001a\u00060\u001eR\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0016R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006&"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/database/index/lsh/LSHIndex;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "params", "", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;Ljava/util/Map;)V", "config", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndexConfig;", "getConfig", "()Lorg/mapdb/Atomic$Var;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "begin", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "Companion", "Tx", "cottontaildb"})
public final class SuperBitLSHIndex<T extends VectorValue<?>>
extends LSHIndex<T> {
    @NotNull
    private final Atomic.Var<SuperBitLSHIndexConfig> config;
    private final boolean supportsIncrementalUpdate;
    @NotNull
    private final IndexType type;
    @NotNull
    public static final String CONFIG_NAME = "lsh_config";
    @NotNull
    public static final String CONFIG_NAME_STAGES = "stages";
    @NotNull
    public static final String CONFIG_NAME_BUCKETS = "buckets";
    @NotNull
    public static final String CONFIG_NAME_SEED = "seed";
    private static final int CONFIG_DEFAULT_STAGES = 3;
    private static final int CONFIG_DEFAULT_BUCKETS = 10;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    public final Atomic.Var<SuperBitLSHIndexConfig> getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate ? Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) && (((KnnPredicate)predicate).getDistance() instanceof CosineDistance || ((KnnPredicate)predicate).getDistance() instanceof AbsoluteInnerProductDistance) : false;
    }

    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return this.canProcess(predicate) ? Cost.Companion.getZERO() : Cost.Companion.getINVALID();
    }

    @Override
    @NotNull
    public IndexTransaction begin(@NotNull Entity.Tx parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new Tx(parent);
    }

    public SuperBitLSHIndex(@NotNull Name.IndexName name, @NotNull Entity parent, @NotNull ColumnDef<?>[] columns, @Nullable Map<String, String> params) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            super(name, parent, columns, null, 8, null);
            this.config = (Atomic.Var)this.getDb().atomicVar(CONFIG_NAME, (Serializer)SuperBitLSHIndexConfig.Serializer).createOrOpen();
            this.supportsIncrementalUpdate = true;
            this.type = IndexType.SUPERBIT_LSH;
            ColumnDef<?>[] $this$all$iv = columns;
            boolean $i$f$all = false;
            ColumnDef<?>[] columnDefArray = $this$all$iv;
            int n = columnDefArray.length;
            for (int i = 0; i < n; ++i) {
                ColumnDef<?> element$iv;
                ColumnDef<?> it = element$iv = columnDefArray[i];
                boolean bl2 = false;
                if (it.getType().getVector()) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            throw (Throwable)new DatabaseException.IndexNotSupportedException(name, "Because only vector columns are supported for SuperBitLSHIndex.");
        }
        if (params != null) {
            Object object = params.get(CONFIG_NAME_BUCKETS);
            int buckets = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 10;
            Object object2 = params.get(CONFIG_NAME_STAGES);
            int stages = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 3;
            Object object3 = params.get(CONFIG_NAME_SEED);
            long seed = object3 != null && (object3 = StringsKt.toLongOrNull((String)object3)) != null ? (Long)object3 : System.currentTimeMillis();
            this.config.set((Object)new SuperBitLSHIndexConfig(buckets, stages, seed));
        }
    }

    public /* synthetic */ SuperBitLSHIndex(Name.IndexName indexName, Entity entity, ColumnDef[] columnDefArray, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map2 = null;
        }
        this(indexName, entity, columnDefArray, map2);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(SuperBitLSHIndex.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\n\u0010\t\u001a\u00060\u0004R\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0014J\b\u0010\u0012\u001a\u00020\u000bH\u0014J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/Index$Tx;", "Lorg/vitrivr/cottontail/database/index/Index;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex;Lorg/vitrivr/cottontail/database/entity/Entity$Tx;)V", "acquireSpecimen", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "tx", "cleanup", "", "filter", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "performCommit", "performRollback", "rebuild", "update", "", "", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends Index.Tx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                Object object;
                VectorValue<?> vectorValue;
                boolean bl = false;
                this.checkValidForWrite();
                LOGGER.trace("Rebuilding SB-LSH index {}", (Object)SuperBitLSHIndex.this.getName());
                if (this.acquireSpecimen(this.getParent()) == null) {
                    return;
                }
                VectorValue<?> specimen = vectorValue;
                SuperBitLSH lsh = new SuperBitLSH(((SuperBitLSHIndexConfig)SuperBitLSHIndex.this.getConfig().get()).getStages(), ((SuperBitLSHIndexConfig)SuperBitLSHIndex.this.getConfig().get()).getBuckets(), this.getColumns()[0].getLogicalSize(), ((SuperBitLSHIndexConfig)SuperBitLSHIndex.this.getConfig().get()).getSeed(), specimen);
                int n = ((SuperBitLSHIndexConfig)SuperBitLSHIndex.this.getConfig().get()).getBuckets();
                List[] listArray = new List[n];
                int n2 = 0;
                while (n2 < n) {
                    List list;
                    int n3 = n2;
                    int n4 = n2++;
                    List[] listArray2 = listArray;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    listArray2[n4] = list = (List)new ArrayList();
                }
                List[] local = listArray;
                AutoCloseable autoCloseable = this.getParent().scan(SuperBitLSHIndex.this.getColumns());
                boolean bl4 = false;
                n2 = 0;
                Throwable throwable = null;
                try {
                    CloseableIterator s = (CloseableIterator)autoCloseable;
                    boolean bl5 = false;
                    Iterator $this$forEach$iv = s;
                    boolean $i$f$forEach = false;
                    object = $this$forEach$iv;
                    boolean bl6 = false;
                    Iterator iterator2 = object;
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        Record record = (Record)element$iv;
                        boolean bl7 = false;
                        Object value = record.get(this.getColumns()[0]);
                        if (!(value instanceof VectorValue)) continue;
                        int bucket = ArraysKt.last((int[])lsh.hash((VectorValue)value));
                        local[bucket].add(record.getTupleId());
                    }
                    List[] listArray3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                SuperBitLSHIndex.this.getMap().clear();
                List[] $this$forEachIndexed$iv = local;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (List item$iv : $this$forEachIndexed$iv) {
                    void list;
                    int n5 = index$iv++;
                    object = item$iv;
                    int bucket = n5;
                    boolean bl8 = false;
                    ((Map)SuperBitLSHIndex.this.getMap()).put(bucket, CollectionsKt.toLongArray((Collection)((Collection)list)));
                }
                Unit $i$a$-read-SuperBitLSHIndex$Tx$rebuild$2 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Void update(@NotNull Collection<DataChangeEvent> update) {
            Intrinsics.checkNotNullParameter(update, (String)"update");
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            catch (Throwable throwable) {
                $this$read$iv.unlock(stamp$iv);
                throw throwable;
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new CloseableIterator<Record>(this, predicate){
                @NotNull
                private final KnnPredicate<?> predicate;
                private final long stamp;
                private volatile boolean closed;
                private final SuperBitLSH lsh;
                private final List<Long> tupleIds;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                @NotNull
                public final KnnPredicate<?> getPredicate() {
                    return this.predicate;
                }

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of hasNext(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Collection collection = this.tupleIds;
                    bl2 = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return new StandaloneRecord(((Number)CollectionsKt.removeFirst(this.tupleIds)).longValue(), this.this$0.SuperBitLSHIndex.this.getColumns(), new Value[0]);
                }

                public void close() {
                    if (!this.closed) {
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.stamp);
                        this.closed = true;
                    }
                }
                {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof KnnPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.SuperBitLSHIndex.this.getName() + "' (LSH Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)$captured_local_variable$1;
                    Tx.access$checkValidForRead(this$0);
                    if (Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)this.predicate.getColumns())), this$0.SuperBitLSHIndex.this.getColumns()[0]) ^ true || !(this.predicate.getDistance() instanceof CosineDistance) && !(this.predicate.getDistance() instanceof AbsoluteInnerProductDistance)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.SuperBitLSHIndex.this.getName() + "' (lsh-index) does not support the provided predicate.");
                    }
                    this.stamp = Tx.access$getLocalLock$p(this$0).readLock();
                    this.lsh = new SuperBitLSH(((SuperBitLSHIndexConfig)this$0.SuperBitLSHIndex.this.getConfig().get()).getStages(), ((SuperBitLSHIndexConfig)this$0.SuperBitLSHIndex.this.getConfig().get()).getBuckets(), ((ColumnDef)ArraysKt.first((Object[])this$0.SuperBitLSHIndex.this.getColumns())).getLogicalSize(), ((SuperBitLSHIndexConfig)this$0.SuperBitLSHIndex.this.getConfig().get()).getSeed(), (VectorValue)CollectionsKt.first(this.predicate.getQuery()));
                    Iterable iterable = this.predicate.getQuery();
                    filter.1 var21_4 = this;
                    boolean $i$f$mapNotNull = false;
                    void var5_6 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        long[] lArray;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        VectorValue it = (VectorValue)element$iv$iv;
                        boolean bl2 = false;
                        if ((long[])SuperBitLSHIndex.access$getMap$p(this.this$0.SuperBitLSHIndex.this).get((Object)ArraysKt.last((int[])this.lsh.hash(it))) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        long[] it$iv$iv = lArray;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    $this$mapNotNull$iv = list;
                    boolean $i$f$flatMap = false;
                    $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        long[] it = (long[])element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = ArraysKt.asIterable((long[])it);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                    var21_4.tupleIds = CollectionsKt.toMutableList((Collection)list);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        protected void performCommit() {
            SuperBitLSHIndex.this.getDb().commit();
        }

        @Override
        protected void performRollback() {
            SuperBitLSHIndex.this.getDb().rollback();
        }

        @Override
        protected void cleanup() {
        }

        /*
         * WARNING - void declaration
         */
        private final VectorValue<?> acquireSpecimen(Entity.Tx tx) {
            long l = 2L;
            long l2 = tx.count();
            while (l < l2) {
                void index;
                Object read2 = tx.read((long)index, SuperBitLSHIndex.this.getColumns()).get(this.getColumns()[0]);
                if (read2 instanceof VectorValue) {
                    return (VectorValue)read2;
                }
                l = index + 1L;
            }
            return null;
        }

        public Tx(Entity.Tx parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(SuperBitLSHIndex.this, parent);
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.getLocalLock();
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBitLSHIndex$Companion;", "", "()V", "CONFIG_DEFAULT_BUCKETS", "", "CONFIG_DEFAULT_STAGES", "CONFIG_NAME", "", "CONFIG_NAME_BUCKETS", "CONFIG_NAME_SEED", "CONFIG_NAME_STAGES", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

