/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.va;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.index.va.ScalarQuantizer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\b\u0010\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B \b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/database/index/va/VectorQuantizer;", "", "scalarQuantizers", "", "Lorg/vitrivr/cottontail/database/index/va/ScalarQuantizer;", "(Ljava/util/List;)V", "vectors", "", "bits", "Lkotlin/UByte;", "(Ljava/util/List;BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "", "quantize", "Ljava/util/BitSet;", "vector", "cottontaildb"})
public final class VectorQuantizer {
    private final List<ScalarQuantizer> scalarQuantizers;
    private final int bits;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BitSet quantize(@NotNull float[] vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        if (vector.length != this.scalarQuantizers.size()) {
            throw (Throwable)new IndexOutOfBoundsException("vector length " + vector.length + " does not match index size " + this.scalarQuantizers.size());
        }
        BitSet bitset = new BitSet(this.bits);
        int offset = 0;
        Iterable $this$forEachIndexed$iv = this.scalarQuantizers;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void scalarQuantizer;
            boolean[] q;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ScalarQuantizer scalarQuantizer2 = (ScalarQuantizer)item$iv;
            int index = n;
            boolean bl2 = false;
            boolean[] $this$forEach$iv = q = scalarQuantizer.quantize(vector[index]);
            boolean $i$f$forEach = false;
            boolean[] blArray = $this$forEach$iv;
            int n2 = blArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                boolean element$iv;
                boolean it = element$iv = blArray[i];
                boolean bl3 = false;
                if (it) {
                    n3 = offset;
                    offset = n3 + 1;
                    bitset.set(n3);
                    continue;
                }
                n3 = offset;
                offset = n3 + 1;
                bitset.clear(n3);
            }
        }
        return bitset;
    }

    /*
     * WARNING - void declaration
     */
    public VectorQuantizer(@NotNull List<ScalarQuantizer> scalarQuantizers) {
        int n;
        void $this$sumBy$iv;
        Intrinsics.checkNotNullParameter(scalarQuantizers, (String)"scalarQuantizers");
        this.scalarQuantizers = scalarQuantizers;
        Iterable iterable = scalarQuantizers;
        VectorQuantizer vectorQuantizer = this;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            ScalarQuantizer scalarQuantizer = (ScalarQuantizer)element$iv;
            n = sum$iv;
            boolean bl = false;
            byte by = it.getBits-w2LRezQ();
            boolean bl2 = false;
            int n2 = by & 0xFF;
            sum$iv = n + n2;
        }
        vectorQuantizer.bits = n = sum$iv;
    }

    /*
     * WARNING - void declaration
     */
    private VectorQuantizer(List<float[]> vectors, byte bits) {
        Collection<ScalarQuantizer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int length = ((float[])CollectionsKt.first(vectors)).length;
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)length);
        VectorQuantizer vectorQuantizer = this;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            List values = new ArrayList();
            Iterable $this$forEach$iv = vectors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void idx;
                float[] it = (float[])element$iv;
                boolean bl3 = false;
                values.add(Float.valueOf(it[idx]));
            }
            ScalarQuantizer scalarQuantizer = new ScalarQuantizer(CollectionsKt.toFloatArray((Collection)values), bits, null);
            collection.add(scalarQuantizer);
        }
        collection = (List)destination$iv$iv;
        vectorQuantizer.scalarQuantizers = collection;
        byte by = bits;
        boolean bl = false;
        this.bits = (by & 0xFF) * length;
    }

    public /* synthetic */ VectorQuantizer(List vectors, byte bits, DefaultConstructorMarker $constructor_marker) {
        this(vectors, bits);
    }
}

