/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.queries.components.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.PatternValue;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B3\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c2\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u00c6\u0003JC\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u00c6\u0001J\u0013\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0016J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001e\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/database/queries/components/AtomicBooleanPredicate;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lorg/vitrivr/cottontail/database/queries/components/BooleanPredicate;", "column", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "operator", "Lorg/vitrivr/cottontail/database/queries/components/ComparisonOperator;", "not", "", "values", "", "(Lorg/vitrivr/cottontail/model/basics/ColumnDef;Lorg/vitrivr/cottontail/database/queries/components/ComparisonOperator;ZLjava/util/Collection;)V", "atomics", "", "getAtomics", "()Ljava/util/Set;", "columns", "getColumns", "cost", "", "getCost", "()F", "getNot", "()Z", "getOperator", "()Lorg/vitrivr/cottontail/database/queries/components/ComparisonOperator;", "getValues", "()Ljava/util/Collection;", "setValues", "(Ljava/util/Collection;)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "matches", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "toString", "", "cottontaildb"})
public final class AtomicBooleanPredicate<T extends Value>
extends BooleanPredicate {
    private final float cost;
    @NotNull
    private final Set<ColumnDef<T>> columns;
    private final ColumnDef<T> column;
    @NotNull
    private final ComparisonOperator operator;
    private final boolean not;
    @NotNull
    private Collection<? extends Value> values;

    @Override
    public float getCost() {
        return this.cost;
    }

    @NotNull
    public Set<ColumnDef<T>> getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Set<AtomicBooleanPredicate<?>> getAtomics() {
        return SetsKt.setOf((Object)this);
    }

    @Override
    public boolean matches(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        boolean bl = record.has(this.column);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "AtomicBooleanPredicate cannot be applied to record because it does not contain the expected column " + this.column + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.not ? !this.operator.match((Value)record.get(this.column), this.values) : this.operator.match((Value)record.get(this.column), this.values);
    }

    @NotNull
    public final ComparisonOperator getOperator() {
        return this.operator;
    }

    public final boolean getNot() {
        return this.not;
    }

    @NotNull
    public final Collection<Value> getValues() {
        return this.values;
    }

    public final void setValues(@NotNull Collection<? extends Value> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.values = collection;
    }

    /*
     * WARNING - void declaration
     */
    public AtomicBooleanPredicate(@NotNull ColumnDef<T> column, @NotNull ComparisonOperator operator, boolean not, @NotNull Collection<? extends Value> values) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        super(null);
        this.column = column;
        this.operator = operator;
        this.not = not;
        this.values = values;
        if (this.operator == ComparisonOperator.IN) {
            this.values = CollectionsKt.toSet((Iterable)this.values);
        }
        if (this.operator == ComparisonOperator.LIKE) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = this.values;
            AtomicBooleanPredicate atomicBooleanPredicate = this;
            boolean $i$f$mapNotNull = false;
            void var7_8 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                PatternValue patternValue;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Value it = (Value)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof StringValue ? new PatternValue(((StringValue)it).unbox-impl()) : null) == null) continue;
                patternValue = patternValue;
                boolean bl3 = false;
                boolean bl4 = false;
                PatternValue it$iv$iv = patternValue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            atomicBooleanPredicate.values = list;
        }
        this.cost = (float)3 * Cost.Companion.getCOST_MEMORY_ACCESS();
        this.columns = SetsKt.setOf(this.column);
    }

    public /* synthetic */ AtomicBooleanPredicate(ColumnDef columnDef, ComparisonOperator comparisonOperator, boolean bl, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(columnDef, comparisonOperator, bl, collection);
    }

    private final ColumnDef<T> component1() {
        return this.column;
    }

    @NotNull
    public final ComparisonOperator component2() {
        return this.operator;
    }

    public final boolean component3() {
        return this.not;
    }

    @NotNull
    public final Collection<Value> component4() {
        return this.values;
    }

    @NotNull
    public final AtomicBooleanPredicate<T> copy(@NotNull ColumnDef<T> column, @NotNull ComparisonOperator operator, boolean not, @NotNull Collection<? extends Value> values) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)operator), (String)"operator");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return new AtomicBooleanPredicate<T>(column, operator, not, values);
    }

    public static /* synthetic */ AtomicBooleanPredicate copy$default(AtomicBooleanPredicate atomicBooleanPredicate, ColumnDef columnDef, ComparisonOperator comparisonOperator, boolean bl, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            columnDef = atomicBooleanPredicate.column;
        }
        if ((n & 2) != 0) {
            comparisonOperator = atomicBooleanPredicate.operator;
        }
        if ((n & 4) != 0) {
            bl = atomicBooleanPredicate.not;
        }
        if ((n & 8) != 0) {
            collection = atomicBooleanPredicate.values;
        }
        return atomicBooleanPredicate.copy(columnDef, comparisonOperator, bl, collection);
    }

    @NotNull
    public String toString() {
        return "AtomicBooleanPredicate(column=" + this.column + ", operator=" + (Object)((Object)this.operator) + ", not=" + this.not + ", values=" + this.values + ")";
    }

    public int hashCode() {
        ColumnDef<T> columnDef = this.column;
        ComparisonOperator comparisonOperator = this.operator;
        int n = ((columnDef != null ? ((Object)columnDef).hashCode() : 0) * 31 + (comparisonOperator != null ? ((Object)((Object)comparisonOperator)).hashCode() : 0)) * 31;
        int n2 = this.not ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        Collection<? extends Value> collection = this.values;
        return (n + n2) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AtomicBooleanPredicate)) break block3;
                AtomicBooleanPredicate atomicBooleanPredicate = (AtomicBooleanPredicate)object;
                if (!Intrinsics.areEqual(this.column, atomicBooleanPredicate.column) || !Intrinsics.areEqual((Object)((Object)this.operator), (Object)((Object)atomicBooleanPredicate.operator)) || this.not != atomicBooleanPredicate.not || !Intrinsics.areEqual(this.values, atomicBooleanPredicate.values)) break block3;
            }
            return true;
        }
        return false;
    }
}

