/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator$WhenMappings;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.PatternValue;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/database/queries/components/ComparisonOperator;", "", "(Ljava/lang/String;I)V", "match", "", "left", "Lorg/vitrivr/cottontail/model/values/types/Value;", "right", "", "EQUAL", "GREATER", "LESS", "GEQUAL", "LEQUAL", "LIKE", "IN", "BETWEEN", "ISNULL", "ISNOTNULL", "cottontaildb"})
public final class ComparisonOperator
extends Enum<ComparisonOperator> {
    public static final /* enum */ ComparisonOperator EQUAL;
    public static final /* enum */ ComparisonOperator GREATER;
    public static final /* enum */ ComparisonOperator LESS;
    public static final /* enum */ ComparisonOperator GEQUAL;
    public static final /* enum */ ComparisonOperator LEQUAL;
    public static final /* enum */ ComparisonOperator LIKE;
    public static final /* enum */ ComparisonOperator IN;
    public static final /* enum */ ComparisonOperator BETWEEN;
    public static final /* enum */ ComparisonOperator ISNULL;
    public static final /* enum */ ComparisonOperator ISNOTNULL;
    private static final /* synthetic */ ComparisonOperator[] $VALUES;

    static {
        ComparisonOperator[] comparisonOperatorArray = new ComparisonOperator[10];
        ComparisonOperator[] comparisonOperatorArray2 = comparisonOperatorArray;
        comparisonOperatorArray[0] = EQUAL = new ComparisonOperator();
        comparisonOperatorArray[1] = GREATER = new ComparisonOperator();
        comparisonOperatorArray[2] = LESS = new ComparisonOperator();
        comparisonOperatorArray[3] = GEQUAL = new ComparisonOperator();
        comparisonOperatorArray[4] = LEQUAL = new ComparisonOperator();
        comparisonOperatorArray[5] = LIKE = new ComparisonOperator();
        comparisonOperatorArray[6] = IN = new ComparisonOperator();
        comparisonOperatorArray[7] = BETWEEN = new ComparisonOperator();
        comparisonOperatorArray[8] = ISNULL = new ComparisonOperator();
        comparisonOperatorArray[9] = ISNOTNULL = new ComparisonOperator();
        $VALUES = comparisonOperatorArray;
    }

    public final boolean match(@Nullable Value left, @NotNull Collection<? extends Value> right) {
        boolean bl;
        Intrinsics.checkNotNullParameter(right, (String)"right");
        if (left == null) {
            boolean bl2;
            switch (ComparisonOperator$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1: {
                    bl2 = true;
                    break;
                }
                case 2: {
                    bl2 = false;
                    break;
                }
                default: {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Left operand cannot be null!");
                }
            }
            return bl2;
        }
        switch (ComparisonOperator$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                Value value = (Value)CollectionsKt.firstOrNull((Iterable)right);
                if (value == null) {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                }
                bl = left.isEqual(value);
                break;
            }
            case 2: {
                Value value = (Value)CollectionsKt.firstOrNull((Iterable)right);
                if (value == null) {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                }
                if (left.compareTo(value) > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                Value value = (Value)CollectionsKt.firstOrNull((Iterable)right);
                if (value == null) {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                }
                if (left.compareTo(value) < 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                Value value = (Value)CollectionsKt.firstOrNull((Iterable)right);
                if (value == null) {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                }
                if (left.compareTo(value) >= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                Value value = (Value)CollectionsKt.firstOrNull((Iterable)right);
                if (value == null) {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                }
                if (left.compareTo(value) <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                bl = right.contains(left);
                break;
            }
            case 7: {
                Value value = (Value)CollectionsKt.firstOrNull((Iterable)right);
                if (value == null) {
                    throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                }
                if (left.compareTo(value) >= 0) {
                    Value value2 = (Value)CollectionsKt.lastOrNull((Iterable)right);
                    if (value2 == null) {
                        throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + ": Right operand cannot be null!");
                    }
                    if (left.compareTo(value2) <= 0) {
                        bl = true;
                        break;
                    }
                }
                bl = false;
                break;
            }
            case 8: {
                Value check = (Value)CollectionsKt.first((Iterable)right);
                if (left instanceof PatternValue && check instanceof StringValue) {
                    bl = ((PatternValue)left).matches-HjvdB-0(((StringValue)check).unbox-impl());
                    break;
                }
                throw (Throwable)new QueryException("Incompatible operands for operator " + (Object)((Object)this) + " (left = " + Reflection.getOrCreateKotlinClass(left.getClass()).getSimpleName() + ", left = " + Reflection.getOrCreateKotlinClass(check.getClass()).getSimpleName() + ")!");
            }
            case 9: {
                bl = false;
                break;
            }
            case 10: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static ComparisonOperator[] values() {
        return (ComparisonOperator[])$VALUES.clone();
    }

    public static ComparisonOperator valueOf(String string) {
        return Enum.valueOf(ComparisonOperator.class, string);
    }
}

