/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.predicates;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.predicates.PredicateHint;
import org.vitrivr.cottontail.model.basics.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0007\b\t\n\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0005\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/PredicateHint;", "()V", "satisfies", "", "index", "Lorg/vitrivr/cottontail/database/index/Index;", "AllowInexactKnnPredicateHint", "IndexNameKnnPredicateHint", "IndexTypeKnnPredicateHint", "NoIndexKnnPredicateHint", "ParallelKnnPredicateHint", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$NoIndexKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$AllowInexactKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$IndexTypeKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$IndexNameKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$ParallelKnnPredicateHint;", "cottontaildb"})
public abstract class KnnPredicateHint
extends PredicateHint {
    public abstract boolean satisfies(@NotNull Index var1);

    private KnnPredicateHint() {
        super(null);
    }

    public /* synthetic */ KnnPredicateHint(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$NoIndexKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "()V", "satisfies", "", "index", "Lorg/vitrivr/cottontail/database/index/Index;", "cottontaildb"})
    public static final class NoIndexKnnPredicateHint
    extends KnnPredicateHint {
        public static final NoIndexKnnPredicateHint INSTANCE;

        @Override
        public boolean satisfies(@NotNull Index index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            return false;
        }

        private NoIndexKnnPredicateHint() {
            super(null);
        }

        static {
            NoIndexKnnPredicateHint noIndexKnnPredicateHint;
            INSTANCE = noIndexKnnPredicateHint = new NoIndexKnnPredicateHint();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$AllowInexactKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "allow", "", "(Z)V", "getAllow", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "satisfies", "index", "Lorg/vitrivr/cottontail/database/index/Index;", "toString", "", "cottontaildb"})
    public static final class AllowInexactKnnPredicateHint
    extends KnnPredicateHint {
        private final boolean allow;

        @Override
        public boolean satisfies(@NotNull Index index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            return this.allow || !index.getType().getInexact();
        }

        public final boolean getAllow() {
            return this.allow;
        }

        public AllowInexactKnnPredicateHint(boolean allow) {
            super(null);
            this.allow = allow;
        }

        public /* synthetic */ AllowInexactKnnPredicateHint(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public AllowInexactKnnPredicateHint() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.allow;
        }

        @NotNull
        public final AllowInexactKnnPredicateHint copy(boolean allow) {
            return new AllowInexactKnnPredicateHint(allow);
        }

        public static /* synthetic */ AllowInexactKnnPredicateHint copy$default(AllowInexactKnnPredicateHint allowInexactKnnPredicateHint, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = allowInexactKnnPredicateHint.allow;
            }
            return allowInexactKnnPredicateHint.copy(bl);
        }

        @NotNull
        public String toString() {
            return "AllowInexactKnnPredicateHint(allow=" + this.allow + ")";
        }

        public int hashCode() {
            int n = this.allow ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AllowInexactKnnPredicateHint)) break block3;
                    AllowInexactKnnPredicateHint allowInexactKnnPredicateHint = (AllowInexactKnnPredicateHint)object;
                    if (this.allow != allowInexactKnnPredicateHint.allow) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$IndexTypeKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "(Lorg/vitrivr/cottontail/database/index/IndexType;)V", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "satisfies", "index", "Lorg/vitrivr/cottontail/database/index/Index;", "toString", "", "cottontaildb"})
    public static final class IndexTypeKnnPredicateHint
    extends KnnPredicateHint {
        @NotNull
        private final IndexType type;

        @Override
        public boolean satisfies(@NotNull Index index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            return index.getType() == this.type;
        }

        @NotNull
        public final IndexType getType() {
            return this.type;
        }

        public IndexTypeKnnPredicateHint(@NotNull IndexType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(null);
            this.type = type;
        }

        @NotNull
        public final IndexType component1() {
            return this.type;
        }

        @NotNull
        public final IndexTypeKnnPredicateHint copy(@NotNull IndexType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new IndexTypeKnnPredicateHint(type);
        }

        public static /* synthetic */ IndexTypeKnnPredicateHint copy$default(IndexTypeKnnPredicateHint indexTypeKnnPredicateHint, IndexType indexType, int n, Object object) {
            if ((n & 1) != 0) {
                indexType = indexTypeKnnPredicateHint.type;
            }
            return indexTypeKnnPredicateHint.copy(indexType);
        }

        @NotNull
        public String toString() {
            return "IndexTypeKnnPredicateHint(type=" + (Object)((Object)this.type) + ")";
        }

        public int hashCode() {
            IndexType indexType = this.type;
            return indexType != null ? ((Object)((Object)indexType)).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexTypeKnnPredicateHint)) break block3;
                    IndexTypeKnnPredicateHint indexTypeKnnPredicateHint = (IndexTypeKnnPredicateHint)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)indexTypeKnnPredicateHint.type))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$IndexNameKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parameters", "", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Ljava/util/Map;)V", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getParameters", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "satisfies", "index", "Lorg/vitrivr/cottontail/database/index/Index;", "toString", "cottontaildb"})
    public static final class IndexNameKnnPredicateHint
    extends KnnPredicateHint {
        @NotNull
        private final Name.IndexName name;
        @Nullable
        private final Map<String, String> parameters;

        @Override
        public boolean satisfies(@NotNull Index index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            return Intrinsics.areEqual((Object)index.getName(), (Object)this.name);
        }

        @NotNull
        public final Name.IndexName getName() {
            return this.name;
        }

        @Nullable
        public final Map<String, String> getParameters() {
            return this.parameters;
        }

        public IndexNameKnnPredicateHint(@NotNull Name.IndexName name, @Nullable Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(null);
            this.name = name;
            this.parameters = parameters;
        }

        public /* synthetic */ IndexNameKnnPredicateHint(Name.IndexName indexName, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                map2 = null;
            }
            this(indexName, map2);
        }

        @NotNull
        public final Name.IndexName component1() {
            return this.name;
        }

        @Nullable
        public final Map<String, String> component2() {
            return this.parameters;
        }

        @NotNull
        public final IndexNameKnnPredicateHint copy(@NotNull Name.IndexName name, @Nullable Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new IndexNameKnnPredicateHint(name, parameters);
        }

        public static /* synthetic */ IndexNameKnnPredicateHint copy$default(IndexNameKnnPredicateHint indexNameKnnPredicateHint, Name.IndexName indexName, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                indexName = indexNameKnnPredicateHint.name;
            }
            if ((n & 2) != 0) {
                map2 = indexNameKnnPredicateHint.parameters;
            }
            return indexNameKnnPredicateHint.copy(indexName, map2);
        }

        @NotNull
        public String toString() {
            return "IndexNameKnnPredicateHint(name=" + this.name + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            Name.IndexName indexName = this.name;
            Map<String, String> map2 = this.parameters;
            return (indexName != null ? ((Object)indexName).hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexNameKnnPredicateHint)) break block3;
                    IndexNameKnnPredicateHint indexNameKnnPredicateHint = (IndexNameKnnPredicateHint)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)indexNameKnnPredicateHint.name) || !Intrinsics.areEqual(this.parameters, indexNameKnnPredicateHint.parameters)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint$ParallelKnnPredicateHint;", "Lorg/vitrivr/cottontail/database/queries/predicates/KnnPredicateHint;", "min", "", "max", "(II)V", "getMax", "()I", "getMin", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "satisfies", "index", "Lorg/vitrivr/cottontail/database/index/Index;", "toString", "", "cottontaildb"})
    public static final class ParallelKnnPredicateHint
    extends KnnPredicateHint {
        private final int min;
        private final int max;

        @Override
        public boolean satisfies(@NotNull Index index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            return true;
        }

        public final int getMin() {
            return this.min;
        }

        public final int getMax() {
            return this.max;
        }

        public ParallelKnnPredicateHint(int min, int max) {
            super(null);
            this.min = min;
            this.max = max;
            boolean bl = this.min > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Desired parallelism of zero is not allowed. Minimum must be one (min = " + this.min + ", max = " + this.max + ").";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = this.max >= this.min;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Upper bound for desired parallelism must be greater or equal than lower bound (min = " + this.min + ", max = " + this.max + ").";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public final int component1() {
            return this.min;
        }

        public final int component2() {
            return this.max;
        }

        @NotNull
        public final ParallelKnnPredicateHint copy(int min, int max) {
            return new ParallelKnnPredicateHint(min, max);
        }

        public static /* synthetic */ ParallelKnnPredicateHint copy$default(ParallelKnnPredicateHint parallelKnnPredicateHint, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = parallelKnnPredicateHint.min;
            }
            if ((n3 & 2) != 0) {
                n2 = parallelKnnPredicateHint.max;
            }
            return parallelKnnPredicateHint.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ParallelKnnPredicateHint(min=" + this.min + ", max=" + this.max + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.min) * 31 + Integer.hashCode(this.max);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ParallelKnnPredicateHint)) break block3;
                    ParallelKnnPredicateHint parallelKnnPredicateHint = (ParallelKnnPredicateHint)object;
                    if (this.min != parallelKnnPredicateHint.min || this.max != parallelKnnPredicateHint.max) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

