/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.config.ExecutionConfig;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.execution.ExecutionStatus;
import org.vitrivr.cottontail.execution.exceptions.ExecutionException;
import org.vitrivr.cottontail.execution.exceptions.OperatorExecutionException;
import org.vitrivr.cottontail.execution.operators.basics.SinkOperator;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "", "config", "Lorg/vitrivr/cottontail/config/ExecutionConfig;", "(Lorg/vitrivr/cottontail/config/ExecutionConfig;)V", "contexts", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lorg/vitrivr/cottontail/execution/ExecutionEngine$ExecutionContext;", "getContexts", "()Ljava/util/concurrent/ConcurrentHashMap;", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "Companion", "ExecutionContext", "cottontaildb"})
public final class ExecutionEngine {
    private final ThreadPoolExecutor executor;
    private final ExecutorCoroutineDispatcher dispatcher;
    @NotNull
    private final ConcurrentHashMap<UUID, ExecutionContext> contexts;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    public final ConcurrentHashMap<UUID, ExecutionContext> getContexts() {
        return this.contexts;
    }

    public ExecutionEngine(@NotNull ExecutionConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.executor = new ThreadPoolExecutor(config.getCoreThreads(), config.getMaxThreads(), config.getKeepAliveMs(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue(config.getQueueSize()));
        this.dispatcher = ExecutorsKt.from((ExecutorService)this.executor);
        this.contexts = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(ExecutionEngine.class);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\u001eJ\u0012\u0010!\u001a\u00060\u0018R\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017J\u0016\u0010#\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0018R\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006&"}, d2={"Lorg/vitrivr/cottontail/execution/ExecutionEngine$ExecutionContext;", "", "(Lorg/vitrivr/cottontail/execution/ExecutionEngine;)V", "availableThreads", "", "getAvailableThreads", "()I", "coroutineDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "getCoroutineDispatcher", "()Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "maxThreads", "getMaxThreads", "operators", "", "Lorg/vitrivr/cottontail/execution/operators/basics/SinkOperator;", "<set-?>", "Lorg/vitrivr/cottontail/execution/ExecutionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/execution/ExecutionStatus;", "transactions", "", "Lorg/vitrivr/cottontail/database/entity/Entity;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "addOperator", "", "operator", "execute", "getTx", "entity", "prepareTransaction", "readonly", "", "cottontaildb"})
    public final class ExecutionContext {
        @NotNull
        private final UUID uuid;
        @NotNull
        private volatile ExecutionStatus state;
        private final List<SinkOperator> operators;
        private final Map<Entity, Entity.Tx> transactions;

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @NotNull
        public final ExecutionStatus getState() {
            return this.state;
        }

        public final int getMaxThreads() {
            return ExecutionEngine.this.executor.getMaximumPoolSize();
        }

        public final int getAvailableThreads() {
            return ExecutionEngine.this.executor.getMaximumPoolSize() - ExecutionEngine.this.executor.getActiveCount();
        }

        @NotNull
        public final ExecutorCoroutineDispatcher getCoroutineDispatcher() {
            return ExecutionEngine.this.dispatcher;
        }

        public final void addOperator(@NotNull SinkOperator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            if (this.operators.contains(operator)) {
                throw (Throwable)new IllegalArgumentException("Operator " + operator + " cannot be added to list of operators because that operator is already part of that list.");
            }
            List<SinkOperator> list = this.operators;
            if (list == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<org.vitrivr.cottontail.execution.operators.basics.SinkOperator>");
            }
            TypeIntrinsics.asMutableList(list).add(operator);
        }

        public final void prepareTransaction(@NotNull Entity entity, boolean readonly) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (!this.transactions.containsKey(entity)) {
                this.transactions.put(entity, new Entity.Tx(entity, readonly, this.uuid, false, 4, null));
            } else if (!readonly) {
                Entity.Tx tx = this.transactions.get(entity);
                Intrinsics.checkNotNull((Object)tx);
                if (tx.getReadonly()) {
                    Entity.Tx tx2 = this.transactions.get(entity);
                    Intrinsics.checkNotNull((Object)tx2);
                    tx2.close();
                    this.transactions.put(entity, new Entity.Tx(entity, readonly, this.uuid, false, 4, null));
                }
            }
        }

        @NotNull
        public final Entity.Tx getTx(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Entity.Tx tx = this.transactions.get(entity);
            if (tx == null) {
                throw (Throwable)new ExecutionException("");
            }
            return tx;
        }

        public final synchronized void execute() {
            boolean bl = this.state == ExecutionStatus.CREATED;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot schedule ExecutionContext " + this.uuid + " because it is in state " + (Object)((Object)this.state) + '.';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = ExecutionStatus.RUNNING;
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)ExecutionEngine.this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ ExecutionContext this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$runBlocking = this.p$;
                            var4_4 = ExecutionContext.access$getOperators$p(this.this$0).iterator();
lbl7:
                            // 4 sources

                            while (var4_4.hasNext()) {
                                operator = (SinkOperator)var4_4.next();
                                operator.open();
                                this.L$0 = $this$runBlocking;
                                this.L$1 = operator;
                                this.L$2 = var4_4;
                                this.label = 1;
                                v0 = FlowKt.collect(operator.toFlow($this$runBlocking), (Continuation)this);
                                if (v0 != var17_2) continue;
                                return var17_2;
                            }
                            break;
                        }
                        case 1: {
                            var4_4 = (Iterator<E>)this.L$2;
                            operator = (SinkOperator)this.L$1;
                            $this$runBlocking = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                ** GOTO lbl7
                            }
                            catch (OperatorExecutionException e) {
                                ExecutionEngine.access$getLOGGER$cp().error("Unhandled exception during query execution: " + ExceptionsKt.stackTraceToString((Throwable)e));
                                throw (Throwable)e;
                            }
                            catch (Throwable e) {
                                ExecutionEngine.access$getLOGGER$cp().error("Unhandled exception during query execution: " + ExceptionsKt.stackTraceToString((Throwable)e));
                                throw (Throwable)new ExecutionException("Unhandled exception during query execution: " + e.getMessage() + '.');
                            }
                        }
                        catch (Throwable var5_9) {
                            throw var5_9;
                        }
                        {
                            finally {
                                $this$forEach$iv = ExecutionContext.access$getTransactions$p(this.this$0);
                                $i$f$forEach = false;
                                var8_15 = $this$forEach$iv;
                                var9_17 = false;
                                var10_18 = var8_15.entrySet().iterator();
                                while (var10_18.hasNext()) {
                                    $dstr$_u24__u24$tx = element$iv = var10_18.next();
                                    $i$a$-forEach-ExecutionEngine$ExecutionContext$execute$2$1 = false;
                                    var14_25 = $dstr$_u24__u24$tx;
                                    var15_27 = false;
                                    tx = (Entity.Tx)var14_25.getValue();
                                    tx.close();
                                }
                                operator.close();
                                ** GOTO lbl7
                            }
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = executionContext;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            this.state = ExecutionStatus.COMPLETED;
            ExecutionEngine.this.getContexts().remove(this.uuid);
        }

        public ExecutionContext() {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
            this.uuid = uUID;
            this.state = ExecutionStatus.CREATED;
            boolean bl = false;
            this.operators = new ArrayList();
            bl = false;
            this.transactions = new LinkedHashMap();
            ((Map)ExecutionEngine.this.getContexts()).put(this.uuid, this);
        }

        public static final /* synthetic */ List access$getOperators$p(ExecutionContext $this) {
            return $this.operators;
        }

        public static final /* synthetic */ Map access$getTransactions$p(ExecutionContext $this) {
            return $this.transactions;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/execution/ExecutionEngine$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

