/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.ExperimentalTime;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.ServerConfig;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.execution.ExecutionEngine;
import org.vitrivr.cottontail.server.grpc.services.CottonDDLService;
import org.vitrivr.cottontail.server.grpc.services.CottonDMLService;
import org.vitrivr.cottontail.server.grpc.services.CottonDQLService;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "", "config", "Lorg/vitrivr/cottontail/config/ServerConfig;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "engine", "Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "(Lorg/vitrivr/cottontail/config/ServerConfig;Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/ExecutionEngine;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getConfig", "()Lorg/vitrivr/cottontail/config/ServerConfig;", "executor", "Ljava/util/concurrent/ExecutorService;", "isRunning", "", "()Z", "server", "Lio/grpc/Server;", "kotlin.jvm.PlatformType", "start", "", "stop", "Companion", "cottontaildb"})
@ExperimentalTime
public final class CottontailGrpcServer {
    private final ExecutorService executor;
    private final Server server;
    @NotNull
    private final ServerConfig config;
    @NotNull
    private final Catalogue catalogue;
    private final ExecutionEngine engine;
    @NotNull
    private static final Logger LOGGER;
    public static final Companion Companion;

    public final boolean isRunning() {
        Server server = this.server;
        Intrinsics.checkNotNullExpressionValue((Object)server, (String)"this.server");
        return !server.isShutdown();
    }

    public final void start() {
        this.server.start();
        LOGGER.info((Object)("Cottontail DB server is up and running at port " + this.config.getPort() + " ! Hop along..."));
    }

    public final void stop() {
        this.server.shutdown();
        LOGGER.info((Object)"Cottontail DB was shut down. Have a binky day!");
    }

    @NotNull
    public final ServerConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    /*
     * WARNING - void declaration
     */
    public CottontailGrpcServer(@NotNull ServerConfig config, @NotNull Catalogue catalogue, @NotNull ExecutionEngine engine) {
        ServerBuilder serverBuilder;
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.config = config;
        this.catalogue = catalogue;
        this.engine = engine;
        this.executor = new ThreadPoolExecutor(this.config.getCoreThreads(), this.config.getMaxThreads(), this.config.getKeepAliveTime(), TimeUnit.MILLISECONDS, new SynchronousQueue());
        ServerBuilder serverBuilder2 = ServerBuilder.forPort((int)this.config.getPort()).executor((Executor)this.executor).addService((BindableService)new CottonDDLService(this.catalogue)).addService((BindableService)new CottonDMLService(this.catalogue, this.engine)).addService((BindableService)new CottonDQLService(this.catalogue, this.engine));
        boolean bl = false;
        boolean bl2 = false;
        ServerBuilder serverBuilder3 = serverBuilder2;
        CottontailGrpcServer cottontailGrpcServer = this;
        boolean bl3 = false;
        if (this.config.getUseTls()) {
            Comparable<Path> comparable = this.config.getCertFile();
            if (comparable == null || (comparable = comparable.toFile()) == null) {
                throw (Throwable)new Exception();
            }
            Comparable<Path> certFile = comparable;
            Comparable<Path> comparable2 = this.config.getPrivateKey();
            if (comparable2 == null || (comparable2 = comparable2.toFile()) == null) {
                throw (Throwable)new Exception();
            }
            Comparable<Path> privateKeyFile = comparable2;
            serverBuilder = it.useTransportSecurity((File)certFile, (File)privateKeyFile);
        } else {
            serverBuilder = it;
        }
        void var12_12 = serverBuilder;
        cottontailGrpcServer.server = var12_12.build();
    }

    static {
        Companion = new Companion(null);
        Logger logger = LogManager.getLogger((String)Reflection.getOrCreateKotlinClass(CottontailGrpcServer.class).getQualifiedName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LogManager.getLogger(Cot\u2026ver::class.qualifiedName)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer$Companion;", "", "()V", "LOGGER", "Lorg/apache/log4j/Logger;", "getLOGGER", "()Lorg/apache/log4j/Logger;", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

