/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.MissingParameter;
import com.github.ajalt.clikt.core.NoSuchOption;
import com.github.ajalt.clikt.core.NoSuchSubcommand;
import com.github.ajalt.clikt.core.PrintHelpMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.vitrivr.cottontail.cli.CottontailCommand;
import org.vitrivr.cottontail.cli.DelegateCompleter;
import org.vitrivr.cottontail.server.grpc.CottontailGrpcServer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00042\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0014J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002J\u0006\u0010\u001c\u001a\u00020\u0014J\"\u0010\u001d\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aJ\u0014\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/cli/Cli;", "", "()V", "PROMPT", "", "clikt", "Lcom/github/ajalt/clikt/core/CliktCommand;", "completer", "Lorg/vitrivr/cottontail/cli/DelegateCompleter;", "cottontailServer", "Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "getCottontailServer", "()Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "setCottontailServer", "(Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;)V", "lineSplitRegex", "Ljava/util/regex/Pattern;", "getLineSplitRegex", "()Ljava/util/regex/Pattern;", "loop", "", "host", "port", "", "resetCompletion", "splitLine", "", "line", "stopServer", "updateArgumentCompletion", "schemata", "entities", "updateCompletion", "strings", "cottontaildb"})
@ExperimentalTime
public final class Cli {
    private static final String PROMPT = "cottontaildb> ";
    @NotNull
    public static CottontailGrpcServer cottontailServer;
    private static final DelegateCompleter completer;
    private static CliktCommand clikt;
    @NotNull
    private static final Pattern lineSplitRegex;
    public static final Cli INSTANCE;

    @NotNull
    public final CottontailGrpcServer getCottontailServer() {
        CottontailGrpcServer cottontailGrpcServer = cottontailServer;
        if (cottontailGrpcServer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cottontailServer");
        }
        return cottontailGrpcServer;
    }

    public final void setCottontailServer(@NotNull CottontailGrpcServer cottontailGrpcServer) {
        Intrinsics.checkNotNullParameter((Object)cottontailGrpcServer, (String)"<set-?>");
        cottontailServer = cottontailGrpcServer;
    }

    public final void updateCompletion(@NotNull List<String> strings) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        if (clikt != null) {
            Completer[] completerArray = new Completer[3];
            completerArray[0] = (Completer)new StringsCompleter(new String[]{"help"});
            CliktCommand cliktCommand = clikt;
            if (cliktCommand == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
            }
            completerArray[1] = (Completer)new StringsCompleter((Iterable)cliktCommand.registeredSubcommandNames());
            completerArray[2] = (Completer)new StringsCompleter((Iterable)strings);
            completer.setDelegate((Completer)new AggregateCompleter(completerArray));
        } else {
            completer.setDelegate((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"}), (Completer)new StringsCompleter((Iterable)strings)}));
        }
    }

    public final void updateArgumentCompletion(@NotNull List<String> schemata, @NotNull List<String> entities) {
        Intrinsics.checkNotNullParameter(schemata, (String)"schemata");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Completer[] completerArray = new Completer[4];
        CliktCommand cliktCommand = clikt;
        if (cliktCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
        }
        completerArray[0] = (Completer)new StringsCompleter((Iterable)cliktCommand.registeredSubcommandNames());
        completerArray[1] = (Completer)new StringsCompleter((Iterable)schemata);
        completerArray[2] = (Completer)new StringsCompleter((Iterable)entities);
        completerArray[3] = (Completer)new NullCompleter();
        ArgumentCompleter args = new ArgumentCompleter(completerArray);
        args.setStrictCommand(true);
        args.setStrict(false);
        completer.setDelegate((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"}), (Completer)args}));
    }

    public final void resetCompletion() {
        if (clikt != null) {
            Completer[] completerArray = new Completer[2];
            completerArray[0] = (Completer)new StringsCompleter(new String[]{"help"});
            CliktCommand cliktCommand = clikt;
            if (cliktCommand == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
            }
            completerArray[1] = (Completer)new StringsCompleter((Iterable)cliktCommand.registeredSubcommandNames());
            completer.setDelegate((Completer)new AggregateCompleter(completerArray));
        } else {
            completer.setDelegate((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"})}));
        }
    }

    public final void loop(@NotNull String host, int port) {
        Terminal terminal;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        clikt = (CliktCommand)new CottontailCommand(host, port);
        try {
            terminal = TerminalBuilder.builder().jansi(true).build();
        }
        catch (IOException e) {
            System.err.println("Could not initialize terminal: " + e.getMessage() + ". Aborting...");
            return;
        }
        Terminal terminal2 = terminal;
        CliktCommand cliktCommand = clikt;
        if (cliktCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
        }
        if (cliktCommand == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.cli.CottontailCommand");
        }
        ((CottontailCommand)cliktCommand).initCompletion();
        LineReader lineReader = LineReaderBuilder.builder().terminal(terminal2).completer((Completer)completer).build();
        while (true) {
            String line;
            boolean bl;
            String string;
            try {
                String string2 = lineReader.readLine(PROMPT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineReader.readLine(PROMPT)");
                string = string2;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            }
            catch (EndOfFileException e) {
                System.err.println("Could not read from terminal. If you're running Cottontail DB in Docker, then either run Docker in interactive mode (-it) or switch off the Cottontail DB CLI via the config.");
                break;
            }
            catch (UserInterruptException e) {
                System.err.println("Cottontail DB was interrupted by the user (Ctrl-C).");
                break;
            }
            string = line = string;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string5, (Object)"help")) {
                CliktCommand cliktCommand2 = clikt;
                if (cliktCommand2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
                }
                string = cliktCommand2.getFormattedHelp();
                bl = false;
                System.out.println((Object)string);
                continue;
            }
            if (StringsKt.isBlank((CharSequence)line)) continue;
            try {
                CliktCommand cliktCommand3 = clikt;
                if (cliktCommand3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
                }
                CliktCommand.parse$default((CliktCommand)cliktCommand3, this.splitLine(line), null, (int)2, null);
                boolean bl2 = false;
                System.out.println();
            }
            catch (Exception e) {
                boolean bl3;
                String string6;
                Exception exception = e;
                if (exception instanceof NoSuchSubcommand) {
                    string6 = "command not found";
                    bl3 = false;
                    System.out.println((Object)string6);
                    continue;
                }
                if (exception instanceof PrintHelpMessage) {
                    string6 = ((PrintHelpMessage)e).getCommand().getFormattedHelp();
                    bl3 = false;
                    System.out.println((Object)string6);
                    continue;
                }
                if (exception instanceof MissingParameter) {
                    string6 = ((MissingParameter)e).getLocalizedMessage();
                    bl3 = false;
                    System.out.println((Object)string6);
                    continue;
                }
                if (exception instanceof NoSuchOption) {
                    string6 = ((NoSuchOption)e).getLocalizedMessage();
                    bl3 = false;
                    System.out.println((Object)string6);
                    continue;
                }
                e.printStackTrace();
            }
        }
    }

    public static /* synthetic */ void loop$default(Cli cli, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 1865;
        }
        cli.loop(string, n);
    }

    @NotNull
    public final Pattern getLineSplitRegex() {
        return lineSplitRegex;
    }

    private final List<String> splitLine(String line) {
        block7: {
            block6: {
                if (line == null) break block6;
                CharSequence charSequence = line;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            return CollectionsKt.emptyList();
        }
        List matchList = new ArrayList();
        Matcher regexMatcher = lineSplitRegex.matcher(line);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                String string = regexMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group(1)");
                matchList.add(string);
                continue;
            }
            if (regexMatcher.group(2) != null) {
                String string = regexMatcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group(2)");
                matchList.add(string);
                continue;
            }
            String string = regexMatcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group()");
            matchList.add(string);
        }
        return matchList;
    }

    public final void stopServer() {
        if (cottontailServer != null) {
            CottontailGrpcServer cottontailGrpcServer = cottontailServer;
            if (cottontailGrpcServer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cottontailServer");
            }
            cottontailGrpcServer.stop();
        }
    }

    private Cli() {
    }

    static {
        Cli cli;
        INSTANCE = cli = new Cli();
        completer = new DelegateCompleter((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"})}));
        Pattern pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"[^\\\\s\\\"\u2026|\\\"([^\\\"]*)\\\"|'([^']*)'\")");
        lineSplitRegex = pattern;
    }

    public static final /* synthetic */ CliktCommand access$getClikt$p(Cli $this) {
        Cli cli = $this;
        CliktCommand cliktCommand = clikt;
        if (cliktCommand == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clikt");
        }
        return cliktCommand;
    }

    public static final /* synthetic */ void access$setClikt$p(Cli $this, CliktCommand cliktCommand) {
        Cli cli = $this;
        clikt = cliktCommand;
    }
}

