/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.catalogue;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.catalogue.CatalogueHeader;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/CatalogueHeaderSerializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueHeader;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "validate", "", "cottontaildb"})
public final class CatalogueHeaderSerializer
implements Serializer<CatalogueHeader> {
    public static final CatalogueHeaderSerializer INSTANCE;

    /*
     * WARNING - void declaration
     */
    public void serialize(@NotNull DataOutput2 out, @NotNull CatalogueHeader value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        out.writeUTF("COTTONT_CAT");
        out.writeShort(1);
        out.packLong(value.getSize());
        out.writeLong(value.getCreated());
        out.writeLong(value.getModified());
        out.writeInt(value.getSchemas().length);
        int n = 0;
        int n2 = value.getSchemas().length;
        while (n < n2) {
            void i;
            out.writeLong(value.getSchemas()[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CatalogueHeader deserialize(@NotNull DataInput2 input, int available) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!this.validate(input)) {
            throw (Throwable)new DatabaseException.InvalidFileException("Cottontail DB Entity");
        }
        long size = input.unpackLong();
        long created = input.readLong();
        long modified = input.readLong();
        int schema_count = input.readInt();
        long[] schemas = new long[schema_count];
        int n = 0;
        int n2 = schema_count;
        while (n < n2) {
            void i;
            schemas[i] = input.readLong();
            ++i;
        }
        return new CatalogueHeader(size, created, modified, schemas);
    }

    private final boolean validate(DataInput2 input) {
        String identifier = input.readUTF();
        short version = input.readShort();
        return version == 1 & Intrinsics.areEqual((Object)identifier, (Object)"COTTONT_CAT");
    }

    private CatalogueHeaderSerializer() {
    }

    static {
        CatalogueHeaderSerializer catalogueHeaderSerializer;
        INSTANCE = catalogueHeaderSerializer = new CatalogueHeaderSerializer();
    }
}

