/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index;

import java.util.UUID;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.TransactionStatus;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.TransactionException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010 \u001a\u00020!2\n\u0010\u0010\u001a\u00060\"R\u00020\u0011H&J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H&J\u0010\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020%H&J\b\u0010(\u001a\u00020)H\u0004R\u001c\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000bR\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/database/index/Index;", "Lorg/vitrivr/cottontail/database/general/DBO;", "()V", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "globalLock", "Ljava/util/concurrent/locks/StampedLock;", "getGlobalLock", "()Ljava/util/concurrent/locks/StampedLock;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "produces", "getProduces", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "txLock", "getTxLock", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "begin", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "finalize", "", "Tx", "cottontaildb"})
public abstract class Index
implements DBO {
    @NotNull
    private final StampedLock globalLock = new StampedLock();
    @NotNull
    private final StampedLock txLock = new StampedLock();

    @NotNull
    protected final StampedLock getGlobalLock() {
        return this.globalLock;
    }

    @NotNull
    protected final StampedLock getTxLock() {
        return this.txLock;
    }

    @Override
    @NotNull
    public abstract Name.IndexName getName();

    @Override
    @NotNull
    public abstract Entity getParent();

    @NotNull
    public abstract ColumnDef<?>[] getColumns();

    @NotNull
    public abstract ColumnDef<?>[] getProduces();

    @NotNull
    public abstract IndexType getType();

    public abstract boolean getSupportsIncrementalUpdate();

    public abstract boolean canProcess(@NotNull Predicate var1);

    @NotNull
    public abstract Cost cost(@NotNull Predicate var1);

    protected final synchronized void finalize() {
        this.close();
    }

    @NotNull
    public abstract IndexTransaction begin(@NotNull Entity.Tx var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0004J\b\u00107\u001a\u000206H\u0004J\b\u00108\u001a\u000206H$J\u0006\u00109\u001a\u000206J\u0006\u0010:\u001a\u000206J\b\u0010;\u001a\u000206H$J\b\u0010<\u001a\u000206H$J\u0006\u0010=\u001a\u000206R\u001e\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR$\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 @DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001eR\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u000eR\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006>"}, d2={"Lorg/vitrivr/cottontail/database/index/Index$Tx;", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/index/Index;Lorg/vitrivr/cottontail/database/entity/Entity$Tx;)V", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "globalStamp", "", "getGlobalStamp", "()J", "localLock", "Ljava/util/concurrent/locks/StampedLock;", "getLocalLock", "()Ljava/util/concurrent/locks/StampedLock;", "name", "Lorg/vitrivr/cottontail/model/basics/Name;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "produces", "getProduces", "readonly", "", "getReadonly", "()Z", "<set-?>", "Lorg/vitrivr/cottontail/database/general/TransactionStatus;", "status", "getStatus", "()Lorg/vitrivr/cottontail/database/general/TransactionStatus;", "setStatus", "(Lorg/vitrivr/cottontail/database/general/TransactionStatus;)V", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "tid", "Ljava/util/UUID;", "getTid", "()Ljava/util/UUID;", "txStamp", "getTxStamp", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "checkValidForRead", "", "checkValidForWrite", "cleanup", "close", "commit", "performCommit", "performRollback", "rollback", "cottontaildb"})
    protected abstract class Tx
    implements IndexTransaction {
        @NotNull
        private volatile TransactionStatus status;
        private final boolean readonly;
        private final long globalStamp;
        private final long txStamp;
        @NotNull
        private final StampedLock localLock;
        @NotNull
        private final Entity.Tx parent;

        @Override
        @NotNull
        public final TransactionStatus getStatus() {
            return this.status;
        }

        protected final void setStatus(@NotNull TransactionStatus transactionStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)transactionStatus), (String)"<set-?>");
            this.status = transactionStatus;
        }

        @Override
        public final boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @NotNull
        public final UUID getTid() {
            return this.parent.getTid();
        }

        protected final long getGlobalStamp() {
            return this.globalStamp;
        }

        protected final long getTxStamp() {
            return this.txStamp;
        }

        @NotNull
        protected final StampedLock getLocalLock() {
            return this.localLock;
        }

        @Override
        @NotNull
        public Name getName() {
            return Index.this.getName();
        }

        @Override
        @NotNull
        public ColumnDef<?>[] getColumns() {
            return Index.this.getColumns();
        }

        @Override
        @NotNull
        public ColumnDef<?>[] getProduces() {
            return Index.this.getProduces();
        }

        @Override
        @NotNull
        public IndexType getType() {
            return Index.this.getType();
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return Index.this.getSupportsIncrementalUpdate();
        }

        @Override
        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return Index.this.canProcess(predicate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void commit() {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-Index$Tx$commit$22 = false;
                if (this.status == TransactionStatus.DIRTY) {
                    this.performCommit();
                    this.status = TransactionStatus.CLEAN;
                }
                Unit $i$a$-read-Index$Tx$commit$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        protected abstract void performCommit();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void rollback() {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-Index$Tx$rollback$22 = false;
                if (this.status == TransactionStatus.DIRTY || this.status == TransactionStatus.ERROR) {
                    this.performRollback();
                    this.status = TransactionStatus.CLEAN;
                }
                Unit $i$a$-read-Index$Tx$rollback$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        protected abstract void performRollback();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-Index$Tx$close$22 = false;
                if (this.status != TransactionStatus.CLOSED) {
                    if (this.status == TransactionStatus.DIRTY || this.status == TransactionStatus.ERROR) {
                        this.performRollback();
                    }
                    this.status = TransactionStatus.CLOSED;
                    Index.this.getTxLock().unlock(this.txStamp);
                    Index.this.getGlobalLock().unlockRead(this.globalStamp);
                    this.cleanup();
                }
                Unit $i$a$-write-Index$Tx$close$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        protected abstract void cleanup();

        protected final void checkValidForWrite() {
            if (this.readonly) {
                throw (Throwable)new TransactionException.TransactionReadOnlyException(this.getTid());
            }
            if (this.status == TransactionStatus.CLOSED) {
                throw (Throwable)new TransactionException.TransactionClosedException(this.getTid());
            }
            if (this.status == TransactionStatus.ERROR) {
                throw (Throwable)new TransactionException.TransactionInErrorException(this.getTid());
            }
            if (this.status != TransactionStatus.DIRTY) {
                this.status = TransactionStatus.DIRTY;
            }
        }

        protected final void checkValidForRead() {
            if (this.status == TransactionStatus.CLOSED) {
                throw (Throwable)new TransactionException.TransactionClosedException(this.getTid());
            }
            if (this.status == TransactionStatus.ERROR) {
                throw (Throwable)new TransactionException.TransactionInErrorException(this.getTid());
            }
        }

        @NotNull
        public final Entity.Tx getParent() {
            return this.parent;
        }

        public Tx(Entity.Tx parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            this.parent = parent;
            this.status = TransactionStatus.CLEAN;
            this.readonly = this.parent.getReadonly();
            if (Index.this.getClosed()) {
                throw (Throwable)new TransactionException.TransactionDBOClosedException(this.getTid());
            }
            this.globalStamp = Index.this.getGlobalLock().readLock();
            this.txStamp = this.readonly ? Index.this.getTxLock().readLock() : Index.this.getTxLock().writeLock();
            this.localLock = new StampedLock();
        }
    }
}

