/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexType$WhenMappings;
import org.vitrivr.cottontail.database.index.hash.NonUniqueHashIndex;
import org.vitrivr.cottontail.database.index.hash.UniqueHashIndex;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSHIndex;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndex;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JC\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/database/index/IndexType;", "", "inexact", "", "(Ljava/lang/String;IZ)V", "getInexact", "()Z", "create", "Lorg/vitrivr/cottontail/database/index/Index;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "params", "", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;Ljava/util/Map;)Lorg/vitrivr/cottontail/database/index/Index;", "open", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)Lorg/vitrivr/cottontail/database/index/Index;", "HASH_UQ", "HASH", "BTREE", "LUCENE", "VAF", "PQ", "SH", "LSH", "SUPERBIT_LSH", "cottontaildb"})
public final class IndexType
extends Enum<IndexType> {
    public static final /* enum */ IndexType HASH_UQ;
    public static final /* enum */ IndexType HASH;
    public static final /* enum */ IndexType BTREE;
    public static final /* enum */ IndexType LUCENE;
    public static final /* enum */ IndexType VAF;
    public static final /* enum */ IndexType PQ;
    public static final /* enum */ IndexType SH;
    public static final /* enum */ IndexType LSH;
    public static final /* enum */ IndexType SUPERBIT_LSH;
    private static final /* synthetic */ IndexType[] $VALUES;
    private final boolean inexact;

    static {
        IndexType[] indexTypeArray = new IndexType[9];
        IndexType[] indexTypeArray2 = indexTypeArray;
        indexTypeArray[0] = HASH_UQ = new IndexType(false);
        indexTypeArray[1] = HASH = new IndexType(false);
        indexTypeArray[2] = BTREE = new IndexType(false);
        indexTypeArray[3] = LUCENE = new IndexType(false);
        indexTypeArray[4] = VAF = new IndexType(false);
        indexTypeArray[5] = PQ = new IndexType(true);
        indexTypeArray[6] = SH = new IndexType(true);
        indexTypeArray[7] = LSH = new IndexType(true);
        indexTypeArray[8] = SUPERBIT_LSH = new IndexType(true);
        $VALUES = indexTypeArray;
    }

    @NotNull
    public final Index open(@NotNull Name.IndexName name, @NotNull Entity entity, @NotNull ColumnDef<?>[] columns) {
        Index index;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        switch (IndexType$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                index = new UniqueHashIndex(name, entity, columns);
                break;
            }
            case 2: {
                index = new NonUniqueHashIndex(name, entity, columns);
                break;
            }
            case 3: {
                index = new LuceneIndex(name, entity, columns);
                break;
            }
            case 4: {
                index = new SuperBitLSHIndex(name, entity, columns, null);
                break;
            }
            default: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
        }
        return index;
    }

    @NotNull
    public final Index create(@NotNull Name.IndexName name, @NotNull Entity entity, @NotNull ColumnDef<?>[] columns, @NotNull Map<String, String> params) {
        Index index;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        switch (IndexType$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                index = new UniqueHashIndex(name, entity, columns);
                break;
            }
            case 2: {
                index = new NonUniqueHashIndex(name, entity, columns);
                break;
            }
            case 3: {
                index = new LuceneIndex(name, entity, columns);
                break;
            }
            case 4: {
                index = new SuperBitLSHIndex(name, entity, columns, params);
                break;
            }
            default: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
        }
        return index;
    }

    public static /* synthetic */ Index create$default(IndexType indexType, Name.IndexName indexName, Entity entity, ColumnDef[] columnDefArray, Map map2, int n, Object object) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return indexType.create(indexName, entity, columnDefArray, map2);
    }

    public final boolean getInexact() {
        return this.inexact;
    }

    private IndexType(boolean inexact) {
        this.inexact = inexact;
    }

    public static IndexType[] values() {
        return (IndexType[])$VALUES.clone();
    }

    public static IndexType valueOf(String string) {
        return Enum.valueOf(IndexType.class, string);
    }
}

