/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.hash;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.hash.NonUniqueHashIndex$Tx$WhenMappings;
import org.vitrivr.cottontail.database.queries.components.AtomicBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.ValidationException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u000223B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010(\u001a\u00020)2\n\u0010\u0004\u001a\u00060*R\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-H\u0016R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b!\u0010\u0010R\u0014\u0010\"\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000eR\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00064"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex;", "Lorg/vitrivr/cottontail/database/index/Index;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "<set-?>", "", "closed", "getClosed", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "db", "Lorg/mapdb/DB;", "map", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "produces", "getProduces", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "begin", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "close", "", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "Companion", "Tx", "cottontaildb"})
public final class NonUniqueHashIndex
extends Index {
    @NotNull
    private final Path path;
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    @NotNull
    private final ColumnDef<?>[] produces;
    private final DB db;
    private final HTreeMap<? extends Value, long[]> map;
    private volatile boolean closed;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final Entity parent;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    public static final String MAP_FIELD_NAME = "nu_map";
    private static final Logger LOGGER;
    public static final Companion Companion;

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof AtomicBooleanPredicate ? Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) && (((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.IN || ((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.EQUAL) : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof AtomicBooleanPredicate) || Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) ^ true) {
            cost = Cost.Companion.getINVALID();
        } else if (((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.EQUAL) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS();
            float f2 = 1.0E-4f;
            boolean $i$f$map = false;
            void var4_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnDef columnDef = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f3 = CollectionsKt.sumOfInt((Iterable)collection);
            float f4 = f;
            float f5 = f2;
            cost = new Cost(f5, f4, f3);
        } else if (((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.IN) {
            Collection<Integer> collection;
            Iterable $this$map$iv = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS() * (float)((AtomicBooleanPredicate)predicate).getValues().size();
            float f6 = 1.0E-4f * (float)((AtomicBooleanPredicate)predicate).getValues().size();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef it = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f7 = CollectionsKt.sumOfInt((Iterable)collection);
            float f8 = f;
            float f9 = f6;
            cost = new Cost(f9, f8, f7);
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTransaction begin(@NotNull Entity.Tx parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new Tx(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.getGlobalLock();
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-NonUniqueHashIndex$close$22 = false;
            if (!this.getClosed()) {
                this.db.close();
                this.closed = true;
            }
            Unit $i$a$-write-NonUniqueHashIndex$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public NonUniqueHashIndex(@NotNull Name.IndexName name, @NotNull Entity parent, @NotNull ColumnDef<?>[] columns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.name = name;
        this.parent = parent;
        this.columns = columns;
        Path path = this.getParent().getPath().resolve("idx_nu_" + this.getName().getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve\u2026dx_nu_${name.simple}.db\")");
        this.path = path;
        this.type = IndexType.HASH_UQ;
        this.supportsIncrementalUpdate = true;
        this.produces = this.getColumns();
        this.db = this.getParent().getParent().getParent().getConfig().getMapdb().db(this.getPath());
        Serializer serializer2 = ((ColumnDef)ArraysKt.first((Object[])this.getColumns())).getType().serializer(this.getColumns().length);
        GroupSerializer groupSerializer = Serializer.LONG_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.LONG_ARRAY");
        this.map = this.db.hashMap(MAP_FIELD_NAME, serializer2, (Serializer)groupSerializer).counterEnable().createOrOpen();
        this.db.commit();
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(NonUniqueHashIndex.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0014J\b\u0010\u000f\u001a\u00020\bH\u0014J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/Index$Tx;", "Lorg/vitrivr/cottontail/database/index/Index;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex;Lorg/vitrivr/cottontail/database/entity/Entity$Tx;)V", "cleanup", "", "filter", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "performCommit", "performRollback", "rebuild", "update", "", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends Index.Tx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                Object object;
                Object record;
                Map.Entry entry;
                boolean $i$a$-read-NonUniqueHashIndex$Tx$rebuild$22 = false;
                this.checkValidForWrite();
                LOGGER.trace("Rebuilding non-unique hash index {}", (Object)NonUniqueHashIndex.this.getName());
                NonUniqueHashIndex.this.map.clear();
                boolean bl = false;
                Map localMap = new LinkedHashMap();
                AutoCloseable autoCloseable = this.getParent().scan(this.getColumns());
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    CloseableIterator s = (CloseableIterator)autoCloseable;
                    boolean bl4 = false;
                    Iterator $this$forEach$iv = s;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv;
                    boolean bl5 = false;
                    entry = iterator2;
                    while (entry.hasNext()) {
                        Object value;
                        Object element$iv = entry.next();
                        record = (Record)element$iv;
                        boolean bl6 = false;
                        if (record.get(this.getColumns()[0]) == null) {
                            throw (Throwable)new ValidationException.IndexUpdateException(this.getName(), "A value cannot be null for instances of non-unique hash-index but tid=" + this.getTid() + " is");
                        }
                        if (!localMap.containsKey(value)) {
                            localMap.put(value, CollectionsKt.mutableListOf((Object[])new Long[]{record.getTupleId()}));
                            continue;
                        }
                        Object v = localMap.get(value);
                        Intrinsics.checkNotNull(v);
                        ((List)v).add(record.getTupleId());
                    }
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                HTreeMap hTreeMap = NonUniqueHashIndex.this.map;
                if (hTreeMap == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mapdb.HTreeMap<org.vitrivr.cottontail.model.values.types.Value, kotlin.LongArray>");
                }
                HTreeMap castMap = hTreeMap;
                Map $this$forEach$iv = localMap;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv;
                boolean bl7 = false;
                Iterator iterator3 = object.entrySet().iterator();
                while (iterator3.hasNext()) {
                    void value;
                    Map.Entry element$iv;
                    Map.Entry $dstr$value$l = element$iv = iterator3.next();
                    boolean bl8 = false;
                    entry = $dstr$value$l;
                    boolean bl9 = false;
                    record = (Value)entry.getKey();
                    entry = $dstr$value$l;
                    bl9 = false;
                    List l = (List)entry.getValue();
                    ((Map)castMap).put(value, CollectionsKt.toLongArray((Collection)l));
                }
                LOGGER.trace("Rebuilding non-unique hash complete!");
                Unit $i$a$-read-NonUniqueHashIndex$Tx$rebuild$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull Collection<DataChangeEvent> update) {
            Intrinsics.checkNotNullParameter(update, (String)"update");
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-NonUniqueHashIndex$Tx$update$22 = false;
                this.checkValidForWrite();
                HTreeMap hTreeMap = NonUniqueHashIndex.this.map;
                if (hTreeMap == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mapdb.HTreeMap<org.vitrivr.cottontail.model.values.types.Value, kotlin.LongArray>");
                }
                HTreeMap localMap = hTreeMap;
                Function1<DataChangeEvent, Unit> $fun$atomicInsert$1 = new Function1<DataChangeEvent, Unit>(localMap, this, update){
                    final /* synthetic */ HTreeMap $localMap;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Collection $update$inlined;
                    {
                        this.$localMap = hTreeMap;
                        this.this$0 = tx;
                        this.$update$inlined = collection;
                        super(1);
                    }

                    public final void invoke(@NotNull DataChangeEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Record record = event.getNew();
                        if (record == null || (record = record.get(this.this$0.getColumns()[0])) == null) {
                            Record record2 = event.getNew();
                            throw (Throwable)new ValidationException.IndexUpdateException(this.this$0.getName(), "Values cannot be null for instances of UniqueHashIndex but tid=" + (record2 != null ? Long.valueOf(record2.getTupleId()) : null) + " is.");
                        }
                        Record newValue = record;
                        if (this.$localMap.containsKey((Object)newValue)) {
                            Object object = this.$localMap.get((Object)newValue);
                            Intrinsics.checkNotNull((Object)object);
                            long[] oldArray = (long[])object;
                            if (!ArraysKt.contains((long[])oldArray, (long)event.getNew().getTupleId())) {
                                long[] lArray = oldArray;
                                int n = oldArray.length + 1;
                                boolean bl = false;
                                long[] lArray2 = Arrays.copyOf(lArray, n);
                                Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
                                long[] newArray = lArray2;
                                newArray[oldArray.length] = event.getNew().getTupleId();
                                ((Map)this.$localMap).put(newValue, newArray);
                            }
                        } else {
                            ((Map)this.$localMap).put(newValue, new long[]{event.getNew().getTupleId()});
                        }
                    }
                };
                Function1<DataChangeEvent, Unit> $fun$atomicDelete$2 = new Function1<DataChangeEvent, Unit>(localMap, this, update){
                    final /* synthetic */ HTreeMap $localMap;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Collection $update$inlined;
                    {
                        this.$localMap = hTreeMap;
                        this.this$0 = tx;
                        this.$update$inlined = collection;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull DataChangeEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Record record = event.getOld();
                        if (record == null || (record = record.get(this.this$0.getColumns()[0])) == null) {
                            Record record2 = event.getNew();
                            throw (Throwable)new ValidationException.IndexUpdateException(this.this$0.getName(), "Values cannot be null for instances of UniqueHashIndex but tid=" + (record2 != null ? Long.valueOf(record2.getTupleId()) : null) + " is.");
                        }
                        Record oldValue = record;
                        if (this.$localMap.containsKey((Object)oldValue)) {
                            Object object = this.$localMap.get((Object)oldValue);
                            Intrinsics.checkNotNull((Object)object);
                            long[] oldArray = (long[])object;
                            if (ArraysKt.contains((long[])oldArray, (long)event.getOld().getTupleId())) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                long[] lArray = oldArray;
                                Record record3 = oldValue;
                                Map map2 = (Map)this.$localMap;
                                boolean $i$f$filter = false;
                                void var8_8 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                void var11_11 = $this$filterTo$iv$iv;
                                int n = ((void)var11_11).length;
                                for (int i = 0; i < n; ++i) {
                                    void element$iv$iv;
                                    void it = element$iv$iv = var11_11[i];
                                    boolean bl = false;
                                    if (!(it != event.getOld().getTupleId())) continue;
                                    destination$iv$iv.add((long)element$iv$iv);
                                }
                                List list = (List)destination$iv$iv;
                                map2.put(record3, CollectionsKt.toLongArray((Collection)list));
                            }
                        }
                    }
                };
                for (DataChangeEvent event : update) {
                    switch (NonUniqueHashIndex$Tx$WhenMappings.$EnumSwitchMapping$0[event.getType().ordinal()]) {
                        case 1: {
                            $fun$atomicInsert$1.invoke(event);
                            break;
                        }
                        case 2: {
                            Record record = event.getNew();
                            Record record2 = event.getOld();
                            if (!(Intrinsics.areEqual(record != null ? record.get(this.getColumns()[0]) : null, record2 != null ? record2.get(this.getColumns()[0]) : null) ^ true)) break;
                            $fun$atomicDelete$2.invoke(event);
                            $fun$atomicInsert$1.invoke(event);
                            break;
                        }
                        case 3: {
                            $fun$atomicDelete$2.invoke(event);
                            break;
                        }
                    }
                }
                Unit $i$a$-read-NonUniqueHashIndex$Tx$update$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new CloseableIterator<Record>(this, predicate){
                private final AtomicBooleanPredicate<?> predicate;
                private final long lock;
                private volatile boolean closed;
                private final List<Record> results;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of hasNext(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Collection collection = this.results;
                    bl2 = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return (Record)CollectionsKt.removeFirst(this.results);
                }

                public void close() {
                    if (!this.closed) {
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.lock);
                        this.closed = true;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final List<Record> prepare() {
                    List list;
                    block18: {
                        void $this$flatMapTo$iv$iv;
                        int n;
                        block15: {
                            Object list$iv$iv;
                            Object $this$flatMapTo$iv$iv2;
                            int n2;
                            switch (NonUniqueHashIndex$Tx$WhenMappings.$EnumSwitchMapping$1[this.predicate.getOperator().ordinal()]) {
                                case 1: {
                                    n2 = 1;
                                    break;
                                }
                                case 2: {
                                    n2 = this.predicate.getValues().size();
                                    break;
                                }
                                default: {
                                    throw (Throwable)new QueryException.UnsupportedPredicateException("Instance of unique hash-index does not support " + (Object)((Object)this.predicate.getOperator()) + " comparison operators.");
                                }
                            }
                            n = n2;
                            if (!this.predicate.getNot()) break block15;
                            Object $this$flatMap$iv = CollectionsKt.take((Iterable)this.predicate.getValues(), (int)n);
                            boolean $i$f$flatMap = false;
                            Iterable iterable = $this$flatMap$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$flatMapTo = false;
                            Object object = $this$flatMapTo$iv$iv2.iterator();
                            while (object.hasNext()) {
                                Object object2;
                                block17: {
                                    block16: {
                                        T element$iv$iv = object.next();
                                        Value it = (Value)element$iv$iv;
                                        boolean bl = false;
                                        Map map2 = (Map)NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this);
                                        boolean bl2 = false;
                                        object2 = (long[])map2.get(it);
                                        if (object2 == null) break block16;
                                        List list2 = ArraysKt.asList((long[])object2);
                                        object2 = list2;
                                        if (list2 != null) break block17;
                                    }
                                    object2 = CollectionsKt.emptyList();
                                }
                                list$iv$iv = (Iterable)object2;
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            HashSet blackList = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
                            $this$flatMap$iv = (Map)NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this);
                            $i$f$flatMap = false;
                            $this$flatMapTo$iv$iv2 = $this$flatMap$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$flatMapTo = false;
                            object = $this$flatMapTo$iv$iv2;
                            boolean element$iv$iv = false;
                            list$iv$iv = object.entrySet().iterator();
                            while (list$iv$iv.hasNext()) {
                                void $this$mapTo$iv$iv;
                                Iterable $this$filterTo$iv$iv;
                                Map.Entry element$iv$iv2;
                                Map.Entry entry = element$iv$iv2 = (Map.Entry)list$iv$iv.next();
                                boolean bl5 = false;
                                Value[] value = new Value[]{(Value)entry.getKey()};
                                V v = entry.getValue();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
                                long[] $this$filter$iv = (long[])v;
                                boolean $i$f$filter = false;
                                long[] lArray = $this$filter$iv;
                                Collection destination$iv$iv2 = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                Iterator<T> iterator2 = $this$filterTo$iv$iv;
                                int n3 = ((void)iterator2).length;
                                for (int i = 0; i < n3; ++i) {
                                    void element$iv$iv3;
                                    void it = element$iv$iv3 = iterator2[i];
                                    boolean bl3 = false;
                                    if (!(!blackList.contains((long)it))) continue;
                                    destination$iv$iv2.add((long)element$iv$iv3);
                                }
                                Iterable $this$map$iv = (List)destination$iv$iv2;
                                boolean $i$f$map = false;
                                $this$filterTo$iv$iv = $this$map$iv;
                                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv2 : $this$mapTo$iv$iv) {
                                    void it;
                                    long l = ((Number)item$iv$iv2).longValue();
                                    Collection collection = destination$iv$iv2;
                                    boolean bl4 = false;
                                    StandaloneRecord standaloneRecord = new StandaloneRecord((long)it, this.this$0.NonUniqueHashIndex.this.getProduces(), value);
                                    collection.add(standaloneRecord);
                                }
                                Iterable list$iv$iv2 = (List)destination$iv$iv2;
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv2);
                            }
                            list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                            break block18;
                        }
                        Iterable $this$flatMap$iv = CollectionsKt.take((Iterable)this.predicate.getValues(), (int)n);
                        boolean $i$f$flatMap = false;
                        Iterable $i$f$flatMap2 = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                            List list3;
                            Value v = (Value)element$iv$iv;
                            boolean bl = false;
                            Map element$iv$iv2 = (Map)NonUniqueHashIndex.access$getMap$p(this.this$0.NonUniqueHashIndex.this);
                            boolean entry = false;
                            if ((long[])element$iv$iv2.get(v) != null) {
                                void $this$mapTo$iv$iv;
                                long[] $this$map$iv;
                                boolean $i$f$map = false;
                                long[] bl5 = $this$map$iv;
                                Collection destination$iv$iv3 = new ArrayList<E>($this$map$iv.length);
                                boolean $i$f$mapTo = false;
                                void var16_33 = $this$mapTo$iv$iv;
                                int n4 = ((void)var16_33).length;
                                for (int i = 0; i < n4; ++i) {
                                    void tupleId;
                                    void item$iv$iv;
                                    void item$iv$iv2 = item$iv$iv = var16_33[i];
                                    Collection collection = destination$iv$iv3;
                                    boolean bl6 = false;
                                    StandaloneRecord standaloneRecord = new StandaloneRecord((long)tupleId, this.this$0.NonUniqueHashIndex.this.getProduces(), new Value[]{v});
                                    collection.add(standaloneRecord);
                                }
                                list3 = (List)destination$iv$iv3;
                            } else {
                                list3 = CollectionsKt.emptyList();
                            }
                            Iterable list$iv$iv = list3;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    }
                    return list;
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof AtomicBooleanPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.NonUniqueHashIndex.this.getName() + "' (non-unique hash-index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (AtomicBooleanPredicate)$captured_local_variable$1;
                    Tx.access$checkValidForRead(this$0);
                    this.lock = Tx.access$getLocalLock$p(this$0).readLock();
                    this.results = this.prepare();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        protected void performCommit() {
            NonUniqueHashIndex.this.db.commit();
        }

        @Override
        protected void performRollback() {
            NonUniqueHashIndex.this.db.rollback();
        }

        @Override
        protected void cleanup() {
        }

        public Tx(Entity.Tx parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(NonUniqueHashIndex.this, parent);
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.getLocalLock();
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/NonUniqueHashIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAP_FIELD_NAME", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

