/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.vaplus;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnType;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.vaplus.SignatureGenerator;
import org.vitrivr.cottontail.database.index.vaplus.VAPlus;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusIndex;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusMeta;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusMetaSerializer;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusSignature;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusSignatureSerializer;
import org.vitrivr.cottontail.database.queries.components.KnnPredicate;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.math.knn.selection.ComparablePair;
import org.vitrivr.cottontail.math.knn.selection.MinHeapSelection;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u0001:\u0002;<B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010*\u001a\u00020+2\n\u0010\u0004\u001a\u00060,R\u00020\u0005H\u0016J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000200H\u0002J\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u00105\u001a\u000206H\u0016R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)\u00a8\u0006="}, d2={"Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusIndex;", "Lorg/vitrivr/cottontail/database/index/Index;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "<set-?>", "", "closed", "getClosed", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "db", "Lorg/mapdb/DB;", "meta", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusMeta;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "produces", "getProduces", "signatures", "Lorg/mapdb/IndexTreeList;", "Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusSignature;", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "begin", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "calculateBounds", "", "cells", "", "bounds", "", "boundsIndex", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "close", "", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "Companion", "Tx", "cottontaildb"})
public final class VAPlusIndex
extends Index {
    @NotNull
    private final Path path;
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    @NotNull
    private final ColumnDef<?>[] produces;
    private final DB db;
    private final Atomic.Var<VAPlusMeta> meta;
    private final IndexTreeList<VAPlusSignature> signatures;
    private volatile boolean closed;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final Entity parent;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    public static final String META_FIELD_NAME = "vaf_meta";
    @NotNull
    public static final String SIGNATURE_FIELD_NAME = "vaf_signatures";
    private static final Logger LOGGER;
    public static final Companion Companion;

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate ? Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) : false;
    }

    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return !(predicate instanceof KnnPredicate) || Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) ^ true ? Cost.Companion.getINVALID() : Cost.Companion.getZERO();
    }

    /*
     * WARNING - void declaration
     */
    private final float calculateBounds(int[] cells, float[] bounds, int[] boundsIndex) {
        void $this$mapIndexedTo$iv$iv;
        int[] $this$mapIndexed$iv = cells;
        boolean $i$f$mapIndexed = false;
        int[] nArray = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void it;
            int n = index$iv$iv++;
            void var14_14 = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void cellsIdx = it < 0 ? (short)(65536 + it) : it;
            Float f = Float.valueOf(bounds[boundsIndex[i] + cellsIdx]);
            collection.add(f);
        }
        return CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public IndexTransaction begin(@NotNull Entity.Tx parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new Tx(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.getGlobalLock();
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-VAPlusIndex$close$22 = false;
            if (!this.getClosed()) {
                this.db.close();
                this.closed = true;
            }
            Unit $i$a$-write-VAPlusIndex$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public VAPlusIndex(@NotNull Name.IndexName name, @NotNull Entity parent, @NotNull ColumnDef<?>[] columns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.name = name;
        this.parent = parent;
        this.columns = columns;
        Path path = this.getParent().getPath().resolve("idx_vaf_" + this.getName() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve(\"idx_vaf_$name.db\")");
        this.path = path;
        this.type = IndexType.VAF;
        this.supportsIncrementalUpdate = true;
        this.produces = new ColumnDef[]{new ColumnDef(this.getParent().getName().column("distance"), ColumnType.Companion.forName("DOUBLE"), 0, false, 12, null)};
        this.db = this.getParent().getParent().getParent().getConfig().getMapdb().db(this.getPath());
        this.meta = (Atomic.Var)this.db.atomicVar(META_FIELD_NAME, (Serializer)VAPlusMetaSerializer.INSTANCE).createOrOpen();
        this.signatures = (IndexTreeList)this.db.indexTreeList(SIGNATURE_FIELD_NAME, (Serializer)VAPlusSignatureSerializer.INSTANCE).createOrOpen();
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(VAPlusIndex.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0014J\b\u0010\u000f\u001a\u00020\bH\u0014J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/Index$Tx;", "Lorg/vitrivr/cottontail/database/index/Index;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusIndex;Lorg/vitrivr/cottontail/database/entity/Entity$Tx;)V", "cleanup", "", "filter", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "performCommit", "performRollback", "rebuild", "update", "", "", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends Index.Tx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                void dataSample;
                boolean $i$a$-read-VAPlusIndex$Tx$rebuild$22 = false;
                this.checkValidForWrite();
                VAPlusIndex.this.signatures.clear();
                VAPlus vaPlus = new VAPlus();
                int trainingSize = 1000;
                int minimumNumberOfTuples = 1000;
                int dimension = this.getColumns()[0].getLogicalSize();
                boolean bl = false;
                double[][] dataSampleTmp = vaPlus.getDataSample(this.getParent(), this.getColumns(), Math.max(trainingSize, minimumNumberOfTuples));
                Pair<double[][], RealMatrix> pair = vaPlus.transformToKLTDomain(dataSampleTmp);
                double[][] dArray = (double[][])pair.component1();
                RealMatrix kltMatrix = (RealMatrix)pair.component2();
                int[] b = vaPlus.nonUniformBitAllocation((double[][])dataSample, dimension * 2);
                SignatureGenerator signatureGenerator = new SignatureGenerator(b);
                double[][] marks = vaPlus.nonUniformQuantization((double[][])dataSample, b);
                RealMatrix kltMatrixBar = kltMatrix.transpose();
                Iterator $this$forEach$iv = this.getParent().scan(VAPlusIndex.this.getColumns());
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                boolean bl2 = false;
                Iterator iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Object element$iv = iterator3.next();
                    Record record = (Record)element$iv;
                    boolean bl3 = false;
                    Object obj = record.get(this.getColumns()[0]);
                    if (obj == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.types.VectorValue<*>");
                    }
                    double[] doubleArray = vaPlus.convertToDoubleArray((VectorValue)obj);
                    RealMatrix dataMatrix = MatrixUtils.createRealMatrix((double[][])new double[][]{doubleArray});
                    double[] vector = kltMatrixBar.multiply(dataMatrix.transpose()).getColumnVector(0).toArray();
                    Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"vector");
                    int[] signature = vaPlus.getCells(vector, marks);
                    VAPlusIndex.this.signatures.add((Object)new VAPlusSignature(record.getTupleId(), signature));
                }
                VAPlusMeta meta = new VAPlusMeta(marks, signatureGenerator, kltMatrix);
                VAPlusIndex.this.meta.set((Object)meta);
                Unit $i$a$-read-VAPlusIndex$Tx$rebuild$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Void update(@NotNull Collection<DataChangeEvent> update) {
            Intrinsics.checkNotNullParameter(update, (String)"update");
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForWrite();
                boolean bl2 = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            catch (Throwable throwable) {
                $this$read$iv.unlock(stamp$iv);
                throw throwable;
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new CloseableIterator<Record>(this, predicate){
                private final KnnPredicate<?> predicate;
                private final long stamp;
                private volatile boolean closed;
                private final VAPlus vaPlus;
                private final VAPlusMeta meta;
                @NotNull
                private final MinHeapSelection<ComparablePair<Pair<Long, DoubleValue>, DoubleValue>>[] heapsP1;
                @NotNull
                private final MinHeapSelection<ComparablePair<Long, DoubleValue>>[] heapsP2;
                @NotNull
                private final int[] d;
                @NotNull
                private final List<Pair<Pair<int[], float[]>, Pair<int[], float[]>>> queryBounds;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                @NotNull
                public final MinHeapSelection<ComparablePair<Pair<Long, DoubleValue>, DoubleValue>>[] getHeapsP1() {
                    return this.heapsP1;
                }

                @NotNull
                public final MinHeapSelection<ComparablePair<Long, DoubleValue>>[] getHeapsP2() {
                    return this.heapsP2;
                }

                @NotNull
                public final int[] getD() {
                    return this.d;
                }

                @NotNull
                public final List<Pair<Pair<int[], float[]>, Pair<int[], float[]>>> getQueryBounds() {
                    return this.queryBounds;
                }

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of hasNext(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    String string = "Not yet implemented";
                    bl2 = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                }

                @NotNull
                public Record next() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    String string = "Not yet implemented";
                    bl2 = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
                }

                public void close() {
                    if (!this.closed) {
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.stamp);
                        this.closed = true;
                    }
                }
                {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    int it;
                    MinHeapSelection<T> minHeapSelection;
                    Object object;
                    int n;
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof KnnPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.VAPlusIndex.this.getName() + "' (vaf-index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)$captured_local_variable$1;
                    Tx.access$checkValidForRead(this$0);
                    if (Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)this.predicate.getColumns())), this$0.VAPlusIndex.this.getColumns()[0])) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.VAPlusIndex.this.getName() + "' (vaf-index) does not support the provided predicate.");
                    }
                    this.stamp = Tx.access$getLocalLock$p(this$0).readLock();
                    this.vaPlus = new VAPlus();
                    this.meta = (VAPlusMeta)VAPlusIndex.access$getMeta$p(this$0.VAPlusIndex.this).get();
                    int n2 = this.predicate.getQuery().size();
                    filter.1 var20_5 = this;
                    Object[] objectArray = new MinHeapSelection[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = n3;
                        n = n3++;
                        object = objectArray;
                        boolean bl = false;
                        object[n] = minHeapSelection = new MinHeapSelection<T>(5 * this.predicate.getK());
                    }
                    object = objectArray;
                    var20_5.heapsP1 = object;
                    n2 = this.predicate.getQuery().size();
                    var20_5 = this;
                    objectArray = new MinHeapSelection[n2];
                    n3 = 0;
                    while (n3 < n2) {
                        it = n3;
                        n = n3++;
                        object = objectArray;
                        boolean bl = false;
                        object[n] = minHeapSelection = new MinHeapSelection<T>(this.predicate.getK());
                    }
                    object = objectArray;
                    var20_5.heapsP2 = object;
                    n2 = this.predicate.getQuery().size();
                    var20_5 = this;
                    objectArray = new int[n2];
                    n3 = 0;
                    while (n3 < n2) {
                        it = n3;
                        n = n3++;
                        object = objectArray;
                        boolean bl = false;
                        int n5 = Integer.MAX_VALUE;
                        object[n] = (MinHeapSelection)n5;
                    }
                    object = objectArray;
                    var20_5.d = (int[])object;
                    Iterable iterable = this.predicate.getQuery();
                    var20_5 = this;
                    boolean $i$f$map = false;
                    void var5_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void ubIndex;
                        void lbIndex;
                        void it2;
                        VectorValue vectorValue = (VectorValue)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        RealMatrix dataMatrix = MatrixUtils.createRealMatrix((double[][])new double[][]{this.vaPlus.convertToDoubleArray((VectorValue<?>)it2)});
                        double[] vector = this.meta.getKltMatrix().multiply(dataMatrix.transpose()).getColumnVector(0).toArray();
                        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"vector");
                        Pair<double[][], double[][]> bounds = this.vaPlus.computeBounds(vector, this.meta.getMarks());
                        Object object2 = this.vaPlus.compressBounds((double[][])bounds.getFirst());
                        int[] nArray = (int[])object2.component1();
                        float[] lbBounds = (float[])object2.component2();
                        Pair<int[], float[]> pair = this.vaPlus.compressBounds((double[][])bounds.getSecond());
                        object2 = (int[])pair.component1();
                        float[] ubBounds = (float[])pair.component2();
                        Pair pair2 = new Pair((Object)new Pair((Object)lbIndex, (Object)lbBounds), (Object)new Pair((Object)ubIndex, (Object)ubBounds));
                        object.add(pair2);
                    }
                    object = (List)destination$iv$iv;
                    var20_5.queryBounds = object;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        protected void performCommit() {
            VAPlusIndex.this.db.commit();
        }

        @Override
        protected void performRollback() {
            VAPlusIndex.this.db.rollback();
        }

        @Override
        protected void cleanup() {
        }

        public Tx(Entity.Tx parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(VAPlusIndex.this, parent);
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.getLocalLock();
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "META_FIELD_NAME", "", "SIGNATURE_FIELD_NAME", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

