/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.vaplus;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.index.vaplus.SignatureGenerator;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusMeta;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusMetaSerializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusMeta;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
public final class VAPlusMetaSerializer
implements Serializer<VAPlusMeta> {
    public static final VAPlusMetaSerializer INSTANCE;

    public void serialize(@NotNull DataOutput2 out, @NotNull VAPlusMeta value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        out.packInt(((Object[])value.getMarks()).length);
        for (double[] mark : value.getMarks()) {
            out.packInt(mark.length);
            for (double m : mark) {
                out.writeDouble(m);
            }
        }
        out.packInt(value.getSignatureGenerator().getNumberOfBitsPerDimension().length);
        for (int bits : value.getSignatureGenerator().getNumberOfBitsPerDimension()) {
            out.writeInt(bits);
        }
        out.packInt(((Object[])value.getKltMatrix().getData()).length);
        for (double[] kltM : value.getKltMatrix().getData()) {
            out.packInt(kltM.length);
            for (double klt : kltM) {
                out.writeDouble(klt);
            }
        }
    }

    @NotNull
    public VAPlusMeta deserialize(@NotNull DataInput2 input, int available) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n7 = input.unpackInt();
        double[][] dArrayArray = new double[n7][];
        for (int i = 0; i < n7; ++i) {
            n6 = i;
            n5 = i;
            object = dArrayArray;
            n4 = 0;
            int n8 = input.unpackInt();
            double[] dArray = new double[n8];
            n3 = 0;
            while (n3 < n8) {
                double d;
                int n9 = n3;
                n2 = n3++;
                double[] dArray2 = dArray;
                boolean bl = false;
                dArray2[n2] = d = input.readDouble();
            }
            double[] dArray3 = dArray;
            object[n5] = dArray3;
        }
        double[][] marks = dArrayArray;
        int n10 = input.unpackInt();
        int[] nArray = new int[n10];
        n6 = 0;
        while (n6 < n10) {
            n4 = n6;
            n5 = n6++;
            object = nArray;
            n = 0;
            int n11 = input.readInt();
            object[n5] = (double[])n11;
        }
        int[] signatureGenerator = nArray;
        int n12 = input.unpackInt();
        double[][] dArrayArray2 = new double[n12][];
        for (int i = 0; i < n12; ++i) {
            n = i;
            n5 = i;
            object = dArrayArray2;
            boolean bl = false;
            n3 = input.unpackInt();
            double[] dArray = new double[n3];
            n2 = 0;
            while (n2 < n3) {
                double d;
                int n13 = n2;
                int n14 = n2++;
                double[] dArray4 = dArray;
                boolean bl2 = false;
                dArray4[n14] = d = input.readDouble();
            }
            double[] dArray5 = dArray;
            object[n5] = dArray5;
        }
        double[][] kltMatrix = dArrayArray2;
        SignatureGenerator signatureGenerator2 = new SignatureGenerator(signatureGenerator);
        RealMatrix realMatrix = MatrixUtils.createRealMatrix((double[][])kltMatrix);
        Intrinsics.checkNotNullExpressionValue((Object)realMatrix, (String)"MatrixUtils.createRealMatrix(kltMatrix)");
        return new VAPlusMeta(marks, signatureGenerator2, realMatrix);
    }

    private VAPlusMetaSerializer() {
    }

    static {
        VAPlusMetaSerializer vAPlusMetaSerializer;
        INSTANCE = vAPlusMetaSerializer = new VAPlusMetaSerializer();
    }
}

