/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.vaplus;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.index.vaplus.VAPlusSignature;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusSignatureSerializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/vaplus/VAPlusSignature;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
public final class VAPlusSignatureSerializer
implements Serializer<VAPlusSignature> {
    public static final VAPlusSignatureSerializer INSTANCE;

    public void serialize(@NotNull DataOutput2 out, @NotNull VAPlusSignature value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int[] signatureArray = value.getSignature();
        out.writeLong(value.getTupleId());
        out.packInt(signatureArray.length);
        for (int signature : signatureArray) {
            out.writeInt(signature);
        }
    }

    @NotNull
    public VAPlusSignature deserialize(@NotNull DataInput2 input, int available) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long tupleId = input.readLong();
        int n = input.unpackInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            nArray2[n5] = n3 = input.readInt();
        }
        int[] signature = nArray;
        return new VAPlusSignature(tupleId, signature);
    }

    private VAPlusSignatureSerializer() {
    }

    static {
        VAPlusSignatureSerializer vAPlusSignatureSerializer;
        INSTANCE = vAPlusSignatureSerializer = new VAPlusSignatureSerializer();
    }
}

