/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning.nodes.physical.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.NullaryPhysicalNodeExpression;
import org.vitrivr.cottontail.execution.ExecutionEngine;
import org.vitrivr.cottontail.execution.operators.sources.EntityScanOperator;
import org.vitrivr.cottontail.model.basics.ColumnDef;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u0000H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0014\u0010\"\u001a\u00020#2\n\u0010$\u001a\u00060%R\u00020&H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/sources/EntityScanPhysicalNodeExpression;", "Lorg/vitrivr/cottontail/database/queries/planning/nodes/physical/NullaryPhysicalNodeExpression;", "entity", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "range", "Lkotlin/ranges/LongRange;", "(Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;Lkotlin/ranges/LongRange;)V", "canBePartitioned", "", "getCanBePartitioned", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getCost", "()Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getEntity", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "outputSize", "", "getOutputSize", "()J", "getRange", "()Lkotlin/ranges/LongRange;", "copy", "partition", "", "p", "", "toOperator", "Lorg/vitrivr/cottontail/execution/operators/sources/EntityScanOperator;", "context", "Lorg/vitrivr/cottontail/execution/ExecutionEngine$ExecutionContext;", "Lorg/vitrivr/cottontail/execution/ExecutionEngine;", "cottontaildb"})
public final class EntityScanPhysicalNodeExpression
extends NullaryPhysicalNodeExpression {
    private final long outputSize;
    private final boolean canBePartitioned;
    @NotNull
    private final Cost cost;
    @NotNull
    private final Entity entity;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final LongRange range;

    @Override
    public long getOutputSize() {
        return this.outputSize;
    }

    @Override
    public boolean getCanBePartitioned() {
        return this.canBePartitioned;
    }

    @Override
    @NotNull
    public Cost getCost() {
        return this.cost;
    }

    @Override
    @NotNull
    public EntityScanPhysicalNodeExpression copy() {
        return new EntityScanPhysicalNodeExpression(this.entity, this.columns, this.range);
    }

    @Override
    @NotNull
    public EntityScanOperator toOperator(@NotNull ExecutionEngine.ExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new EntityScanOperator(context, this.entity, this.columns, this.range);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<NullaryPhysicalNodeExpression> partition(int p) {
        void $this$mapTo$iv$iv;
        long partitionSize = Math.floorDiv(this.range.getLast() - this.range.getFirst() + 1L, (long)p);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)p);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long start = this.range.getFirst() + (long)it * partitionSize;
            long l = ((long)it + 1L) * partitionSize;
            long l2 = this.range.getLast();
            boolean bl2 = false;
            long end = this.range.getFirst() + Math.min(l, l2);
            EntityScanPhysicalNodeExpression entityScanPhysicalNodeExpression = new EntityScanPhysicalNodeExpression(this.entity, this.columns, RangesKt.until((long)start, (long)end));
            collection.add(entityScanPhysicalNodeExpression);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @NotNull
    public final LongRange getRange() {
        return this.range;
    }

    public EntityScanPhysicalNodeExpression(@NotNull Entity entity, @NotNull ColumnDef<?>[] columns, @NotNull LongRange range) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.entity = entity;
        this.columns = columns;
        this.range = range;
        boolean bl = this.range.getFirst() > 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Start of a ranged entity scan must be greater than zero.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.outputSize = this.range.getLast() - this.range.getFirst();
        this.canBePartitioned = true;
        this.cost = new Cost((float)(this.getOutputSize() * (long)this.columns.length) * 1.0E-4f, (float)this.getOutputSize() * Cost.Companion.getCOST_MEMORY_ACCESS(), 0.0f, 4, null);
    }

    public /* synthetic */ EntityScanPhysicalNodeExpression(Entity entity, ColumnDef[] columnDefArray, LongRange longRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Collection<ColumnDef<?>> $this$toTypedArray$iv = entity.allColumns();
            boolean $i$f$toTypedArray = false;
            Collection<ColumnDef<?>> thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray2 = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            columnDefArray = columnDefArray2;
        }
        if ((n & 4) != 0) {
            long l = 1L;
            longRange = new LongRange(l, entity.getStatistics().getMaxTupleId());
        }
        this(entity, columnDefArray, longRange);
    }
}

