/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.schema;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.column.mapdb.MapDBColumn;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityHeader;
import org.vitrivr.cottontail.database.entity.EntityHeaderSerializer;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.database.schema.SchemaHeader;
import org.vitrivr.cottontail.database.schema.SchemaHeaderSerializer;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 72\u00020\u0001:\u00017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010.\u001a\u00020/H\u0016J/\u00100\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u00142\u001a\u00101\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030302\"\u0006\u0012\u0002\b\u000303\u00a2\u0006\u0002\u00104J\u000e\u00105\u001a\u00020/2\u0006\u0010\u0002\u001a\u00020\u0014J\u000e\u00106\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/database/schema/Schema;", "Lorg/vitrivr/cottontail/database/general/DBO;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "(Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/catalogue/Catalogue;)V", "cacheLock", "Ljava/util/concurrent/locks/ReentrantLock;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "entities", "", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "getEntities", "()Ljava/util/List;", "entityLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "header", "Lorg/vitrivr/cottontail/database/schema/SchemaHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/schema/SchemaHeader;", "loaded", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/vitrivr/cottontail/model/basics/Name;", "Ljava/lang/ref/SoftReference;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "getParent", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getPath", "()Ljava/nio/file/Path;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/CottontailStoreWAL;", "close", "", "createEntity", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "dropEntity", "entityForName", "Companion", "cottontaildb"})
public final class Schema
implements DBO {
    private final CottontailStoreWAL store;
    private final StampedLock closeLock;
    private final ReentrantReadWriteLock entityLock;
    private final ReentrantLock cacheLock;
    private final ConcurrentHashMap<Name, SoftReference<Entity>> loaded;
    private volatile boolean closed;
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final Path path;
    @NotNull
    private final Catalogue parent;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "index.db";
    public static final Companion Companion = new Companion(null);

    private final SchemaHeader getHeader() {
        SchemaHeader schemaHeader = (SchemaHeader)this.store.get(1L, SchemaHeaderSerializer.INSTANCE);
        if (schemaHeader == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of schema " + this.getName() + '!');
        }
        return schemaHeader;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Name.EntityName> getEntities() {
        void $this$mapTo$iv$iv;
        long[] $this$map$iv = this.getHeader().getEntities();
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = var6_6[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name.SchemaName schemaName = this.getName();
            GroupSerializer groupSerializer = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.STRING");
            String string = (String)this.store.get((long)it, (Serializer)groupSerializer);
            if (string == null) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to read schema " + this.getName() + " (" + this.getPath() + "): Could not find entity name of ID " + (long)it + '.');
            }
            Name.EntityName entityName = schemaName.entity(string);
            collection.add(entityName);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.entityLock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            n = this.getHeader().getEntities().length;
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void createEntity(@NotNull Name.EntityName name, ColumnDef<?> ... columns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            int n;
            int n2;
            ColumnDef<?> it;
            ColumnDef<?>[] $this$mapTo$iv$iv;
            boolean bl = false;
            if (this.getClosed()) {
                throw (Throwable)new IllegalStateException("Schema " + this.getName() + " has been closed and cannot be used anymore.");
            }
            ColumnDef<?>[] $this$map$iv = columns;
            boolean $i$f$map = false;
            ColumnDef<?>[] columnDefArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (ColumnDef<?> item$iv$iv : $this$mapTo$iv$iv) {
                void var17_26 = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Name.ColumnName columnName = it.getName();
                collection.add(columnName);
            }
            if (CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size() != columns.length) {
                Collection<Name.ColumnName> collection;
                $this$map$iv = columns;
                Name.EntityName entityName = name;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.length);
                $i$f$mapTo = false;
                ColumnDef<?>[] columnDefArray2 = $this$mapTo$iv$iv;
                n2 = columnDefArray2.length;
                for (n = 0; n < n2; ++n) {
                    ColumnDef<?> item$iv$iv;
                    it = item$iv$iv = columnDefArray2[n];
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Name.ColumnName columnName = it.getName();
                    collection.add(columnName);
                }
                collection = (List)destination$iv$iv;
                Collection collection2 = collection;
                Name.EntityName entityName2 = entityName;
                throw (Throwable)new DatabaseException.DuplicateColumnException(entityName2, collection2);
            }
            if (this.getEntities().contains(name)) {
                throw (Throwable)new DatabaseException.EntityAlreadyExistsException(name);
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this.entityLock;
            boolean bl4 = false;
            boolean bl5 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl6 = false;
            int n4 = 0;
            n4 = 0;
            n2 = n3;
            while (n4 < n2) {
                n = n4++;
                boolean bl7 = false;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl8 = false;
                Path data = this.getPath().resolve("entity_" + name.getSimple());
                try {
                    void $this$mapTo$iv$iv22;
                    if (Files.exists(data, new LinkOption[0])) {
                        throw (Throwable)new DatabaseException("Failed to create entity '" + name + "'. Data directory '" + data + "' seems to be occupied.");
                    }
                    Files.createDirectories(data, new FileAttribute[0]);
                    String string = name.getSimple();
                    GroupSerializer groupSerializer = Serializer.STRING;
                    Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.STRING");
                    long recId = this.store.put(string, (Serializer)groupSerializer);
                    MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
                    Path path = data.resolve(FILE_CATALOGUE);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"data.resolve(Entity.FILE_CATALOGUE)");
                    CottontailStoreWAL store = mapDBConfig.store(path);
                    store.preallocate();
                    ColumnDef<?>[] $this$map$iv2 = columns;
                    boolean $i$f$map22 = false;
                    ColumnDef<?>[] columnDefArray3 = $this$map$iv2;
                    Collection destination$iv$iv22 = new ArrayList($this$map$iv2.length);
                    boolean $i$f$mapTo2 = false;
                    void var32_54 = $this$mapTo$iv$iv22;
                    int n5 = ((void)var32_54).length;
                    for (int i = 0; i < n5; ++i) {
                        void it2;
                        void item$iv$iv;
                        void var36_58 = item$iv$iv = var32_54[i];
                        Collection collection = destination$iv$iv22;
                        boolean bl9 = false;
                        Path path2 = data;
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"data");
                        MapDBColumn.Companion.initialize((ColumnDef<?>)it2, path2, this.getParent().getConfig().getMapdb());
                        String string2 = it2.getName().getSimple();
                        GroupSerializer groupSerializer2 = Serializer.STRING;
                        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer2, (String)"Serializer.STRING");
                        Long l = store.put(string2, (Serializer)groupSerializer2);
                        collection.add(l);
                    }
                    long[] columnIds = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv22));
                    store.update(1L, new EntityHeader(0L, 0L, 0L, columnIds, null, 23, null), EntityHeaderSerializer.INSTANCE);
                    store.commit();
                    store.close();
                    SchemaHeader header = this.getHeader();
                    header.setModified(System.currentTimeMillis());
                    long[] $i$f$map22 = header.getEntities();
                    int $this$mapTo$iv$iv22 = header.getEntities().length + 1;
                    boolean destination$iv$iv22 = false;
                    long[] lArray = Arrays.copyOf($i$f$map22, $this$mapTo$iv$iv22);
                    Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"java.util.Arrays.copyOf(this, newSize)");
                    header.setEntities(lArray);
                    header.getEntities()[header.getEntities().length - 1] = recId;
                    this.store.update(1L, header, SchemaHeaderSerializer.INSTANCE);
                    this.store.commit();
                }
                catch (DBException e) {
                    List pathsToDelete;
                    this.store.rollback();
                    List list = pathsToDelete = Files.walk(data, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"pathsToDelete");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Path it3 = (Path)element$iv;
                        boolean bl10 = false;
                        Files.delete(it3);
                    }
                    throw (Throwable)new DatabaseException("Failed to create entity '" + name + "' due to error in the underlying data store: {" + e.getMessage());
                }
                catch (IOException e) {
                    throw (Throwable)new DatabaseException("Failed to create entity '" + name + "' due to an IO exception: {" + e.getMessage());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n2 = 0;
                n = 0;
                n = 0;
                int n6 = n3;
                while (n < n6) {
                    int n7 = n++;
                    boolean bl11 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void dropEntity(@NotNull Name.EntityName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            int n;
            int n2;
            boolean $i$a$-read-Schema$dropEntity$22 = false;
            if (this.getClosed()) {
                throw (Throwable)new IllegalStateException("Schema " + this.getName() + " has been closed and cannot be used anymore.");
            }
            ReentrantReadWriteLock reentrantReadWriteLock = this.entityLock;
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                List pathsToDelete;
                Object object;
                Object object2;
                Object item$iv$iv;
                Iterator $this$mapTo$iv$iv;
                Long l;
                Object object3;
                block20: {
                    boolean bl4 = false;
                    long[] lArray = this.getHeader().getEntities();
                    boolean bl5 = false;
                    long[] lArray2 = lArray;
                    boolean bl6 = false;
                    object3 = lArray2;
                    int n6 = ((long[])object3).length;
                    for (int i = 0; i < n6; ++i) {
                        long l2;
                        long it = l2 = object3[i];
                        boolean bl7 = false;
                        GroupSerializer groupSerializer = Serializer.STRING;
                        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.STRING");
                        if (!Intrinsics.areEqual((Object)((String)this.store.get(it, (Serializer)groupSerializer)), (Object)name.getSimple())) continue;
                        l = l2;
                        break block20;
                    }
                    l = null;
                }
                if (l == null) {
                    throw (Throwable)new DatabaseException.EntityDoesNotExistException(name);
                }
                long entityRecId = l;
                Entity entity = this.entityForName(name);
                Iterable $this$map$iv = entity.allIndexes();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    item$iv$iv = iterator2.next();
                    Index index = (Index)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl8 = false;
                    object = it.getName();
                    object2.add(object);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Name.IndexName it = (Name.IndexName)element$iv;
                    boolean bl9 = false;
                    entity.dropIndex(it);
                }
                SoftReference<Entity> softReference = this.loaded.remove(name);
                if (softReference != null && (softReference = softReference.get()) != null) {
                    ((Entity)((Object)softReference)).close();
                }
                try {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Object element$iv;
                    GroupSerializer groupSerializer = Serializer.STRING;
                    Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.STRING");
                    this.store.delete(entityRecId, (Serializer)groupSerializer);
                    SchemaHeader header = this.getHeader();
                    header.setModified(System.currentTimeMillis());
                    long[] $i$f$forEach2 = header.getEntities();
                    object2 = header;
                    boolean $i$f$filter = false;
                    element$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    item$iv$iv = $this$filterTo$iv$iv;
                    int n7 = ((T)item$iv$iv).length;
                    for (int i = 0; i < n7; ++i) {
                        Object element$iv$iv;
                        Object it = element$iv$iv = item$iv$iv[i];
                        boolean bl10 = false;
                        if (!(it != entityRecId)) continue;
                        destination$iv$iv2.add(Long.valueOf(element$iv$iv));
                    }
                    object = (List)destination$iv$iv2;
                    ((SchemaHeader)object2).setEntities(CollectionsKt.toLongArray((Collection)((Collection)object)));
                    this.store.update(1L, header, SchemaHeaderSerializer.INSTANCE);
                    this.store.commit();
                }
                catch (DBException e) {
                    this.store.rollback();
                    throw (Throwable)new DatabaseException("Entity '" + name + "' could not be dropped, because of an error in the underlying data store: " + e.getMessage() + '!');
                }
                List list = pathsToDelete = Files.walk(this.getPath().resolve("entity_" + name.getSimple()), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"pathsToDelete");
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach3 = false;
                object3 = $this$forEach$iv2.iterator();
                while (object3.hasNext()) {
                    Object element$iv = object3.next();
                    Path it = (Path)element$iv;
                    boolean bl11 = false;
                    Files.deleteIfExists(it);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n8 = n2++;
                    boolean bl12 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
            Unit $i$a$-read-Schema$dropEntity$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final Entity entityForName(@NotNull Name.EntityName name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-Schema$close$22 = false;
            if (!this.getClosed()) {
                Lock lock = this.cacheLock;
                boolean bl = false;
                boolean bl2 = false;
                lock.lock();
                try {
                    boolean bl3 = false;
                    bl2 = this.loaded.entrySet().removeIf(close.1.1.1.INSTANCE);
                }
                finally {
                    lock.unlock();
                }
                this.store.close();
                this.closed = true;
            }
            Unit $i$a$-read-Schema$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Catalogue getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public Schema(@NotNull Name.SchemaName name, @NotNull Path path, @NotNull Catalogue parent) {
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.path = path;
        this.parent = parent;
        Schema schema = this;
        try {
            Schema schema2 = schema;
            MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
            Path path2 = this.getPath().resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(FILE_CATALOGUE)");
            cottontailStoreWAL = mapDBConfig.store(path2);
        }
        catch (DBException dBException) {
            void e;
            Schema schema3 = schema;
            throw (Throwable)new DatabaseException("Failed to open schema " + this.getName() + " at '" + this.getPath() + "': " + e.getMessage() + '\'');
        }
        schema2.store = cottontailStoreWAL;
        this.closeLock = new StampedLock();
        this.entityLock = new ReentrantReadWriteLock();
        this.cacheLock = new ReentrantLock();
        this.loaded = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/database/schema/Schema$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

