/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.basics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001d\u0010\u0013\u001a\u00020\u00002\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0000H&J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0016J(\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0010H\u0016J\u001f\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0016\u0010!\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010\u00100\"H\u0016R\u001e\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/model/basics/Record;", "", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "size", "", "getSize", "()I", "tupleId", "", "getTupleId", "()J", "values", "Lorg/vitrivr/cottontail/model/values/types/Value;", "getValues", "()[Lorg/vitrivr/cottontail/model/values/types/Value;", "assign", "([Lorg/vitrivr/cottontail/model/values/types/Value;)Lorg/vitrivr/cottontail/model/basics/Record;", "copy", "first", "get", "T", "column", "(Lorg/vitrivr/cottontail/model/basics/ColumnDef;)Lorg/vitrivr/cottontail/model/values/types/Value;", "has", "", "last", "set", "", "value", "toMap", "", "Lorg/vitrivr/cottontail/model/basics/Name;", "cottontaildb"})
public interface Record {
    public long getTupleId();

    @NotNull
    public ColumnDef<?>[] getColumns();

    @NotNull
    public Value[] getValues();

    public int getSize();

    @Nullable
    public Value first();

    @Nullable
    public Value last();

    @NotNull
    public Record copy();

    @NotNull
    public Record assign(@NotNull Value[] var1);

    public boolean has(@NotNull ColumnDef<?> var1);

    @NotNull
    public Map<Name, Value> toMap();

    @Nullable
    public <T extends Value> T get(@NotNull ColumnDef<T> var1);

    public void set(@NotNull ColumnDef<?> var1, @Nullable Value var2);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static int getSize(@NotNull Record $this) {
            return $this.getColumns().length;
        }

        @Nullable
        public static Value first(@NotNull Record $this) {
            return (Value)ArraysKt.first((Object[])$this.getValues());
        }

        @Nullable
        public static Value last(@NotNull Record $this) {
            return (Value)ArraysKt.last((Object[])$this.getValues());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Record assign(@NotNull Record $this, @NotNull Value[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            boolean bl = $this.getValues().length == $this.getColumns().length;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The number of values must be equal to the number of columns held by this record (v = " + $this.getValues().length + ", c = " + $this.getColumns().length + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value[] $this$forEachIndexed$iv = values;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Value item$iv : $this$forEachIndexed$iv) {
                void v;
                int n = index$iv++;
                Value value = item$iv;
                int i = n;
                boolean bl5 = false;
                $this.getColumns()[i].validateOrThrow((Value)v);
                $this.getValues()[i] = v;
            }
            return $this;
        }

        /*
         * WARNING - void declaration
         */
        public static boolean has(@NotNull Record $this, @NotNull ColumnDef<?> column) {
            int n;
            block2: {
                Intrinsics.checkNotNullParameter(column, (String)"column");
                ColumnDef<?>[] $this$indexOfFirst$iv = $this.getColumns();
                boolean $i$f$indexOfFirst = false;
                int n2 = 0;
                int n3 = $this$indexOfFirst$iv.length;
                while (n2 < n3) {
                    void index$iv;
                    ColumnDef<?> it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, column)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n > -1;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Map<Name, Value> toMap(@NotNull Record $this) {
            void $this$mapIndexedTo$iv$iv;
            ColumnDef<?>[] $this$mapIndexed$iv = $this.getColumns();
            boolean $i$f$mapIndexed = false;
            ColumnDef<?>[] columnDefArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void column;
                int n = index$iv$iv++;
                void var11_11 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Pair pair = new Pair((Object)column.getName(), (Object)$this.getValues()[index]);
                collection.add(pair);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            if (pairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return MapsKt.mapOf((Pair[])Arrays.copyOf(pairArray, pairArray.length));
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public static <T extends Value> T get(@NotNull Record $this, @NotNull ColumnDef<T> column) {
            int n;
            int n2;
            block3: {
                Intrinsics.checkNotNullParameter(column, (String)"column");
                ColumnDef<?>[] $this$indexOfFirst$iv = $this.getColumns();
                boolean $i$f$indexOfFirst = false;
                n2 = 0;
                int n3 = $this$indexOfFirst$iv.length;
                while (n2 < n3) {
                    void index$iv;
                    ColumnDef<?> it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, column)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index = n;
            boolean bl = index > -1;
            boolean bl2 = false;
            n2 = 0;
            if (!bl) {
                boolean bl3 = false;
                String string = "The specified column " + column.getName() + "  (type=" + column.getType().getName() + ")  is not contained in this record.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return column.getType().cast($this.getValues()[index]);
        }

        /*
         * WARNING - void declaration
         */
        public static void set(@NotNull Record $this, @NotNull ColumnDef<?> column, @Nullable Value value) {
            int n;
            int n2;
            block3: {
                Intrinsics.checkNotNullParameter(column, (String)"column");
                ColumnDef<?>[] $this$indexOfFirst$iv = $this.getColumns();
                boolean $i$f$indexOfFirst = false;
                n2 = 0;
                int n3 = $this$indexOfFirst$iv.length;
                while (n2 < n3) {
                    void index$iv;
                    ColumnDef<?> it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, column)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int index = n;
            boolean bl = index > -1;
            boolean bl2 = false;
            n2 = 0;
            if (!bl) {
                boolean bl3 = false;
                String string = "The specified column " + column.getName() + "  (type=" + column.getType().getName() + ")  is not contained in this record.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            column.validateOrThrow(value);
            $this.getValues()[index] = value;
        }
    }
}

