/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.ProtocolStringList;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.column.ColumnType;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.grpc.CottonDDLGrpc;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.server.grpc.helper.ExtensionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0016J\u001e\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0016J\u001e\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00110\fH\u0016J\u001e\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDDLService;", "Lorg/vitrivr/cottontail/grpc/CottonDDLGrpc$CottonDDLImplBase;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "createEntity", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDefinition;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Status;", "createIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$IndexDefinition;", "createSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Schema;", "dropEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Entity;", "dropIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Index;", "dropSchema", "entityDetails", "listEntities", "listIndexes", "listSchemas", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Empty;", "optimize", "rebuildIndex", "truncate", "Companion", "cottontaildb"})
public final class CottonDDLService
extends CottonDDLGrpc.CottonDDLImplBase {
    @NotNull
    private final Catalogue catalogue;
    private static final Logger LOGGER;
    public static final Companion Companion;

    public void createSchema(@NotNull CottontailGrpc.Schema request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.SchemaName schemaName = ExtensionsKt.fqn(request);
            LOGGER.trace("Creating schema {}", (Object)schemaName);
            this.catalogue.createSchema(schemaName);
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaAlreadyExistsException e) {
            LOGGER.error("Error while creating schema", (Throwable)e);
            responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription("Schema '" + request.getName() + "' cannot be created because it already exists!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while creating schema", (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to create schema '" + request.getName() + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while creating schema", e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to create schema '" + request.getName() + "' 'because unknown error: " + e.getMessage()).asException());
        }
    }

    public void dropSchema(@NotNull CottontailGrpc.Schema request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.SchemaName schemaName = ExtensionsKt.fqn(request);
            LOGGER.trace("Dropping schema {}", (Object)schemaName);
            this.catalogue.dropSchema(schemaName);
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while dropping schema '" + request.getName() + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Schema '" + request.getName() + "' does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while dropping schema '" + request.getName() + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop schema '" + request.getName() + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while dropping schema '" + request.getName() + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop schema '" + request.getName() + "' because unknown error: " + e.getMessage()).asException());
        }
    }

    public void listSchemas(@NotNull CottontailGrpc.Empty request, @NotNull StreamObserver<CottontailGrpc.Schema> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Iterable $this$forEach$iv = this.catalogue.getSchemas();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Name.SchemaName it = (Name.SchemaName)element$iv;
                boolean bl = false;
                responseObserver.onNext((Object)CottontailGrpc.Schema.newBuilder().setName(it.getSimple()).build());
            }
            responseObserver.onCompleted();
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while listing schemas", (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to list schemas because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while listing schemas", e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to list schemas because of unknown error: " + e.getMessage()).asException());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createEntity(@NotNull CottontailGrpc.EntityDefinition request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            void $this$mapTo$iv$iv;
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            Name.EntityName entityName = ExtensionsKt.fqn(entity);
            LOGGER.trace("Creating entity {}...", (Object)entityName);
            Schema schema = this.catalogue.schemaForName(entityName.schema());
            List list = request.getColumnsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.columnsList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CottontailGrpc.ColumnDefinition columnDefinition = (CottontailGrpc.ColumnDefinition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                ColumnType<?> type = ColumnType.Companion.forName(v2.getType().name());
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                Name.ColumnName name = entityName.column(string);
                ColumnDef columnDef = new ColumnDef(name, type, it.getLength(), it.getNullable());
                collection.add(columnDef);
            }
            List columns = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = columns;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            schema.createEntity(entityName, Arrays.copyOf(columnDefArray, columnDefArray.length));
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating entity '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(entity)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder2 = new StringBuilder().append("Schema '");
            CottontailGrpc.Entity entity2 = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity2, (String)"request.entity");
            CottontailGrpc.Schema schema = entity2.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.entity.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder2.append(schema.getName()).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityAlreadyExistsException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating entity '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(entity)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder3 = new StringBuilder().append("Entity '");
            CottontailGrpc.Entity entity3 = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity3, (String)"request.entity");
            responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(stringBuilder3.append(ExtensionsKt.fqn(entity3)).append(" does already exist!").toString()).asException());
        }
        catch (DatabaseException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating entity '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(entity)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder4 = new StringBuilder().append("Failed to create entity '");
            CottontailGrpc.Entity entity4 = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity4, (String)"request.entity");
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(stringBuilder4.append(ExtensionsKt.fqn(entity4)).append("' because of database error: ").append(e.getMessage()).toString()).asException());
        }
        catch (Throwable e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating entity '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(entity)).append('\'').toString(), e);
            StringBuilder stringBuilder5 = new StringBuilder().append("Failed to create entity '");
            CottontailGrpc.Entity entity5 = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity5, (String)"request.entity");
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(stringBuilder5.append(ExtensionsKt.fqn(entity5)).append("' because of unknown error: ").append(e.getMessage()).toString()).asException());
        }
    }

    public void entityDetails(@NotNull CottontailGrpc.Entity request, @NotNull StreamObserver<CottontailGrpc.EntityDefinition> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.EntityName entityName = ExtensionsKt.fqn(request);
            Entity entity = this.catalogue.schemaForName(entityName.schema()).entityForName(entityName);
            CottontailGrpc.EntityDefinition.Builder def = CottontailGrpc.EntityDefinition.newBuilder().setEntity(request);
            for (ColumnDef<?> c : entity.allColumns()) {
                def.addColumns(CottontailGrpc.ColumnDefinition.newBuilder().setName(c.getName().getSimple()).setNullable(c.getNullable()).setLength(c.getLogicalSize()).setType(CottontailGrpc.Type.valueOf((String)c.getType().getName())));
            }
            responseObserver.onNext((Object)def.build());
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while fetching information for entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Schema schema = request.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append("' does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while fetching information for entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Entity '" + ExtensionsKt.fqn(request) + "' does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while fetching information for entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop entity '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while fetching information for entity '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop entity '" + ExtensionsKt.fqn(request) + "' because of unknown error: " + e.getMessage()).asException());
        }
    }

    public void dropEntity(@NotNull CottontailGrpc.Entity request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.EntityName entityName = ExtensionsKt.fqn(request);
            LOGGER.trace("Dropping entity {}...", (Object)entityName);
            this.catalogue.schemaForName(entityName.schema()).dropEntity(entityName);
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while dropping entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Schema schema = request.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append("' does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while dropping entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Entity '" + ExtensionsKt.fqn(request) + "' does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while dropping entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop entity '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while dropping entity '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop entity '" + ExtensionsKt.fqn(request) + "' because of unknown error: " + e.getMessage()).asException());
        }
    }

    public void listEntities(@NotNull CottontailGrpc.Schema request, @NotNull StreamObserver<CottontailGrpc.Entity> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.SchemaName schemaName = ExtensionsKt.fqn(request);
            CottontailGrpc.Entity.Builder builder = CottontailGrpc.Entity.newBuilder();
            Iterable $this$forEach$iv = this.catalogue.schemaForName(schemaName).getEntities();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Name.EntityName it = (Name.EntityName)element$iv;
                boolean bl = false;
                responseObserver.onNext((Object)builder.setName(it.getSimple()).setSchema(request).build());
            }
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while listing entities", (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Schema '" + request.getName() + " does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while listing entities", (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to list entities for schema " + request.getName() + " because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while listing entities", e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to list entities for schema " + request.getName() + " because of unknown error: " + e.getMessage()).asException());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createIndex(@NotNull CottontailGrpc.IndexDefinition request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            void $this$mapTo$iv$iv;
            LOGGER.trace("Creating index {}", (Object)request);
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            Name.IndexName indexName = ExtensionsKt.fqn(index);
            Entity entity = this.catalogue.schemaForName(indexName.schema()).entityForName(indexName.entity());
            ProtocolStringList protocolStringList = request.getColumnsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"request.columnsList");
            Iterable $this$map$iv = (Iterable)protocolStringList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef<?> columnDef;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Name.EntityName entityName = indexName.entity();
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                Name.ColumnName columnName = entityName.column((String)v3);
                if (entity.columnForName(columnName) == null) {
                    throw (Throwable)new DatabaseException.ColumnDoesNotExistException(columnName);
                }
                collection.add(columnDef);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ColumnDef[] columns = columnDefArray;
            CottontailGrpc.Index index2 = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index2, (String)"request.index");
            IndexType indexType = IndexType.valueOf(index2.getType().toString());
            Map map2 = request.getParamsMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"request.paramsMap");
            entity.createIndex(indexName, indexType, columns, map2);
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
            LOGGER.trace("Index {} created successfully!", (Object)request);
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating index '");
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(index)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder2 = new StringBuilder().append("Schema '");
            CottontailGrpc.Index index3 = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index3, (String)"request.index");
            CottontailGrpc.Entity entity = index3.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.index.entity");
            CottontailGrpc.Schema schema = entity.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.index.entity.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder2.append(ExtensionsKt.fqn(schema)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating index '");
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(index)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder3 = new StringBuilder().append("Entity '");
            CottontailGrpc.Index index4 = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index4, (String)"request.index");
            CottontailGrpc.Entity entity = index4.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.index.entity");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder3.append(ExtensionsKt.fqn(entity)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.IndexAlreadyExistsException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating index '");
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(index)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder4 = new StringBuilder().append("Index '");
            CottontailGrpc.Index index5 = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index5, (String)"request.index");
            responseObserver.onError((Throwable)Status.ALREADY_EXISTS.withDescription(stringBuilder4.append(ExtensionsKt.fqn(index5)).append("' does already exist!").toString()).asException());
        }
        catch (DatabaseException.ColumnDoesNotExistException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating index '");
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(index)).append('\'').toString(), (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(e.getMessage()).asException());
        }
        catch (DatabaseException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating index '");
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(index)).append('\'').toString(), (Throwable)e);
            StringBuilder stringBuilder5 = new StringBuilder().append("Failed to create index '");
            CottontailGrpc.Index index6 = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index6, (String)"request.index");
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(stringBuilder5.append(ExtensionsKt.fqn(index6)).append("' because of database error: ").append(e.getMessage()).toString()).asException());
        }
        catch (Throwable e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error while creating index '");
            CottontailGrpc.Index index = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"request.index");
            LOGGER.error(stringBuilder.append(ExtensionsKt.fqn(index)).append('\'').toString(), e);
            StringBuilder stringBuilder6 = new StringBuilder().append("Failed to create index '");
            CottontailGrpc.Index index7 = request.getIndex();
            Intrinsics.checkNotNullExpressionValue((Object)index7, (String)"request.index");
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(stringBuilder6.append(ExtensionsKt.fqn(index7)).append("' because of an unknown error: ").append(e.getMessage()).toString()).asException());
        }
    }

    public void dropIndex(@NotNull CottontailGrpc.Index request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.IndexName indexName = ExtensionsKt.fqn(request);
            LOGGER.trace("Dropping index {}", (Object)indexName);
            this.catalogue.schemaForName(indexName.schema()).entityForName(indexName.entity()).dropIndex(indexName);
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
            LOGGER.trace("Index {} dropped successfully!", (Object)request);
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while dropping index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            CottontailGrpc.Schema schema = entity.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.entity.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while dropping index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Entity '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(entity)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.IndexDoesNotExistException e) {
            LOGGER.error("Error while dropping index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Index '" + ExtensionsKt.fqn(request) + " does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while dropping index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop index '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while dropping index '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop index '" + ExtensionsKt.fqn(request) + "' because of an unknown error: " + e.getMessage()).asException());
        }
    }

    public void rebuildIndex(@NotNull CottontailGrpc.Index request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.IndexName indexName = ExtensionsKt.fqn(request);
            LOGGER.trace("Rebuilding index {}", (Object)indexName);
            this.catalogue.schemaForName(indexName.schema()).entityForName(indexName.entity()).updateIndex(indexName);
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
            LOGGER.trace("Index {} rebuilt successfully!", (Object)request);
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while rebuilding index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            CottontailGrpc.Schema schema = entity.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.entity.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while rebuilding index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Entity '");
            CottontailGrpc.Entity entity = request.getEntity();
            Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"request.entity");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(entity)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.IndexDoesNotExistException e) {
            LOGGER.error("Error while rebuilding index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Index '" + ExtensionsKt.fqn(request) + " does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while rebuilding index '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to rebuild index '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while rebuilding index '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to rebuild index '" + ExtensionsKt.fqn(request) + "' because of an unknown error: " + e.getMessage()).asException());
        }
    }

    public void listIndexes(@NotNull CottontailGrpc.Entity request, @NotNull StreamObserver<CottontailGrpc.Index> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.EntityName entityName = ExtensionsKt.fqn(request);
            Entity entity = this.catalogue.schemaForName(entityName.schema()).entityForName(entityName);
            Iterable $this$forEach$iv = entity.allIndexes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Index it = (Index)element$iv;
                boolean bl = false;
                CottontailGrpc.Index.Builder index = CottontailGrpc.Index.newBuilder().setName(it.getName().getSimple()).setType(CottontailGrpc.IndexType.valueOf((String)it.getType().name())).setEntity(CottontailGrpc.Entity.newBuilder().setName(entity.getName().getSimple()).setSchema(CottontailGrpc.Schema.newBuilder().setName(entity.getParent().getName().getSimple())));
                responseObserver.onNext((Object)index.build());
            }
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Schema schema = request.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Entity '" + ExtensionsKt.fqn(request) + " does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to optimize entity '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to optimize entity '" + ExtensionsKt.fqn(request) + "' because of an unknown error: " + e.getMessage()).asException());
        }
    }

    public void optimize(@NotNull CottontailGrpc.Entity request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.EntityName entityName = ExtensionsKt.fqn(request);
            this.catalogue.schemaForName(entityName.schema()).entityForName(entityName).updateAllIndexes();
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Schema schema = request.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append(" does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Entity '" + ExtensionsKt.fqn(request) + " does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to optimize entity '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while optimizing entity '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to optimize entity '" + ExtensionsKt.fqn(request) + "' because of an unknown error: " + e.getMessage()).asException());
        }
    }

    public void truncate(@NotNull CottontailGrpc.Entity request, @NotNull StreamObserver<CottontailGrpc.Status> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            Name.EntityName entityName = ExtensionsKt.fqn(request);
            LOGGER.trace("Truncating entity {}...", (Object)entityName);
            Schema schema = this.catalogue.schemaForName(entityName.schema());
            Collection<ColumnDef<?>> $this$toTypedArray$iv = schema.entityForName(entityName).allColumns();
            boolean $i$f$toTypedArray = false;
            Collection<ColumnDef<?>> thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ColumnDef[] columns = columnDefArray;
            schema.dropEntity(entityName);
            schema.createEntity(entityName, Arrays.copyOf(columns, columns.length));
            responseObserver.onNext((Object)CottontailGrpc.Status.newBuilder().setSuccess(true).setTimestamp(System.currentTimeMillis()).build());
            responseObserver.onCompleted();
            LOGGER.trace("Truncating " + entityName + " successfull!", (Object)request);
        }
        catch (DatabaseException.SchemaDoesNotExistException e) {
            LOGGER.error("Error while truncating entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder().append("Schema '");
            CottontailGrpc.Schema schema = request.getSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"request.schema");
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription(stringBuilder.append(ExtensionsKt.fqn(schema)).append("' does not exist!").toString()).asException());
        }
        catch (DatabaseException.EntityDoesNotExistException e) {
            LOGGER.error("Error while truncating entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.NOT_FOUND.withDescription("Entity '" + ExtensionsKt.fqn(request) + "' does not exist!").asException());
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while truncating entity '" + ExtensionsKt.fqn(request) + '\'', (Throwable)e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop entity '" + ExtensionsKt.fqn(request) + "' because of database error: " + e.getMessage()).asException());
        }
        catch (Throwable e) {
            LOGGER.error("Error while truncating entity '" + ExtensionsKt.fqn(request) + '\'', e);
            responseObserver.onError((Throwable)Status.UNKNOWN.withDescription("Failed to drop entity '" + ExtensionsKt.fqn(request) + "' because of unknown error: " + e.getMessage()).asException());
        }
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    public CottonDDLService(@NotNull Catalogue catalogue) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        this.catalogue = catalogue;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(CottonDDLService.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/CottonDDLService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

