/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lucene;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.SimilarityBase;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.lucene.LuceneAnalyzerType;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndex$WhenMappings;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndexConfig;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.pattern.LikePatternValue;
import org.vitrivr.cottontail.model.values.pattern.LucenePatternValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 <2\u00020\u0001:\u0002<=B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J)\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\n\u0010.\u001a\u00060/j\u0002`0H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u00102J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\f\u00107\u001a\u000208*\u000209H\u0002J\f\u00107\u001a\u000208*\u00020:H\u0002J\f\u00107\u001a\u000208*\u00020;H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006>"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;", "directory", "Lorg/apache/lucene/store/Directory;", "indexReader", "Lorg/apache/lucene/index/DirectoryReader;", "kotlin.jvm.PlatformType", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "close", "", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "documentFromRecord", "Lorg/apache/lucene/document/Document;", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "documentFromValue", "value", "Lorg/vitrivr/cottontail/model/values/StringValue;", "tupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "documentFromValue-WukLJtg", "(Ljava/lang/String;J)Lorg/apache/lucene/document/Document;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "toLuceneQuery", "Lorg/apache/lucene/search/Query;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic$Literal;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Compound;", "Companion", "Tx", "cottontaildb"})
public final class LuceneIndex
extends AbstractIndex {
    @NotNull
    private final ColumnDef<?>[] produces;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private final IndexType type;
    @NotNull
    private final LuceneIndexConfig config;
    private final Directory directory;
    private DirectoryReader indexReader;
    @NotNull
    public static final String TID_COLUMN = "_tid";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public LuceneIndexConfig getConfig() {
        return this.config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        boolean bl;
        Object it;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate)) return false;
        Iterable $this$all$iv = predicate.getColumns();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                it = (ColumnDef)element$iv;
                boolean bl3 = false;
                if (ArraysKt.contains((Object[])this.getColumns(), (Object)it)) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$all$iv = ((BooleanPredicate)predicate).getAtomics();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (BooleanPredicate.Atomic)element$iv;
            boolean bl4 = false;
            if (!(((BooleanPredicate.Atomic)it).getOperator() instanceof ComparisonOperator.Binary.Like) && !(((BooleanPredicate.Atomic)it).getOperator() instanceof ComparisonOperator.Binary.Equal)) {
                if (!(((BooleanPredicate.Atomic)it).getOperator() instanceof ComparisonOperator.Binary.Match)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (this.canProcess(predicate)) {
            void var3_3;
            IndexSearcher searcher = new IndexSearcher((IndexReader)this.indexReader);
            Cost cost2 = Cost.Companion.getZERO();
            int n = predicate.getColumns().size();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                cost2 = cost2.plus(new Cost(1.0E-4f, Cost.Companion.getCOST_MEMORY_ACCESS(), 0.0f, 4, null).times(SimilarityBase.log2((double)searcher.getIndexReader().numDocs())));
            }
            cost = var3_3;
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.indexReader.close();
            this.directory.close();
        }
    }

    private final Document documentFromRecord(Record record) {
        Value value = record.get(this.getColumns()[0]);
        if (value instanceof StringValue) {
            return this.documentFromValue-WukLJtg(((StringValue)value).unbox-impl(), record.getTupleId());
        }
        throw (Throwable)new IllegalArgumentException("Given record does not contain a StringValue column named " + this.getColumns()[0].getName() + '.');
    }

    private final Document documentFromValue-WukLJtg(String value, long tupleId) {
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField(TID_COLUMN, tupleId));
        doc.add((IndexableField)new StoredField(TID_COLUMN, tupleId));
        doc.add((IndexableField)new TextField(this.getColumns()[0].getName() + "_txt", value, Field.Store.NO));
        doc.add((IndexableField)new StringField(this.getColumns()[0].getName() + "_str", value, Field.Store.NO));
        return doc;
    }

    private final Query toLuceneQuery(BooleanPredicate $this$toLuceneQuery) {
        Query query2;
        BooleanPredicate booleanPredicate = $this$toLuceneQuery;
        if (booleanPredicate instanceof BooleanPredicate.Atomic.Literal) {
            query2 = this.toLuceneQuery((BooleanPredicate.Atomic.Literal)$this$toLuceneQuery);
        } else if (booleanPredicate instanceof BooleanPredicate.Compound) {
            query2 = this.toLuceneQuery((BooleanPredicate.Compound)$this$toLuceneQuery);
        } else {
            if (booleanPredicate instanceof BooleanPredicate.Atomic.Reference) {
                throw (Throwable)new IllegalStateException("An Atomic.Reference boolean predicate cannot be converted to a lucene query.");
            }
            throw new NoWhenBranchMatchedException();
        }
        return query2;
    }

    private final Query toLuceneQuery(BooleanPredicate.Atomic.Literal $this$toLuceneQuery) {
        Query query2;
        ComparisonOperator comparisonOperator = $this$toLuceneQuery.getOperator();
        if (comparisonOperator instanceof ComparisonOperator.Binary.Equal) {
            ColumnDef column = (ColumnDef)CollectionsKt.first((Iterable)$this$toLuceneQuery.getColumns());
            Value string = ((ComparisonOperator.Binary.Equal)$this$toLuceneQuery.getOperator()).getRight().getValue();
            if (!(string instanceof StringValue)) {
                throw (Throwable)new QueryException("Conversion to Lucene query failed: EQUAL queries strictly require a StringValue as second operand!");
            }
            query2 = (Query)new TermQuery(new Term(column.getName() + "_str", ((StringValue)string).unbox-impl()));
        } else if (comparisonOperator instanceof ComparisonOperator.Binary.Like) {
            Query query3;
            ColumnDef column = (ColumnDef)CollectionsKt.first((Iterable)$this$toLuceneQuery.getColumns());
            Value pattern = ((ComparisonOperator.Binary.Like)$this$toLuceneQuery.getOperator()).getRight().getValue();
            if (pattern instanceof LucenePatternValue) {
                query3 = QueryParserUtil.parse((String[])new String[]{((LucenePatternValue)pattern).getValue()}, (String[])new String[]{column.getName() + "_txt"}, (Analyzer)((Analyzer)new StandardAnalyzer()));
            } else if (pattern instanceof LikePatternValue) {
                query3 = QueryParserUtil.parse((String[])new String[]{((LikePatternValue)pattern).toLucene().getValue()}, (String[])new String[]{column.getName() + "_txt"}, (Analyzer)((Analyzer)new StandardAnalyzer()));
            } else {
                throw (Throwable)new QueryException("Conversion to Lucene query failed: LIKE queries require a LucenePatternValue OR LikePatternValue as second operand!");
            }
            query2 = query3;
            Intrinsics.checkNotNullExpressionValue((Object)query3, (String)"when (val pattern = this\u2026 operand!\")\n            }");
        } else if (comparisonOperator instanceof ComparisonOperator.Binary.Match) {
            ColumnDef column = (ColumnDef)CollectionsKt.first((Iterable)$this$toLuceneQuery.getColumns());
            Value pattern = ((ComparisonOperator.Binary.Match)$this$toLuceneQuery.getOperator()).getRight().getValue();
            if (!(pattern instanceof LucenePatternValue)) {
                throw (Throwable)new QueryException("Conversion to Lucene query failed: MATCH queries strictly require a LucenePatternValue as second operand!");
            }
            Query query4 = QueryParserUtil.parse((String[])new String[]{((LucenePatternValue)pattern).getValue()}, (String[])new String[]{column.getName() + "_txt"}, (Analyzer)((Analyzer)new StandardAnalyzer()));
            query2 = query4;
            Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"if (pattern is LucenePat\u2026 operand!\")\n            }");
        } else {
            throw (Throwable)new QueryException("Lucene Query Conversion failed: Only EQUAL, MATCH and LIKE queries can be mapped to a Apache Lucene!");
        }
        return query2;
    }

    private final Query toLuceneQuery(BooleanPredicate.Compound $this$toLuceneQuery) {
        BooleanClause.Occur occur;
        switch (LuceneIndex$WhenMappings.$EnumSwitchMapping$0[$this$toLuceneQuery.getConnector().ordinal()]) {
            case 1: {
                occur = BooleanClause.Occur.MUST;
                break;
            }
            case 2: {
                occur = BooleanClause.Occur.SHOULD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BooleanClause.Occur clause = occur;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.toLuceneQuery($this$toLuceneQuery.getP1()), clause);
        builder.add(this.toLuceneQuery($this$toLuceneQuery.getP2()), clause);
        BooleanQuery booleanQuery = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"builder.build()");
        return (Query)booleanQuery;
    }

    public LuceneIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable LuceneIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.produces = new ColumnDef[]{new ColumnDef(this.getParent().getName().column("score"), Type.Float.INSTANCE, false, false, 12, null)};
        this.supportsIncrementalUpdate = true;
        this.type = IndexType.LUCENE;
        FSDirectory fSDirectory = FSDirectory.open((Path)this.getPath().getParent().resolve(this.getName().getSimple() + ".lucene"), (LockFactory)((LockFactory)NativeFSLockFactory.getDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"FSDirectory.open(\n      \u2026actory.getDefault()\n    )");
        this.directory = (Directory)fSDirectory;
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)LuceneIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new LuceneIndexConfig(LuceneAnalyzerType.STANDARD);
            configOnDisk.set((Object)config);
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (LuceneIndexConfig)object;
        }
        IndexWriter writer = new IndexWriter(this.directory, new IndexWriterConfig(this.getConfig().getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND).setCommitOnClose(true));
        writer.close();
        this.getStore().commit();
        this.indexReader = DirectoryReader.open((Directory)this.directory);
    }

    public /* synthetic */ LuceneIndex(Path path, DefaultEntity defaultEntity, LuceneIndexConfig luceneIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            luceneIndexConfig = null;
        }
        this(path, defaultEntity, luceneIndexConfig);
    }

    public static final /* synthetic */ void access$setIndexReader$p(LuceneIndex $this, DirectoryReader directoryReader) {
        $this.indexReader = directoryReader;
    }

    public static final /* synthetic */ Query access$toLuceneQuery(LuceneIndex $this, BooleanPredicate $this$access_u24toLuceneQuery) {
        return $this.toLuceneQuery($this$access_u24toLuceneQuery);
    }

    public static final /* synthetic */ DB access$getStore$p(LuceneIndex $this) {
        return $this.getStore();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "writer", "Lorg/apache/lucene/index/IndexWriter;", "cleanup", "", "clear", "count", "", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        private final IndexWriter writer;
        @NotNull
        private final TxSnapshot snapshot;

        @Override
        @NotNull
        protected TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return LuceneIndex.this.indexReader.numDocs();
        }

        @Override
        public void rebuild() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
            if (tx == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.entity.EntityTx");
            }
            EntityTx entityTx = (EntityTx)tx;
            this.writer.deleteAll();
            Iterator<Record> $this$forEach$iv = entityTx.scan(LuceneIndex.this.getColumns());
            boolean $i$f$forEach = false;
            Iterator<Record> iterator2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator<Record> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Record element$iv;
                Record record = element$iv = iterator3.next();
                boolean bl3 = false;
                this.writer.addDocument((Iterable)LuceneIndex.this.documentFromRecord(record));
            }
        }

        @Override
        public void update(@NotNull DataChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            DataChangeEvent dataChangeEvent = event;
            if (dataChangeEvent instanceof DataChangeEvent.InsertDataChangeEvent) {
                Value value = ((DataChangeEvent.InsertDataChangeEvent)event).getInserts().get(this.getColumns()[0]);
                if (value instanceof StringValue) {
                    this.writer.addDocument((Iterable)LuceneIndex.this.documentFromValue-WukLJtg(((StringValue)value).unbox-impl(), event.getTupleId()));
                }
            } else if (dataChangeEvent instanceof DataChangeEvent.UpdateDataChangeEvent) {
                Value value;
                this.writer.deleteDocuments(new Term[]{new Term(LuceneIndex.TID_COLUMN, String.valueOf(event.getTupleId()))});
                Pair<Value, Value> pair = ((DataChangeEvent.UpdateDataChangeEvent)event).getUpdates().get(this.getColumns()[0]);
                Value value2 = value = pair != null ? (Value)pair.getSecond() : null;
                if (value instanceof StringValue) {
                    this.writer.addDocument((Iterable)LuceneIndex.this.documentFromValue-WukLJtg(((StringValue)value).unbox-impl(), event.getTupleId()));
                }
            } else if (dataChangeEvent instanceof DataChangeEvent.DeleteDataChangeEvent) {
                this.writer.deleteDocuments(new Term[]{new Term(LuceneIndex.TID_COLUMN, String.valueOf(event.getTupleId()))});
            }
        }

        @Override
        public void clear() {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            this.writer.deleteAll();
            LuceneIndex.this.getDirtyField().compareAndSet(false, true);
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(this, predicate){
                private final BooleanPredicate predicate;
                private volatile int returned;
                private final Query query;
                private final IndexSearcher searcher;
                private final TopDocs results;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    return (long)this.returned < this.results.totalHits.value;
                }

                @NotNull
                public Record next() {
                    int n = this.returned;
                    this.returned = n + 1;
                    ScoreDoc scores = this.results.scoreDocs[n];
                    Document doc = this.searcher.doc(scores.doc);
                    String string = doc.get("_tid");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc[TID_COLUMN]");
                    String string2 = string;
                    boolean bl = false;
                    return new StandaloneRecord(Long.parseLong(string2), this.this$0.LuceneIndex.this.getProduces(), new Value[]{FloatValue.box-impl(FloatValue.constructor-impl(scores.score))});
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof BooleanPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.LuceneIndex.this.getName() + "' (lucene index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (BooleanPredicate)$captured_local_variable$1;
                    if (!this$0.LuceneIndex.this.canProcess($captured_local_variable$1)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.LuceneIndex.this.getName() + "' (lucene-index) cannot process the provided predicate.");
                    }
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                        this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    }
                    boolean bl = false;
                    this.query = LuceneIndex.access$toLuceneQuery(this$0.LuceneIndex.this, this.predicate);
                    this.searcher = new IndexSearcher((IndexReader)LuceneIndex.access$getIndexReader$p(this$0.LuceneIndex.this));
                    this.results = this.searcher.search(this.query, Integer.MAX_VALUE);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw (Throwable)new UnsupportedOperationException("The LuceneIndex does not support ranged filtering!");
        }

        @Override
        protected void cleanup() {
            this.writer.close();
            super.cleanup();
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(LuceneIndex.this, context);
            this.writer = new IndexWriter(LuceneIndex.this.directory, new IndexWriterConfig(LuceneIndex.this.getConfig().getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.APPEND).setMaxBufferedDocs(10000).setCommitOnClose(false));
            this.snapshot = new TxSnapshot(this){
                final /* synthetic */ Tx this$0;

                public void commit() {
                    Tx.access$getWriter$p(this.this$0).commit();
                    LuceneIndex.access$getStore$p(this.this$0.LuceneIndex.this).commit();
                    DirectoryReader oldReader = LuceneIndex.access$getIndexReader$p(this.this$0.LuceneIndex.this);
                    LuceneIndex.access$setIndexReader$p(this.this$0.LuceneIndex.this, DirectoryReader.open((Directory)LuceneIndex.access$getDirectory$p(this.this$0.LuceneIndex.this)));
                    oldReader.close();
                }

                public void rollback() {
                    Tx.access$getWriter$p(this.this$0).rollback();
                    LuceneIndex.access$getStore$p(this.this$0.LuceneIndex.this).rollback();
                }
                {
                    this.this$0 = this$0;
                }
            };
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }

        public static final /* synthetic */ IndexWriter access$getWriter$p(Tx $this) {
            return $this.writer;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex$Companion;", "", "()V", "TID_COLUMN", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

