/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.locking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.locking.Lock$WhenMappings;
import org.vitrivr.cottontail.database.locking.LockHolder;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.locking.WaitForGraph;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0006\u0010\u001c\u001a\u00020\u0019J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eJ\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eR\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/database/locking/Lock;", "", "waitForGraph", "Lorg/vitrivr/cottontail/database/locking/WaitForGraph;", "(Lorg/vitrivr/cottontail/database/locking/WaitForGraph;)V", "<set-?>", "", "isExclusivelyLocked", "()Z", "isSharedLocked", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "owners", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/vitrivr/cottontail/database/locking/LockHolder;", "", "sharedLockCount", "getSharedLockCount", "()I", "waiters", "Ljava/util/concurrent/locks/Condition;", "acquire", "", "txn", "lockMode", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "acquireExclusiveLock", "acquireSharedLock", "getMode", "getOwners", "", "release", "upgrade", "cottontaildb"})
public final class Lock {
    private final ObjectOpenHashSet<LockHolder> owners;
    private final ReentrantReadWriteLock lock;
    private final Condition waiters;
    private int sharedLockCount;
    private boolean isExclusivelyLocked;
    private final WaitForGraph waitForGraph;

    public final int getSharedLockCount() {
        return this.sharedLockCount;
    }

    public final boolean isExclusivelyLocked() {
        return this.isExclusivelyLocked;
    }

    public final boolean isSharedLocked() {
        return this.sharedLockCount > 0;
    }

    public final void acquire(@NotNull LockHolder txn, @NotNull LockMode lockMode) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)((Object)lockMode), (String)"lockMode");
        switch (Lock$WhenMappings.$EnumSwitchMapping$0[lockMode.ordinal()]) {
            case 1: {
                this.acquireSharedLock(txn);
                break;
            }
            case 2: {
                this.acquireExclusiveLock(txn);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Lock mode of type UNLOCKED cannot be acquired!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(@NotNull LockHolder txn) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            if (this.sharedLockCount > 0) {
                n = this.sharedLockCount;
                this.sharedLockCount = n + -1;
            }
            if (this.isExclusivelyLocked) {
                this.isExclusivelyLocked = false;
            }
            this.owners.remove((Object)txn);
            this.waitForGraph.remove(txn);
            this.waiters.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                int n7 = n3++;
                n = 0;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void upgrade(@NotNull LockHolder txn) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            n = 0;
            if (this.owners.contains((Object)txn) && this.isExclusivelyLocked) {
                return;
            }
            while (this.isExclusivelyLocked || this.sharedLockCount > 1) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)this.owners;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LockHolder it = (LockHolder)element$iv$iv;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)txn) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                Collection collection = list;
                Set ownersWithSelfRemoved = (Set)new ObjectOpenHashSet(collection);
                this.waitForGraph.add(txn, ownersWithSelfRemoved);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
            this.sharedLockCount = 0;
            this.isExclusivelyLocked = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                n = n3++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @NotNull
    public final Set<LockHolder> getOwners() {
        Set<LockHolder> set = Collections.unmodifiableSet((Set)this.owners);
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.unmodifiableSet(this.owners)");
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final LockMode getMode() {
        LockMode lockMode;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            lockMode = this.isExclusivelyLocked ? LockMode.EXCLUSIVE : (this.isSharedLocked() ? LockMode.SHARED : LockMode.NO_LOCK);
        }
        finally {
            readLock.unlock();
        }
        return lockMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean acquireSharedLock(LockHolder txn) {
        int n;
        int n2;
        int n3;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            while (this.isExclusivelyLocked || this.lock.hasWaiters(this.waiters)) {
                this.waitForGraph.add(txn, (Set)this.owners);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
            n = this.sharedLockCount;
            this.sharedLockCount = n + 1;
            n5 = this.owners.add((Object)txn) ? 1 : 0;
        }
        finally {
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                int n7 = n3++;
                n = 0;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return n5 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean acquireExclusiveLock(LockHolder txn) {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            while (this.isExclusivelyLocked || this.isSharedLocked()) {
                this.waitForGraph.add(txn, (Set)this.owners);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
            this.isExclusivelyLocked = true;
            n4 = this.owners.add((Object)txn) ? 1 : 0;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return n4 != 0;
    }

    public Lock(@NotNull WaitForGraph waitForGraph) {
        Intrinsics.checkNotNullParameter((Object)waitForGraph, (String)"waitForGraph");
        this.waitForGraph = waitForGraph;
        this.owners = new ObjectOpenHashSet();
        this.lock = new ReentrantReadWriteLock(true);
        Condition condition = this.lock.writeLock().newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"this.lock.writeLock().newCondition()");
        this.waiters = condition;
    }
}

