/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.locking;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.locking.Lock;
import org.vitrivr.cottontail.database.locking.LockHolder;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.locking.WaitForGraph;
import org.vitrivr.cottontail.model.basics.Name;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r0\fJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/database/locking/LockManager;", "", "()V", "locks", "", "Lorg/vitrivr/cottontail/database/general/DBO;", "kotlin.jvm.PlatformType", "Lorg/vitrivr/cottontail/database/locking/Lock;", "", "waitForGraph", "Lorg/vitrivr/cottontail/database/locking/WaitForGraph;", "allLocks", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/model/basics/Name;", "lock", "", "txn", "Lorg/vitrivr/cottontail/database/locking/LockHolder;", "dbo", "mode", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "lockOn", "unlock", "cottontaildb"})
public final class LockManager {
    private final Map<DBO, Lock> locks = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
    private final WaitForGraph waitForGraph = new WaitForGraph();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Name, Lock>> allLocks() {
        void $this$mapTo$iv$iv;
        Map<DBO, Lock> map2 = this.locks;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"this.locks");
        Map<DBO, Lock> $this$map$iv = map2;
        boolean $i$f$map = false;
        Map<DBO, Lock> map3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var6_6.entrySet().iterator();
        while (iterator2.hasNext()) {
            void v;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)((DBO)v.getKey()).getName(), v.getValue());
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    public final void lock(@NotNull LockHolder txn, @NotNull DBO dbo, @NotNull LockMode mode) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        boolean bl = mode != LockMode.NO_LOCK;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot acquire a lock of mode " + (Object)((Object)mode) + "; try LockManager.release().";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        LockMode lockOn = this.lockOn(txn, dbo);
        if (lockOn == mode) {
            return;
        }
        if (lockOn == LockMode.EXCLUSIVE && mode == LockMode.SHARED) {
            return;
        }
        if (lockOn == LockMode.SHARED && mode == LockMode.EXCLUSIVE) {
            Lock lock2 = this.locks.computeIfAbsent(dbo, new Function<DBO, Lock>(this){
                final /* synthetic */ LockManager this$0;

                public final Lock apply(DBO it) {
                    return new Lock(LockManager.access$getWaitForGraph$p(this.this$0));
                }
                {
                    this.this$0 = lockManager;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)lock2, (String)"this.locks.computeIfAbse\u2026Lock(this.waitForGraph) }");
            Lock lock3 = lock2;
            lock3.upgrade(txn);
            txn.addLock$cottontaildb(lock3);
        } else {
            Lock lock4 = this.locks.computeIfAbsent(dbo, new Function<DBO, Lock>(this){
                final /* synthetic */ LockManager this$0;

                public final Lock apply(DBO it) {
                    return new Lock(LockManager.access$getWaitForGraph$p(this.this$0));
                }
                {
                    this.this$0 = lockManager;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)lock4, (String)"this.locks.computeIfAbse\u2026Lock(this.waitForGraph) }");
            Lock lock5 = lock4;
            lock5.acquire(txn, mode);
            txn.addLock$cottontaildb(lock5);
        }
    }

    public final void unlock(@NotNull LockHolder txn, @NotNull DBO dbo) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
        Lock lock2 = this.locks.get(dbo);
        if (lock2 != null) {
            lock2.release(txn);
            txn.removeLock$cottontaildb(lock2);
        }
    }

    @NotNull
    public final LockMode lockOn(@NotNull LockHolder txn, @NotNull DBO dbo) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Iterable iterable = txn.getLocks();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Lock it = (Lock)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)this.locks.get(dbo))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Lock)v0) == null || (object = object.getMode()) == null) {
            object = LockMode.NO_LOCK;
        }
        return object;
    }

    public static final /* synthetic */ WaitForGraph access$getWaitForGraph$p(LockManager $this) {
        return $this.waitForGraph;
    }
}

