/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.planning.cost;

import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0013H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\fH\u00d6\u0001J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0013H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010\u0019\u001a\u00020\f2\b\b\u0002\u0010\u001a\u001a\u00020\fJ\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0013H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0013H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u001d\u001a\u00020\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "", "io", "", "cpu", "memory", "(FFF)V", "getCpu", "()F", "getIo", "getMemory", "compareTo", "", "other", "component1", "component2", "component3", "copy", "div", "", "equals", "", "", "hashCode", "minus", "parallelisation", "max", "plus", "times", "toScore", "toString", "", "Companion", "cottontaildb"})
public final class Cost
implements Comparable<Cost> {
    private final float io;
    private final float cpu;
    private final float memory;
    @NotNull
    private static final Cost ZERO;
    @NotNull
    private static final Cost INVALID;
    private static final int ESTIMATION_REPETITION = 1000000;
    private static final int MAX_PARALLELISATION = 4;
    public static final float COST_DISK_ACCESS_READ = 1.0E-4f;
    public static final float COST_DISK_ACCESS_WRITE = 4.9999997E-4f;
    private static final float COST_MEMORY_ACCESS;
    private static final float COST_FLOP;
    @NotNull
    public static final Companion Companion;

    public final int parallelisation(int max) {
        return Integer.max(Integer.min(max, (int)this.cpu), max);
    }

    public static /* synthetic */ int parallelisation$default(Cost cost, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return cost.parallelisation(n);
    }

    @NotNull
    public final Cost plus(@NotNull Cost other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io + other.io, this.cpu + other.cpu, this.memory + other.memory);
    }

    @NotNull
    public final Cost minus(@NotNull Cost other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io - other.io, this.cpu - other.cpu, this.memory - other.memory);
    }

    @NotNull
    public final Cost times(@NotNull Cost other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io * other.io, this.cpu * other.cpu, this.memory * other.memory);
    }

    @NotNull
    public final Cost div(@NotNull Cost other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io / other.io, this.cpu / other.cpu, this.memory / other.memory);
    }

    @NotNull
    public final Cost plus(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io + other.floatValue(), this.cpu + other.floatValue(), this.memory + other.floatValue());
    }

    @NotNull
    public final Cost minus(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io - other.floatValue(), this.cpu - other.floatValue(), this.memory - other.floatValue());
    }

    @NotNull
    public final Cost times(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io * other.floatValue(), this.cpu * other.floatValue(), this.memory * other.floatValue());
    }

    @NotNull
    public final Cost div(@NotNull Number other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Cost(this.io / other.floatValue(), this.cpu / other.floatValue(), this.memory / other.floatValue());
    }

    public final float toScore() {
        return 0.8f * this.cpu + 0.15f * this.io + 0.05f * this.memory;
    }

    @Override
    public int compareTo(@NotNull Cost other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Float.compare(this.toScore(), other.toScore());
    }

    public final float getIo() {
        return this.io;
    }

    public final float getCpu() {
        return this.cpu;
    }

    public final float getMemory() {
        return this.memory;
    }

    public Cost(float io, float cpu, float memory) {
        this.io = io;
        this.cpu = cpu;
        this.memory = memory;
    }

    public /* synthetic */ Cost(float f, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.0f;
        }
        this(f, f2, f3);
    }

    public Cost() {
        this(0.0f, 0.0f, 0.0f, 7, null);
    }

    static {
        Companion = new Companion(null);
        ZERO = new Cost(0.0f, 0.0f, 0.0f);
        INVALID = new Cost(Float.NaN, Float.NaN, Float.NaN);
        COST_MEMORY_ACCESS = Cost.Companion.estimateMemoryAccessCost();
        COST_FLOP = Cost.Companion.estimateFlopCost();
    }

    public final float component1() {
        return this.io;
    }

    public final float component2() {
        return this.cpu;
    }

    public final float component3() {
        return this.memory;
    }

    @NotNull
    public final Cost copy(float io, float cpu, float memory) {
        return new Cost(io, cpu, memory);
    }

    public static /* synthetic */ Cost copy$default(Cost cost, float f, float f2, float f3, int n, Object object) {
        if ((n & 1) != 0) {
            f = cost.io;
        }
        if ((n & 2) != 0) {
            f2 = cost.cpu;
        }
        if ((n & 4) != 0) {
            f3 = cost.memory;
        }
        return cost.copy(f, f2, f3);
    }

    @NotNull
    public String toString() {
        return "Cost(io=" + this.io + ", cpu=" + this.cpu + ", memory=" + this.memory + ")";
    }

    public int hashCode() {
        return (Float.hashCode(this.io) * 31 + Float.hashCode(this.cpu)) * 31 + Float.hashCode(this.memory);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Cost)) break block3;
                Cost cost = (Cost)object;
                if (Float.compare(this.io, cost.io) != 0 || Float.compare(this.cpu, cost.cpu) != 0 || Float.compare(this.memory, cost.memory) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0004H\u0002J\b\u0010\u0015\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost$Companion;", "", "()V", "COST_DISK_ACCESS_READ", "", "COST_DISK_ACCESS_WRITE", "COST_FLOP", "getCOST_FLOP", "()F", "COST_MEMORY_ACCESS", "getCOST_MEMORY_ACCESS", "ESTIMATION_REPETITION", "", "INVALID", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "getINVALID", "()Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "MAX_PARALLELISATION", "ZERO", "getZERO", "estimateFlopCost", "estimateMemoryAccessCost", "cottontaildb"})
    public static final class Companion {
        @NotNull
        public final Cost getZERO() {
            return ZERO;
        }

        @NotNull
        public final Cost getINVALID() {
            return INVALID;
        }

        public final float getCOST_MEMORY_ACCESS() {
            return COST_MEMORY_ACCESS;
        }

        public final float getCOST_FLOP() {
            return COST_FLOP;
        }

        private final float estimateMemoryAccessCost() {
            SplittableRandom random2 = new SplittableRandom();
            long time = 0L;
            int n = 1000000;
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                long a = random2.nextLong();
                long b = random2.nextLong();
                long c = 0L;
                boolean $i$f$measureNanoTime = false;
                boolean bl3 = false;
                long start$iv = System.nanoTime();
                long l = time;
                boolean bl4 = false;
                c = a;
                a = b;
                b = c;
                Unit unit = Unit.INSTANCE;
                time = l + (System.nanoTime() - start$iv);
                long cfr_ignored_0 = c + b;
            }
            return (float)(time / (long)3000000) * 1.0E-9f;
        }

        private final float estimateFlopCost() {
            SplittableRandom random2 = new SplittableRandom();
            long timeAdd = 0L;
            int n = 1000000;
            int n2 = 0;
            int n3 = 0;
            n3 = 0;
            int n4 = n;
            while (n3 < n4) {
                int it = n3++;
                boolean bl = false;
                double a = random2.nextDouble();
                double b = random2.nextDouble();
                boolean $i$f$measureNanoTime = false;
                boolean bl2 = false;
                long start$iv = System.nanoTime();
                long l = timeAdd;
                boolean bl3 = false;
                double cfr_ignored_0 = a + b;
                Unit unit = Unit.INSTANCE;
                timeAdd = l + (System.nanoTime() - start$iv);
            }
            long timeSubtract = 0L;
            n2 = 1000000;
            n3 = 0;
            n4 = 0;
            n4 = 0;
            int n5 = n2;
            while (n4 < n5) {
                int it = n4++;
                boolean bl = false;
                double a = random2.nextDouble();
                double b = random2.nextDouble();
                boolean $i$f$measureNanoTime = false;
                boolean start$iv = false;
                long start$iv2 = System.nanoTime();
                long l = timeSubtract;
                boolean bl4 = false;
                double cfr_ignored_1 = a - b;
                Unit unit = Unit.INSTANCE;
                timeSubtract = l + (System.nanoTime() - start$iv2);
            }
            long timeMultiply = 0L;
            n3 = 1000000;
            n4 = 0;
            n5 = 0;
            n5 = 0;
            int n6 = n3;
            while (n5 < n6) {
                int it = n5++;
                boolean bl = false;
                double a = random2.nextDouble();
                double b = random2.nextDouble();
                boolean $i$f$measureNanoTime = false;
                boolean start$iv2 = false;
                long start$iv = System.nanoTime();
                long l = timeMultiply;
                boolean bl5 = false;
                double cfr_ignored_2 = a * b;
                Unit unit = Unit.INSTANCE;
                timeMultiply = l + (System.nanoTime() - start$iv);
            }
            long timeDivide = 0L;
            n4 = 1000000;
            n5 = 0;
            n6 = 0;
            n6 = 0;
            int n7 = n4;
            while (n6 < n7) {
                int it = n6++;
                boolean bl = false;
                double a = random2.nextDouble();
                double b = random2.nextDouble(1.0);
                boolean $i$f$measureNanoTime = false;
                boolean bl6 = false;
                long start$iv = System.nanoTime();
                long l = timeDivide;
                boolean bl7 = false;
                double cfr_ignored_3 = a / b;
                Unit unit = Unit.INSTANCE;
                timeDivide = l + (System.nanoTime() - start$iv);
            }
            return (float)((timeAdd + timeSubtract + timeMultiply + timeDivide) / (long)4000000) * 1.0E-9f;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

