/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.locking.DeadlockException;
import org.vitrivr.cottontail.database.locking.LockHolder;
import org.vitrivr.cottontail.database.locking.LockManager;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.TransactionStatus;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.ExecutionException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0018\u001a\b\u0018\u00010\u000fR\u00020\u00002\n\u0010\u0019\u001a\u00060\u0016j\u0002`\u001aH\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RE\u0010\r\u001a6\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000 \u0010*\u001a\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000\u0018\u00010\u00110\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R^\u0010\u0014\u001aR\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00160\u0016\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000 \u0010*(\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00160\u0016\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000\u0018\u00010\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager;", "", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "(Ljava/util/concurrent/ThreadPoolExecutor;)V", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "lockManager", "Lorg/vitrivr/cottontail/database/locking/LockManager;", "getLockManager", "()Lorg/vitrivr/cottontail/database/locking/LockManager;", "tidCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "transactionHistory", "", "Lorg/vitrivr/cottontail/execution/TransactionManager$Transaction;", "kotlin.jvm.PlatformType", "", "getTransactionHistory", "()Ljava/util/List;", "transactions", "", "", "", "get", "txId", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "Companion", "Transaction", "cottontaildb"})
public final class TransactionManager {
    private final ExecutorCoroutineDispatcher dispatcher;
    private final Map<Long, Transaction> transactions;
    private final AtomicLong tidCounter;
    private final List<Transaction> transactionHistory;
    @NotNull
    private final LockManager lockManager;
    private final ThreadPoolExecutor executor;
    private static final Logger LOGGER;
    private static final int TRANSACTION_TABLE_SIZE = 100;
    private static final int TRANSACTION_HISTORY = 500;
    @NotNull
    public static final Companion Companion;

    public final List<Transaction> getTransactionHistory() {
        return this.transactionHistory;
    }

    @NotNull
    public final LockManager getLockManager() {
        return this.lockManager;
    }

    @Nullable
    public final Transaction get(long txId) {
        return this.transactions.get(txId);
    }

    public TransactionManager(@NotNull ThreadPoolExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        this.dispatcher = ExecutorsKt.from((ExecutorService)this.executor);
        this.transactions = Collections.synchronizedMap((Map)new Long2ObjectOpenHashMap(100, 0.25f));
        this.tidCounter = new AtomicLong();
        this.transactionHistory = Collections.synchronizedList(new ArrayList(500));
        this.lockManager = new LockManager();
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(TransactionManager.class);
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0019H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u0019H\u0016J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0019H\u0016J\u0018\u0010'\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010(\u001a\u00020%H\u0016J\u0006\u0010)\u001a\u00020\u001eJ\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0013@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager$Transaction;", "Lorg/vitrivr/cottontail/database/locking/LockHolder;", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "type", "Lorg/vitrivr/cottontail/execution/TransactionType;", "(Lorg/vitrivr/cottontail/execution/TransactionManager;Lorg/vitrivr/cottontail/execution/TransactionType;)V", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "numberOfTxs", "", "getNumberOfTxs", "()I", "Lorg/vitrivr/cottontail/execution/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/execution/TransactionStatus;", "txns", "", "Lorg/vitrivr/cottontail/database/general/DBO;", "Lorg/vitrivr/cottontail/database/general/Tx;", "getType", "()Lorg/vitrivr/cottontail/execution/TransactionType;", "commit", "", "execute", "operator", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$SinkOperator;", "getTx", "dbo", "lockOn", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "releaseLock", "requestLock", "mode", "rollback", "signalEvent", "event", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    public final class Transaction
    extends LockHolder
    implements TransactionContext {
        @NotNull
        private volatile TransactionStatus state;
        private final Map<DBO, Tx> txns;
        private final int numberOfTxs;
        private final long created;
        @Nullable
        private Long ended;
        @NotNull
        private final TransactionType type;

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        public final int getNumberOfTxs() {
            return this.numberOfTxs;
        }

        public final long getCreated() {
            return this.created;
        }

        @Nullable
        public final Long getEnded() {
            return this.ended;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo, new Function<DBO, Tx>(this, dbo){
                final /* synthetic */ Transaction this$0;
                final /* synthetic */ DBO $dbo;

                @NotNull
                public final Tx apply(@NotNull DBO it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$dbo.newTx(this.this$0);
                }
                {
                    this.this$0 = transaction;
                    this.$dbo = dBO;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"this.txns.computeIfAbsen\u2026newTx(this)\n            }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            TransactionManager.this.getLockManager().lock(this, dbo, mode);
        }

        @Override
        public void releaseLock(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            TransactionManager.this.getLockManager().unlock(this, dbo);
        }

        @Override
        @NotNull
        public LockMode lockOn(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            return TransactionManager.this.getLockManager().lockOn(this, dbo);
        }

        @Override
        public void signalEvent(@NotNull DataChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        }

        public final synchronized void execute(@NotNull Operator.SinkOperator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)TransactionManager.this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, operator, null){
                int label;
                final /* synthetic */ Transaction this$0;
                final /* synthetic */ Operator.SinkOperator $operator;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            Transaction.access$setState$p(this.this$0, TransactionStatus.RUNNING);
                            this.label = 1;
                            v0 = FlowKt.collect(this.$operator.toFlow(this.this$0), (Continuation)this);
                            ** if (v0 != var3_2) goto lbl12
lbl11:
                            // 1 sources

                            return var3_2;
lbl12:
                            // 1 sources

                            ** GOTO lbl18
                        }
                        case 1: {
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl18:
                                // 2 sources

                                Transaction.access$setState$p(this.this$0, TransactionStatus.READY);
                            }
                            catch (DeadlockException e) {
                                TransactionManager.access$getLOGGER$cp().debug("Deadlock encountered during execution of transaction " + this.this$0.getTxId() + '.', (Throwable)e);
                                Transaction.access$setState$p(this.this$0, TransactionStatus.ERROR);
                                throw (Throwable)new TransactionException.DeadlockException(this.this$0.getTxId(), e);
                            }
                            catch (ExecutionException.OperatorExecutionException e) {
                                TransactionManager.access$getLOGGER$cp().debug("Unhandled exception during operator execution in transaction " + this.this$0.getTxId() + '.', (Throwable)e);
                                Transaction.access$setState$p(this.this$0, TransactionStatus.ERROR);
                                throw (Throwable)e;
                            }
                            catch (DatabaseException e) {
                                TransactionManager.access$getLOGGER$cp().warn("Unhandled database exception during execution of transaction " + this.this$0.getTxId() + '.', (Throwable)e);
                                Transaction.access$setState$p(this.this$0, TransactionStatus.ERROR);
                                throw (Throwable)e;
                            }
                            catch (Throwable e) {
                                TransactionManager.access$getLOGGER$cp().error("Unhandled exception during query execution of transaction " + this.this$0.getTxId() + '.', e);
                                Transaction.access$setState$p(this.this$0, TransactionStatus.ERROR);
                                throw (Throwable)new ExecutionException("Unhandled exception during execution of transaction " + this.this$0.getTxId() + ": " + e.getMessage() + '.');
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = transaction;
                    this.$operator = sinkOperator;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public final synchronized void commit() {
            boolean bl = this.getState() == TransactionStatus.READY;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot commit transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            Iterable $this$forEach$iv = this.txns.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tx txn = (Tx)element$iv;
                boolean bl5 = false;
                txn.commit();
                txn.close();
            }
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            this.state = TransactionStatus.COMMIT;
            TransactionManager.this.transactions.remove(this.getTxId());
        }

        public final synchronized void rollback() {
            boolean bl = this.getState() == TransactionStatus.READY || this.getState() == TransactionStatus.ERROR;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot rollback transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            Iterable $this$forEach$iv = this.txns.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Tx txn = (Tx)element$iv;
                boolean bl5 = false;
                txn.rollback();
                txn.close();
            }
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            this.state = TransactionStatus.ROLLBACK;
            TransactionManager.this.transactions.remove(this.getTxId());
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        public Transaction(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(TransactionManager.this.tidCounter.getAndIncrement());
            this.type = type;
            this.state = TransactionStatus.READY;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"Object2ObjectMaps.synchr\u2026ject2ObjectOpenHashMap())");
            this.txns = (Map)object2ObjectMap;
            this.numberOfTxs = this.txns.size();
            this.created = System.currentTimeMillis();
            if (TransactionManager.this.getTransactionHistory().size() >= 500) {
                Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)50);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl = false;
                    TransactionManager.this.getTransactionHistory().remove(it);
                }
            }
            Map map2 = TransactionManager.this.transactions;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"this@TransactionManager.transactions");
            map2.put(this.getTxId(), this);
            TransactionManager.this.getTransactionHistory().add(this);
        }

        public static final /* synthetic */ TransactionStatus access$getState$p(Transaction $this) {
            return $this.getState();
        }

        public static final /* synthetic */ void access$setState$p(Transaction $this, TransactionStatus transactionStatus) {
            $this.state = transactionStatus;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TRANSACTION_HISTORY", "", "TRANSACTION_TABLE_SIZE", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

