/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.column;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.column.ColumnTx;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.legacy.v1.column.ColumnV1Header;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000267B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00028\u0000032\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lorg/vitrivr/cottontail/database/column/Column;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1Header;", "maxTupleId", "", "getMaxTupleId", "()J", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class ColumnV1<T extends Value>
implements Column<T> {
    @NotNull
    private final Path path;
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    private volatile boolean closed;
    private final StampedLock closeLock;
    @NotNull
    private final Name.ColumnName name;
    @NotNull
    private final Entity parent;
    private static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    private final ColumnV1Header getHeader() {
        ColumnV1Header columnV1Header = (ColumnV1Header)this.store.get(1L, ColumnV1Header.Serializer);
        if (columnV1Header == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnV1Header;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    @NotNull
    public ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public long getMaxTupleId() {
        return this.store.getMaxRecid();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-ColumnV1$close$22 = false;
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-ColumnV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public ColumnTx<T> newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public ColumnV1(@NotNull Name.ColumnName name, @NotNull Entity parent) {
        void it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        Path path = this.getParent().getPath().resolve("col_" + this.getName().getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.path.resolve(\"col_${name.simple}.db\")");
        this.path = path;
        ColumnV1 columnV1 = this;
        try {
            ColumnV1 columnV12 = columnV1;
            object = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.getPath());
        }
        catch (DBException dBException) {
            void e;
            ColumnV1 columnV13 = columnV1;
            throw (Throwable)new DatabaseException("Failed to open column at '" + this.getPath() + "': " + e.getMessage() + '\'');
        }
        columnV12.store = object;
        object = this.getHeader();
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        columnV1 = this;
        boolean bl3 = false;
        Type<?> type = it.getType();
        if (type == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.basics.Type<T>");
        }
        ColumnDef columnDef = new ColumnDef(this.getName(), type, it.getNullable(), false, 8, null);
        columnV1.columnDef = columnDef;
        this.closeLock = new StampedLock();
    }

    @Override
    @NotNull
    public Type<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    public static final /* synthetic */ void access$setStore$p(ColumnV1 $this, CottontailStoreWAL cottontailStoreWAL) {
        $this.store = cottontailStoreWAL;
    }

    public static final /* synthetic */ boolean access$getClosed$p(ColumnV1 $this) {
        return $this.getClosed();
    }

    public static final /* synthetic */ void access$setClosed$p(ColumnV1 $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J)\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00018\u00002\b\u0010#\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0010H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u0017\u0010(\u001a\u00020\u00102\b\u0010)\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u0017\u0010+\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u001bH\u0016J\u0012\u0010.\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`00/H\u0016J\u001a\u0010.\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`00/2\u0006\u00101\u001a\u000202H\u0016J\u001f\u00103\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00104R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1$Tx;", "Lorg/vitrivr/cottontail/database/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "columnDef", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumnDef", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getContext", "()Lorg/vitrivr/cottontail/execution/TransactionContext;", "dbo", "Lorg/vitrivr/cottontail/database/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/database/column/Column;", "globalStamp", "", "localLock", "Ljava/util/concurrent/locks/StampedLock;", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "<set-?>", "Lorg/vitrivr/cottontail/database/general/TxStatus;", "status", "getStatus", "()Lorg/vitrivr/cottontail/database/general/TxStatus;", "checkValidForRead", "", "checkValidTupleId", "tupleId", "close", "commit", "compareAndUpdate", "", "value", "expected", "(JLorg/vitrivr/cottontail/model/values/types/Value;Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "count", "delete", "", "insert", "record", "(Lorg/vitrivr/cottontail/model/values/types/Value;)J", "read", "(J)Lorg/vitrivr/cottontail/model/values/types/Value;", "rollback", "scan", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "range", "Lkotlin/ranges/LongRange;", "update", "(JLorg/vitrivr/cottontail/model/values/types/Value;)Ljava/lang/Void;", "cottontaildb"})
    public final class Tx
    implements ColumnTx<T> {
        @NotNull
        private volatile TxStatus status;
        private final MapDBSerializer<T> serializer;
        private final long globalStamp;
        private final StampedLock localLock;
        @NotNull
        private final TransactionContext context;

        @Override
        @NotNull
        public TxStatus getStatus() {
            return this.status;
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnV1.this.getColumnDef();
        }

        @Override
        @NotNull
        public Column<T> getDbo() {
            return ColumnV1.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void commit() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-ColumnV1$Tx$commit$22 = false;
                if (this.getStatus() == TxStatus.DIRTY) {
                    ColumnV1.this.store.commit();
                    this.status = TxStatus.CLEAN;
                }
                Unit $i$a$-write-ColumnV1$Tx$commit$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void rollback() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-ColumnV1$Tx$rollback$22 = false;
                if (this.getStatus() == TxStatus.DIRTY || this.getStatus() == TxStatus.ERROR) {
                    ColumnV1.this.store.rollback();
                    this.status = TxStatus.CLEAN;
                }
                Unit $i$a$-write-ColumnV1$Tx$rollback$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-ColumnV1$Tx$close$22 = false;
                if (this.getStatus() != TxStatus.CLOSED) {
                    if (this.getStatus() == TxStatus.DIRTY || this.getStatus() == TxStatus.ERROR) {
                        this.rollback();
                    }
                    this.status = TxStatus.CLOSED;
                    ColumnV1.this.closeLock.unlockRead(this.globalStamp);
                }
                Unit $i$a$-write-ColumnV1$Tx$close$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T read(long tupleId) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForRead();
                this.checkValidTupleId(tupleId);
                Value value = (Value)ColumnV1.this.store.get(tupleId, this.serializer);
                return value;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long count() {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForRead();
                long l = ColumnV1.this.getHeader().getCount();
                return l;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public Iterator<Long> scan() {
            long l = 1L;
            return this.scan(new LongRange(l, ColumnV1.this.getMaxTupleId()));
        }

        @Override
        @NotNull
        public Iterator<Long> scan(@NotNull LongRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new Iterator<Long>(this, range){
                private final CottontailStoreWAL.RecordIdIterator wrapped;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ LongRange $range;

                @NotNull
                public Long next() {
                    return this.wrapped.next();
                }

                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }
                {
                    this.this$0 = this$0;
                    this.$range = $captured_local_variable$1;
                    Tx.access$checkValidForRead(this$0);
                    this.wrapped = new CottontailStoreWAL.RecordIdIterator(ColumnV1.access$getStore$p(this$0.ColumnV1.this), $captured_local_variable$1);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long insert(@Nullable T record) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
            }
            catch (Throwable throwable) {
                $this$read$iv.unlock(stamp$iv);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Void update(long tupleId, @Nullable T value) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
            }
            catch (Throwable throwable) {
                $this$read$iv.unlock(stamp$iv);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndUpdate(long tupleId, @Nullable T value, @Nullable T expected) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
            }
            catch (Throwable throwable) {
                $this$read$iv.unlock(stamp$iv);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Void delete(long tupleId) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                throw (Throwable)new UnsupportedOperationException("Operation not supported on legacy DBO.");
            }
            catch (Throwable throwable) {
                $this$read$iv.unlock(stamp$iv);
                throw throwable;
            }
        }

        private final void checkValidTupleId(long tupleId) {
            if (tupleId < 0L | tupleId == 1L) {
                throw (Throwable)new IllegalStateException("");
            }
        }

        private final synchronized void checkValidForRead() {
            if (this.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new IllegalStateException("");
            }
            if (this.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new IllegalStateException("");
            }
        }

        @Override
        @NotNull
        public TransactionContext getContext() {
            return this.context;
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.status = TxStatus.CLEAN;
            if (ColumnV1.this.getClosed()) {
                throw (Throwable)new IllegalStateException("");
            }
            this.serializer = ColumnV1.this.getType().serializerFactory().mapdb(ColumnV1.this.getType().getLogicalSize());
            this.globalStamp = ColumnV1.this.closeLock.readLock();
            this.localLock = new StampedLock();
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1$Companion;", "", "()V", "HEADER_RECORD_ID", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

