/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.exceptions;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001:\u000e\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "", "message", "", "(Ljava/lang/String;)V", "ColumnDoesNotExistException", "ColumnTypeUnexpectedException", "DataCorruptionException", "DuplicateColumnException", "EntityAlreadyExistsException", "EntityDoesNotExistException", "IndexAlreadyExistsException", "IndexDoesNotExistException", "IndexNotSupportedException", "InvalidFileException", "PredicateNotSupportedBxIndexException", "SchemaAlreadyExistsException", "SchemaDoesNotExistException", "VersionMismatchException", "cottontaildb"})
public class DatabaseException
extends Throwable {
    public DatabaseException(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$VersionMismatchException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "found", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "expected", "(Lorg/vitrivr/cottontail/database/general/DBOVersion;Lorg/vitrivr/cottontail/database/general/DBOVersion;)V", "cottontaildb"})
    public static final class VersionMismatchException
    extends DatabaseException {
        public VersionMismatchException(@NotNull DBOVersion found, @NotNull DBOVersion expected) {
            Intrinsics.checkNotNullParameter((Object)((Object)found), (String)"found");
            Intrinsics.checkNotNullParameter((Object)((Object)expected), (String)"expected");
            super("Version mismatch for DBO: Expected " + (Object)((Object)expected) + " but found " + (Object)((Object)found) + '.');
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$SchemaAlreadyExistsException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "schema", "Lorg/vitrivr/cottontail/model/basics/Name;", "(Lorg/vitrivr/cottontail/model/basics/Name;)V", "cottontaildb"})
    public static final class SchemaAlreadyExistsException
    extends DatabaseException {
        public SchemaAlreadyExistsException(@NotNull Name schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super("Schema '" + schema + "' does already exist!");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$SchemaDoesNotExistException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "schema", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "(Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;)V", "getSchema", "()Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "cottontaildb"})
    public static final class SchemaDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name.SchemaName schema;

        @NotNull
        public final Name.SchemaName getSchema() {
            return this.schema;
        }

        public SchemaDoesNotExistException(@NotNull Name.SchemaName schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super("Schema '" + schema + "' does not exist!");
            this.schema = schema;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$EntityAlreadyExistsException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;)V", "cottontaildb"})
    public static final class EntityAlreadyExistsException
    extends DatabaseException {
        public EntityAlreadyExistsException(@NotNull Name.EntityName entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super("Entity '" + entity + "' does already exist!");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$EntityDoesNotExistException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;)V", "getEntity", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "cottontaildb"})
    public static final class EntityDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name.EntityName entity;

        @NotNull
        public final Name.EntityName getEntity() {
            return this.entity;
        }

        public EntityDoesNotExistException(@NotNull Name.EntityName entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super("Entity '" + entity + "' does not exist!");
            this.entity = entity;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$IndexAlreadyExistsException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;)V", "getIndex", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "cottontaildb"})
    public static final class IndexAlreadyExistsException
    extends DatabaseException {
        @NotNull
        private final Name.IndexName index;

        @NotNull
        public final Name.IndexName getIndex() {
            return this.index;
        }

        public IndexAlreadyExistsException(@NotNull Name.IndexName index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super("Index '" + index + "' does already exist!");
            this.index = index;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$IndexDoesNotExistException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/model/basics/Name;", "(Lorg/vitrivr/cottontail/model/basics/Name;)V", "getIndex", "()Lorg/vitrivr/cottontail/model/basics/Name;", "cottontaildb"})
    public static final class IndexDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name index;

        @NotNull
        public final Name getIndex() {
            return this.index;
        }

        public IndexDoesNotExistException(@NotNull Name index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super("Index '" + index + "' does not exist!");
            this.index = index;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$IndexNotSupportedException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "reason", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Ljava/lang/String;)V", "getIndex", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getReason", "()Ljava/lang/String;", "cottontaildb"})
    public static final class IndexNotSupportedException
    extends DatabaseException {
        @NotNull
        private final Name.IndexName index;
        @NotNull
        private final String reason;

        @NotNull
        public final Name.IndexName getIndex() {
            return this.index;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        public IndexNotSupportedException(@NotNull Name.IndexName index, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super("Index '" + index + "' could not be created: " + reason);
            this.index = index;
            this.reason = reason;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$DuplicateColumnException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/Name;", "(Lorg/vitrivr/cottontail/model/basics/Name$EntityName;Ljava/util/Collection;)V", "cottontaildb"})
    public static final class DuplicateColumnException
    extends DatabaseException {
        public DuplicateColumnException(@NotNull Name.EntityName entity, @NotNull Collection<? extends Name> columns) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            super("Entity '" + entity + "' could not be created because it contains duplicate column names (c=[" + CollectionsKt.joinToString$default((Iterable)columns, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "])!");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$ColumnDoesNotExistException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "column", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "(Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;)V", "getColumn", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "cottontaildb"})
    public static final class ColumnDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name.ColumnName column;

        @NotNull
        public final Name.ColumnName getColumn() {
            return this.column;
        }

        public ColumnDoesNotExistException(@NotNull Name.ColumnName column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            super("Column " + column + " does not exist.");
            this.column = column;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$PredicateNotSupportedBxIndexException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/model/basics/Name;", "(Lorg/vitrivr/cottontail/model/basics/Name;)V", "cottontaildb"})
    public static final class PredicateNotSupportedBxIndexException
    extends DatabaseException {
        public PredicateNotSupportedBxIndexException(@NotNull Name index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super("Index '" + index + "' cannot be used to execute the given predicate.");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$ColumnTypeUnexpectedException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "column", "Lorg/vitrivr/cottontail/model/basics/Name;", "expected", "Lorg/vitrivr/cottontail/model/basics/Type;", "actual", "(Lorg/vitrivr/cottontail/model/basics/Name;Lorg/vitrivr/cottontail/model/basics/Type;Lorg/vitrivr/cottontail/model/basics/Type;)V", "cottontaildb"})
    public static final class ColumnTypeUnexpectedException
    extends DatabaseException {
        public ColumnTypeUnexpectedException(@NotNull Name column, @NotNull Type<?> expected, @NotNull Type<?> actual) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            Intrinsics.checkNotNullParameter(expected, (String)"expected");
            Intrinsics.checkNotNullParameter(actual, (String)"actual");
            super("Column '" + column + "' has wrong type (expected: " + expected.getName() + ", actual: " + actual.getName() + ").");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$InvalidFileException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "type", "", "(Ljava/lang/String;)V", "cottontaildb"})
    public static final class InvalidFileException
    extends DatabaseException {
        public InvalidFileException(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super("The provided file is not a valid " + type + " file!");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/model/exceptions/DatabaseException$DataCorruptionException;", "Lorg/vitrivr/cottontail/model/exceptions/DatabaseException;", "message", "", "(Ljava/lang/String;)V", "cottontaildb"})
    public static final class DataCorruptionException
    extends DatabaseException {
        public DataCorruptionException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

