/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.binding.GrpcQueryBinder;
import org.vitrivr.cottontail.database.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.database.queries.planning.nodes.physical.management.InsertPhysicalOperatorNode;
import org.vitrivr.cottontail.database.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.sinks.SpoolerSinkOperator;
import org.vitrivr.cottontail.execution.operators.utility.NoOpSinkOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DMLGrpc;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.ExecutionException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.server.grpc.services.TransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015H\u0016J\u001e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001c2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DMLService;", "Lorg/vitrivr/cottontail/grpc/DMLGrpc$DMLImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "binder", "Lorg/vitrivr/cottontail/database/queries/binding/GrpcQueryBinder;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "planner", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "delete", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DeleteMessage;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "insert", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage;", "insertBatch", "Lcom/google/protobuf/Empty;", "update", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$UpdateMessage;", "Companion", "cottontaildb"})
@ExperimentalTime
public final class DMLService
extends DMLGrpc.DMLImplBase
implements TransactionService {
    private final GrpcQueryBinder binder;
    private final CottontailQueryPlanner planner;
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final TransactionManager manager;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    public void update(@NotNull CottontailGrpc.UpdateMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DMLService this$0;
                final /* synthetic */ CottontailGrpc.UpdateMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        QueryContext ctx = new QueryContext(tx);
                        boolean $i$f$measureTime = false;
                        boolean bl = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime2 = false;
                        boolean bl2 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                        boolean bl3 = false;
                        boolean $i$f$measureTime3 = false;
                        boolean bl4 = false;
                        TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime4 = false;
                        boolean bl5 = false;
                        TimeMark mark$iv$iv22 = $this$measureTime$iv$iv2.markNow();
                        boolean bl6 = false;
                        DMLService.access$getBinder$p(this.this$0).bind(this.$request, ctx);
                        double bindTime = mark$iv$iv22.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Parsing & binding UPDATE took " + Duration.toString-impl((double)bindTime) + '.'));
                        $i$f$measureTime4 = false;
                        boolean mark$iv$iv22 = false;
                        TimeSource $this$measureTime$iv$iv3 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime5 = false;
                        boolean bl7 = false;
                        TimeMark mark$iv$iv3 = $this$measureTime$iv$iv3.markNow();
                        boolean bl8 = false;
                        CottontailQueryPlanner.planAndSelect$default(DMLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                        double planningTime = mark$iv$iv3.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Planning UPDATE took " + Duration.toString-impl((double)planningTime) + '.'));
                        tx.execute(new SpoolerSinkOperator(ctx.toOperatorTree(tx), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver));
                        double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                        this.$responseObserver.onCompleted();
                        DMLService.access$getLOGGER$cp().info(this.this$0.formatMessage(tx, q, "Executing UPDATE took " + Duration.toString-impl((double)totalDuration) + '.'));
                    }
                    catch (QueryException.QuerySyntaxException e) {
                        String message = this.this$0.formatMessage(tx, q, "UPDATE failed due to syntax error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryBindException e) {
                        String message = this.this$0.formatMessage(tx, q, "UPDATE failed due to binding error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryPlannerException e) {
                        String message = this.this$0.formatMessage(tx, q, "UPDATE failed because of an error during query planning: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        String message = this.this$0.formatMessage(tx, q, "UPDATE failed due to deadlock with other transaction: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (ExecutionException e) {
                        String message = this.this$0.formatMessage(tx, q, "UPDATE failed due to execution error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        String message = this.this$0.formatMessage(tx, q, "UPDATE failed due an unhandled error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                    }
                }
                {
                    this.this$0 = dMLService;
                    this.$request = updateMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void delete(@NotNull CottontailGrpc.DeleteMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DMLService this$0;
                final /* synthetic */ CottontailGrpc.DeleteMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        QueryContext ctx = new QueryContext(tx);
                        boolean $i$f$measureTime = false;
                        boolean bl = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime2 = false;
                        boolean bl2 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                        boolean bl3 = false;
                        boolean $i$f$measureTime3 = false;
                        boolean bl4 = false;
                        TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime4 = false;
                        boolean bl5 = false;
                        TimeMark mark$iv$iv2 = $this$measureTime$iv$iv2.markNow();
                        boolean bl6 = false;
                        DMLService.access$getBinder$p(this.this$0).bind(this.$request, ctx);
                        double bindTime = mark$iv$iv2.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Parsing & binding DELETE took " + Duration.toString-impl((double)bindTime) + '.'));
                        boolean $i$f$measureTimedValue = false;
                        $i$f$measureTime4 = false;
                        TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTimedValue2 = false;
                        bl6 = false;
                        TimeMark mark$iv$iv3 = $this$measureTimedValue$iv$iv.markNow();
                        boolean bl7 = false;
                        CottontailQueryPlanner.planAndSelect$default(DMLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                        Unit result$iv$iv = Unit.INSTANCE;
                        TimedValue planTime = new TimedValue((Object)result$iv$iv, mark$iv$iv3.elapsedNow-UwyO8pc(), null);
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Planning DELETE took " + planTime + '.'));
                        tx.execute(new SpoolerSinkOperator(ctx.toOperatorTree(tx), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver));
                        double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                        this.$responseObserver.onCompleted();
                        DMLService.access$getLOGGER$cp().info(this.this$0.formatMessage(tx, q, "Executed DELETE in " + Duration.toString-impl((double)totalDuration) + '.'));
                    }
                    catch (QueryException.QuerySyntaxException e) {
                        String message = this.this$0.formatMessage(tx, q, "DELETE failed due to syntax error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryBindException e) {
                        String message = this.this$0.formatMessage(tx, q, "DELETE failed due to binding error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryPlannerException e) {
                        String message = this.this$0.formatMessage(tx, q, "DELETE failed because of an error during query planning: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        String message = this.this$0.formatMessage(tx, q, "DELETE failed due to deadlock with other transaction: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (ExecutionException e) {
                        String message = this.this$0.formatMessage(tx, q, "DELETE failed due to execution error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        String message = this.this$0.formatMessage(tx, q, "DELETE failed due an unhandled error: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                    }
                }
                {
                    this.this$0 = dMLService;
                    this.$request = deleteMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void insert(@NotNull CottontailGrpc.InsertMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DMLService this$0;
                final /* synthetic */ CottontailGrpc.InsertMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        QueryContext ctx = new QueryContext(tx);
                        boolean $i$f$measureTime = false;
                        boolean bl = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime2 = false;
                        boolean bl2 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                        boolean bl3 = false;
                        boolean $i$f$measureTime3 = false;
                        boolean bl4 = false;
                        TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime4 = false;
                        boolean bl5 = false;
                        TimeMark mark$iv$iv22 = $this$measureTime$iv$iv2.markNow();
                        boolean bl6 = false;
                        DMLService.access$getBinder$p(this.this$0).bind(this.$request, ctx);
                        double bindTime = mark$iv$iv22.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Parsing & binding INSERT took " + Duration.toString-impl((double)bindTime) + '.'));
                        $i$f$measureTime4 = false;
                        boolean mark$iv$iv22 = false;
                        TimeSource $this$measureTime$iv$iv3 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime5 = false;
                        boolean bl7 = false;
                        TimeMark mark$iv$iv3 = $this$measureTime$iv$iv3.markNow();
                        boolean bl8 = false;
                        CottontailQueryPlanner.planAndSelect$default(DMLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                        double planTime = mark$iv$iv3.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Planning INSERT took " + Duration.toString-impl((double)planTime) + '.'));
                        tx.execute(new SpoolerSinkOperator(ctx.toOperatorTree(tx), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver));
                        double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                        this.$responseObserver.onCompleted();
                        DMLService.access$getLOGGER$cp().info("Executed INSERT in " + Duration.toString-impl((double)totalDuration) + '.');
                    }
                    catch (QueryException.QuerySyntaxException e) {
                        String message = "INSERT failed due to syntax error: " + e.getMessage();
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryBindException e) {
                        String message = "INSERT failed due to binding error: " + e.getMessage();
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryPlannerException e) {
                        String message = this.this$0.formatMessage(tx, q, "INSERT failed because of an error during query planning: " + e.getMessage());
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        String message = "INSERT failed due to deadlock with other transaction: " + e.getMessage();
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (ExecutionException e) {
                        String message = "INSERT failed due to execution error: " + e.getMessage();
                        DMLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        String message = "INSERT failed due an unhandled error: " + e.getMessage();
                        DMLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                    }
                }
                {
                    this.this$0 = dMLService;
                    this.$request = insertMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    @NotNull
    public StreamObserver<CottontailGrpc.InsertMessage> insertBatch(@NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        return (StreamObserver)new StreamObserver<CottontailGrpc.InsertMessage>(this, responseObserver){
            private QueryContext queryContext;
            private final TransactionManager.Transaction transaction;
            private final String queryId;
            final /* synthetic */ DMLService this$0;
            final /* synthetic */ StreamObserver $responseObserver;

            public void onNext(@NotNull CottontailGrpc.InsertMessage value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                try {
                    QueryContext localContext = this.queryContext;
                    if (localContext == null) {
                        QueryContext newQueryContext = new QueryContext(this.transaction);
                        boolean $i$f$measureTime = false;
                        boolean bl = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime2 = false;
                        boolean bl2 = false;
                        TimeMark mark$iv$iv22 = $this$measureTime$iv$iv.markNow();
                        boolean bl3 = false;
                        DMLService.access$getBinder$p(this.this$0).bind(value, newQueryContext);
                        double bindTime = mark$iv$iv22.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(this.transaction, this.queryId, "Parsing & binding INSERT took " + Duration.toString-impl((double)bindTime) + '.'));
                        $i$f$measureTime2 = false;
                        boolean mark$iv$iv22 = false;
                        TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime3 = false;
                        boolean bl4 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv2.markNow();
                        boolean bl5 = false;
                        DMLService.access$getPlanner$p(this.this$0).planAndSelect(newQueryContext, true, false);
                        double planTime = mark$iv$iv.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(this.transaction, this.queryId, "Planning INSERT took " + Duration.toString-impl((double)planTime) + '.'));
                        this.queryContext = newQueryContext;
                    } else {
                        boolean $i$f$measureTime = false;
                        boolean planTime = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime4 = false;
                        boolean $i$f$measureTime5 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                        boolean bl = false;
                        Binding<Record> binding = DMLService.access$getBinder$p(this.this$0).bindValues(value, localContext);
                        OperatorNode.Physical physical = localContext.getPhysical();
                        if (physical == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.planning.nodes.physical.management.InsertPhysicalOperatorNode");
                        }
                        ((InsertPhysicalOperatorNode)physical).getRecords().add(binding);
                        double bindTime = mark$iv$iv.elapsedNow-UwyO8pc();
                        DMLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(this.transaction, this.queryId, "Parsing & binding INSERT took " + Duration.toString-impl((double)bindTime) + '.'));
                        OperatorNode.Physical physical2 = localContext.getPhysical();
                        if (physical2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.planning.nodes.physical.management.InsertPhysicalOperatorNode");
                        }
                        if (((InsertPhysicalOperatorNode)physical2).getRecords().size() >= this.this$0.getCatalogue().getConfig().getCache().getInsertCacheSize()) {
                            this.flush();
                        }
                    }
                    this.$responseObserver.onNext((Object)Empty.getDefaultInstance());
                }
                catch (QueryException.QuerySyntaxException e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due to syntax error: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().info(message);
                    this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                }
                catch (QueryException.QueryBindException e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due to binding error: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().info(message);
                    this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                }
                catch (QueryException.QueryPlannerException e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed because of an error during query planning: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().info(message);
                    this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                }
                catch (TransactionException.DeadlockException e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due to deadlock with other transaction: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().info(message);
                    this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                }
                catch (ExecutionException e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due to execution error: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().info(message);
                    this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                }
                catch (Throwable e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due an unhandled error: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().error(message, e);
                    this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.transaction.rollback();
                DMLService.access$getLOGGER$cp().info(this.this$0.formatMessage(this.transaction, this.queryId, "INSERT was aborted by the user! Force transaction to ROLLBACK."));
                this.$responseObserver.onCompleted();
            }

            public void onCompleted() {
                try {
                    this.flush();
                }
                catch (ExecutionException e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due to execution error: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().info(message);
                    this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                }
                catch (Throwable e) {
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "INSERT failed due an unhandled error: " + e.getMessage());
                    DMLService.access$getLOGGER$cp().error(message, e);
                    this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                }
                this.transaction.commit();
                this.$responseObserver.onCompleted();
            }

            private final void flush() {
                QueryContext localContext = this.queryContext;
                if (localContext != null) {
                    OperatorNode.Physical physical = localContext.getPhysical();
                    if (physical == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.planning.nodes.physical.management.InsertPhysicalOperatorNode");
                    }
                    int records = ((InsertPhysicalOperatorNode)physical).getRecords().size();
                    boolean $i$f$measureTime = false;
                    boolean bl = false;
                    TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime2 = false;
                    boolean bl2 = false;
                    TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                    boolean bl3 = false;
                    this.transaction.execute(new NoOpSinkOperator(localContext.toOperatorTree(this.transaction)));
                    this.queryContext = null;
                    double duration = mark$iv$iv.elapsedNow-UwyO8pc();
                    String message = this.this$0.formatMessage(this.transaction, this.queryId, "Executed BATCHED INSERT for " + records + " records in " + Duration.toString-impl((double)duration) + '.');
                    DMLService.access$getLOGGER$cp().info(message);
                }
            }
            {
                this.this$0 = this$0;
                this.$responseObserver = $captured_local_variable$1;
                this.transaction = this$0.getManager().new TransactionManager.Transaction(TransactionType.USER_IMPLICIT);
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
                this.queryId = string;
            }
        };
    }

    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public DMLService(@NotNull DefaultCatalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.catalogue = catalogue;
        this.manager = manager;
        this.binder = new GrpcQueryBinder(this.catalogue);
        this.planner = new CottontailQueryPlanner(CollectionsKt.listOf((Object[])new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE}), CollectionsKt.listOf((Object)BooleanIndexScanRule.INSTANCE), this.catalogue.getConfig().getCache().getPlanCacheSize());
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(DMLService.class);
    }

    @Override
    public void withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull Function2<? super TransactionManager.Transaction, ? super String, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        TransactionService.DefaultImpls.withTransactionContext(this, txId, action);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return TransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }

    public static final /* synthetic */ GrpcQueryBinder access$getBinder$p(DMLService $this) {
        return $this.binder;
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ CottontailQueryPlanner access$getPlanner$p(DMLService $this) {
        return $this.planner;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DMLService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

