/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.binding.GrpcQueryBinder;
import org.vitrivr.cottontail.database.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.database.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.DeferredFetchRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.index.KnnIndexScanRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.merge.LimitingSortMergeRule;
import org.vitrivr.cottontail.database.queries.planning.rules.physical.pushdown.CountPushdownRule;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.sinks.SpoolerSinkOperator;
import org.vitrivr.cottontail.execution.operators.system.ExplainQueryOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpc;
import org.vitrivr.cottontail.model.exceptions.ExecutionException;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.server.grpc.services.TransactionService;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u001e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015H\u0016J\u001e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DQLService;", "Lorg/vitrivr/cottontail/grpc/DQLGrpc$DQLImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "binder", "Lorg/vitrivr/cottontail/database/queries/binding/GrpcQueryBinder;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "planner", "Lorg/vitrivr/cottontail/database/queries/planning/CottontailQueryPlanner;", "explain", "", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "responseObserver", "Lio/grpc/stub/StreamObserver;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "ping", "Lcom/google/protobuf/Empty;", "query", "Companion", "cottontaildb"})
@ExperimentalTime
public final class DQLService
extends DQLGrpc.DQLImplBase
implements TransactionService {
    private final GrpcQueryBinder binder;
    private final CottontailQueryPlanner planner;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager manager;
    private static final Logger LOGGER;
    @NotNull
    public static final Companion Companion;

    public void query(@NotNull CottontailGrpc.QueryMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DQLService this$0;
                final /* synthetic */ CottontailGrpc.QueryMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        QueryContext ctx = new QueryContext(tx);
                        boolean $i$f$measureTime = false;
                        boolean bl = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime2 = false;
                        boolean bl2 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                        boolean bl3 = false;
                        boolean $i$f$measureTime3 = false;
                        boolean bl4 = false;
                        TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime4 = false;
                        boolean bl5 = false;
                        TimeMark mark$iv$iv22 = $this$measureTime$iv$iv2.markNow();
                        boolean bl6 = false;
                        GrpcQueryBinder grpcQueryBinder = DQLService.access$getBinder$p(this.this$0);
                        CottontailGrpc.Query query2 = this.$request.getQuery();
                        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                        grpcQueryBinder.bind(query2, ctx);
                        double bindTime = mark$iv$iv22.elapsedNow-UwyO8pc();
                        DQLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Parsing & binding query took " + Duration.toString-impl((double)bindTime) + '.'));
                        $i$f$measureTime4 = false;
                        boolean mark$iv$iv22 = false;
                        TimeSource $this$measureTime$iv$iv3 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime5 = false;
                        boolean bl7 = false;
                        TimeMark mark$iv$iv3 = $this$measureTime$iv$iv3.markNow();
                        boolean bl8 = false;
                        CottontailQueryPlanner.planAndSelect$default(DQLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                        double planTime = mark$iv$iv3.elapsedNow-UwyO8pc();
                        DQLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Planning query took " + Duration.toString-impl((double)planTime) + '.'));
                        tx.execute(new SpoolerSinkOperator(ctx.toOperatorTree(tx), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver));
                        double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                        DQLService.access$getLOGGER$cp().info(this.this$0.formatMessage(tx, q, "Executing query took " + Duration.toString-impl((double)totalDuration) + '.'));
                        this.$responseObserver.onCompleted();
                    }
                    catch (QueryException.QuerySyntaxException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query due to syntax error: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryBindException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query because DBO could not be found: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryPlannerException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query because of an error during query planning: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query due to deadlock with other transaction: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (ExecutionException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query due to an unhandled execution error: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query due to an unhandled error: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                    }
                }
                {
                    this.this$0 = dQLService;
                    this.$request = queryMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void explain(@NotNull CottontailGrpc.QueryMessage request, @NotNull StreamObserver<CottontailGrpc.QueryResponseMessage> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        try {
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            this.withTransactionContext(transactionId, (Function2<? super TransactionManager.Transaction, ? super String, Unit>)((Function2)new Function2<TransactionManager.Transaction, String, Unit>(this, request, responseObserver){
                final /* synthetic */ DQLService this$0;
                final /* synthetic */ CottontailGrpc.QueryMessage $request;
                final /* synthetic */ StreamObserver $responseObserver;

                public final void invoke(@NotNull TransactionManager.Transaction tx, @NotNull String q) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    Intrinsics.checkNotNullParameter((Object)q, (String)"q");
                    try {
                        QueryContext ctx = new QueryContext(tx);
                        boolean $i$f$measureTime = false;
                        boolean bl = false;
                        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime2 = false;
                        boolean bl2 = false;
                        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
                        boolean bl3 = false;
                        boolean $i$f$measureTime3 = false;
                        boolean bl4 = false;
                        TimeSource $this$measureTime$iv$iv2 = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTime4 = false;
                        boolean bl5 = false;
                        TimeMark mark$iv$iv2 = $this$measureTime$iv$iv2.markNow();
                        boolean bl6 = false;
                        GrpcQueryBinder grpcQueryBinder = DQLService.access$getBinder$p(this.this$0);
                        CottontailGrpc.Query query2 = this.$request.getQuery();
                        Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                        grpcQueryBinder.bind(query2, ctx);
                        double bindTimed = mark$iv$iv2.elapsedNow-UwyO8pc();
                        DQLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Parsing & binding query took " + Duration.toString-impl((double)bindTimed) + '.'));
                        boolean $i$f$measureTimedValue = false;
                        $i$f$measureTime4 = false;
                        TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                        boolean $i$f$measureTimedValue2 = false;
                        bl6 = false;
                        TimeMark mark$iv$iv3 = $this$measureTimedValue$iv$iv.markNow();
                        boolean bl7 = false;
                        Collection<OperatorNode.Physical> candidates = DQLService.access$getPlanner$p(this.this$0).plan(ctx);
                        SpoolerSinkOperator result$iv$iv = new SpoolerSinkOperator(new ExplainQueryOperator(candidates), q, 0, (StreamObserver<CottontailGrpc.QueryResponseMessage>)this.$responseObserver);
                        TimedValue planTimedValue = new TimedValue((Object)result$iv$iv, mark$iv$iv3.elapsedNow-UwyO8pc(), null);
                        DQLService.access$getLOGGER$cp().debug(this.this$0.formatMessage(tx, q, "Planning query took " + Duration.toString-impl((double)planTimedValue.getDuration-UwyO8pc()) + '.'));
                        tx.execute((Operator.SinkOperator)planTimedValue.getValue());
                        double totalDuration = mark$iv$iv.elapsedNow-UwyO8pc();
                        DQLService.access$getLOGGER$cp().info(this.this$0.formatMessage(tx, q, "Explaining query took " + Duration.toString-impl((double)totalDuration) + '.'));
                        this.$responseObserver.onCompleted();
                    }
                    catch (QueryException.QuerySyntaxException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not explain query due to syntax error: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryBindException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not explain query because DBO could not be found: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(message).asException());
                    }
                    catch (QueryException.QueryPlannerException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not execute query because of an error during query planning: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (TransactionException.DeadlockException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not explain query due to deadlock with other transaction: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().info(message);
                        this.$responseObserver.onError((Throwable)Status.ABORTED.withDescription(message).asException());
                    }
                    catch (ExecutionException e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not explain query due to an unhandled execution error: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().error(message, (Throwable)e);
                        this.$responseObserver.onError((Throwable)Status.INTERNAL.withDescription(message).asException());
                    }
                    catch (Throwable e) {
                        String message = this.this$0.formatMessage(tx, q, "Could not explain query due to an unhandled error: " + e.getMessage());
                        DQLService.access$getLOGGER$cp().error(message, e);
                        this.$responseObserver.onError((Throwable)Status.UNKNOWN.withDescription(message).asException());
                    }
                }
                {
                    this.this$0 = dQLService;
                    this.$request = queryMessage;
                    this.$responseObserver = streamObserver;
                    super(2);
                }
            }));
        }
        catch (TransactionException.TransactionNotFoundException e) {
            StringBuilder stringBuilder = new StringBuilder().append("Execution failed because transaction ");
            CottontailGrpc.TransactionId transactionId = request.getTxId();
            Intrinsics.checkNotNullExpressionValue((Object)transactionId, (String)"request.txId");
            String message = stringBuilder.append(transactionId.getValue()).append(" could not be resumed.").toString();
            LOGGER.info(message);
            responseObserver.onError((Throwable)Status.FAILED_PRECONDITION.withDescription(message).asException());
        }
    }

    public void ping(@NotNull Empty request, @NotNull StreamObserver<Empty> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        responseObserver.onCompleted();
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    public DQLService(@NotNull Catalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.catalogue = catalogue;
        this.manager = manager;
        this.binder = new GrpcQueryBinder(this.catalogue);
        this.planner = new CottontailQueryPlanner(CollectionsKt.listOf((Object[])new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE, LeftConjunctionOnSubselectRewriteRule.INSTANCE, RightConjunctionOnSubselectRewriteRule.INSTANCE, DeferredFetchRewriteRule.INSTANCE}), CollectionsKt.listOf((Object[])new RewriteRule[]{BooleanIndexScanRule.INSTANCE, KnnIndexScanRule.INSTANCE, CountPushdownRule.INSTANCE, LimitingSortMergeRule.INSTANCE}), this.catalogue.getConfig().getCache().getPlanCacheSize());
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(DQLService.class);
    }

    @Override
    public void withTransactionContext(@NotNull CottontailGrpc.TransactionId txId, @NotNull Function2<? super TransactionManager.Transaction, ? super String, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)txId, (String)"txId");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        TransactionService.DefaultImpls.withTransactionContext(this, txId, action);
    }

    @Override
    @NotNull
    public String formatMessage(@NotNull TransactionManager.Transaction tx, @NotNull String queryId, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return TransactionService.DefaultImpls.formatMessage(this, tx, queryId, message);
    }

    public static final /* synthetic */ GrpcQueryBinder access$getBinder$p(DQLService $this) {
        return $this.binder;
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ CottontailQueryPlanner access$getPlanner$p(DQLService $this) {
        return $this.planner;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DQLService$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

