/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.data.exporter;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.exporter.DataExporter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/utilities/data/exporter/ProtoDataExporter;", "Lorg/vitrivr/cottontail/utilities/data/exporter/DataExporter;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "<set-?>", "", "closed", "getClosed", "()Z", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "output", "Ljava/io/OutputStream;", "kotlin.jvm.PlatformType", "getPath", "()Ljava/nio/file/Path;", "close", "", "offer", "message", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "cottontaildb"})
public final class ProtoDataExporter
implements DataExporter {
    @NotNull
    private final Format format;
    private boolean closed;
    private final OutputStream output;
    @NotNull
    private final Path path;

    @Override
    @NotNull
    public Format getFormat() {
        return this.format;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public void offer(@NotNull CottontailGrpc.QueryResponseMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        for (CottontailGrpc.QueryResponseMessage.Tuple tuple : message.getTuplesList()) {
            CottontailGrpc.InsertMessage.Builder insert2 = CottontailGrpc.InsertMessage.newBuilder();
            CottontailGrpc.QueryResponseMessage.Tuple tuple2 = tuple;
            Intrinsics.checkNotNullExpressionValue((Object)tuple2, (String)"tuple");
            List list = tuple2.getDataList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tuple.dataList");
            Iterable iterable = list;
            List list2 = message.getColumnsList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"message.columnsList");
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair e = (Pair)element$iv;
                boolean bl = false;
                insert2.addInserts(CottontailGrpc.InsertMessage.InsertElement.newBuilder().setValue((CottontailGrpc.Literal)e.getFirst()).setColumn((CottontailGrpc.ColumnName)e.getSecond()));
            }
            insert2.build().writeDelimitedTo(this.output);
        }
        this.output.flush();
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.output.close();
            this.closed = true;
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    public ProtoDataExporter(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.format = Format.PROTO;
        this.output = Files.newOutputStream(this.getPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }
}

