/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli;

import com.github.ajalt.clikt.core.BadParameterValue;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.CliktCommandKt;
import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.core.MissingArgument;
import com.github.ajalt.clikt.core.MissingOption;
import com.github.ajalt.clikt.core.NoOpCliktCommand;
import com.github.ajalt.clikt.core.NoSuchOption;
import com.github.ajalt.clikt.core.NoSuchSubcommand;
import com.github.ajalt.clikt.core.PrintHelpMessage;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.output.CliktHelpFormatter;
import com.github.ajalt.clikt.output.HelpFormatter;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.cli.DelegateCompleter;
import org.vitrivr.cottontail.cli.entity.AboutEntityCommand;
import org.vitrivr.cottontail.cli.entity.ClearEntityCommand;
import org.vitrivr.cottontail.cli.entity.CreateEntityCommand;
import org.vitrivr.cottontail.cli.entity.CreateIndexCommand;
import org.vitrivr.cottontail.cli.entity.DropEntityCommand;
import org.vitrivr.cottontail.cli.entity.DropIndexCommand;
import org.vitrivr.cottontail.cli.entity.DumpEntityCommand;
import org.vitrivr.cottontail.cli.entity.ImportDataCommand;
import org.vitrivr.cottontail.cli.entity.ListAllEntitiesCommand;
import org.vitrivr.cottontail.cli.entity.OptimizeEntityCommand;
import org.vitrivr.cottontail.cli.query.CountEntityCommand;
import org.vitrivr.cottontail.cli.query.ExecuteQueryCommand;
import org.vitrivr.cottontail.cli.query.FindInEntityCommand;
import org.vitrivr.cottontail.cli.query.PreviewEntityCommand;
import org.vitrivr.cottontail.cli.schema.CreateSchemaCommand;
import org.vitrivr.cottontail.cli.schema.DropSchemaCommand;
import org.vitrivr.cottontail.cli.schema.ListAllSchemaCommand;
import org.vitrivr.cottontail.cli.schema.ListEntitiesCommand;
import org.vitrivr.cottontail.cli.system.ListLocksCommand;
import org.vitrivr.cottontail.cli.system.ListTransactionsCommand;
import org.vitrivr.cottontail.cli.system.MigrationCommand;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DDLGrpc;
import org.vitrivr.cottontail.grpc.DMLGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpc;
import org.vitrivr.cottontail.grpc.TXNGrpc;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u0006\u0010\u0017\u001a\u00020\u0012J\"\u0010\u0018\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015J\u0014\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/cli/Cli;", "", "host", "", "port", "", "(Ljava/lang/String;I)V", "clikt", "Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;", "completer", "Lorg/vitrivr/cottontail/cli/DelegateCompleter;", "getHost", "()Ljava/lang/String;", "getPort", "()I", "stopped", "", "loop", "", "resetCompletion", "splitLine", "", "line", "stop", "updateArgumentCompletion", "schemata", "entities", "updateCompletion", "strings", "Companion", "CottontailCommand", "cottontaildb"})
@ExperimentalTime
public final class Cli {
    private final CottontailCommand clikt;
    private final DelegateCompleter completer;
    private volatile boolean stopped;
    @NotNull
    private final String host;
    private final int port;
    private static final String PROMPT = "cottontaildb> ";
    private static final Pattern LINE_SPLIT_REGEX;
    @NotNull
    public static final Companion Companion;

    public final void updateCompletion(@NotNull List<String> strings) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        this.completer.setDelegate((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"}), (Completer)new StringsCompleter((Iterable)this.clikt.registeredSubcommandNames()), (Completer)new StringsCompleter((Iterable)strings)}));
    }

    public final void updateArgumentCompletion(@NotNull List<String> schemata, @NotNull List<String> entities) {
        Intrinsics.checkNotNullParameter(schemata, (String)"schemata");
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        ArgumentCompleter args = new ArgumentCompleter(new Completer[]{(Completer)new StringsCompleter((Iterable)this.clikt.registeredSubcommandNames()), (Completer)new StringsCompleter((Iterable)schemata), (Completer)new StringsCompleter((Iterable)entities), (Completer)new NullCompleter()});
        args.setStrictCommand(true);
        args.setStrict(false);
        this.completer.setDelegate((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"}), (Completer)args}));
    }

    public final void resetCompletion() {
        this.completer.setDelegate((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"}), (Completer)new StringsCompleter((Iterable)this.clikt.registeredSubcommandNames())}));
    }

    public final void loop() {
        Terminal terminal;
        try {
            terminal = TerminalBuilder.builder().jansi(true).build();
        }
        catch (IOException e) {
            System.err.println("Could not initialize terminal: " + e.getMessage() + ". Aborting...");
            return;
        }
        Terminal terminal2 = terminal;
        try {
            this.clikt.initCompletion();
        }
        catch (StatusRuntimeException e) {
            System.err.println("Failed to fetch schema from Cottontail DB instance; some commands may be unavailable!");
        }
        LineReader lineReader = LineReaderBuilder.builder().terminal(terminal2).completer((Completer)this.completer).build();
        while (!this.stopped) {
            String line;
            boolean bl;
            String string;
            try {
                String string2 = lineReader.readLine(PROMPT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineReader.readLine(PROMPT)");
                string = string2;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            }
            catch (EndOfFileException e) {
                System.err.println("Could not read from terminal. If you're running Cottontail DB in Docker, then either run Docker in interactive mode (-it) or switch off the Cottontail DB CLI via the config.");
                break;
            }
            catch (UserInterruptException e) {
                System.err.println("Cottontail DB was interrupted by the user (Ctrl-C).");
                break;
            }
            string = line = string;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string5, (Object)"help")) {
                string = this.clikt.getFormattedHelp();
                bl = false;
                System.out.println((Object)string);
                continue;
            }
            if (StringsKt.isBlank((CharSequence)line)) continue;
            try {
                CliktCommand.parse$default((CliktCommand)((CliktCommand)this.clikt), this.splitLine(line), null, (int)2, null);
                boolean bl2 = false;
                System.out.println();
            }
            catch (Exception e) {
                boolean bl3;
                String string6;
                Exception exception = e;
                if (exception instanceof PrintHelpMessage) {
                    string6 = ((PrintHelpMessage)e).getCommand().getFormattedHelp();
                    bl3 = false;
                    System.out.println((Object)string6);
                }
                if (exception instanceof NoSuchSubcommand || exception instanceof MissingArgument || exception instanceof MissingOption || exception instanceof BadParameterValue || exception instanceof UsageError || exception instanceof NoSuchOption) {
                    string6 = e.getLocalizedMessage();
                    bl3 = false;
                    System.out.println((Object)string6);
                }
                if (exception instanceof StatusException || exception instanceof StatusRuntimeException) {
                    string6 = e.getLocalizedMessage();
                    bl3 = false;
                    System.out.println((Object)string6);
                }
                e.printStackTrace();
                string6 = Unit.INSTANCE;
                bl3 = false;
                System.out.println((Object)string6);
            }
            Thread.sleep(100L);
        }
    }

    private final List<String> splitLine(String line) {
        block7: {
            block6: {
                if (line == null) break block6;
                CharSequence charSequence = line;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            return CollectionsKt.emptyList();
        }
        List matchList = new ArrayList();
        Matcher regexMatcher = LINE_SPLIT_REGEX.matcher(line);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                String string = regexMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group(1)");
                matchList.add(string);
                continue;
            }
            if (regexMatcher.group(2) != null) {
                String string = regexMatcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group(2)");
                matchList.add(string);
                continue;
            }
            String string = regexMatcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group()");
            matchList.add(string);
        }
        return matchList;
    }

    public final void stop() {
        this.stopped = true;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public Cli(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.clikt = new CottontailCommand();
        this.completer = new DelegateCompleter((Completer)new AggregateCompleter(new Completer[]{(Completer)new StringsCompleter(new String[]{"help"})}));
    }

    public /* synthetic */ Cli(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 1865;
        }
        this(string, n);
    }

    public Cli() {
        this(null, 0, 3, null);
    }

    static {
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"[^\\\\s\\\"\u2026|\\\"([^\\\"]*)\\\"|'([^']*)'\")");
        LINE_SPLIT_REGEX = pattern;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000fH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;", "Lcom/github/ajalt/clikt/core/NoOpCliktCommand;", "(Lorg/vitrivr/cottontail/cli/Cli;)V", "channel", "Lio/grpc/ManagedChannel;", "ddlService", "Lorg/vitrivr/cottontail/grpc/DDLGrpc$DDLBlockingStub;", "kotlin.jvm.PlatformType", "dmlService", "Lorg/vitrivr/cottontail/grpc/DMLGrpc$DMLBlockingStub;", "dqlService", "Lorg/vitrivr/cottontail/grpc/DQLGrpc$DQLBlockingStub;", "txnService", "Lorg/vitrivr/cottontail/grpc/TXNGrpc$TXNBlockingStub;", "aliases", "", "", "", "initCompletion", "", "CliHelpFormatter", "StopCommand", "cottontaildb"})
    @ExperimentalTime
    public final class CottontailCommand
    extends NoOpCliktCommand {
        private final ManagedChannel channel;
        private final DQLGrpc.DQLBlockingStub dqlService;
        private final DDLGrpc.DDLBlockingStub ddlService;
        private final DMLGrpc.DMLBlockingStub dmlService;
        private final TXNGrpc.TXNBlockingStub txnService;

        @NotNull
        public Map<String, List<String>> aliases() {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"sls", (Object)CollectionsKt.listOf((Object[])new String[]{"schema", "all"})), TuplesKt.to((Object)"els", (Object)CollectionsKt.listOf((Object[])new String[]{"schema", "list"})), TuplesKt.to((Object)"tls", (Object)CollectionsKt.listOf((Object[])new String[]{"system", "list-transactions"})), TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object[])new String[]{"entity", "all"})), TuplesKt.to((Object)"edelete", (Object)CollectionsKt.listOf((Object[])new String[]{"entity", "drop"})), TuplesKt.to((Object)"edel", (Object)CollectionsKt.listOf((Object[])new String[]{"entity", "drop"})), TuplesKt.to((Object)"erm", (Object)CollectionsKt.listOf((Object[])new String[]{"entity", "drop"})), TuplesKt.to((Object)"eremove", (Object)CollectionsKt.listOf((Object[])new String[]{"entity", "drop"})), TuplesKt.to((Object)"delete", (Object)CollectionsKt.listOf((Object[])new String[]{"schema", "drop"})), TuplesKt.to((Object)"del", (Object)CollectionsKt.listOf((Object[])new String[]{"schema", "drop"})), TuplesKt.to((Object)"rm", (Object)CollectionsKt.listOf((Object[])new String[]{"schema", "drop"})), TuplesKt.to((Object)"remove", (Object)CollectionsKt.listOf((Object[])new String[]{"schema", "drop"})), TuplesKt.to((Object)"li", (Object)CollectionsKt.listOf((Object[])new String[]{"entity", "list-indices"})), TuplesKt.to((Object)"quit", (Object)CollectionsKt.listOf((Object)"stop")), TuplesKt.to((Object)"exit", (Object)CollectionsKt.listOf((Object)"stop")), TuplesKt.to((Object)"schemas", (Object)CollectionsKt.listOf((Object)"schema")), TuplesKt.to((Object)"entities", (Object)CollectionsKt.listOf((Object)"entity"))});
        }

        /*
         * WARNING - void declaration
         */
        public final void initCompletion() {
            Object object;
            Collection<String> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            boolean bl = false;
            List schemata = new ArrayList();
            boolean bl2 = false;
            List entities = new ArrayList();
            Iterator iterator2 = this.ddlService.listSchemas(CottontailGrpc.ListSchemaMessage.getDefaultInstance());
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"this@CottontailCommand.d\u2026age.getDefaultInstance())");
            Object $this$forEach$iv = iterator2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv;
            boolean bl3 = false;
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Object element$iv = iterator4.next();
                CottontailGrpc.QueryResponseMessage _schema = (CottontailGrpc.QueryResponseMessage)element$iv;
                boolean bl4 = false;
            }
            $this$forEach$iv = schemata;
            Cli cli = Cli.this;
            boolean $i$f$map = false;
            iterator3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CottontailGrpc.SchemaName bl4 = (CottontailGrpc.SchemaName)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                object = it.getName();
                collection.add((String)object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = entities;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CottontailGrpc.EntityName it = (CottontailGrpc.EntityName)item$iv$iv;
                object = destination$iv$iv;
                boolean bl6 = false;
                String string = it.getName();
                object.add(string);
            }
            object = (List)destination$iv$iv;
            cli.updateArgumentCompletion((List<String>)collection, (List<String>)object);
        }

        public CottontailCommand() {
            boolean bl = false;
            String string = null;
            Map map2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = "The base command for all CLI commands.";
            String string3 = null;
            String string4 = "cottontail";
            super(string2, string3, string4, bl3, bl2, map2, string, bl, 250, null);
            ManagedChannel managedChannel = ManagedChannelBuilder.forAddress((String)Cli.this.getHost(), (int)Cli.this.getPort()).enableFullStreamDecompression().usePlaintext().build();
            Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"ManagedChannelBuilder\n  \u2026xt()\n            .build()");
            this.channel = managedChannel;
            this.dqlService = DQLGrpc.newBlockingStub((Channel)((Channel)this.channel));
            this.ddlService = DDLGrpc.newBlockingStub((Channel)((Channel)this.channel));
            this.dmlService = DMLGrpc.newBlockingStub((Channel)((Channel)this.channel));
            this.txnService = TXNGrpc.newBlockingStub((Channel)((Channel)this.channel));
            CliktCommandKt.context((CliktCommand)this, (Function1)((Function1)new Function1<Context.Builder, Unit>(){

                public final void invoke(@NotNull Context.Builder $this$context) {
                    Intrinsics.checkNotNullParameter((Object)$this$context, (String)"$receiver");
                    $this$context.setHelpFormatter((HelpFormatter)new CliHelpFormatter());
                }
            }));
            CliktCommand[] cliktCommandArray = new CliktCommand[5];
            CliktCommand cliktCommand = (CliktCommand)new NoOpCliktCommand("entity", "Groups commands that act on Cottontail DB entities. Usually requires the entity's qualified name.", "Entity related commands usually have the form: entity <command> <name>, `entity about schema_name.entity_name. Check help for command specific parameters.", true, true){

                @NotNull
                public Map<String, List<String>> aliases() {
                    return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object)"list")), TuplesKt.to((Object)"list-indexes", (Object)CollectionsKt.listOf((Object)"list-indices"))});
                }
            };
            CliktCommand[] cliktCommandArray2 = new CliktCommand[10];
            DDLGrpc.DDLBlockingStub dDLBlockingStub = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub, (String)"this.ddlService");
            cliktCommandArray2[0] = new AboutEntityCommand(dDLBlockingStub);
            DMLGrpc.DMLBlockingStub dMLBlockingStub = this.dmlService;
            Intrinsics.checkNotNullExpressionValue((Object)dMLBlockingStub, (String)"this.dmlService");
            cliktCommandArray2[1] = new ClearEntityCommand(dMLBlockingStub);
            DDLGrpc.DDLBlockingStub dDLBlockingStub2 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub2, (String)"this.ddlService");
            cliktCommandArray2[2] = new CreateEntityCommand(dDLBlockingStub2);
            DDLGrpc.DDLBlockingStub dDLBlockingStub3 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub3, (String)"this.ddlService");
            cliktCommandArray2[3] = new DropEntityCommand(dDLBlockingStub3);
            DQLGrpc.DQLBlockingStub dQLBlockingStub = this.dqlService;
            Intrinsics.checkNotNullExpressionValue((Object)dQLBlockingStub, (String)"this.dqlService");
            cliktCommandArray2[4] = new DumpEntityCommand(dQLBlockingStub);
            DDLGrpc.DDLBlockingStub dDLBlockingStub4 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub4, (String)"this.ddlService");
            cliktCommandArray2[5] = new ListAllEntitiesCommand(dDLBlockingStub4);
            DDLGrpc.DDLBlockingStub dDLBlockingStub5 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub5, (String)"this.ddlService");
            cliktCommandArray2[6] = new OptimizeEntityCommand(dDLBlockingStub5);
            DDLGrpc.DDLBlockingStub dDLBlockingStub6 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub6, (String)"this.ddlService");
            cliktCommandArray2[7] = new CreateIndexCommand(dDLBlockingStub6);
            DDLGrpc.DDLBlockingStub dDLBlockingStub7 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub7, (String)"this.ddlService");
            cliktCommandArray2[8] = new DropIndexCommand(dDLBlockingStub7);
            DDLGrpc.DDLBlockingStub dDLBlockingStub8 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub8, (String)"this.ddlService");
            DMLGrpc.DMLBlockingStub dMLBlockingStub2 = this.dmlService;
            Intrinsics.checkNotNullExpressionValue((Object)dMLBlockingStub2, (String)"this.dmlService");
            TXNGrpc.TXNBlockingStub tXNBlockingStub = this.txnService;
            Intrinsics.checkNotNullExpressionValue((Object)tXNBlockingStub, (String)"this.txnService");
            cliktCommandArray2[9] = new ImportDataCommand(dDLBlockingStub8, dMLBlockingStub2, tXNBlockingStub);
            cliktCommandArray[0] = CliktCommandKt.subcommands((CliktCommand)cliktCommand, (CliktCommand[])cliktCommandArray2);
            CliktCommand cliktCommand2 = (CliktCommand)new NoOpCliktCommand("schema", "Groups commands that act on Cottontail DB  schemas. Usually requires the schema's qualified name", "Schema related commands usually have the form: schema <command> <name>, e.g., `schema list schema_name` Check help for command specific parameters.", true, true){

                @NotNull
                public Map<String, List<String>> aliases() {
                    return MapsKt.mapOf((Pair)TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object)"list")));
                }
            };
            CliktCommand[] cliktCommandArray3 = new CliktCommand[4];
            DDLGrpc.DDLBlockingStub dDLBlockingStub9 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub9, (String)"this.ddlService");
            cliktCommandArray3[0] = new CreateSchemaCommand(dDLBlockingStub9);
            DDLGrpc.DDLBlockingStub dDLBlockingStub10 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub10, (String)"this.ddlService");
            cliktCommandArray3[1] = new DropSchemaCommand(dDLBlockingStub10);
            DDLGrpc.DDLBlockingStub dDLBlockingStub11 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub11, (String)"this.ddlService");
            cliktCommandArray3[2] = new ListAllSchemaCommand(dDLBlockingStub11);
            DDLGrpc.DDLBlockingStub dDLBlockingStub12 = this.ddlService;
            Intrinsics.checkNotNullExpressionValue((Object)dDLBlockingStub12, (String)"this.ddlService");
            cliktCommandArray3[3] = new ListEntitiesCommand(dDLBlockingStub12);
            cliktCommandArray[1] = CliktCommandKt.subcommands((CliktCommand)cliktCommand2, (CliktCommand[])cliktCommandArray3);
            CliktCommand cliktCommand3 = (CliktCommand)new NoOpCliktCommand("query", "Groups commands that can be used to query Cottontail DB.", "Transaction related commands usually have the form: query <command>, e.g., `query execute`.", true, true){};
            CliktCommand[] cliktCommandArray4 = new CliktCommand[4];
            DQLGrpc.DQLBlockingStub dQLBlockingStub2 = this.dqlService;
            Intrinsics.checkNotNullExpressionValue((Object)dQLBlockingStub2, (String)"this.dqlService");
            cliktCommandArray4[0] = new CountEntityCommand(dQLBlockingStub2);
            DQLGrpc.DQLBlockingStub dQLBlockingStub3 = this.dqlService;
            Intrinsics.checkNotNullExpressionValue((Object)dQLBlockingStub3, (String)"this.dqlService");
            cliktCommandArray4[1] = new PreviewEntityCommand(dQLBlockingStub3);
            DQLGrpc.DQLBlockingStub dQLBlockingStub4 = this.dqlService;
            Intrinsics.checkNotNullExpressionValue((Object)dQLBlockingStub4, (String)"this.dqlService");
            cliktCommandArray4[2] = new FindInEntityCommand(dQLBlockingStub4);
            DQLGrpc.DQLBlockingStub dQLBlockingStub5 = this.dqlService;
            Intrinsics.checkNotNullExpressionValue((Object)dQLBlockingStub5, (String)"this.dqlService");
            cliktCommandArray4[3] = new ExecuteQueryCommand(dQLBlockingStub5);
            cliktCommandArray[2] = CliktCommandKt.subcommands((CliktCommand)cliktCommand3, (CliktCommand[])cliktCommandArray4);
            CliktCommand cliktCommand4 = (CliktCommand)new NoOpCliktCommand("system", "Groups commands that act on the Cottontail DB on a system level.", "Transaction related commands usually have the form: system <command> <txId>, e.g., `transaction list-transactions`.", true, true){

                @NotNull
                public Map<String, List<String>> aliases() {
                    return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object)"list")), TuplesKt.to((Object)"tls", (Object)CollectionsKt.listOf((Object)"transactions")), TuplesKt.to((Object)"list-transactionstls", (Object)CollectionsKt.listOf((Object)"transactions"))});
                }
            };
            CliktCommand[] cliktCommandArray5 = new CliktCommand[3];
            TXNGrpc.TXNBlockingStub tXNBlockingStub2 = this.txnService;
            Intrinsics.checkNotNullExpressionValue((Object)tXNBlockingStub2, (String)"this.txnService");
            cliktCommandArray5[0] = new ListTransactionsCommand(tXNBlockingStub2);
            TXNGrpc.TXNBlockingStub tXNBlockingStub3 = this.txnService;
            Intrinsics.checkNotNullExpressionValue((Object)tXNBlockingStub3, (String)"this.txnService");
            cliktCommandArray5[1] = new ListLocksCommand(tXNBlockingStub3);
            cliktCommandArray5[2] = new MigrationCommand();
            cliktCommandArray[3] = CliktCommandKt.subcommands((CliktCommand)cliktCommand4, (CliktCommand[])cliktCommandArray5);
            cliktCommandArray[4] = new StopCommand();
            CliktCommandKt.subcommands((CliktCommand)this, (CliktCommand[])cliktCommandArray);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand$CliHelpFormatter;", "Lcom/github/ajalt/clikt/output/CliktHelpFormatter;", "(Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;)V", "formatHelp", "", "prolog", "epilog", "parameters", "", "Lcom/github/ajalt/clikt/output/HelpFormatter$ParameterHelp;", "programName", "cottontaildb"})
        public final class CliHelpFormatter
        extends CliktHelpFormatter {
            @NotNull
            public String formatHelp(@NotNull String prolog, @NotNull String epilog, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters, @NotNull String programName) {
                Intrinsics.checkNotNullParameter((Object)prolog, (String)"prolog");
                Intrinsics.checkNotNullParameter((Object)epilog, (String)"epilog");
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)programName, (String)"programName");
                boolean bl = false;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder $this$buildString = stringBuilder;
                boolean bl5 = false;
                if (StringsKt.contains$default((CharSequence)programName, (CharSequence)" ", (boolean)false, (int)2, null)) {
                    this.addUsage($this$buildString, parameters, (String)StringsKt.split$default((CharSequence)programName, (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null).get(1));
                } else {
                    this.addUsage($this$buildString, parameters, programName);
                }
                this.addOptions($this$buildString, parameters);
                this.addArguments($this$buildString, parameters);
                this.addCommands($this$buildString, parameters);
                if (StringsKt.endsWith$default((String)programName, (String)"cottontail", (boolean)false, (int)2, null)) {
                    this.addEpilog($this$buildString, "\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0((`\\\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0___\u00a0\\\\\u00a0'--._\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0.'`\u00a0\u00a0\u00a0`'\u00a0\u00a0\u00a0\u00a0o\u00a0\u00a0)\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0/\u00a0\u00a0\u00a0\u00a0\\\u00a0\u00a0\u00a0'.\u00a0__.'\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0_|\u00a0\u00a0\u00a0\u00a0/_\u00a0\u00a0\\\u00a0\\_\\_\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0{_\\______\\-'\\__\\_\\\u0085\u0085by jks from https://www.asciiart.eu/animals/rabbits");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }

            public CliHelpFormatter() {
                super(null, null, null, 0, null, 0, null, false, false, 511, null);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand$StopCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand;", "(Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;)V", "exec", "", "cottontaildb"})
        public final class StopCommand
        extends AbstractCottontailCommand {
            @Override
            public void exec() {
                String string = "Stopping Cottontail DB now...";
                boolean bl = false;
                System.out.println((Object)string);
                Cli.this.stop();
            }

            public StopCommand() {
                super("stop", "Stops the database server and this CLI");
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$Companion;", "", "()V", "LINE_SPLIT_REGEX", "Ljava/util/regex/Pattern;", "PROMPT", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

