/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.column.ColumnTx;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityHeader;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.entity.EntityTxSnapshot;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.schema.DefaultSchema;
import org.vitrivr.cottontail.database.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.database.statistics.entity.EntityStatistics;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.utilities.io.FileUtilities;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 =2\u00020\u0001:\u0002=>B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020,H\u0002J\u0014\u00109\u001a\u00060:R\u00020\u00002\u0006\u0010;\u001a\u00020<H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00060\u0019j\u0002`\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020,0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006?"}, d2={"Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/schema/DefaultSchema;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "Lorg/vitrivr/cottontail/database/column/Column;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/entity/EntityHeader;", "indexes", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "Lorg/vitrivr/cottontail/database/index/Index;", "maxTupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "numberOfColumns", "", "getNumberOfColumns", "()I", "numberOfRows", "getNumberOfRows", "getParent", "()Lorg/vitrivr/cottontail/database/schema/DefaultSchema;", "getPath", "()Ljava/nio/file/Path;", "statistics", "Lorg/vitrivr/cottontail/database/statistics/entity/EntityStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/database/statistics/entity/EntityStatistics;", "statisticsField", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newStatistics", "newTx", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class DefaultEntity
implements Entity {
    private final DB store;
    private final Atomic.Var<EntityHeader> headerField;
    private final Atomic.Var<EntityStatistics> statisticsField;
    @NotNull
    private final Name.EntityName name;
    private final StampedLock closeLock;
    private final Map<Name.ColumnName, Column<?>> columns;
    private final Map<Name.IndexName, Index> indexes;
    private volatile boolean closed;
    @NotNull
    private final Path path;
    @NotNull
    private final DefaultSchema parent;
    @NotNull
    public static final String CATALOGUE_FILE = "index.db";
    @NotNull
    public static final String ENTITY_HEADER_FIELD = "cdb_entity_header";
    @NotNull
    public static final String ENTITY_STATISTICS_FIELD = "cdb_entity_statistics";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    @NotNull
    public EntityStatistics getStatistics() {
        Object object = this.statisticsField.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.statisticsField.get()");
        return (EntityStatistics)object;
    }

    @Override
    public long getNumberOfRows() {
        return this.getStatistics().getCount();
    }

    @Override
    public long getMaxTupleId() {
        return this.getStatistics().getMaximumTupleId();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new Tx(context);
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            try {
                long stamp = this.closeLock.tryWriteLock(1000L, TimeUnit.MILLISECONDS);
                try {
                    Iterable $this$forEach$iv = this.columns.values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Column it = (Column)element$iv;
                        boolean bl = false;
                        it.close();
                    }
                    this.store.close();
                    this.closed = true;
                }
                catch (Throwable e) {
                    this.closeLock.unlockWrite(stamp);
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw (Throwable)new IllegalStateException("Could not close entity " + this.getName() + ". Failed to acquire exclusive lock which indicates, that transaction wasn't closed properly.");
            }
        }
    }

    private final EntityStatistics newStatistics() {
        EntityStatistics statistics = new EntityStatistics(0L, 0L, 3, null);
        Iterable $this$forEach$iv = this.columns.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column it = (Column)element$iv;
            boolean bl = false;
            ValueStatistics<Value> valueStatistics = it.getType().statistics();
            if (valueStatistics == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.statistics.columns.ValueStatistics<org.vitrivr.cottontail.model.values.types.Value>");
            }
            statistics.set(it.getColumnDef(), valueStatistics);
        }
        return statistics;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public DefaultSchema getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultEntity(@NotNull Path path, @NotNull DefaultSchema parent) {
        void $this$mapTo$iv$iv;
        DB dB;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        Object object = this;
        try {
            DefaultEntity defaultEntity = object;
            MapDBConfig mapDBConfig = this.getParent().getParent().getConfig().getMapdb();
            Path path2 = this.getPath().resolve(CATALOGUE_FILE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(CATALOGUE_FILE)");
            dB = mapDBConfig.db(path2);
        }
        catch (DBException dBException) {
            void e;
            DefaultEntity defaultEntity = object;
            throw (Throwable)new DatabaseException("Failed to open entity at " + this.getPath() + ": " + e.getMessage() + "'.");
        }
        defaultEntity.store = dB;
        this.headerField = (Atomic.Var)this.store.atomicVar(ENTITY_HEADER_FIELD, (Serializer)EntityHeader.Serializer).createOrOpen();
        this.statisticsField = (Atomic.Var)this.store.atomicVar(ENTITY_STATISTICS_FIELD, (Serializer)EntityStatistics.Serializer).createOrOpen();
        this.name = this.getParent().getName().entity(((EntityHeader)this.headerField.get()).getName());
        this.closeLock = new StampedLock();
        this.columns = (Map)new Object2ObjectLinkedOpenHashMap();
        this.indexes = (Map)new Object2ObjectOpenHashMap();
        EntityHeader header = (EntityHeader)this.headerField.get();
        Iterable $this$map$iv = header.getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EntityHeader.ColumnRef columnRef = (EntityHeader.ColumnRef)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Name.ColumnName columnName = this.getName().column(it.getName());
            Path path3 = this.getPath().resolve(it.getName() + ".col");
            ColumnEngine columnEngine = it.getType();
            Path path4 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
            this.columns.put(columnName, columnEngine.open(path4, this));
            Unit unit = Unit.INSTANCE;
            object.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = header.getIndexes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityHeader.IndexRef it = (EntityHeader.IndexRef)element$iv;
            boolean bl = false;
            Name.IndexName indexName = this.getName().index(it.getName());
            Path path5 = this.getPath().resolve(it.getName() + ".idx");
            IndexType indexType = it.getType();
            Path path6 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"path");
            this.indexes.put(indexName, indexType.open(path6, this));
        }
        if (this.statisticsField.get() == null) {
            this.statisticsField.set((Object)this.newStatistics());
        }
    }

    public static final /* synthetic */ Atomic.Var access$getStatisticsField$p(DefaultEntity $this) {
        return $this.statisticsField;
    }

    public static final /* synthetic */ DB access$getStore$p(DefaultEntity $this) {
        return $this.store;
    }

    public static final /* synthetic */ Map access$getIndexes$p(DefaultEntity $this) {
        return $this.indexes;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DefaultEntity $this) {
        return $this.getClosed();
    }

    public static final /* synthetic */ void access$setClosed$p(DefaultEntity $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0014\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016JC\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\u00020\u00112\n\u0010$\u001a\u00060\u0007j\u0002`%H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u001d\u0010(\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`%2\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0016J\f\u0010/\u001a\u00060\u0007j\u0002`%H\u0016J\b\u00100\u001a\u00020\u0011H\u0016J+\u00101\u001a\u00020*2\n\u0010$\u001a\u00060\u0007j\u0002`%2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dH\u0016\u00a2\u0006\u0002\u00102J%\u00103\u001a\b\u0012\u0004\u0012\u00020*042\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dH\u0016\u00a2\u0006\u0002\u00105J-\u00103\u001a\b\u0012\u0004\u0012\u00020*042\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d2\u0006\u00106\u001a\u000207H\u0016\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006:"}, d2={"Lorg/vitrivr/cottontail/database/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "getDbo", "()Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "snapshot", "Lorg/vitrivr/cottontail/database/entity/EntityTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/entity/EntityTxSnapshot;", "cleanup", "", "columnForName", "Lorg/vitrivr/cottontail/database/column/Column;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "count", "createIndex", "Lorg/vitrivr/cottontail/database/index/Index;", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "params", "", "", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/database/column/ColumnDef;Ljava/util/Map;)Lorg/vitrivr/cottontail/database/index/Index;", "delete", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "dropIndex", "indexForName", "insert", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "(Lorg/vitrivr/cottontail/model/basics/Record;)Ljava/lang/Long;", "listColumns", "", "listIndexes", "maxTupleId", "optimize", "read", "(J[Lorg/vitrivr/cottontail/database/column/ColumnDef;)Lorg/vitrivr/cottontail/model/basics/Record;", "scan", "", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;)Ljava/util/Iterator;", "range", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/database/column/ColumnDef;Lkotlin/ranges/LongRange;)Ljava/util/Iterator;", "update", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        private final long closeStamp;
        @NotNull
        private final EntityTxSnapshot snapshot;

        @Override
        @NotNull
        public DefaultEntity getDbo() {
            return DefaultEntity.this;
        }

        @Override
        @NotNull
        protected EntityTxSnapshot getSnapshot() {
            return this.snapshot;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Object $this$map$iv = columns;
            boolean $i$f$map = false;
            ColumnDef<?>[] columnDefArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((ColumnDef<?>[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var10_8 = $this$mapTo$iv$iv;
            int n = ((void)var10_8).length;
            for (int i = 0; i < n; ++i) {
                Column column;
                void it;
                void item$iv$iv;
                void var14_12 = item$iv$iv = var10_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if ((Column)DefaultEntity.this.columns.get(it.getName()) == null) {
                    throw (Throwable)new IllegalArgumentException("Column " + it + " does not exist on entity " + DefaultEntity.this.getName() + '.');
                }
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(column);
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                }
                Object t = ((ColumnTx)tx).read(tupleId);
                collection.add(t);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
            if (valueArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Value[] values = valueArray;
            return new StandaloneRecord(tupleId, columns, values);
        }

        @Override
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return this.getSnapshot().getStatistics().getCount();
        }

        @Override
        public long maxTupleId() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return this.getSnapshot().getStatistics().getMaximumTupleId();
        }

        @Override
        @NotNull
        public List<Column<?>> listColumns() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)DefaultEntity.this.columns.values());
        }

        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            Column column;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            if (!name.getWildcard()) {
                column = (Column)DefaultEntity.this.columns.get(name);
                if (column == null) {
                    throw (Throwable)new DatabaseException.ColumnDoesNotExistException(name);
                }
            } else {
                Name.ColumnName fqn = DefaultEntity.this.getName().column(name.getSimple());
                column = (Column)DefaultEntity.this.columns.get(fqn);
                if (column == null) {
                    throw (Throwable)new DatabaseException.ColumnDoesNotExistException(fqn);
                }
            }
            return column;
        }

        @Override
        @NotNull
        public List<Index> listIndexes() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            return CollectionsKt.toList((Iterable)this.getSnapshot().getIndexes().values());
        }

        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            }
            boolean bl = false;
            Index index = this.getSnapshot().getIndexes().get(name);
            if (index == null) {
                throw (Throwable)new DatabaseException.IndexDoesNotExistException(name);
            }
            return index;
        }

        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, @NotNull Map<String, String> params) {
            Path data;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            if (this.getSnapshot().getIndexes().containsKey(name)) {
                throw (Throwable)new DatabaseException.IndexAlreadyExistsException(name);
            }
            Path path = data = DefaultEntity.this.getPath().resolve(name.getSimple() + ".idx");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"data");
            AbstractIndex newIndex = type.create(path, this.getDbo(), name, columns, params);
            this.getSnapshot().getIndexes().put(newIndex.getName(), newIndex);
            return newIndex;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            Index index = this.getSnapshot().getIndexes().remove(name);
            if (index == null) {
                throw (Throwable)new DatabaseException.IndexDoesNotExistException(name);
            }
            Index index2 = index;
            if (this.getContext().lockOn(index2) == LockMode.NO_LOCK) {
                this.getContext().requestLock(index2, LockMode.EXCLUSIVE);
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                EntityHeader oldHeader = (EntityHeader)DefaultEntity.this.headerField.get();
                Iterable iterable = oldHeader.getIndexes();
                List list = null;
                long l = 0L;
                long l2 = 0L;
                String string = null;
                EntityHeader entityHeader = oldHeader;
                Atomic.Var var = DefaultEntity.this.headerField;
                boolean $i$f$filter = false;
                void var17_17 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    EntityHeader.IndexRef it = (EntityHeader.IndexRef)element$iv$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)index2.getName().getSimple()) ^ true)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                var.set((Object)EntityHeader.copy$default(entityHeader, string, l2, l, list, list2, 15, null));
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to drop index '" + name + "' due to a storage exception: " + e.getMessage());
            }
            catch (IOException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Failed to drop index '" + name + "' due to an IO exception: " + e.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void optimize() {
            void $this$filterTo$iv$iv;
            void $this$toTypedArray$iv;
            Object item$iv$iv3;
            void $this$mapTo$iv$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Index it;
            void $this$filterTo$iv$iv2;
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            Iterable $this$filter$iv = this.listIndexes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (Index)element$iv$iv;
                boolean bl2 = false;
                if (!it.getSupportsIncrementalUpdate()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                it = (Index)item$iv$iv2;
                collection = destination$iv$iv;
                boolean bl3 = false;
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                }
                IndexTx tx2 = (IndexTx)tx;
                tx2.clear();
                object = tx2;
                collection.add(object);
            }
            List incremental = (List)destination$iv$iv;
            Iterable $this$map$iv2 = this.listColumns();
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                void it2;
                Column bl3 = (Column)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                object = it2.getColumnDef();
                collection.add(object);
            }
            $this$map$iv2 = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
            if (columnDefArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ColumnDef[] columns = columnDefArray;
            Object2ObjectOpenHashMap map2 = new Object2ObjectOpenHashMap(columns.length);
            EntityStatistics statistics = DefaultEntity.this.newStatistics();
            Iterator<Record> $this$forEach$iv = this.scan(columns);
            boolean $i$f$forEach = false;
            Object $i$f$mapTo22 = $this$forEach$iv;
            boolean item$iv$iv2 = false;
            item$iv$iv3 = $i$f$mapTo22;
            while (item$iv$iv3.hasNext()) {
                Object element$iv = item$iv$iv3.next();
                Record r = (Record)element$iv;
                boolean bl5 = false;
                r.forEach((Function2)new Function2<ColumnDef<?>, Value, Unit>(map2, statistics, incremental, this){
                    final /* synthetic */ Object2ObjectOpenHashMap $map$inlined;
                    final /* synthetic */ EntityStatistics $statistics$inlined;
                    final /* synthetic */ List $incremental$inlined;
                    final /* synthetic */ Tx this$0;
                    {
                        this.$map$inlined = object2ObjectOpenHashMap;
                        this.$statistics$inlined = entityStatistics;
                        this.$incremental$inlined = list;
                        this.this$0 = tx;
                        super(2);
                    }

                    public final void invoke(@NotNull ColumnDef<?> columnDef, @Nullable Value value) {
                        Intrinsics.checkNotNullParameter(columnDef, (String)"columnDef");
                        ((Map)this.$map$inlined).put(columnDef, value);
                    }
                });
                DataChangeEvent.InsertDataChangeEvent event = new DataChangeEvent.InsertDataChangeEvent((Entity)DefaultEntity.this, r.getTupleId(), (Map)map2);
                statistics.consume(event);
                Iterable $this$forEach$iv2 = incremental;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IndexTx it3 = (IndexTx)element$iv2;
                    boolean bl6 = false;
                    it3.update(event);
                }
            }
            this.getSnapshot().getStatistics().clear();
            this.getSnapshot().getStatistics().combine(statistics);
            Iterable $this$filter$iv2 = this.listIndexes();
            boolean $i$f$filter2 = false;
            $i$f$mapTo22 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Index it4 = (Index)element$iv$iv;
                boolean bl7 = false;
                if (!(!it4.getSupportsIncrementalUpdate())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Index it5 = (Index)element$iv;
                boolean bl8 = false;
                org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it5);
                if (tx == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                }
                ((IndexTx)tx).rebuild();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            long l = 1L;
            return this.scan(columns, new LongRange(l, this.maxTupleId()));
        }

        @Override
        @NotNull
        public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns, @NotNull LongRange range) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new Iterator<Record>(this, (ColumnDef[])columns, range){
                private final Iterator<Long> wrapped;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ ColumnDef[] $columns;
                final /* synthetic */ LongRange $range;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public Record next() {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    long tupleId = ((Number)this.wrapped.next()).longValue();
                    Object $this$map$iv = this.$columns;
                    boolean $i$f$map = false;
                    ColumnDef[] columnDefArray = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(((ColumnDef[])$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    void var9_7 = $this$mapTo$iv$iv;
                    int n = ((void)var9_7).length;
                    for (int i = 0; i < n; ++i) {
                        Column column;
                        void it;
                        void item$iv$iv;
                        void var13_11 = item$iv$iv = var9_7[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        if ((Column)DefaultEntity.access$getColumns$p(this.this$0.DefaultEntity.this).get(it.getName()) == null) {
                            throw (Throwable)new IllegalArgumentException("Column " + it + " does not exist on entity " + this.this$0.DefaultEntity.this.getName() + '.');
                        }
                        org.vitrivr.cottontail.database.general.Tx tx = this.this$0.getContext().getTx(column);
                        if (tx == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                        }
                        T t = ((ColumnTx)tx).read(tupleId);
                        collection.add(t);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                    if (valueArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Value[] values = valueArray;
                    return new StandaloneRecord(tupleId, this.$columns, values);
                }

                public boolean hasNext() {
                    return this.wrapped.hasNext();
                }
                {
                    this.this$0 = this$0;
                    this.$columns = $captured_local_variable$1;
                    this.$range = $captured_local_variable$2;
                    AbstractTx this_$iv = this$0;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getContext().lockOn(this_$iv.getDbo()) == LockMode.NO_LOCK) {
                        this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    }
                    scan.1 var7_6 = this;
                    boolean bl = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.this$0.getContext().getTx((DBO)CollectionsKt.first((Iterable)DefaultEntity.access$getColumns$p(this.this$0.DefaultEntity.this).values()));
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                    }
                    Iterator<Long> iterator2 = ((ColumnTx)tx).scan(this.$range);
                    var7_6.wrapped = iterator2;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @Nullable
        public Long insert(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Long lastTupleId = null;
                Object2ObjectArrayMap inserts = new Object2ObjectArrayMap(DefaultEntity.this.columns.size());
                Iterable $this$forEach$iv = DefaultEntity.this.columns.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Column it = (Column)element$iv;
                    boolean bl2 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<org.vitrivr.cottontail.model.values.types.Value>");
                    }
                    ColumnTx tx2 = (ColumnTx)tx;
                    Value value = record.get(it.getColumnDef());
                    long tupleId = tx2.insert(value);
                    Long l = lastTupleId;
                    if ((l == null || l != tupleId) && lastTupleId != null) {
                        throw (Throwable)new DatabaseException.DataCorruptionException("Entity '" + DefaultEntity.this.getName() + "' is corrupt. Insert did not yield same record ID for all columns involved!");
                    }
                    lastTupleId = tupleId;
                    ((Map)inserts).put(it.getColumnDef(), value);
                }
                if (lastTupleId != null) {
                    Entity entity = DefaultEntity.this;
                    Long l = lastTupleId;
                    Intrinsics.checkNotNull((Object)l);
                    DataChangeEvent.InsertDataChangeEvent event = new DataChangeEvent.InsertDataChangeEvent(entity, (long)l, (Map)inserts);
                    Iterable $this$forEach$iv2 = this.getSnapshot().getIndexes().values();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Index it = (Index)element$iv;
                        boolean bl3 = false;
                        org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                        if (tx == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                        }
                        ((IndexTx)tx).update(event);
                    }
                    this.getSnapshot().getStatistics().consume(event);
                    this.getContext().signalEvent(event);
                }
                return lastTupleId;
            }
            catch (DatabaseException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)e;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Inserting record failed due to an error in the underlying storage: " + e.getMessage() + '.');
            }
        }

        @Override
        public void update(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                Object2ObjectArrayMap updates = new Object2ObjectArrayMap(record.getColumns().length);
                ColumnDef<?>[] $this$forEach$iv = record.getColumns();
                boolean $i$f$forEach = false;
                ColumnDef<?>[] columnDefArray = $this$forEach$iv;
                int n = columnDefArray.length;
                for (int i = 0; i < n; ++i) {
                    Column column;
                    ColumnDef<?> element$iv;
                    ColumnDef<?> def = element$iv = columnDefArray[i];
                    boolean bl2 = false;
                    if ((Column)DefaultEntity.this.columns.get(def.getName()) == null) {
                        throw (Throwable)new IllegalArgumentException("Column " + def + " does not exist on entity " + DefaultEntity.this.getName() + '.');
                    }
                    Value value = record.get(def);
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(column);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<org.vitrivr.cottontail.model.values.types.Value>");
                    }
                    ColumnTx columnTx = (ColumnTx)tx;
                    ((Map)updates).put(def, new Pair((Object)columnTx.update(record.getTupleId(), value), (Object)value));
                }
                DataChangeEvent.UpdateDataChangeEvent event = new DataChangeEvent.UpdateDataChangeEvent((Entity)DefaultEntity.this, record.getTupleId(), (Map)updates);
                Iterable $this$forEach$iv2 = this.getSnapshot().getIndexes().values();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Index it = (Index)element$iv;
                    boolean bl3 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                    }
                    ((IndexTx)tx).update(event);
                }
                this.getSnapshot().getStatistics().consume(event);
                this.getContext().signalEvent(event);
            }
            catch (DatabaseException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)e;
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Updating record " + record.getTupleId() + " failed due to an error in the underlying storage: " + e.getMessage() + '.');
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void delete(long tupleId) {
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw (Throwable)new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw (Throwable)new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getContext().lockOn(this_$iv.getDbo()) != LockMode.EXCLUSIVE) {
                this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            }
            if (this_$iv.getStatus() != TxStatus.DIRTY) {
                AbstractTx.access$setStatus$p(this_$iv, TxStatus.DIRTY);
            }
            boolean bl = false;
            try {
                void $this$mapTo$iv$iv;
                Object2ObjectArrayMap deleted = new Object2ObjectArrayMap(DefaultEntity.this.columns.size());
                Iterable $this$map$iv = DefaultEntity.this.columns.values();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column column = (Column)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx((DBO)it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnTx<*>");
                    }
                    ((Map)deleted).put(it.getColumnDef(), ((ColumnTx)tx).delete(tupleId));
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                DataChangeEvent.DeleteDataChangeEvent event = new DataChangeEvent.DeleteDataChangeEvent((Entity)DefaultEntity.this, tupleId, (Map)deleted);
                Iterable $this$forEach$iv = this.getSnapshot().getIndexes().values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Index it = (Index)element$iv;
                    boolean bl3 = false;
                    org.vitrivr.cottontail.database.general.Tx tx = this.getContext().getTx(it);
                    if (tx == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.index.IndexTx");
                    }
                    ((IndexTx)tx).update(event);
                }
                this.getSnapshot().getStatistics().consume(event);
                this.getContext().signalEvent(event);
            }
            catch (DBException e) {
                this.setStatus(TxStatus.ERROR);
                throw (Throwable)new DatabaseException("Deleting record " + tupleId + " failed due to an error in the underlying storage: " + e.getMessage() + '.');
            }
        }

        @Override
        protected void cleanup() {
            DefaultEntity.this.closeLock.unlockRead(this.closeStamp);
        }

        public Tx(TransactionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.closeStamp = DefaultEntity.this.closeLock.readLock();
            this.snapshot = new EntityTxSnapshot(this){
                @NotNull
                private final EntityStatistics statistics;
                @NotNull
                private final Object2ObjectOpenHashMap<Name.IndexName, Index> indexes;
                final /* synthetic */ Tx this$0;

                @NotNull
                public EntityStatistics getStatistics() {
                    return this.statistics;
                }

                @NotNull
                public Object2ObjectOpenHashMap<Name.IndexName, Index> getIndexes() {
                    return this.indexes;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void commit() {
                    void $this$filterTo$iv$iv;
                    K it;
                    Object item$iv$iv;
                    Iterator<Map.Entry<K, V>> $this$mapTo$iv$iv;
                    Map $this$map$iv;
                    boolean $i$f$map22;
                    try {
                        Collection<EntityHeader.IndexRef> collection;
                        EntityHeader oldHeader = (EntityHeader)DefaultEntity.access$getHeaderField$p(this.this$0.DefaultEntity.this).get();
                        long l = System.currentTimeMillis();
                        ObjectCollection objectCollection = (ObjectCollection)this.getIndexes().values();
                        Intrinsics.checkNotNullExpressionValue((Object)objectCollection, (String)"this.indexes.values");
                        Iterable iterable = (Iterable)objectCollection;
                        List list = null;
                        long l2 = l;
                        long l3 = 0L;
                        String string = null;
                        EntityHeader entityHeader = oldHeader;
                        $i$f$map22 = false;
                        void var5_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            item$iv$iv = iterator2.next();
                            Index index = (Index)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            EntityHeader.IndexRef indexRef = new EntityHeader.IndexRef(it.getName().getSimple(), it.getType());
                            collection.add(indexRef);
                        }
                        collection = (List)destination$iv$iv;
                        EntityHeader newHeader = EntityHeader.copy$default(entityHeader, string, l3, l2, list, (List)collection, 11, null);
                        DefaultEntity.access$getHeaderField$p(this.this$0.DefaultEntity.this).compareAndSet((Object)oldHeader, (Object)newHeader);
                        DefaultEntity.access$getStatisticsField$p(this.this$0.DefaultEntity.this).set((Object)this.getStatistics());
                        DefaultEntity.access$getStore$p(this.this$0.DefaultEntity.this).commit();
                    }
                    catch (DBException e) {
                        Tx.access$setStatus$p(this.this$0, TxStatus.ERROR);
                        throw (Throwable)new DatabaseException("Failed to create index '" + this.this$0.DefaultEntity.this.getName() + "' due to a storage exception: " + e.getMessage());
                    }
                    Map $this$forEach$iv = (Map)this.getIndexes();
                    boolean $i$f$forEach = false;
                    $this$map$iv = $this$forEach$iv;
                    $i$f$map22 = false;
                    $this$mapTo$iv$iv = $this$map$iv.entrySet().iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it2 = element$iv = $this$mapTo$iv$iv.next();
                        boolean bl = false;
                        item$iv$iv = DefaultEntity.access$getIndexes$p(this.this$0.DefaultEntity.this);
                        it = it2.getKey();
                        boolean bl2 = false;
                        Object object = item$iv$iv;
                        boolean bl3 = false;
                        if (object.containsKey(it)) continue;
                        Map map2 = DefaultEntity.access$getIndexes$p(this.this$0.DefaultEntity.this);
                        K k = it2.getKey();
                        Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                        V v = it2.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                        map2.put(k, v);
                    }
                    Iterable $this$filter$iv = DefaultEntity.access$getIndexes$p(this.this$0.DefaultEntity.this).values();
                    boolean $i$f$filter = false;
                    Iterable $i$f$map22 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Index it3 = (Index)element$iv$iv;
                        boolean bl = false;
                        if (!(!this.getIndexes().containsKey((Object)it3.getName()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List remove = (List)destination$iv$iv;
                    Iterable $this$forEach$iv2 = remove;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv2) {
                        Index it4 = (Index)element$iv;
                        boolean bl = false;
                        try {
                            it4.close();
                            FileUtilities.INSTANCE.deleteRecursively(it4.getPath());
                        }
                        finally {
                            DefaultEntity.access$getIndexes$p(this.this$0.DefaultEntity.this).remove(it4.getName());
                        }
                    }
                }

                public void rollback() {
                    Map $this$forEach$iv = (Map)this.getIndexes();
                    boolean $i$f$forEach = false;
                    Map map2 = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        Map map3 = DefaultEntity.access$getIndexes$p(this.this$0.DefaultEntity.this);
                        K k = it.getKey();
                        boolean bl3 = false;
                        Map map4 = map3;
                        boolean bl4 = false;
                        if (map4.containsKey(k)) continue;
                        ((Index)it.getValue()).close();
                        FileUtilities.INSTANCE.deleteRecursively(((Index)it.getValue()).getPath());
                    }
                    DefaultEntity.access$getStore$p(this.this$0.DefaultEntity.this).rollback();
                }
                {
                    this.this$0 = this$0;
                    Object object = DefaultEntity.access$getStatisticsField$p(this$0.DefaultEntity.this).get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@DefaultEntity.statisticsField.get()");
                    this.statistics = (EntityStatistics)object;
                    this.indexes = new Object2ObjectOpenHashMap(DefaultEntity.access$getIndexes$p(this$0.DefaultEntity.this));
                }
            };
            if (DefaultEntity.this.getClosed()) {
                throw (Throwable)new TxException.TxDBOClosedException(this.getContext().getTxId());
            }
        }

        public static final /* synthetic */ Object access$withReadLock(Tx $this, Function0 block) {
            return $this.withReadLock(block);
        }

        public static final /* synthetic */ TxStatus access$getStatus$p(Tx $this) {
            return $this.getStatus();
        }

        public static final /* synthetic */ void access$setStatus$p(Tx $this, TxStatus txStatus) {
            $this.setStatus(txStatus);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/database/entity/DefaultEntity$Companion;", "", "()V", "CATALOGUE_FILE", "", "ENTITY_HEADER_FIELD", "ENTITY_STATISTICS_FIELD", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

