/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.general;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.exceptions.TxException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H$J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J%\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u001c\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001aH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/general/Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "getContext", "()Lorg/vitrivr/cottontail/execution/TransactionContext;", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "<set-?>", "Lorg/vitrivr/cottontail/database/general/TxStatus;", "status", "getStatus", "()Lorg/vitrivr/cottontail/database/general/TxStatus;", "setStatus", "(Lorg/vitrivr/cottontail/database/general/TxStatus;)V", "cleanup", "", "close", "commit", "rollback", "withReadLock", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withWriteLock", "cottontaildb"})
public abstract class AbstractTx
implements Tx {
    @NotNull
    private volatile TxStatus status;
    @NotNull
    private final TransactionContext context;

    @Override
    @NotNull
    public final TxStatus getStatus() {
        return this.status;
    }

    protected final void setStatus(@NotNull TxStatus txStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)txStatus), (String)"<set-?>");
        this.status = txStatus;
    }

    @NotNull
    protected abstract TxSnapshot getSnapshot();

    @Override
    public final void commit() {
        if (this.status == TxStatus.DIRTY) {
            this.getSnapshot().commit();
            this.status = TxStatus.CLEAN;
        }
        this.getContext().releaseLock(this.getDbo());
    }

    @Override
    public final void rollback() {
        if (this.status == TxStatus.DIRTY || this.status == TxStatus.ERROR) {
            this.getSnapshot().rollback();
            this.status = TxStatus.CLEAN;
        }
        this.getContext().releaseLock(this.getDbo());
    }

    @Override
    public final void close() {
        if (this.status != TxStatus.CLOSED) {
            this.rollback();
            this.cleanup();
            this.status = TxStatus.CLOSED;
        }
    }

    protected abstract void cleanup();

    protected final <T> T withWriteLock(@NotNull Function0<? extends T> block) {
        int $i$f$withWriteLock = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.getStatus() == TxStatus.CLOSED) {
            throw (Throwable)new TxException.TxClosedException(this.getContext().getTxId());
        }
        if (this.getStatus() == TxStatus.ERROR) {
            throw (Throwable)new TxException.TxInErrorException(this.getContext().getTxId());
        }
        if (this.getContext().lockOn(this.getDbo()) != LockMode.EXCLUSIVE) {
            this.getContext().requestLock(this.getDbo(), LockMode.EXCLUSIVE);
        }
        if (this.getStatus() != TxStatus.DIRTY) {
            this.status = TxStatus.DIRTY;
        }
        return (T)block.invoke();
    }

    protected final <T> T withReadLock(@NotNull Function0<? extends T> block) {
        int $i$f$withReadLock = 0;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.getStatus() == TxStatus.CLOSED) {
            throw (Throwable)new TxException.TxClosedException(this.getContext().getTxId());
        }
        if (this.getStatus() == TxStatus.ERROR) {
            throw (Throwable)new TxException.TxInErrorException(this.getContext().getTxId());
        }
        if (this.getContext().lockOn(this.getDbo()) == LockMode.NO_LOCK) {
            this.getContext().requestLock(this.getDbo(), LockMode.SHARED);
        }
        return (T)block.invoke();
    }

    @Override
    @NotNull
    public TransactionContext getContext() {
        return this.context;
    }

    public AbstractTx(@NotNull TransactionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.status = TxStatus.CLEAN;
    }

    public static final /* synthetic */ TxStatus access$getStatus$p(AbstractTx $this) {
        return $this.status;
    }
}

