/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index;

import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexType$WhenMappings;
import org.vitrivr.cottontail.database.index.gg.GGIndex;
import org.vitrivr.cottontail.database.index.gg.GGIndexConfig;
import org.vitrivr.cottontail.database.index.hash.NonUniqueHashIndex;
import org.vitrivr.cottontail.database.index.hash.UniqueHashIndex;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSHIndex;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBitLSHIndexConfig;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndex;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndexConfig;
import org.vitrivr.cottontail.database.index.pq.PQIndex;
import org.vitrivr.cottontail.database.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.database.index.va.VAFIndex;
import org.vitrivr.cottontail.database.index.va.VAFIndexConfig;
import org.vitrivr.cottontail.model.basics.Name;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JK\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/database/index/IndexType;", "", "inexact", "", "(Ljava/lang/String;IZ)V", "getInexact", "()Z", "create", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "entity", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "params", "", "", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/model/basics/Name$IndexName;[Lorg/vitrivr/cottontail/database/column/ColumnDef;Ljava/util/Map;)Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "open", "HASH_UQ", "HASH", "BTREE", "LUCENE", "VAF", "PQ", "SH", "LSH", "LSH_SB", "GG", "cottontaildb"})
public final class IndexType
extends Enum<IndexType> {
    public static final /* enum */ IndexType HASH_UQ;
    public static final /* enum */ IndexType HASH;
    public static final /* enum */ IndexType BTREE;
    public static final /* enum */ IndexType LUCENE;
    public static final /* enum */ IndexType VAF;
    public static final /* enum */ IndexType PQ;
    public static final /* enum */ IndexType SH;
    public static final /* enum */ IndexType LSH;
    public static final /* enum */ IndexType LSH_SB;
    public static final /* enum */ IndexType GG;
    private static final /* synthetic */ IndexType[] $VALUES;
    private final boolean inexact;

    static {
        IndexType[] indexTypeArray = new IndexType[10];
        IndexType[] indexTypeArray2 = indexTypeArray;
        indexTypeArray[0] = HASH_UQ = new IndexType(false);
        indexTypeArray[1] = HASH = new IndexType(false);
        indexTypeArray[2] = BTREE = new IndexType(false);
        indexTypeArray[3] = LUCENE = new IndexType(false);
        indexTypeArray[4] = VAF = new IndexType(false);
        indexTypeArray[5] = PQ = new IndexType(true);
        indexTypeArray[6] = SH = new IndexType(true);
        indexTypeArray[7] = LSH = new IndexType(true);
        indexTypeArray[8] = LSH_SB = new IndexType(true);
        indexTypeArray[9] = GG = new IndexType(true);
        $VALUES = indexTypeArray;
    }

    @NotNull
    public final AbstractIndex open(@NotNull Path path, @NotNull DefaultEntity entity) {
        AbstractIndex abstractIndex;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        switch (IndexType$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                abstractIndex = new UniqueHashIndex(path, entity);
                break;
            }
            case 2: {
                abstractIndex = new NonUniqueHashIndex(path, entity);
                break;
            }
            case 3: {
                abstractIndex = new LuceneIndex(path, entity, null, 4, null);
                break;
            }
            case 4: {
                abstractIndex = new SuperBitLSHIndex(path, entity, null, 4, null);
                break;
            }
            case 5: {
                abstractIndex = new VAFIndex(path, entity, null, 4, null);
                break;
            }
            case 6: {
                abstractIndex = new PQIndex(path, entity, null, 4, null);
                break;
            }
            case 7: {
                abstractIndex = new GGIndex(path, entity, null, 4, null);
                break;
            }
            default: {
                throw (Throwable)new NotImplementedError("Index of type " + (Object)((Object)this) + " is not implemented.");
            }
        }
        return abstractIndex;
    }

    @NotNull
    public final AbstractIndex create(@NotNull Path path, @NotNull DefaultEntity entity, @NotNull Name.IndexName name, @NotNull ColumnDef<?>[] columns, @NotNull Map<String, String> params) {
        AbstractIndex abstractIndex;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        AbstractIndex.Companion.initialize(path, name, this, columns, entity.getParent().getParent().getConfig());
        switch (IndexType$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: {
                abstractIndex = new UniqueHashIndex(path, entity);
                break;
            }
            case 2: {
                abstractIndex = new NonUniqueHashIndex(path, entity);
                break;
            }
            case 3: {
                abstractIndex = new LuceneIndex(path, entity, LuceneIndexConfig.Serializer.fromParamMap(params));
                break;
            }
            case 4: {
                abstractIndex = new SuperBitLSHIndex(path, entity, SuperBitLSHIndexConfig.Serializer.fromParamMap(params));
                break;
            }
            case 5: {
                abstractIndex = new VAFIndex(path, entity, VAFIndexConfig.Serializer.fromParamMap(params));
                break;
            }
            case 6: {
                abstractIndex = new PQIndex(path, entity, PQIndexConfig.Serializer.fromParamMap(params));
                break;
            }
            case 7: {
                abstractIndex = new GGIndex(path, entity, GGIndexConfig.Serializer.fromParamsMap(params));
                break;
            }
            default: {
                throw (Throwable)new NotImplementedError("Index of type " + (Object)((Object)this) + " is not implemented.");
            }
        }
        return abstractIndex;
    }

    public static /* synthetic */ AbstractIndex create$default(IndexType indexType, Path path, DefaultEntity defaultEntity, Name.IndexName indexName, ColumnDef[] columnDefArray, Map map2, int n, Object object) {
        if ((n & 0x10) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return indexType.create(path, defaultEntity, indexName, columnDefArray, map2);
    }

    public final boolean getInexact() {
        return this.inexact;
    }

    private IndexType(boolean inexact) {
        this.inexact = inexact;
    }

    public static IndexType[] values() {
        return (IndexType[])$VALUES.clone();
    }

    public static IndexType valueOf(String string) {
        return Enum.valueOf(IndexType.class, string);
    }
}

