/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.gg;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.index.IndexConfig;
import org.vitrivr.cottontail.math.knn.metrics.Distances;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\t\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;", "Lorg/vitrivr/cottontail/database/index/IndexConfig;", "numGroups", "", "seed", "", "distance", "Lorg/vitrivr/cottontail/math/knn/metrics/Distances;", "(IJLorg/vitrivr/cottontail/math/knn/metrics/Distances;)V", "getDistance", "()Lorg/vitrivr/cottontail/math/knn/metrics/Distances;", "getNumGroups", "()I", "getSeed", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toMap", "", "", "toString", "Serializer", "cottontaildb"})
public final class GGIndexConfig
implements IndexConfig {
    private final int numGroups;
    private final long seed;
    @NotNull
    private final Distances distance;
    @NotNull
    public static final String NUM_SUBSPACES_KEY = "num_groups";
    @NotNull
    public static final String SEED_KEY = "seed";
    @NotNull
    public static final String DISTANCE_KEY = "distance";
    @NotNull
    public static final Serializer Serializer = new Serializer(null);

    @Override
    @NotNull
    public Map<String, String> toMap() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)NUM_SUBSPACES_KEY, (Object)String.valueOf(this.numGroups)), TuplesKt.to((Object)SEED_KEY, (Object)String.valueOf(this.seed)), TuplesKt.to((Object)DISTANCE_KEY, (Object)this.distance.toString())});
    }

    public final int getNumGroups() {
        return this.numGroups;
    }

    public final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final Distances getDistance() {
        return this.distance;
    }

    public GGIndexConfig(int numGroups, long seed, @NotNull Distances distance) {
        Intrinsics.checkNotNullParameter((Object)((Object)distance), (String)DISTANCE_KEY);
        this.numGroups = numGroups;
        this.seed = seed;
        this.distance = distance;
    }

    public final int component1() {
        return this.numGroups;
    }

    public final long component2() {
        return this.seed;
    }

    @NotNull
    public final Distances component3() {
        return this.distance;
    }

    @NotNull
    public final GGIndexConfig copy(int numGroups, long seed, @NotNull Distances distance) {
        Intrinsics.checkNotNullParameter((Object)((Object)distance), (String)DISTANCE_KEY);
        return new GGIndexConfig(numGroups, seed, distance);
    }

    public static /* synthetic */ GGIndexConfig copy$default(GGIndexConfig gGIndexConfig, int n, long l, Distances distances, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = gGIndexConfig.numGroups;
        }
        if ((n2 & 2) != 0) {
            l = gGIndexConfig.seed;
        }
        if ((n2 & 4) != 0) {
            distances = gGIndexConfig.distance;
        }
        return gGIndexConfig.copy(n, l, distances);
    }

    @NotNull
    public String toString() {
        return "GGIndexConfig(numGroups=" + this.numGroups + ", seed=" + this.seed + ", distance=" + (Object)((Object)this.distance) + ")";
    }

    public int hashCode() {
        Distances distances = this.distance;
        return (Integer.hashCode(this.numGroups) * 31 + Long.hashCode(this.seed)) * 31 + (distances != null ? ((Object)((Object)distances)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GGIndexConfig)) break block3;
                GGIndexConfig gGIndexConfig = (GGIndexConfig)object;
                if (this.numGroups != gGIndexConfig.numGroups || this.seed != gGIndexConfig.seed || !Intrinsics.areEqual((Object)((Object)this.distance), (Object)((Object)gGIndexConfig.distance))) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;", "()V", "DISTANCE_KEY", "", "NUM_SUBSPACES_KEY", "SEED_KEY", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "fromParamsMap", "params", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<GGIndexConfig> {
        public void serialize(@NotNull DataOutput2 out, @NotNull GGIndexConfig value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packInt(value.getNumGroups());
            out.packLong(value.getSeed());
            out.packInt(value.getDistance().ordinal());
        }

        @NotNull
        public GGIndexConfig deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new GGIndexConfig(input.unpackInt(), input.unpackLong(), Distances.values()[input.unpackInt()]);
        }

        @NotNull
        public final GGIndexConfig fromParamsMap(@NotNull Map<String, String> params) {
            Distances distances;
            long l;
            int n;
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Object object = params.get(GGIndexConfig.SEED_KEY);
            long l2 = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : System.currentTimeMillis();
            Object object2 = params.get(GGIndexConfig.NUM_SUBSPACES_KEY);
            int n2 = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 100;
            try {
                n = n2;
                l = l2;
                String string = params.get(GGIndexConfig.DISTANCE_KEY);
                if (string == null) {
                    string = "";
                }
                distances = Distances.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                n = n2;
                l = l2;
                distances = Distances.L2;
            }
            Distances distances2 = distances;
            long l3 = l;
            int n3 = n;
            return new GGIndexConfig(n3, l3, distances2);
        }

        private Serializer() {
        }

        public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

