/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh.superbit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.index.lsh.superbit.SamplingMethod;
import org.vitrivr.cottontail.database.index.lsh.superbit.SuperBit$WhenMappings;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\nJ\u0012\u0010\u001e\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBit;", "Ljava/io/Serializable;", "N", "", "L", "seed", "", "samplingMethod", "Lorg/vitrivr/cottontail/database/index/lsh/superbit/SamplingMethod;", "species", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "(IIJLorg/vitrivr/cottontail/database/index/lsh/superbit/SamplingMethod;Lorg/vitrivr/cottontail/model/values/types/VectorValue;)V", "getL", "()I", "getN", "_hyperplanes", "", "[Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "d", "getD", "hyperplanes", "getHyperplanes", "()[Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "getSamplingMethod", "()Lorg/vitrivr/cottontail/database/index/lsh/superbit/SamplingMethod;", "getSeed", "()J", "signature", "", "vector", "signatureComplex", "Lorg/vitrivr/cottontail/model/values/types/ComplexVectorValue;", "cottontaildb"})
public final class SuperBit
implements Serializable {
    private final int d;
    private final VectorValue<?>[] _hyperplanes;
    private final int N;
    private final int L;
    private final long seed;
    @NotNull
    private final SamplingMethod samplingMethod;

    public final int getD() {
        return this.d;
    }

    @NotNull
    public final VectorValue<?>[] getHyperplanes() {
        VectorValue<?>[] vectorValueArray = this._hyperplanes;
        boolean bl = false;
        VectorValue<?>[] vectorValueArray2 = Arrays.copyOf(vectorValueArray, vectorValueArray.length);
        Intrinsics.checkNotNullExpressionValue(vectorValueArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return vectorValueArray2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final boolean[] signature(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        boolean[] signature = new boolean[this._hyperplanes.length];
        int n = 0;
        int n2 = this._hyperplanes.length;
        while (n < n2) {
            void i;
            signature[i] = this._hyperplanes[i].dot(vector).asInt-HuW2oqM() >= 0;
            ++i;
        }
        return signature;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final boolean[] signatureComplex(@NotNull ComplexVectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        int n = this._hyperplanes.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            void it;
            boolean bl;
            int n2 = i;
            int n3 = i;
            boolean[] blArray2 = blArray;
            boolean bl2 = false;
            blArray2[n3] = bl = it % 2 == false ? this._hyperplanes[it].dot((VectorValue)vector).getReal().asInt-HuW2oqM() >= 0 : this._hyperplanes[it].dot((VectorValue)vector).getImaginary().asInt-HuW2oqM() >= 0;
        }
        return blArray;
    }

    public final int getN() {
        return this.N;
    }

    public final int getL() {
        return this.L;
    }

    public final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final SamplingMethod getSamplingMethod() {
        return this.samplingMethod;
    }

    /*
     * WARNING - void declaration
     */
    public SuperBit(int N, int L, long seed, @NotNull SamplingMethod samplingMethod, @NotNull VectorValue<?> species) {
        int it;
        VectorValue[] vectorValueArray;
        VectorValue vectorValue;
        int n;
        VectorValue[] vectorValueArray2;
        int n2;
        int n3;
        VectorValue[] $i$a$-require-SuperBit$42;
        Intrinsics.checkNotNullParameter((Object)((Object)samplingMethod), (String)"samplingMethod");
        Intrinsics.checkNotNullParameter(species, (String)"species");
        this.N = N;
        this.L = L;
        this.seed = seed;
        this.samplingMethod = samplingMethod;
        this.d = species.getLogicalSize();
        boolean bl = this.d > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Dimension d must be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.N >= 1 && this.N <= this.d;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Super-Bit depth N must be 1 <= N <= d";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.L >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean $i$a$-require-SuperBit$42 = false;
            String string = "Number of Super-Bits L must be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int K = this.N * this.L;
        switch (SuperBit$WhenMappings.$EnumSwitchMapping$0[this.samplingMethod.ordinal()]) {
            case 1: {
                VectorValue rnd;
                int it2;
                Object[] objectArray;
                int n4;
                int n5;
                Object[] objectArray2;
                VectorValue<?> vectorValue2;
                RandomGenerator random2 = new SplittableRandom(this.seed);
                $i$a$-require-SuperBit$42 = new VectorValue[K];
                for (n3 = 0; n3 < K; ++n3) {
                    VectorValue<Double> vectorValue3;
                    double d;
                    int n6 = n3;
                    n2 = n3;
                    vectorValueArray2 = $i$a$-require-SuperBit$42;
                    boolean bl6 = false;
                    vectorValue2 = species;
                    if (vectorValue2 instanceof DoubleVectorValue) {
                        n = species.getLogicalSize();
                        objectArray2 = new double[n];
                        n5 = 0;
                        while (n5 < n) {
                            int n7 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl7 = false;
                            objectArray[n4] = d = random2.nextDouble() - 0.5;
                        }
                        vectorValue3 = DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl(objectArray2));
                    } else if (vectorValue2 instanceof FloatVectorValue) {
                        n = species.getLogicalSize();
                        objectArray2 = new float[n];
                        n5 = 0;
                        while (n5 < n) {
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl8 = false;
                            float f = (float)(random2.nextDouble() - 0.5);
                            objectArray[n4] = f;
                        }
                        vectorValue3 = FloatVectorValue.box-impl(FloatVectorValue.constructor-impl((float[])objectArray2));
                    } else if (vectorValue2 instanceof Complex32VectorValue) {
                        n = species.getLogicalSize() * 2;
                        objectArray2 = new float[n];
                        n5 = 0;
                        while (n5 < n) {
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl9 = false;
                            float f = (float)(random2.nextDouble() - 0.5);
                            objectArray[n4] = f;
                        }
                        vectorValue3 = Complex32VectorValue.box-impl(Complex32VectorValue.constructor-impl((float[])objectArray2));
                    } else if (vectorValue2 instanceof Complex64VectorValue) {
                        n = species.getLogicalSize() * 2;
                        objectArray2 = new double[n];
                        n5 = 0;
                        while (n5 < n) {
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl10 = false;
                            objectArray[n4] = d = random2.nextDouble() - 0.5;
                        }
                        vectorValue3 = Complex64VectorValue.box-impl(Complex64VectorValue.constructor-impl(objectArray2));
                    } else {
                        throw (Throwable)new IllegalArgumentException("Unsupported vector type");
                    }
                    rnd = vectorValue3;
                    vectorValueArray2[n2] = vectorValue = rnd.div((NumericValue)rnd.norm2());
                }
                vectorValueArray = $i$a$-require-SuperBit$42;
                break;
            }
            case 2: {
                VectorValue rnd;
                int it2;
                Object[] objectArray;
                int n4;
                int n5;
                Object[] objectArray2;
                VectorValue<?> vectorValue2;
                RandomGenerator random2 = new Random(this.seed);
                $i$a$-require-SuperBit$42 = new VectorValue[K];
                for (n3 = 0; n3 < K; ++n3) {
                    VectorValue<Double> vectorValue4;
                    it = n3;
                    n2 = n3;
                    vectorValueArray2 = $i$a$-require-SuperBit$42;
                    boolean bl11 = false;
                    vectorValue2 = species;
                    if (vectorValue2 instanceof DoubleVectorValue) {
                        n = species.getLogicalSize();
                        objectArray2 = new double[n];
                        n5 = 0;
                        while (n5 < n) {
                            double d;
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl12 = false;
                            objectArray[n4] = d = ((Random)random2).nextGaussian();
                        }
                        vectorValue4 = DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl(objectArray2));
                    } else if (vectorValue2 instanceof FloatVectorValue) {
                        n = species.getLogicalSize();
                        objectArray2 = new float[n];
                        n5 = 0;
                        while (n5 < n) {
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl13 = false;
                            float f = (float)((Random)random2).nextGaussian();
                            objectArray[n4] = f;
                        }
                        vectorValue4 = FloatVectorValue.box-impl(FloatVectorValue.constructor-impl((float[])objectArray2));
                    } else if (vectorValue2 instanceof Complex32VectorValue) {
                        n = species.getLogicalSize() * 2;
                        objectArray2 = new float[n];
                        n5 = 0;
                        while (n5 < n) {
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl14 = false;
                            float f = (float)((Random)random2).nextGaussian();
                            objectArray[n4] = f;
                        }
                        vectorValue4 = Complex32VectorValue.box-impl(Complex32VectorValue.constructor-impl((float[])objectArray2));
                    } else if (vectorValue2 instanceof Complex64VectorValue) {
                        n = species.getLogicalSize() * 2;
                        objectArray2 = new double[n];
                        n5 = 0;
                        while (n5 < n) {
                            double d;
                            it2 = n5;
                            n4 = n5++;
                            objectArray = objectArray2;
                            boolean bl15 = false;
                            objectArray[n4] = d = ((Random)random2).nextGaussian();
                        }
                        vectorValue4 = Complex64VectorValue.box-impl(Complex64VectorValue.constructor-impl(objectArray2));
                    } else {
                        throw (Throwable)new IllegalArgumentException("Unsupported vector type");
                    }
                    rnd = vectorValue4;
                    vectorValueArray2[n2] = vectorValue = rnd.div((NumericValue)rnd.norm2());
                }
                vectorValueArray = $i$a$-require-SuperBit$42;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        VectorValue[] v = vectorValueArray;
        $i$a$-require-SuperBit$42 = new VectorValue[K];
        n3 = 0;
        while (n3 < K) {
            it = n3;
            n2 = n3++;
            vectorValueArray2 = $i$a$-require-SuperBit$42;
            boolean bl16 = false;
            vectorValue = v[it];
            vectorValueArray2[n2] = vectorValue;
        }
        VectorValue[] w = $i$a$-require-SuperBit$42;
        int $i$a$-require-SuperBit$42 = 0;
        n3 = this.L;
        while ($i$a$-require-SuperBit$42 < n3) {
            void i;
            it = 1;
            int n8 = this.N;
            if (it <= n8) {
                void j;
                do {
                    int n9 = 1;
                    n = ++j;
                    while (n9 < n) {
                        void k;
                        w[i * this.N + j - true] = w[i * this.N + j - true].minus(w[i * this.N + k - true].times(w[i * this.N + j - true].dot(v[i * this.N + k - true])));
                        ++k;
                    }
                    w[i * this.N + j - true] = w[i * this.N + j - true].div((NumericValue)w[i * this.N + j - true].norm2());
                } while (j != n8);
            }
            ++i;
        }
        this._hyperplanes = w;
    }
}

