/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lucene;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.index.IndexConfig;
import org.vitrivr.cottontail.database.index.lucene.LuceneAnalyzerType;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndexConfig$WhenMappings;
import org.vitrivr.cottontail.database.index.lucene.SoundexAnalyzer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\t\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;", "Lorg/vitrivr/cottontail/database/index/IndexConfig;", "type", "Lorg/vitrivr/cottontail/database/index/lucene/LuceneAnalyzerType;", "(Lorg/vitrivr/cottontail/database/index/lucene/LuceneAnalyzerType;)V", "getType", "()Lorg/vitrivr/cottontail/database/index/lucene/LuceneAnalyzerType;", "component1", "copy", "equals", "", "other", "", "getAnalyzer", "Lorg/apache/lucene/analysis/Analyzer;", "hashCode", "", "toMap", "", "", "toString", "Serializer", "cottontaildb"})
public final class LuceneIndexConfig
implements IndexConfig {
    @NotNull
    private final LuceneAnalyzerType type;
    @NotNull
    public static final String ANALYZER_TYPE_KEY = "analyzer_type";
    @NotNull
    public static final Serializer Serializer = new Serializer(null);

    @NotNull
    public final Analyzer getAnalyzer() {
        Analyzer analyzer;
        switch (LuceneIndexConfig$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                analyzer = (Analyzer)new StandardAnalyzer();
                break;
            }
            case 2: {
                analyzer = (Analyzer)new SimpleAnalyzer();
                break;
            }
            case 3: {
                analyzer = (Analyzer)new WhitespaceAnalyzer();
                break;
            }
            case 4: {
                analyzer = (Analyzer)new EnglishAnalyzer();
                break;
            }
            case 5: {
                analyzer = new SoundexAnalyzer();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return analyzer;
    }

    @Override
    @NotNull
    public Map<String, String> toMap() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)ANALYZER_TYPE_KEY, (Object)this.type.toString()));
    }

    @NotNull
    public final LuceneAnalyzerType getType() {
        return this.type;
    }

    public LuceneIndexConfig(@NotNull LuceneAnalyzerType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
    }

    @NotNull
    public final LuceneAnalyzerType component1() {
        return this.type;
    }

    @NotNull
    public final LuceneIndexConfig copy(@NotNull LuceneAnalyzerType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new LuceneIndexConfig(type);
    }

    public static /* synthetic */ LuceneIndexConfig copy$default(LuceneIndexConfig luceneIndexConfig, LuceneAnalyzerType luceneAnalyzerType, int n, Object object) {
        if ((n & 1) != 0) {
            luceneAnalyzerType = luceneIndexConfig.type;
        }
        return luceneIndexConfig.copy(luceneAnalyzerType);
    }

    @NotNull
    public String toString() {
        return "LuceneIndexConfig(type=" + (Object)((Object)this.type) + ")";
    }

    public int hashCode() {
        LuceneAnalyzerType luceneAnalyzerType = this.type;
        return luceneAnalyzerType != null ? ((Object)((Object)luceneAnalyzerType)).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LuceneIndexConfig)) break block3;
                LuceneIndexConfig luceneIndexConfig = (LuceneIndexConfig)object;
                if (!Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)luceneIndexConfig.type))) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00022\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;", "()V", "ANALYZER_TYPE_KEY", "", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "fromParamMap", "params", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<LuceneIndexConfig> {
        public void serialize(@NotNull DataOutput2 out, @NotNull LuceneIndexConfig value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packInt(value.getType().ordinal());
        }

        @NotNull
        public LuceneIndexConfig deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new LuceneIndexConfig(LuceneAnalyzerType.values()[input.unpackInt()]);
        }

        @NotNull
        public final LuceneIndexConfig fromParamMap(@NotNull Map<String, String> params) {
            LuceneAnalyzerType luceneAnalyzerType;
            Intrinsics.checkNotNullParameter(params, (String)"params");
            try {
                String string = params.get(LuceneIndexConfig.ANALYZER_TYPE_KEY);
                if (string == null) {
                    string = "";
                }
                luceneAnalyzerType = LuceneAnalyzerType.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                luceneAnalyzerType = LuceneAnalyzerType.STANDARD;
            }
            LuceneAnalyzerType luceneAnalyzerType2 = luceneAnalyzerType;
            return new LuceneIndexConfig(luceneAnalyzerType2);
        }

        private Serializer() {
        }

        public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

